/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import common.Unit;
import common.campaign.pilot.Pilot;
import common.util.SpringLayoutHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class PromotePilotDialog
extends JFrame
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = -8988175448434842033L;
    private MWClient mwclient = null;
    private CUnit playerUnit = null;
    private Pilot pilot = null;
    private static final String okayCommand = "Ok";
    private static final String cancelCommand = "Close";
    private String windowName = "Bulk Repair Dialog";
    private final JButton okayButton = new JButton("Buy");
    private final JButton cancelButton = new JButton("Close");
    private JOptionPane pane;
    private JPanel MasterPanel = new JPanel(new SpringLayout());
    private JPanel contentPane = new JPanel();
    private JCheckBox masterCB = new JCheckBox();
    private JTextField currentExp = new JTextField();
    private JTextField expCost = new JTextField();

    public PromotePilotDialog(MWClient c, int unitID) {
        this.mwclient = c;
        this.playerUnit = c.getPlayer().getUnit(unitID);
        this.windowName = "Pilot Promotion Dialog";
        this.addKeyListener(this);
        this.okayButton.setActionCommand(okayCommand);
        this.okayButton.addActionListener(this);
        this.okayButton.setToolTipText("Buy Pilot Skill.");
        this.okayButton.setMnemonic('B');
        this.cancelButton.setActionCommand(cancelCommand);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setToolTipText("Close dialog");
        this.cancelButton.setDefaultCapable(true);
        this.loadPanel();
        SpringLayoutHelper.setupSpringGrid(this.MasterPanel, 4);
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(this.MasterPanel, -1, 2, null, options, null);
        this.setTitle(this.windowName);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.pane, "Center");
        this.setResizable(true);
        this.setSize(new Dimension(369, 287));
        this.setExtendedState(0);
        this.addKeyListener(this);
        this.contentPane.addKeyListener(this);
        this.pane.addKeyListener(this);
        this.MasterPanel.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.pane.getRootPane().setDefaultButton(this.cancelButton);
        this.addKeyListener(this);
        this.repaint();
        this.setLocationRelativeTo(this.mwclient.getMainFrame());
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            this.sendPromoteCommands();
            super.dispose();
        } else if (command.equals(cancelCommand)) {
            super.dispose();
        } else if (e.getSource() instanceof JCheckBox) {
            this.calculateExpCost();
        }
    }

    private void loadPanel() {
        this.pilot = this.playerUnit.getPilot();
        Dimension dim = new Dimension(10, 10);
        this.MasterPanel.add(new JLabel("Current Exp", 11));
        this.currentExp.setEditable(false);
        this.currentExp.setText(Integer.toString(this.pilot.getExperience()));
        this.currentExp.setMinimumSize(dim);
        this.currentExp.setPreferredSize(dim);
        this.currentExp.setMaximumSize(dim);
        this.MasterPanel.add(this.currentExp);
        this.MasterPanel.add(new JLabel("Exp Cost", 11));
        this.expCost.setEditable(false);
        this.expCost.setMinimumSize(dim);
        this.expCost.setPreferredSize(dim);
        this.expCost.setMaximumSize(dim);
        this.MasterPanel.add(this.expCost);
        if (this.pilot.getGunnery() > Integer.parseInt(this.mwclient.getserverConfigs("BestGunnerySkill"))) {
            this.masterCB = new JCheckBox("Gunnery " + (this.pilot.getGunnery() - 1));
            this.masterCB.setName("gunnery");
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (this.pilot.getPiloting() > Integer.parseInt(this.mwclient.getserverConfigs("BestPilotingSkill"))) {
            this.masterCB = new JCheckBox("Piloting " + (this.pilot.getPiloting() - 1));
            this.masterCB.setName("piloting");
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (!(Integer.parseInt(this.mwclient.getserverConfigs("chanceforATfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) <= 0 || this.pilot.getSkills().has(2) && this.pilot.getSkills().getPilotSkill(2).getLevel() >= 2)) {
            this.masterCB = new JCheckBox("Astech");
            this.masterCB.setName("chanceforATfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforDMfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(1)) {
            this.masterCB = new JCheckBox("Dodge Maneuver");
            this.masterCB.setName("chanceforDMfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforMSfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(3)) {
            this.masterCB = new JCheckBox("Melee Specialist");
            this.masterCB.setName("chanceforMSfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforPRfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(4)) {
            this.masterCB = new JCheckBox("Pain Resistance");
            this.masterCB.setName("chanceforPRfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforSVfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(14)) {
            this.masterCB = new JCheckBox("Survivalist");
            this.masterCB.setName("chanceforSVfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforIMfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(13)) {
            this.masterCB = new JCheckBox("Iron Man");
            this.masterCB.setName("chanceforIMfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (!(Integer.parseInt(this.mwclient.getserverConfigs("chanceforEDfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) <= 0 || this.pilot.getSkills().has(20) && this.pilot.getSkills().getPilotSkill(20).getLevel() >= Integer.parseInt(this.mwclient.getserverConfigs("MaxEdgeChanges")))) {
            this.masterCB = new JCheckBox("Edge");
            this.masterCB.setName("chanceforEDfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforMAfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(7)) {
            this.masterCB = new JCheckBox("Maneuvering Ace");
            this.masterCB.setName("chanceforMAfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforNAPfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(6)) {
            this.masterCB = new JCheckBox("Natural Aptitude Piloting");
            this.masterCB.setName("chanceforNAPfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforNAGfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(6)) {
            this.masterCB = new JCheckBox("Natural Aptitude Gunnery");
            this.masterCB.setName("chanceforNAGfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforWSfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(12)) {
            this.masterCB = new JCheckBox("Weapon Specialist");
            this.masterCB.setName("chanceforWSfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforTGfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(8)) {
            this.masterCB = new JCheckBox("Tactical Genius");
            this.masterCB.setName("chanceforTGfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforGMfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(11)) {
            this.masterCB = new JCheckBox("Gunnery Missile");
            this.masterCB.addActionListener(this);
            this.masterCB.setName("chanceforGMfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforGBfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(9)) {
            this.masterCB = new JCheckBox("Gunnery Ballistic");
            this.masterCB.setName("chanceforGBfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforGLfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(10)) {
            this.masterCB = new JCheckBox("Gunnery Laser");
            this.masterCB.setName("chanceforGLfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforTNfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(15)) {
            this.masterCB = new JCheckBox("Trait");
            this.masterCB.setName("chanceforTNfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforEIfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(16)) {
            this.masterCB = new JCheckBox("Enhanced Interface");
            this.masterCB.setName("chanceforEIfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforGTfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(18)) {
            this.masterCB = new JCheckBox("Gifted");
            this.masterCB.setName("chanceforGTfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforQSfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(17)) {
            this.masterCB = new JCheckBox("Quick Study");
            this.masterCB.setName("chanceforQSfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforMTfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(19)) {
            this.masterCB = new JCheckBox("Med Tech");
            this.masterCB.setName("chanceforMTfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforVDNIfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(22)) {
            this.masterCB = new JCheckBox("VDNI");
            this.masterCB.setName("chanceforVDNIfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforBVDNIfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(23)) {
            this.masterCB = new JCheckBox("Buffered VDNI");
            this.masterCB.setName("chanceforBVDNIfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
        if (Integer.parseInt(this.mwclient.getserverConfigs("chanceforPSfor" + Unit.getTypeClassDesc(this.playerUnit.getType()))) > 0 && !this.pilot.getSkills().has(24)) {
            this.masterCB = new JCheckBox("Pain Shunt");
            this.masterCB.setName("chanceforPSfor" + Unit.getTypeClassDesc(this.playerUnit.getType()));
            this.masterCB.addActionListener(this);
            this.MasterPanel.add(this.masterCB);
        }
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
        if (arg0.getKeyCode() == 27) {
            super.dispose();
        } else if (arg0.getKeyCode() == 10) {
            this.sendPromoteCommands();
        }
    }

    private void calculateExpCost() {
        int cost = 0;
        int gun = this.pilot.getGunnery();
        int piloting = this.pilot.getPiloting();
        if (this.pilot.getSkills().has(5)) {
            ++gun;
        }
        if (this.pilot.getSkills().has(6)) {
            ++piloting;
        }
        for (Component object : this.MasterPanel.getComponents()) {
            int level;
            JCheckBox checkBox;
            int pilotCost = 0;
            if (!(object instanceof JCheckBox) || !(checkBox = (JCheckBox)object).isSelected()) continue;
            if (checkBox.getName().equalsIgnoreCase("gunnery") || checkBox.getName().equalsIgnoreCase("piloting")) {
                int totalSkill = Math.min(9, gun + piloting);
                pilotCost = Integer.parseInt(this.mwclient.getserverConfigs("BaseRollToLevel"));
                pilotCost *= Integer.parseInt(this.mwclient.getserverConfigs("MultiplierPerPreviousLevel"));
                pilotCost *= 10 - totalSkill;
            } else if (checkBox.getName().startsWith("chanceforATfor")) {
                if (this.pilot.getSkills().has(2)) {
                    level = this.pilot.getSkills().getPilotSkill(2).getLevel();
                    pilotCost = Integer.parseInt(this.mwclient.getserverConfigs(checkBox.getName()));
                    pilotCost *= level + 2;
                } else {
                    pilotCost = Integer.parseInt(this.mwclient.getserverConfigs(checkBox.getName()));
                }
            } else if (checkBox.getName().startsWith("chanceforEDfor")) {
                if (this.pilot.getSkills().has(20)) {
                    level = this.pilot.getSkills().getPilotSkill(20).getLevel();
                    pilotCost = Integer.parseInt(this.mwclient.getserverConfigs(checkBox.getName()));
                    pilotCost *= level + 1;
                } else {
                    pilotCost = Integer.parseInt(this.mwclient.getserverConfigs(checkBox.getName()));
                }
            } else {
                pilotCost = Integer.parseInt(this.mwclient.getserverConfigs(checkBox.getName()));
            }
            cost += pilotCost;
        }
        if (this.pilot.getSkills().has(18)) {
            cost = (int)((double)cost * (1.0 - Double.parseDouble(this.mwclient.getserverConfigs("GiftedPercent"))));
        }
        this.expCost.setText(Integer.toString(cost));
    }

    private void sendPromoteCommands() {
        String baseCommand = "/c promotepilot#" + this.playerUnit.getId() + "#";
        for (Component object : this.MasterPanel.getComponents()) {
            JCheckBox checkBox;
            if (!(object instanceof JCheckBox) || !(checkBox = (JCheckBox)object).isSelected()) continue;
            String cmd = checkBox.getName();
            if (cmd.startsWith("chancefor")) {
                int startPos = "chancefor".length();
                cmd = cmd.substring(startPos, cmd.indexOf("for", startPos));
            }
            this.mwclient.sendChat(baseCommand + cmd);
        }
    }
}

