/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public final class RegisterNameDialog
implements ActionListener {
    private final String okayCommand = "okay";
    private final String cancelCommand = "cancel";
    private final JTextField usernameField = new JTextField();
    private final JPasswordField passwordField1 = new JPasswordField();
    private final JPasswordField passwordField2 = new JPasswordField();
    private final JTextField emailField1 = new JTextField();
    private final JTextField emailField2 = new JTextField();
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private JDialog dialog;
    private JOptionPane pane;

    public RegisterNameDialog(MWClient mwclient) {
        this.okayButton.setActionCommand("okay");
        this.cancelButton.setActionCommand("cancel");
        this.usernameField.addActionListener(this);
        this.passwordField1.addActionListener(this);
        this.passwordField2.addActionListener(this);
        this.emailField1.addActionListener(this);
        this.emailField2.addActionListener(this);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.usernameField.setToolTipText("Username to register");
        this.passwordField1.setToolTipText("Password to set.");
        this.passwordField2.setToolTipText("Confirm password.");
        this.emailField1.setToolTipText("Email address.");
        this.emailField2.setToolTipText("Confirm email address.");
        int panelRows = 3;
        if (Boolean.parseBoolean(mwclient.getserverConfigs("REQUIREEMAILFORREGISTRATION"))) {
            panelRows = 5;
        }
        JPanel fieldPanel = new JPanel(new GridLayout(panelRows, 2), false);
        fieldPanel.add(new JLabel("Username: ", 2));
        fieldPanel.add(this.usernameField);
        fieldPanel.add(new JLabel("Password1: ", 2));
        fieldPanel.add(this.passwordField1);
        fieldPanel.add(new JLabel("Password2: ", 2));
        fieldPanel.add(this.passwordField2);
        if (Boolean.parseBoolean(mwclient.getserverConfigs("REQUIREEMAILFORREGISTRATION"))) {
            fieldPanel.add(new JLabel("Email: ", 2));
            fieldPanel.add(this.emailField1);
            fieldPanel.add(new JLabel("Confirm Email: ", 2));
            fieldPanel.add(this.emailField2);
        }
        JPanel messagePanel = new JPanel();
        messagePanel.add(new JLabel("<HTML><b><center>Note: password will be stored<br>and transmitted in plain text.</b></center></HTML>"));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.add(fieldPanel);
        textPanel.add(messagePanel);
        JPanel mainPanel = new JPanel(false);
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(textPanel, -1, -1, null, options, this.passwordField1);
        this.dialog = this.pane.createDialog(mainPanel, "Register Nickname");
        this.dialog.getRootPane().setDefaultButton(this.okayButton);
        this.usernameField.setText(mwclient.getPlayer().getName());
        this.dialog.setVisible(true);
        this.dialog.requestFocus();
        this.usernameField.requestFocus();
        if (this.pane.getValue() == this.okayButton) {
            String pass1 = String.valueOf(this.passwordField1.getPassword());
            String pass2 = String.valueOf(this.passwordField2.getPassword());
            boolean emailValid = false;
            boolean passwordValid = false;
            StringBuilder toUser = new StringBuilder();
            if (!pass1.equals(pass2)) {
                toUser.append("CH|CLIENT: Passwords did not match. Registration failed.<br>");
            } else {
                passwordValid = true;
            }
            if (Boolean.parseBoolean(mwclient.getserverConfigs("REQUIREEMAILFORREGISTRATION"))) {
                if (this.emailField1.getText().equalsIgnoreCase(this.emailField2.getText())) {
                    if (this.emailIsValid(this.emailField1.getText().toUpperCase())) {
                        emailValid = true;
                    } else {
                        toUser.append("CH|CLIENT: " + this.emailField1.getText() + " is not a valid email address. Registration failed.<br>");
                    }
                } else {
                    toUser.append("CH|CLIENT: Email fields did not match.  Registration failed.");
                }
            } else {
                emailValid = true;
            }
            if (emailValid && passwordValid) {
                if (Boolean.parseBoolean(mwclient.getserverConfigs("REQUIREEMAILFORREGISTRATION"))) {
                    mwclient.sendChat("/register " + this.usernameField.getText() + "," + this.emailField1.getText() + "," + String.valueOf(this.passwordField1.getPassword()));
                } else {
                    mwclient.sendChat("/register " + this.usernameField.getText() + "," + String.valueOf(this.passwordField1.getPassword()));
                }
            } else {
                mwclient.doParseDataInput(toUser.toString());
            }
        }
        mwclient.sendChat("/c setclientversion#" + mwclient.myUsername.trim() + "#" + "0.2.40.0");
        this.dialog.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("okay")) {
            this.pane.setValue(this.okayButton);
            this.dialog.dispose();
        } else if (command.equals("cancel")) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        }
    }

    private boolean emailIsValid(String email) {
        return email.matches("[A-Z0-9._%+-]+@([A-Z0-9.-]+.)+(?:[A-Z]{2}|com|org|net|gov|mil|biz|info|name|aero|biz|info|jobs|museum)");
    }
}

