/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.gui.CMainFrame;
import client.gui.MechInfo;
import common.CampaignData;
import common.util.SpringLayoutHelper;
import common.util.UnitUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.ui.AWT.UnitFailureDialog;
import megamek.client.ui.AWT.UnitLoadingDialog;
import megamek.client.ui.MechView;
import megamek.common.Entity;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.MechSummaryComparator;
import megamek.common.loaders.EntityLoadingException;

public class RepodSelectorDialog
extends JFrame
implements ActionListener,
KeyListener,
ListSelectionListener,
Runnable,
WindowListener,
ItemListener {
    private static final long serialVersionUID = -6467246609231845514L;
    private static final int KEY_TIMEOUT = 1000;
    private CMainFrame clientgui;
    private MechSummary[] mechsCurrent;
    private UnitLoadingDialog unitLoadingDialog;
    private StringBuilder m_sbSearch = new StringBuilder();
    private long m_nLastSearch = 0L;
    private JPanel pParams = new JPanel();
    DefaultListModel defaultModel = null;
    ListSelectionModel listSelectionModel = null;
    JList mechList = null;
    JScrollPane listScrollPane = null;
    JScrollPane leftScrollPane = null;
    JScrollPane rightScrollPane = null;
    private JButton bRepod = new JButton("Repod");
    private JButton bCancel = new JButton("Close");
    private JButton bRandom = new JButton("Random");
    private JTextArea mechViewLeft = null;
    private JTextArea mechViewRight = null;
    private JPanel pUpper = new JPanel();
    private JPanel pPreview = new JPanel();
    private MWClient mwclient = null;
    private TreeMap<String, String> chassieList = new TreeMap();
    private String unitId = "";
    private boolean global = false;
    private static final String SPACES = "                        ";

    public RepodSelectorDialog(CMainFrame cl, UnitLoadingDialog uld, MWClient mwclient, String chassieList, String unitId) {
        super("Repod Selector");
        this.clientgui = cl;
        this.unitLoadingDialog = uld;
        this.mwclient = mwclient;
        StringTokenizer ST = new StringTokenizer(chassieList, "#");
        while (ST.hasMoreElements()) {
            String tempstr = ST.nextToken();
            if (tempstr.equals("GLOBAL")) {
                this.global = true;
                continue;
            }
            String chassieMods = ST.nextToken();
            this.chassieList.put(tempstr, chassieMods);
        }
        this.unitId = unitId;
        this.mechViewLeft = new JTextArea(22, 29);
        this.mechViewRight = new JTextArea(22, 34);
        this.defaultModel = new DefaultListModel();
        this.mechList = new JList(this.defaultModel);
        this.listSelectionModel = this.mechList.getSelectionModel();
        this.mechList.setVisibleRowCount(22);
        this.listSelectionModel.addListSelectionListener(this);
        this.listScrollPane = new JScrollPane(this.mechList);
        this.leftScrollPane = new JScrollPane(this.mechViewLeft);
        this.rightScrollPane = new JScrollPane(this.mechViewRight);
        this.listScrollPane.setAlignmentX(0.0f);
        this.listScrollPane.setHorizontalScrollBarPolicy(31);
        this.leftScrollPane.setAlignmentX(0.0f);
        this.leftScrollPane.setHorizontalScrollBarPolicy(31);
        this.rightScrollPane.setAlignmentX(0.0f);
        this.rightScrollPane.setHorizontalScrollBarPolicy(31);
        this.mechList.setSelectionMode(0);
        this.mechViewLeft.setFont(new Font("Monospaced", 0, 11));
        this.mechViewRight.setFont(new Font("Monospaced", 0, 11));
        this.mechList.setFont(new Font("Monospaced", 0, 11));
        this.pPreview = new MechInfo(mwclient);
        this.pPreview.setVisible(false);
        this.pPreview.setMinimumSize(new Dimension(86, 74));
        this.pPreview.setMaximumSize(new Dimension(86, 74));
        this.pUpper.setLayout(new FlowLayout(1));
        this.pUpper.add(this.pParams);
        this.pUpper.add(this.pPreview);
        JPanel textBoxSpring = new JPanel(new SpringLayout());
        textBoxSpring.add(this.listScrollPane);
        textBoxSpring.add(this.leftScrollPane);
        textBoxSpring.add(this.rightScrollPane);
        SpringLayoutHelper.setupSpringGrid(textBoxSpring, 1, 3);
        JPanel buttonHolder = new JPanel();
        buttonHolder.add(this.bRepod);
        buttonHolder.add(this.bRandom);
        buttonHolder.add(this.bCancel);
        this.getRootPane().setDefaultButton(this.bCancel);
        JPanel springHolder = new JPanel(new SpringLayout());
        springHolder.add(this.pUpper);
        springHolder.add(textBoxSpring);
        springHolder.add(buttonHolder);
        SpringLayoutHelper.setupSpringGrid(springHolder, 3, 1);
        this.getContentPane().add(springHolder);
        this.clearMechPreview();
        this.setSize(785, 560);
        this.setResizable(false);
        this.bRandom.setEnabled(Boolean.parseBoolean(mwclient.getserverConfigs("RandomRepodAllowed")));
        this.bRepod.setEnabled(!Boolean.parseBoolean(mwclient.getserverConfigs("RandomRepodOnly")));
        this.mechList.addListSelectionListener(this);
        this.mechList.addKeyListener(this);
        this.bRepod.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bRandom.addActionListener(this);
        this.addWindowListener(this);
    }

    public void run() {
        this.filterMechs();
        this.sortMechs();
        this.unitLoadingDialog.setVisible(false);
        Map<String, String> hFailedFiles = MechSummaryCache.getInstance().getFailedFiles();
        if (hFailedFiles != null && hFailedFiles.size() > 0) {
            new UnitFailureDialog((Frame)this.clientgui, hFailedFiles);
        }
        try {
            this.mechList.setSelectedIndex(0);
        }
        catch (Exception e) {
            this.mechList.setSelectedIndex(-1);
        }
        this.pPreview.setVisible(true);
        this.setVisible(true);
        this.mechList.requestFocus();
    }

    private void filterMechs() {
        int x;
        Vector<MechSummary> vMechs = new Vector<MechSummary>(1, 1);
        MechSummary[] mechs = MechSummaryCache.getInstance().getAllMechs();
        if (mechs == null) {
            System.err.println("No units to filter!");
            return;
        }
        try {
            for (x = 0; x < mechs.length; ++x) {
                if (this.chassieList.get(mechs[x].getName()) == null || vMechs.contains(mechs[x].getName())) continue;
                vMechs.addElement(mechs[x]);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            System.err.println("mechs size: " + mechs.length + " x: " + x);
        }
        this.mechsCurrent = new MechSummary[vMechs.size()];
        vMechs.copyInto(this.mechsCurrent);
        this.sortMechs();
    }

    private void sortMechs() {
        Arrays.sort(this.mechsCurrent, new MechSummaryComparator(0));
        this.defaultModel.clear();
        for (int x = 0; x < this.mechsCurrent.length; ++x) {
            this.defaultModel.add(x, this.formatMech(this.mechsCurrent[x]));
        }
        this.repaint();
    }

    private void searchFor(String search) {
        for (int i = 0; i < this.mechsCurrent.length; ++i) {
            if (!this.mechsCurrent[i].getName().toLowerCase().startsWith(search)) continue;
            this.mechList.setSelectedIndex(i);
            this.mechList.ensureIndexIsVisible(i);
            break;
        }
    }

    public void setVisible(boolean show) {
        this.setLocationRelativeTo(null);
        super.setVisible(show);
        this.pack();
    }

    private String formatMech(MechSummary ms) {
        String result = this.makeLength(ms.getModel(), 12) + " " + this.makeLength(ms.getChassis(), 10) + " " + this.makeLength("" + ms.getTons(), 3) + " " + this.makeLength("" + ms.getBV(), 5);
        String chassieMods = this.chassieList.get(ms.getName());
        StringTokenizer mods = new StringTokenizer(chassieMods, "$");
        result = result + " " + this.makeLength(mods.nextToken() + this.mwclient.moneyOrFluMessage(true, true, -1), 5);
        result = result + " " + this.makeLength(mods.nextToken() + "cp", 7);
        result = result + " " + this.makeLength(mods.nextToken() + this.mwclient.moneyOrFluMessage(false, true, -1), 5);
        return result;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.bCancel) {
            this.dispose();
        }
        if (ae.getSource() == this.bRepod) {
            try {
                MechSummary ms = this.mechsCurrent[this.mechList.getSelectedIndex()];
                if (this.global) {
                    this.mwclient.sendChat("/c repod#" + this.unitId + "#GLOBAL#" + ms.getName());
                } else {
                    this.mwclient.sendChat("/c repod#" + this.unitId + "#" + ms.getName());
                }
                Thread.sleep(125L);
                this.dispose();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        if (ae.getSource() == this.bRandom) {
            try {
                if (this.global) {
                    this.mwclient.sendChat("/c repod#" + this.unitId + "#GLOBAL#RANDOM");
                } else {
                    this.mwclient.sendChat("/c repod#" + this.unitId + "#RANDOM");
                }
                Thread.sleep(125L);
                this.dispose();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        int selected = this.mechList.getSelectedIndex();
        if (selected == -1) {
            this.clearMechPreview();
            return;
        }
        MechSummary ms = this.mechsCurrent[selected];
        try {
            Entity entity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
            this.previewMech(entity);
        }
        catch (EntityLoadingException ex) {
            System.out.println("Unable to load mech: " + ms.getSourceFile() + ": " + ms.getEntryName() + ": " + ex.getMessage());
            CampaignData.mwlog.errLog(ex);
            this.clearMechPreview();
            return;
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        Object currSelection = this.mechList.getSelectedValue();
        this.sortMechs();
        this.filterMechs();
        this.mechList.setSelectedValue(currSelection, true);
    }

    void clearMechPreview() {
        this.mechViewLeft.setEditable(false);
        this.mechViewRight.setEditable(false);
        this.mechViewLeft.setText("");
        this.mechViewRight.setText("");
        this.previewMech(null);
    }

    void previewMech(Entity entity) {
        Entity currEntity = entity;
        boolean populateTextFields = true;
        if (entity == null) {
            try {
                currEntity = UnitUtils.createOMG();
                populateTextFields = false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MechView mechView = null;
        try {
            mechView = new MechView(currEntity, true);
        }
        catch (Exception e) {
            populateTextFields = false;
        }
        this.mechViewLeft.setEditable(false);
        this.mechViewRight.setEditable(false);
        if (populateTextFields && mechView != null) {
            this.mechViewLeft.setText(mechView.getMechReadoutBasic());
            this.mechViewRight.setText(mechView.getMechReadoutLoadout());
        } else {
            this.mechViewLeft.setText("No unit selected");
            this.mechViewRight.setText("No unit selected");
        }
        this.mechViewLeft.setCaretPosition(0);
        this.mechViewRight.setCaretPosition(0);
        try {
            ((MechInfo)this.pPreview).setUnit(currEntity);
            ((MechInfo)this.pPreview).setImageVisible(true);
            this.pPreview.paint(this.pPreview.getGraphics());
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private String makeLength(String s, int nLength) {
        if (s.length() == nLength) {
            return s;
        }
        if (s.length() > nLength) {
            return s.substring(0, nLength - 2) + "..";
        }
        return s + SPACES.substring(0, nLength - s.length());
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyPressed(KeyEvent ke) {
        long curTime;
        if (ke.getKeyCode() == 10) {
            ActionEvent event = new ActionEvent(this.bCancel, 1001, "");
            this.actionPerformed(event);
        }
        if ((curTime = System.currentTimeMillis()) - this.m_nLastSearch > 1000L) {
            this.m_sbSearch = new StringBuilder();
        }
        this.m_nLastSearch = curTime;
        this.m_sbSearch.append(ke.getKeyChar());
        this.searchFor(this.m_sbSearch.toString().toLowerCase());
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

