/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import client.gui.WholeNumberField;
import common.util.SpringLayoutHelper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import megamek.common.Infantry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SellUnitDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7292249744702852873L;
    private MWClient mwclient;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private JTextField minBidText = new WholeNumberField(0, 5);
    private JTextField ticksText = new WholeNumberField(0, 5);
    private JComboBox possibleSaleUnits = new JComboBox();

    public SellUnitDialog(JFrame parent, MWClient mwclient, Vector<CUnit> toSell) {
        super(parent, "Sell Unit", true);
        this.mwclient = mwclient;
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        if (toSell == null || toSell.size() == 0) {
            toSell = new Vector(1, 1);
            for (CUnit currU : mwclient.getPlayer().getHangar()) {
                if (currU.getType() == 0 && !Boolean.parseBoolean(mwclient.getserverConfigs("MeksMayBeSoldOnBM")) || currU.getType() == 1 && !Boolean.parseBoolean(mwclient.getserverConfigs("VehsMayBeSoldOnBM")) || currU.getType() == 4 && !Boolean.parseBoolean(mwclient.getserverConfigs("BAMayBeSoldOnBM")) || currU.getType() == 3 && !Boolean.parseBoolean(mwclient.getserverConfigs("ProtosMayBeSoldOnBM")) || currU.getType() == 2 && !Boolean.parseBoolean(mwclient.getserverConfigs("InfantryMayBeSoldOnBM")) || currU.getStatus() == 3 || Boolean.parseBoolean(mwclient.getserverConfigs("BMNoClan")) && currU.getEntity().isClan()) continue;
                toSell.add(currU);
            }
        }
        this.possibleSaleUnits.setModel(new DefaultComboBoxModel(toSell){
            private static final long serialVersionUID = 2012355422040841647L;

            public Object getElementAt(int index) {
                CUnit mm = (CUnit)super.getElementAt(index);
                if (mm.getType() == 0 || mm.getType() == 1 || mm.getType() == 5) {
                    return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + "]";
                }
                if (mm.getType() == 2 || mm.getType() == 4) {
                    if (((Infantry)mm.getEntity()).isAntiMek()) {
                        return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + "]";
                    }
                    return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "]";
                }
                return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "]";
            }
        });
        JPanel comboBoxHolder = new JPanel(new SpringLayout());
        JLabel selectUnitHeader = new JLabel("Unit to sell:", 0);
        selectUnitHeader.setAlignmentX(0.5f);
        comboBoxHolder.add(selectUnitHeader);
        comboBoxHolder.add(this.possibleSaleUnits);
        SpringLayoutHelper.setupSpringGrid(comboBoxHolder, 2, 1);
        Dimension newDim = new Dimension();
        newDim.setSize(this.possibleSaleUnits.getMinimumSize().getWidth() * 1.25, this.possibleSaleUnits.getMinimumSize().getHeight());
        this.possibleSaleUnits.setMaximumSize(newDim);
        JPanel sellTextSpring = new JPanel(new SpringLayout());
        sellTextSpring.add(new JLabel("Minimum Bid:", 11));
        this.minBidText.setToolTipText("Minimum bid you're willing to accept for the unit.");
        this.minBidText.setText(mwclient.getserverConfigs("MinBMSalesPrice"));
        sellTextSpring.add(this.minBidText);
        sellTextSpring.add(new JLabel("Sale Ticks:", 11));
        this.ticksText.setToolTipText("Number of ticks the unit will remain on sale.");
        this.ticksText.setText(mwclient.getserverConfigs("MinBMSalesTicks"));
        sellTextSpring.add(this.ticksText);
        SpringLayoutHelper.setupSpringGrid(sellTextSpring, 2);
        this.getRootPane().setDefaultButton(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(new JLabel("\n"));
        generalLayout.add(comboBoxHolder);
        generalLayout.add(new JLabel("\n"));
        generalLayout.add(sellTextSpring);
        generalLayout.add(new JLabel("\n"));
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.setLocationRelativeTo(mwclient.getMainFrame());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            int index = this.possibleSaleUnits.getSelectedIndex();
            if (index < 0) {
                return;
            }
            String result = "/c sell#";
            String mms = (String)this.possibleSaleUnits.getSelectedItem();
            StringTokenizer st = new StringTokenizer(mms);
            CUnit mm = this.mwclient.getPlayer().getUnit(Integer.parseInt(st.nextToken()));
            result = result + mm.getId();
            result = !this.ticksText.getText().equalsIgnoreCase("") ? result + "#" + this.ticksText.getText() : result + "#" + this.mwclient.getserverConfigs("MinBMSalesTicks");
            result = !this.minBidText.getText().equalsIgnoreCase("") ? result + "#" + this.minBidText.getText() : result + "#" + this.mwclient.getserverConfigs("MinBMSalesPrice");
            this.mwclient.sendChat(result);
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 220.0) {
            width = 220;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 220.0) {
            height = 220;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }
}

