/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import common.House;
import common.util.SpringLayoutHelper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class SubFactionNameDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3552906075410667280L;
    private final TreeSet<String> subFactionNames;
    private House faction = null;
    private JList matchingHousesList;
    private JScrollPane scrollPane;
    private JTextField nameField;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private String subFactionName = null;
    private boolean addblank = false;

    public SubFactionNameDialog(MWClient mwclient, String boxText, String factionName) {
        super(mwclient.getMainFrame(), boxText, true);
        this.faction = mwclient.getData().getHouseByName(factionName);
        this.subFactionNames = new TreeSet();
        if (this.faction == null) {
            return;
        }
        for (String subFaction : this.faction.getSubFactionList().keySet()) {
            this.subFactionNames.add(subFaction);
        }
        final Object[] allSubFactionNames = this.subFactionNames.toArray();
        this.matchingHousesList = new JList<Object>(allSubFactionNames);
        this.matchingHousesList.setVisibleRowCount(10);
        this.matchingHousesList.setSelectionMode(0);
        this.nameField = new JTextField();
        this.nameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                new Thread(){

                    public void run() {
                        String text = SubFactionNameDialog.this.nameField.getText();
                        if (text == null || text.equals("")) {
                            SubFactionNameDialog.this.matchingHousesList.setListData(allSubFactionNames);
                            return;
                        }
                        ArrayList<String> possibleHouses = new ArrayList<String>();
                        text = text.toLowerCase();
                        for (String subFaction : SubFactionNameDialog.this.faction.getSubFactionList().keySet()) {
                            if (subFaction.toLowerCase().indexOf(text) == -1) continue;
                            possibleHouses.add(subFaction);
                        }
                        SubFactionNameDialog.this.matchingHousesList.setListData(possibleHouses.toArray());
                        boolean shouldContinue = true;
                        int element = 0;
                        Iterator it = possibleHouses.iterator();
                        while (it.hasNext() && shouldContinue) {
                            String name = (String)it.next();
                            if (name.toLowerCase().startsWith(text)) {
                                SubFactionNameDialog.this.matchingHousesList.setSelectedIndex(element);
                                shouldContinue = false;
                            }
                            ++element;
                        }
                        if (shouldContinue) {
                            SubFactionNameDialog.this.matchingHousesList.setSelectedIndex(0);
                        }
                    }
                }.start();
            }
        });
        this.scrollPane = new JScrollPane(this.matchingHousesList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.nameField);
        springPanel.add(this.scrollPane);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(springPanel);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(mwclient.getMainFrame());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            String selectedHouse = (String)this.matchingHousesList.getSelectedValue();
            if (selectedHouse == null) {
                selectedHouse = this.nameField.getText();
            }
            if (!this.addblank && (selectedHouse == null || selectedHouse.equals(""))) {
                return;
            }
            if (this.matchingHousesList.getModel().getSize() == 1) {
                selectedHouse = (String)this.matchingHousesList.getModel().getElementAt(0);
            }
            for (String subFaction : this.faction.getSubFactionList().keySet()) {
                if (!selectedHouse.equals(subFaction)) continue;
                this.setSubFactionName(subFaction);
                this.setVisible(false);
                return;
            }
            this.setSubFactionName(this.nameField.getText());
            this.setVisible(false);
            return;
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 300.0) {
            width = 300;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 150.0) {
            height = 150;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }

    private void setSubFactionName(String name) {
        this.subFactionName = name;
    }

    public String getSubFactionName() {
        return this.subFactionName;
    }
}

