/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import common.util.SpringLayoutHelper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import megamek.common.Infantry;

public class UnitSelectionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 16880146524838545L;
    private JComboBox possibleUnits = new JComboBox();
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private JLabel comboLabel = new JLabel();
    private String toReturn = "-1";

    public UnitSelectionDialog(MWClient mwclient, String boxText, String labelText) {
        super(mwclient.getMainFrame(), boxText, true);
        this.comboLabel = new JLabel(labelText, 0);
        this.comboLabel.setAlignmentX(0.5f);
        this.comboLabel.setAlignmentY(0.5f);
        this.possibleUnits.setModel(new DefaultComboBoxModel(mwclient.getPlayer().getHangar()){
            private static final long serialVersionUID = -3752642922668363196L;

            public Object getElementAt(int index) {
                CUnit mm = (CUnit)super.getElementAt(index);
                if (mm.getType() == 0 || mm.getType() == 1 || mm.getType() == 5) {
                    return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + "]";
                }
                if (mm.getType() == 2 || mm.getType() == 4) {
                    if (((Infantry)mm.getEntity()).isAntiMek()) {
                        return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "/" + mm.getPilot().getPiloting() + "]";
                    }
                    return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "]";
                }
                return mm.getId() + " " + mm.getModelName() + " [" + mm.getPilot().getGunnery() + "]";
            }
        });
        Dimension newDim = new Dimension();
        newDim.setSize(this.possibleUnits.getMinimumSize().getWidth() * 1.25, this.possibleUnits.getMinimumSize().getHeight());
        this.possibleUnits.setMaximumSize(newDim);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.comboLabel);
        springPanel.add(this.possibleUnits);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(new JLabel("\n"));
        generalLayout.add(springPanel);
        generalLayout.add(new JLabel("\n"));
        generalLayout.add(buttonFlow);
        generalLayout.add(new JLabel("\n"));
        this.getContentPane().add(generalLayout);
        this.pack();
        this.setLocationRelativeTo(mwclient.getMainFrame());
        this.checkMinimumSize();
        this.setResizable(true);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            int index = this.possibleUnits.getSelectedIndex();
            if (index < 0) {
                return;
            }
            String mms = (String)this.possibleUnits.getSelectedItem();
            StringTokenizer st = new StringTokenizer(mms);
            String id = st.nextToken();
            this.setUnitID(id);
            this.setVisible(false);
            return;
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 275.0) {
            width = 275;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 200.0) {
            height = 200;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }

    private void setUnitID(String id) {
        this.toReturn = id;
    }

    public String getUnitID() {
        return this.toReturn;
    }
}

