/*
 * Decompiled with CFR 0.152.
 */
package client.protocol;

import client.protocol.ConnectionHandlerLocal;
import common.CampaignData;
import java.io.PrintStream;
import java.util.Vector;

class WriterThread
extends Thread {
    private boolean keepGoing = true;
    private Vector<String> outgoingMessages;
    private PrintStream _out;

    WriterThread(PrintStream out) {
        super("ConnectionHandler$WriterThread");
        this._out = out;
        this.outgoingMessages = new Vector(1, 1);
    }

    public synchronized void run() {
        try {
            while (this.keepGoing) {
                this.flushOutputQueue();
                this.wait(1000L);
            }
            CampaignData.mwlog.errLog("WriterThread: stopping gracefully.");
        }
        catch (InterruptedException e) {
            CampaignData.mwlog.errLog("ConnectionHandlerLocal$WriterThread.run(): Interrupted!");
        }
    }

    void flushOutputQueue() {
        while (this.outgoingMessages.size() > 0) {
            String message = this.outgoingMessages.elementAt(0);
            this.outgoingMessages.removeElementAt(0);
            ConnectionHandlerLocal.DEBUG("> " + message);
            this._out.print(message + "\r\n");
        }
        this._out.flush();
    }

    synchronized void queueMessage(String s) {
        this.outgoingMessages.addElement(s);
        this.notify();
    }

    void pleaseStop() {
        this.keepGoing = false;
    }
}

