/*
 * Decompiled with CFR 0.152.
 */
package client.util;

import client.MWClient;
import client.campaign.CUnit;
import common.CampaignData;
import common.util.UnitUtils;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import megamek.common.CriticalSlot;
import megamek.common.Mech;
import megamek.common.Mounted;

public class SalvageManagmentThread
extends Thread {
    private Vector<ConcurrentLinkedQueue<String>> workOrders = new Vector(5, 1);
    private long averageRepairTime = 1000L;
    private MWClient client = null;

    public SalvageManagmentThread(Long repairTime, MWClient client) {
        if (repairTime > 1000L) {
            this.averageRepairTime = repairTime;
        }
        this.client = client;
        for (int x = 0; x <= 4; ++x) {
            ConcurrentLinkedQueue tempVector = new ConcurrentLinkedQueue();
            this.workOrders.add(tempVector);
        }
    }

    public synchronized void run() {
        while (true) {
            try {
                while (true) {
                    this.wait(this.averageRepairTime);
                    this.processWorkOrders();
                }
            }
            catch (Exception ex) {
                this.client.systemMessage("Error proccessing Salvage Management queue. Alert an SO and check your ./logs/error.0 for the error");
                CampaignData.mwlog.errLog("Error in Salvage Management Queue");
                CampaignData.mwlog.errLog(ex);
                continue;
            }
            break;
        }
    }

    public void addWorkOrder(int techType, String workOrder) {
        this.workOrders.elementAt(techType).add(workOrder);
    }

    public void removeAllWorkOrders(int unitID) {
        String id = Integer.toString(unitID);
        for (int tech = 0; tech <= 4; ++tech) {
            Iterator<String> repairs = this.workOrders.elementAt(tech).iterator();
            while (repairs.hasNext()) {
                String repair = repairs.next();
                if (!repair.startsWith(id + "#")) continue;
                repairs.remove();
            }
        }
    }

    public void removeWorkOrder(int techType, String data) {
        Iterator<String> repairs = this.workOrders.elementAt(techType).iterator();
        while (repairs.hasNext()) {
            String repair = repairs.next();
            if (!repair.equals(data)) continue;
            repairs.remove();
            break;
        }
        this.client.systemMessage("Removed work orders for for " + UnitUtils.techDescription(techType) + " techs.");
    }

    public boolean isQueued(int Location2, int slot, int unitid) {
        for (int tech = 0; tech <= 4; ++tech) {
            for (String repair : this.workOrders.elementAt(tech)) {
                if (repair.indexOf(Integer.toString(unitid)) != 0) continue;
                StringTokenizer order = new StringTokenizer(repair, "#");
                order.nextToken();
                int locationid = Integer.parseInt(order.nextToken());
                int slotid = Integer.parseInt(order.nextToken());
                if (slotid == 14) {
                    locationid -= 7;
                }
                if (locationid != Location2 || slotid != slot) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasQueuedOrders(int unitid) {
        String id = Integer.toString(unitid);
        for (int tech = 0; tech <= 4; ++tech) {
            for (String repair : this.workOrders.elementAt(tech)) {
                if (!repair.startsWith(id + "#")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkOrders() {
        int availableTechs = 1;
        Vector<ConcurrentLinkedQueue<String>> vector = this.workOrders;
        synchronized (vector) {
            for (int pos = 0; pos <= 4; ++pos) {
                if (this.workOrders.elementAt(pos).size() <= 0) continue;
                if (pos != 4 && this.client.getPlayer().getTotalTechs().get(pos) <= 0) {
                    this.client.systemMessage("You have pending work orders for " + UnitUtils.techDescription(pos) + " techs, but have none on your pay roll.");
                    continue;
                }
                if (pos != 4) {
                    availableTechs = this.client.getPlayer().getAvailableTechs().get(pos);
                }
                if (availableTechs <= 0) continue;
                Iterator<String> workQueue = this.workOrders.elementAt(pos).iterator();
                while (workQueue.hasNext() && availableTechs > 0) {
                    boolean armor;
                    StringTokenizer order = new StringTokenizer(workQueue.next(), "#");
                    CUnit unit = this.client.getPlayer().getUnit(Integer.parseInt(order.nextToken()));
                    int location = Integer.parseInt(order.nextToken());
                    int slot = Integer.parseInt(order.nextToken());
                    boolean bl = armor = slot >= 13;
                    if (unit == null) {
                        CampaignData.mwlog.errLog("Unable to find unit to salvage. removing salvage job");
                        this.client.systemMessage("Unable to find unit to salvage. removing salvage job");
                        workQueue.remove();
                        continue;
                    }
                    CUnit cUnit = unit;
                    synchronized (cUnit) {
                        if (pos == 4 && !unit.getPilot().getSkills().has(2)) {
                            this.client.systemMessage("Work order found for the pilot of " + unit.getModelName() + " however the pilot cannot salvage this unit.<br>The work order has been terminated.");
                            workQueue.remove();
                            continue;
                        }
                        if (pos == 4 && unit.getPilotIsReparing()) {
                            continue;
                        }
                        if (!armor) {
                            CriticalSlot cs = unit.getEntity().getCritical(location, slot);
                            if (cs == null) {
                                this.client.systemMessage(UnitUtils.techDescription(pos) + " tech work order canceled because the critical doesn't exist.");
                                workQueue.remove();
                                continue;
                            }
                            if (cs.isDamaged()) {
                                this.client.systemMessage(UnitUtils.techDescription(pos) + " tech work order canceled because the critical was damaged.");
                                workQueue.remove();
                                continue;
                            }
                        } else if (slot == 13) {
                            int tempLocation = location;
                            if (location >= 8) {
                                tempLocation -= 7;
                            }
                            if (unit.getEntity().getArmor(tempLocation) <= 0) {
                                this.client.systemMessage(UnitUtils.techDescription(pos) + " tech work order canceled, that sections armor has already been salvaged.");
                                workQueue.remove();
                                continue;
                            }
                        } else if (slot == 14) {
                            if (location >= 8) {
                                location -= 7;
                            }
                            if (unit.getEntity().getArmor(location, true) <= 0) {
                                this.client.systemMessage(UnitUtils.techDescription(pos) + " tech work order canceled, that sections armor has already been salvaged.");
                                workQueue.remove();
                                continue;
                            }
                        } else {
                            if (UnitUtils.getSalvageMessage(unit.getEntity(), location, slot, armor).length() > 0) {
                                continue;
                            }
                            if (unit.getEntity().getInternal(location) <= 0) {
                                this.client.systemMessage(UnitUtils.techDescription(pos) + " tech work order canceled, that sections Internal Structure has already been salvaged.");
                                workQueue.remove();
                                continue;
                            }
                        }
                        this.client.sendChat("/c salvageunit#" + unit.getId() + "#" + location + "#" + slot + "#" + armor + "#" + pos + "#false");
                        workQueue.remove();
                        --availableTechs;
                    }
                }
            }
        }
    }

    public String getSalvageQueue(int unitID) {
        String data = "None.";
        CUnit unit = this.client.getPlayer().getUnit(unitID);
        for (int tech = 0; tech <= 4; ++tech) {
            for (String repair : this.workOrders.elementAt(tech)) {
                if (repair.indexOf(Integer.toString(unitID)) != 0) continue;
                StringTokenizer order = new StringTokenizer(repair, "#");
                order.nextToken();
                int locationid = Integer.parseInt(order.nextToken());
                int slotid = Integer.parseInt(order.nextToken());
                if (data.equals("None.")) {
                    data = "";
                }
                if (slotid == 13) {
                    data = data + UnitUtils.techDescription(tech) + " tech queued for external armor salavage " + unit.getEntity().getLocationAbbr(locationid) + ".";
                } else if (slotid == 14) {
                    data = data + UnitUtils.techDescription(tech) + " tech queued for external armor salavage " + unit.getEntity().getLocationAbbr(locationid - 7) + "(r).";
                } else if (slotid == 15) {
                    data = data + UnitUtils.techDescription(tech) + " tech queued for internal structure salavage " + unit.getEntity().getLocationAbbr(locationid) + ".";
                } else {
                    CriticalSlot cs = unit.getEntity().getCritical(locationid, slotid);
                    if (cs.getType() == 1) {
                        Mounted mounted = unit.getEntity().getEquipment(cs.getIndex());
                        data = data + UnitUtils.techDescription(tech) + " tech queued for salavage of " + mounted.getName() + "(" + unit.getEntity().getLocationAbbr(locationid) + ").";
                    } else if (unit.getEntity() instanceof Mech) {
                        data = data + UnitUtils.techDescription(tech) + " tech queued for salavage of " + ((Mech)unit.getEntity()).getSystemName(cs.getIndex()) + "(" + unit.getEntity().getLocationAbbr(locationid) + ").";
                    }
                }
                data = data + " <a href=\"REMOVESALVAGEQUEUEDWORKORDER|" + tech + "|" + repair + "\">click here to remove work order</a>.<br>";
            }
        }
        return data;
    }
}

