/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.CampaignData;
import common.util.HTML;
import common.util.TeePrinter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class BinWriter {
    private PrintWriter out;
    private boolean debug;
    private BinWriter dataBlock = null;
    private boolean open = true;

    public BinWriter(PrintWriter out) {
        this.out = out;
        this.debug = false;
    }

    public BinWriter(PrintWriter out, String debugFilename) {
        try {
            String ls = System.getProperty("line.seperator");
            System.setProperty("line.seperator", String.valueOf('\r'));
            this.out = new PrintWriter(new TeePrinter(out, new FileWriter(debugFilename)));
            System.setProperty("line.seperator", ls);
        }
        catch (IOException e) {
            CampaignData.mwlog.errLog(e);
            this.out = new PrintWriter(out);
        }
        this.debug = true;
        this.out.println("###DEBUG_ON###");
    }

    public void println(int v, String debugName) {
        if (this.debug) {
            this.out.print(debugName + "=");
        }
        this.out.println(v);
    }

    public void println(double v, String debugName) {
        if (this.debug) {
            this.out.print(debugName + "=");
        }
        this.out.println(v);
    }

    public void println(String v, String debugName) {
        if (this.debug) {
            this.out.print(debugName + "=");
        }
        this.out.println(HTML.cr2br(v));
    }

    public void println(boolean v, String debugName) {
        if (this.debug) {
            this.out.print(debugName + "=");
        }
        this.out.println(v);
    }

    public void printStringln(String v, String debugName) {
        if (this.debug) {
            this.out.print(debugName + "=");
        }
        this.out.println(v);
    }

    public void close() {
        if (this.dataBlock != null && this.dataBlock.open) {
            this.dataBlock.close();
            this.dataBlock = null;
        }
        this.out.close();
        this.open = false;
    }

    public void flush() {
        if (this.dataBlock != null && this.dataBlock.open) {
            this.dataBlock.close();
            this.dataBlock = null;
        }
        this.out.flush();
    }

    public BinWriter newBlock(String name) {
        return new BinWriter(this.out);
    }
}

