/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer;

import server.MWChatServer.commands.ICommands;

public class CommandMakerRemote
implements ICommands {
    public static final String constructSignonAck(String myname) {
        StringBuilder sb = new StringBuilder();
        sb.append("/ack_signon");
        sb.append("\t");
        sb.append(myname);
        return sb.toString();
    }

    public static final String constructJoinRoomAck(String room) {
        StringBuilder sb = new StringBuilder();
        sb.append("/ack_join");
        sb.append("\t");
        sb.append(room);
        return sb.toString();
    }

    public static final String constructErrorMessage(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("/err");
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static final String constructGeneralMessage(String msg) {
        return msg;
    }

    public static final String constructRoomMessage(String from, String room, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("/sayroom");
        sb.append("\t");
        sb.append(from);
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static final String constructPrivateMessage(String from, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("/msg");
        sb.append("\t");
        sb.append(from);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static final String constructSignoffAckMessage() {
        return "/quit";
    }

    public static final String constructRoomUserListMessage(String room, String[] names) {
        StringBuilder sb = new StringBuilder();
        sb.append("/who");
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        for (int i = 0; i < names.length; ++i) {
            sb.append(names[i]);
            sb.append("\t");
        }
        return sb.toString();
    }

    public static final String constructGlobalUserListMessage(String[] names) {
        StringBuilder sb = new StringBuilder();
        sb.append("/users");
        sb.append("\t");
        for (int i = 0; i < names.length; ++i) {
            sb.append(names[i]);
            sb.append("\t");
        }
        return sb.toString();
    }

    public static final String constructUserJoinedRoomMessage(String user, String room) {
        StringBuilder sb = new StringBuilder();
        sb.append("/roomuser");
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append("+");
        sb.append("\t");
        sb.append(user);
        return sb.toString();
    }

    public static final String constructUserPartedRoomMessage(String user, String room, boolean signOff) {
        StringBuilder sb = new StringBuilder();
        sb.append("/roomuser");
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append("-");
        sb.append("\t");
        sb.append(user);
        return sb.toString();
    }

    public static final String constructPartRoomAck(String room) {
        StringBuilder sb = new StringBuilder();
        sb.append("/ack_part");
        sb.append("\t");
        sb.append(room);
        return sb.toString();
    }

    public static final String constructPrivateEmoteMessage(String from, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("/mesg");
        sb.append("\t");
        sb.append(from);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static final String constructRoomListMessage(String[] rooms) {
        StringBuilder sb = new StringBuilder();
        sb.append("/rooms");
        sb.append("\t");
        for (int i = 0; i < rooms.length; ++i) {
            sb.append(rooms[i]);
            sb.append("\t");
        }
        return sb.toString();
    }

    public static final String constructPing(String user, String arg) {
        StringBuilder sb = new StringBuilder();
        sb.append("/ping");
        sb.append("\t");
        sb.append(user);
        sb.append("\t");
        sb.append(arg);
        return sb.toString();
    }

    public static final String constructPong(String user, String arg) {
        StringBuilder sb = new StringBuilder();
        sb.append("/pong");
        sb.append("\t");
        sb.append(user);
        sb.append("\t");
        sb.append(arg);
        return sb.toString();
    }

    public static final String constructGeneralRoomMessage(String room, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("/room_msg");
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static String constructRoomJoinError(String s, String room) {
        StringBuilder sb = new StringBuilder(s);
        sb.append("\t");
        sb.append(room);
        return sb.toString();
    }

    public static String constructSignOnError(String s, String user) {
        StringBuilder sb = new StringBuilder(s);
        sb.append("\t");
        sb.append(user);
        return sb.toString();
    }

    public static String constructError(String type, String arg) {
        StringBuilder sb = new StringBuilder(type);
        if (arg != null) {
            sb.append("\t");
            sb.append(arg);
        }
        return sb.toString();
    }

    public static String constructKilled(String killer, String msg) {
        StringBuilder sb = new StringBuilder("/kill");
        sb.append("\t");
        sb.append(killer);
        sb.append("\t");
        sb.append(msg);
        return sb.toString();
    }

    public static String constructIgnoreListMessage(String[] ignorees) {
        StringBuilder sb = new StringBuilder();
        sb.append("/ignorelist");
        sb.append("\t");
        for (int i = 0; i < ignorees.length; ++i) {
            sb.append(ignorees[i]);
            sb.append("\t");
        }
        return sb.toString();
    }

    public static String constructAckKill(String victim) {
        StringBuilder sb = new StringBuilder("/ack_kill");
        sb.append("\t");
        sb.append(victim);
        return sb.toString();
    }

    public static String constructEmote(String user, String room, String message) {
        StringBuilder sb = new StringBuilder("/me");
        sb.append("\t");
        sb.append(user);
        sb.append("\t");
        sb.append(room);
        sb.append("\t");
        sb.append(message);
        return sb.toString();
    }

    public static String constructUserSignOn(String userId) {
        return CommandMakerRemote.constructUserDiff(userId, "+");
    }

    public static String constructUserSignOff(String userId) {
        return CommandMakerRemote.constructUserDiff(userId, "-");
    }

    private static String constructUserDiff(String userId, String diff) {
        StringBuilder sb = new StringBuilder("/user");
        sb.append("\t");
        sb.append(diff);
        sb.append("\t");
        sb.append(userId);
        return sb.toString();
    }

    public static String constructRoomCreated(String room) {
        return CommandMakerRemote.constructRoomDiff(room, "+");
    }

    public static String constructRoomDestroyed(String room) {
        return CommandMakerRemote.constructRoomDiff(room, "-");
    }

    private static String constructRoomDiff(String room, String diff) {
        StringBuilder sb = new StringBuilder("/room");
        sb.append("\t");
        sb.append(diff);
        sb.append("\t");
        sb.append(room);
        return sb.toString();
    }

    public static String constructAckMail(String toUser) {
        StringBuilder sb = new StringBuilder("/ack_mail");
        sb.append("\t");
        sb.append(toUser);
        return sb.toString();
    }
}

