/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer;

import common.CampaignData;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import server.MWChatServer.MWChatClient;
import server.MWChatServer.Translator;
import server.MWChatServer.commands.ICommandProcessorRemote;
import server.MWChatServer.commands.ICommands;
import server.MWChatServer.commands.UnknownCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandProcessorRemote
implements ICommands {
    private static HashMap<String, ICommandProcessorRemote> _processors;
    private static HashSet<String> _idleTimeImmune;
    private static UnknownCommand unknownCommandProcessor;

    public static void init(Properties p) {
        if (_processors != null && _idleTimeImmune != null) {
            CampaignData.mwlog.infoLog("CommandProcessorRemote: Warning: init() called a second time");
        }
        _processors = new HashMap();
        _idleTimeImmune = new HashSet();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            int idx = name.indexOf(".");
            if (idx < 1) {
                CampaignData.mwlog.infoLog("CommandProcessorRemote: unknown property: " + name);
                continue;
            }
            String command = name.substring(0, idx);
            if (name.endsWith(".class")) {
                String className = p.getProperty(name);
                CampaignData.mwlog.infoLog("CommandProcessorRemote: initting the " + command + " command processor");
                try {
                    ICommandProcessorRemote cp = (ICommandProcessorRemote)Class.forName(className).newInstance();
                    String help = p.getProperty(command + ".help");
                    cp.setHelp(help);
                    String usage = p.getProperty(command + ".usage");
                    cp.setUsage(usage);
                    int access = 0;
                    try {
                        String s = p.getProperty(command + ".access");
                        access = Integer.parseInt(s);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    cp.setAccessRequired(access);
                    CommandProcessorRemote.extendCommandSet("/" + command, cp);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Unable to install the " + command + " command");
                    CampaignData.mwlog.errLog(ex);
                    CampaignData.mwlog.errLog("Continuing despite error(s)");
                }
                continue;
            }
            if (!name.endsWith(".idleImmune")) continue;
            _idleTimeImmune.add("/" + command);
        }
    }

    public static void extendCommandSet(String command, ICommandProcessorRemote processor) {
        _processors.put(command, processor);
    }

    public static void setIdleTimeImmune(String command) {
        _idleTimeImmune.add(command);
    }

    public static void process(String input, MWChatClient client) {
        String[] args = CommandProcessorRemote.decompose(input);
        if (args.length == 0) {
            return;
        }
        ICommandProcessorRemote processor = _processors.get(args[0]);
        if (processor == null) {
            unknownCommandProcessor.process(client, args);
        } else if (client.getAccessLevel() < processor.accessRequired()) {
            client.generalError(Translator.getMessage("access_denied"));
            client.generalError("Access denied");
        } else {
            processor.process(client, args);
        }
    }

    public static String[] decompose(String input) {
        StringTokenizer st = new StringTokenizer(input, "\t");
        ArrayList<String> list = new ArrayList<String>(5);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    public static Map<String, ICommandProcessorRemote> getCommandProcessors() {
        return _processors;
    }

    static {
        unknownCommandProcessor = new UnknownCommand();
    }
}

