/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer;

import common.CampaignData;
import common.util.ThreadManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import server.MWChatServer.AbstractConnectionHandler;
import server.MWChatServer.MWChatClient;
import server.MWChatServer.ReaderThread;
import server.MWChatServer.WriterThread;

public class ConnectionHandler
extends AbstractConnectionHandler {
    protected Socket _socket = null;
    protected PrintWriter _out = null;
    protected ReaderThread _reader = null;
    protected WriterThread _writer = null;
    protected InputStream _inputStream = null;
    protected boolean _isShutDown = false;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public ConnectionHandler(Socket socket, MWChatClient client) throws IOException {
        this._client = client;
        this._socket = socket;
        this._out = new PrintWriter(new OutputStreamWriter(this._socket.getOutputStream(), "UTF8"));
        this._inputStream = socket.getInputStream();
    }

    void init() {
        try {
            this._reader = new ReaderThread(this, this._client, this._inputStream);
            ThreadManager.getInstance().runInThreadFromPool(this._reader);
            this._writer = new WriterThread(this._socket, this._out, this._client.getHost());
            this.scheduler.scheduleAtFixedRate(this._writer, 0L, 20L, TimeUnit.MILLISECONDS);
        }
        catch (OutOfMemoryError OOM) {
            CampaignData.mwlog.errLog(OOM.getMessage());
            try {
                this._out.close();
                this._out = null;
                this._socket.close();
                this._socket = null;
                this._inputStream.close();
                this._inputStream = null;
                this._client = null;
                this._reader = null;
                this._writer = null;
                System.gc();
                this.shutdown(true);
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog(e);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePriorityMessage(String message) {
        String string = message;
        synchronized (string) {
            this._out.print(message + "\n");
            this._out.flush();
        }
    }

    public synchronized void shutdown(boolean notify) {
        if (!this._isShutDown) {
            this._isShutDown = true;
            this._reader.pleaseStop();
            this._reader.interrupt();
            this._writer.pleaseStop();
            this._writer.interrupt();
            try {
                this._socket.close();
            }
            catch (IOException e) {
                CampaignData.mwlog.errLog("connection shutdown due to error");
                CampaignData.mwlog.errLog(e);
            }
            super.shutdown(notify);
        }
    }

    public void queueMessage(String message) {
        if (this._writer != null) {
            this._writer.queueMessage(message);
        }
    }
}

