/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer;

import common.CampaignData;
import java.io.IOException;
import java.net.Socket;
import server.MWChatServer.AbstractConnectionHandler;
import server.MWChatServer.CommandMakerRemote;
import server.MWChatServer.CommandProcessorRemote;
import server.MWChatServer.ConnectionHandler;
import server.MWChatServer.IConnectionListener;
import server.MWChatServer.MWChatServer;
import server.MWChatServer.commands.ICommands;

public class MWChatClient
implements IConnectionListener,
ICommands {
    protected AbstractConnectionHandler _connectionHandler;
    protected MWChatServer _server;
    protected String _userId;
    private int _accessLevel = 0;
    private long _connectionTime;
    private String _host;
    private String _clientVersion;
    private String _key = "";
    private boolean _tunneling = false;

    public MWChatClient(MWChatServer server, Socket s) throws IOException {
        this._server = server;
        this._connectionTime = System.currentTimeMillis();
        this._host = s.getInetAddress().getHostAddress();
        this._connectionHandler = this.createConnectionHandler(s);
        ((ConnectionHandler)this._connectionHandler).init();
    }

    public AbstractConnectionHandler createConnectionHandler(Socket s) throws IOException {
        return new ConnectionHandler(s, this);
    }

    public boolean getTunneling() {
        return this._tunneling;
    }

    public long getConnectionTime() {
        return this._connectionTime;
    }

    public int getAccessLevel() {
        return this._accessLevel;
    }

    public String getClientVersion() {
        return this._clientVersion;
    }

    public void setClientVersion(String version) {
        this._clientVersion = version;
    }

    public String getHost() {
        return this._host;
    }

    public void setAccessLevel(int level) {
        this._accessLevel = level;
    }

    public String getUserId() {
        return this._userId;
    }

    public static String getKey(String userId) {
        return userId.toLowerCase();
    }

    public void setUserId(String userId) {
        if (userId == null || userId.equalsIgnoreCase("null")) {
            try {
                throw new NullPointerException();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Null user in setUserId report the following error to Torren");
                CampaignData.mwlog.errLog(ex);
            }
        }
        if (this._userId == null || !this._userId.equals(userId)) {
            this._userId = userId;
            this._key = userId == null ? null : MWChatClient.getKey(userId);
        }
    }

    public void die() {
        this._connectionHandler.shutdown(false);
    }

    public MWChatServer getServer() {
        return this._server;
    }

    public void incomingMessage(String msg) {
        CommandProcessorRemote.process(msg, this);
    }

    public void socketClosed() {
        this._server.signOff(this);
    }

    public void ackSignon(String myName) {
        if (this._connectionHandler == null) {
            System.err.println("conn handler is null");
        }
        this._connectionHandler.queueMessage(CommandMakerRemote.constructSignonAck(myName));
    }

    public void connectionLost() {
    }

    public void ackJoinRoom(String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructJoinRoomAck(room));
    }

    public void ackPartRoom(String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructPartRoomAck(room));
    }

    public void messageFromUser(String user, String room, String msg) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomMessage(user, room, msg));
    }

    public void roomList(String[] roomList) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomListMessage(roomList));
    }

    public void globalUserList(String[] users) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructGlobalUserListMessage(users));
    }

    public void roomUserList(String room, String[] users) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomUserListMessage(room, users));
    }

    public void userJoinedRoom(String user, String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructUserJoinedRoomMessage(user, room));
    }

    public void userPartedRoom(String user, String room, boolean signOff) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructUserPartedRoomMessage(user, room, signOff));
    }

    public void generalError(String message) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructErrorMessage(message));
    }

    public void generalMessage(String message) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructGeneralMessage(message));
    }

    public void generalRoomMessage(String room, String message) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructGeneralRoomMessage(room, message));
    }

    public void ping(String user, String arg) {
        this._connectionHandler.queuePriorityMessage(CommandMakerRemote.constructPing(user, arg));
    }

    public void pong(String user, String arg) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructPong(user, arg));
    }

    public void roomJoinError(String error, String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomJoinError(error, room));
    }

    public void signOnError(String error, String user) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructSignOnError(error, user));
    }

    public void error(String type, String arg) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructError(type, arg));
    }

    public void killed(String killer, String msg) {
        this._connectionHandler.queuePriorityMessage(CommandMakerRemote.constructKilled(killer, msg));
    }

    public void ackKill(String victim) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructAckKill(victim));
    }

    public void sendRaw(String s) {
        this._connectionHandler.queueMessage(s);
    }

    public void userSignOn(String userId) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructUserSignOn(userId));
    }

    public void userSignOff(String userId) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructUserSignOff(userId));
    }

    public void roomCreated(String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomCreated(room));
    }

    public String getKey() {
        return this._key;
    }

    public void ackMail(String toUser) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructAckMail(toUser));
    }
}

