/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer;

import common.CampaignData;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import server.MWChatServer.CommandProcessorRemote;
import server.MWChatServer.MWChatClient;
import server.MWChatServer.RoomServer;
import server.MWChatServer.TimedUserList;
import server.MWChatServer.Translator;
import server.MWChatServer.auth.Auth;
import server.MWChatServer.auth.IAuthenticator;
import server.MWChatServer.auth.IRoomAuthenticator;
import server.MWChatServer.auth.NullRoomAuthenticator;
import server.MWChatServer.auth.PasswdAuthenticator;
import server.MWChatServer.commands.ICommands;

public class MWChatServer
implements ICommands {
    protected static Properties _properties;
    protected boolean _asciiRoomNames;
    protected TimedUserList _killedUsers;
    protected IAuthenticator _authenticator;
    protected IRoomAuthenticator _roomAuthenticator;
    protected Map<String, MWChatClient> _users = Collections.synchronizedMap(new HashMap());
    protected HashMap<String, RoomServer> _rooms = new HashMap();
    protected String _motd;
    protected ServerSocket _serverSocket;
    protected int _cumulativeLogins = 0;
    protected int _port = 0;
    protected int _kickBanSeconds = 86400;

    public MWChatServer(String IPAddress, int port) throws Exception {
        Properties commandProps = new Properties();
        commandProps.setProperty("signon.class", "server.MWChatServer.commands.SignOn");
        commandProps.setProperty("signon.access", "0");
        commandProps.setProperty("comm.class", "server.MWChatServer.commands.Command");
        this.initCommandProcessor(commandProps);
        Properties messagesProps = new Properties();
        messagesProps.setProperty("access_denied", "Accessdenied.");
        messagesProps.setProperty("sql_error", "SQLError:{0}");
        messagesProps.setProperty("already_on", "Youarealreadysignedon");
        messagesProps.setProperty("unknown_command", "Sorry,Ididnotrecognizethatcommand.");
        messagesProps.setProperty("noroom", "Thereisnoroomcalled{0}");
        messagesProps.setProperty("reserved_name", "{0}isareservedname");
        messagesProps.setProperty("nosuchcommand", "Nosuchcommand:{0}");
        messagesProps.setProperty("nosuchuser", "Nosuchuser:{0}");
        messagesProps.setProperty("nosuchroom", "Nosuchroom:{0}");
        this.initTranslator(messagesProps);
        this._port = port;
        this._authenticator = new PasswdAuthenticator(this, true, false);
        this._roomAuthenticator = new NullRoomAuthenticator();
        this._asciiRoomNames = true;
        this._serverSocket = IPAddress == null || IPAddress.equals("-1") ? new ServerSocket(this._port, -1, null) : new ServerSocket(this._port, -1, InetAddress.getByName(IPAddress));
        this._killedUsers = new TimedUserList(7200);
    }

    public static Properties getProperties() {
        return _properties;
    }

    public int getKickBanSeconds() {
        return this._kickBanSeconds;
    }

    public int getRoomAccessLevel(MWChatClient client, RoomServer rs) {
        return this._roomAuthenticator.getAccessLevel(client, rs);
    }

    public MWChatClient getRoomNextOp(RoomServer rs) {
        return this._roomAuthenticator.getNextOp(rs);
    }

    public void initTranslator(Properties p) {
        Translator.init(p);
    }

    public void initCommandProcessor(Properties p) {
        CommandProcessorRemote.init(p);
    }

    public MWChatClient getClient(String target) {
        try {
            return this._users.get(MWChatServer.clientKey(target));
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return null;
        }
    }

    protected void validateUserId(String user) throws Exception {
        if (this.getName().toLowerCase().equals(user.toLowerCase())) {
            throw new Exception(user + " is a reserved name");
        }
        if (user.toLowerCase().startsWith("war bot")) {
            throw new Exception("/denied");
        }
        char[] chars = user.toLowerCase().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (Character.isLetterOrDigit(chars[i]) || ch == '_' || ch == '-' || ch == '\\' || ch == '^' || ch == '`' || ch == '|' || ch == '[' || ch == '{' || ch == ']' || ch == '}' || ch == '(' || ch == ')' || ch == '\'') continue;
            throw new Exception("/badchars");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signOn(MWChatClient client, String password) throws Exception {
        String userId = client.getUserId();
        this.validateUserId(userId);
        Auth auth = this._authenticator.authenticate(client, password);
        int access = auth.getAccess();
        CampaignData.mwlog.infoLog(client.getUserId() + " signon from " + client.getHost() + ".  Access = " + access + (client.getTunneling() ? " (tunneling)" : ""));
        if (access == 0 || this._killedUsers.contains(client.getKey())) {
            throw new Exception("/denied");
        }
        client.setUserId(auth.getUserId());
        Map<String, MWChatClient> map = this._users;
        synchronized (map) {
            CampaignData.mwlog.infoLog("signOn: " + client.getUserId());
            MWChatClient oldC = this._users.get(MWChatServer.clientKey(client));
            if (oldC != null) {
                oldC.killed(client.getUserId(), "Terminated by signing on elsewhere");
                CampaignData.mwlog.errLog("Terminated by signing on elsewhere");
                this.signOff(oldC);
            }
            client.setAccessLevel(access);
            this._users.put(MWChatServer.clientKey(client), client);
            ++this._cumulativeLogins;
            try {
                this.joinRoom(client, "Main Chat", "");
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to join room");
                CampaignData.mwlog.errLog(ex);
            }
        }
        client.ackSignon(auth.getUserId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signOff(MWChatClient client) {
        if (client.getAccessLevel() == 0) {
            if (MWChatServer.clientKey(client) != null) {
                try {
                    this._users.remove(MWChatServer.clientKey(client));
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
            client.die();
            return;
        }
        MWChatClient o = null;
        Map<String, MWChatClient> map = this._users;
        synchronized (map) {
            o = this._users.remove(MWChatServer.clientKey(client));
        }
        if (o != null) {
            map = this._rooms;
            synchronized (map) {
                for (String key : this._rooms.keySet()) {
                    RoomServer room = this._rooms.get(key);
                    room.part(client, true);
                    if (!room.isEmpty()) continue;
                    CampaignData.mwlog.infoLog("Removing empty room: " + key);
                    this._rooms.remove(key);
                }
            }
        }
        client.die();
    }

    public void kill(String victim, MWChatClient killer, String message) {
        if (killer.getAccessLevel() < 100) {
            killer.error("/denied", "/kill " + victim);
            return;
        }
        String killedKey = null;
        MWChatClient c = this.getClient(victim);
        if (c == null) {
            killer.error("/nosuchuser", victim);
            String victimId = this._authenticator.getUserId(victim);
            if (victimId != null) {
                killedKey = MWChatClient.getKey(victimId);
            }
        } else {
            CampaignData.mwlog.infoLog(victim + " kicked off by " + killer._userId);
            killedKey = c.getKey();
            c.killed(killer.getUserId(), message);
            this.signOff(c);
            killer.ackKill(victim);
        }
        if (killedKey != null) {
            this._killedUsers.add(killedKey);
        }
    }

    public void kill(String victim, String message) {
        String killedKey = null;
        MWChatClient c = this.getClient(victim);
        if (c == null) {
            String victimId = this._authenticator.getUserId(victim);
            if (victimId != null) {
                killedKey = MWChatClient.getKey(victimId);
            }
        } else {
            CampaignData.mwlog.infoLog(victim + " kicked off by server.");
            killedKey = c.getKey();
            this.signOff(c);
        }
        if (killedKey != null) {
            this._killedUsers.add(killedKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinRoom(MWChatClient client, String roomName, String password) throws Exception {
        String key = MWChatServer.roomKey(roomName);
        RoomServer room = this._rooms.get(key);
        HashMap<String, RoomServer> hashMap = this._rooms;
        synchronized (hashMap) {
            if (room == null) {
                if (!this._roomAuthenticator.isCreateAllowed(client, roomName, password)) {
                    throw new Exception("/roomaccessdenied");
                }
                room = this._rooms.get(MWChatServer.roomKey(roomName));
                if (room == null) {
                    if (this._asciiRoomNames) {
                        for (int i = 0; i < roomName.length(); ++i) {
                            char c = roomName.charAt(i);
                            if (c > ' ' || c < '\u0080') continue;
                            CampaignData.mwlog.infoLog(client.getUserId() + " room creation rejected: " + roomName);
                            throw new Exception("/badchars");
                        }
                    }
                    CampaignData.mwlog.infoLog(client.getUserId() + " created new room: " + roomName);
                    room = this.createRoomServer(roomName, password);
                    this._rooms.put(MWChatServer.roomKey(room), room);
                }
            }
        }
        room.join(client, password);
    }

    public RoomServer createRoomServer(String roomName, String password) {
        return new RoomServer(roomName, password, this);
    }

    public static String roomKey(String room) {
        return room.toLowerCase();
    }

    public static String roomKey(RoomServer room) {
        return MWChatServer.roomKey(room.getName());
    }

    public static String clientKey(MWChatClient client) {
        return client.getKey();
    }

    public static String clientKey(String client) {
        if (client == null) {
            return null;
        }
        try {
            return client.toLowerCase();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return null;
        }
    }

    protected void acceptConnections() {
        PingThread pingKeepAlive = new PingThread(this);
        pingKeepAlive.start();
        CampaignData.mwlog.infoLog("Accepting socket connections on port " + this._port);
        while (true) {
            try {
                while (true) {
                    Socket s = this._serverSocket.accept();
                    this.createMWChatClient(s);
                }
            }
            catch (IOException e) {
                CampaignData.mwlog.errLog(e);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
                continue;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exs) {
                    CampaignData.mwlog.errLog(exs);
                    continue;
                }
            }
            break;
        }
    }

    protected MWChatClient createMWChatClient(Socket s) throws IOException {
        return new MWChatClient(this, s);
    }

    public String getName() {
        try {
            return InetAddress.getLocalHost().getHostName() + ":" + this._port;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public boolean userExists(String username) {
        return this._users.containsKey(username.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendServerPing(String server) {
        StringBuilder sb = new StringBuilder();
        sb.append("/ping");
        sb.append("\t");
        sb.append(server);
        sb.append("\t");
        sb.append(System.currentTimeMillis());
        try {
            Map<String, MWChatClient> map = this._users;
            synchronized (map) {
                CampaignData.mwlog.infoLog("sendServerPing: " + server);
                for (MWChatClient client : this._users.values()) {
                    client.sendRaw(sb.toString());
                }
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error while sending server ping!");
            CampaignData.mwlog.errLog(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForPongs() {
        Map<String, MWChatClient> map = this._users;
        synchronized (map) {
            ArrayList<MWChatClient> clientToRemove = new ArrayList<MWChatClient>();
            for (MWChatClient client : this._users.values()) {
                if (client._connectionHandler._lastReceived + 120000L >= System.currentTimeMillis()) continue;
                clientToRemove.add(client);
            }
            for (MWChatClient client : clientToRemove) {
                CampaignData.mwlog.infoLog("RemovalThread sign off: " + client.getUserId());
                this.signOff(client);
            }
        }
    }

    private static final class PingThread
    extends Thread {
        private long waittime = 45000L;
        private MWChatServer server;

        public PingThread(MWChatServer server) {
            super("PingThread");
            CampaignData.mwlog.infoLog("Starting PingThread");
            this.server = server;
        }

        public synchronized void run() {
            try {
                while (true) {
                    this.wait(this.waittime);
                    this.server.sendServerPing("server");
                    this.server.checkForPongs();
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error while trying to sleep PingThread");
                CampaignData.mwlog.errLog(ex);
                return;
            }
        }
    }
}

