/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer;

import common.CampaignData;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import server.MWChatServer.ConnectionHandler;
import server.MWChatServer.IConnectionListener;

public class ReaderThread
extends Thread {
    protected IConnectionListener _connectionListener;
    protected BufferedReader _in;
    protected InputStream _inputStream;
    protected boolean _keepGoing = true;
    protected ConnectionHandler _connectionHandler;

    public ReaderThread(ConnectionHandler handler, IConnectionListener listener, InputStream in) {
        super("ReaderThread " + handler._client.getUserId());
        this._connectionHandler = handler;
        this._connectionListener = listener;
        this._inputStream = in;
        try {
            this._in = new BufferedReader(new InputStreamReader(in, "UTF8"));
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
        }
    }

    public void normalRun() {
        while (this._keepGoing) {
            try {
                String newLine;
                while ((newLine = this._in.readLine()) != null) {
                    this._connectionHandler.setLastReceived(System.currentTimeMillis());
                    if (newLine.startsWith("/pong")) continue;
                    this._connectionListener.incomingMessage(newLine);
                }
                if (this._in.readLine() != null) continue;
                this.pleaseStop();
            }
            catch (SocketException se) {
                this.pleaseStop();
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception ex) {
                this.pleaseStop();
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public synchronized void run() {
        this.normalRun();
        this._connectionHandler.shutdown(true);
    }

    void pleaseStop() {
        this._keepGoing = false;
    }
}

