/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer;

import java.util.ArrayList;
import java.util.HashMap;
import server.MWChatServer.MWChatClient;
import server.MWChatServer.MWChatServer;
import server.MWChatServer.TimedUserList;
import server.MWChatServer.Translator;
import server.MWChatServer.commands.ICommands;

public class RoomServer
implements ICommands {
    protected String _roomName;
    protected ArrayList<MWChatClient> _users;
    protected HashMap<String, MWChatClient> _ops;
    protected TimedUserList _kickedUsers;
    protected MWChatServer _server;
    private String _password;

    public RoomServer(String name, MWChatServer server) {
        this._server = server;
        this._roomName = name;
        this._users = new ArrayList();
        this._ops = new HashMap();
        this._kickedUsers = new TimedUserList(this._server.getKickBanSeconds());
    }

    public RoomServer(String name, String password, MWChatServer server) {
        this(name, server);
        this._password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWChatClient getOldestClient() {
        ArrayList<MWChatClient> arrayList = this._users;
        synchronized (arrayList) {
            return this._users.size() > 0 ? this._users.get(0) : null;
        }
    }

    public String getName() {
        return this._roomName;
    }

    public boolean isEmpty() {
        return this._users.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(String message) {
        ArrayList<MWChatClient> arrayList = this._users;
        synchronized (arrayList) {
            for (MWChatClient rcpt : this._users) {
                rcpt.generalRoomMessage(this._roomName, message);
            }
        }
    }

    public void say(MWChatClient sender, String message) {
        String from = sender.getUserId();
        this.say(from, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void say(String from, String message) {
        ArrayList<MWChatClient> arrayList = this._users;
        synchronized (arrayList) {
            for (MWChatClient rcpt : this._users) {
                rcpt.messageFromUser(from, this._roomName, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyJoin(String userId) {
        ArrayList<MWChatClient> arrayList = this._users;
        synchronized (arrayList) {
            for (MWChatClient rcpt : this._users) {
                rcpt.userJoinedRoom(userId, this._roomName);
            }
        }
    }

    public void remoteJoin(String username, String password) {
        this.notifyJoin(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPart(String userId, boolean isSignoff) {
        ArrayList<MWChatClient> arrayList = this._users;
        synchronized (arrayList) {
            for (MWChatClient rcpt : this._users) {
                rcpt.userPartedRoom(userId, this._roomName, isSignoff);
            }
        }
    }

    public void remotePart(String username, boolean isSignoff) {
        this.notifyPart(username, isSignoff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(MWChatClient client, String password) throws Exception {
        MWChatClient nextOp;
        int level = this._server.getRoomAccessLevel(client, this);
        if (level == 0 || this._kickedUsers.contains(client.getKey()) || this._password != null && !this._password.equals(password)) {
            throw new Exception("It No Workie");
        }
        ArrayList<MWChatClient> arrayList = this._users;
        synchronized (arrayList) {
            if (!this._users.contains(client)) {
                this.notifyJoin(client.getUserId());
                this._users.add(client);
                client.ackJoinRoom(this._roomName);
            }
        }
        if (level >= 100) {
            this.op(client);
        } else if (this._ops.size() == 0 && (nextOp = this._server.getRoomNextOp(this)) != null) {
            this.op(nextOp);
        }
    }

    public void op(MWChatClient client) {
        this.op(null, client);
    }

    public void deop(MWChatClient client) {
        this.deop(null, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void op(MWChatClient op, MWChatClient newOp) {
        HashMap<String, MWChatClient> hashMap = this._ops;
        synchronized (hashMap) {
            if (op == null || this._ops.keySet().contains(MWChatServer.clientKey(op))) {
                if (!this._ops.keySet().contains(MWChatServer.clientKey(newOp))) {
                    this._ops.put(MWChatServer.clientKey(newOp), newOp);
                    String actor = op == null ? "Server" : op.getUserId();
                    this.broadcast(Translator.getMessage("op.add", actor, newOp.getUserId()));
                }
            } else {
                op.generalError(Translator.getMessage("op.denied"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deop(MWChatClient op, MWChatClient newOp) {
        HashMap<String, MWChatClient> hashMap = this._ops;
        synchronized (hashMap) {
            if (op == null || this._ops.keySet().contains(MWChatServer.clientKey(op))) {
                MWChatClient nextOp;
                if (this._ops.keySet().contains(MWChatServer.clientKey(newOp))) {
                    this._ops.remove(MWChatServer.clientKey(newOp));
                    newOp.generalMessage(Translator.getMessage("op.remove.confirm", this._roomName));
                }
                if (this._ops.size() == 0 && (nextOp = this._server.getRoomNextOp(this)) != null) {
                    this.op(nextOp);
                }
            } else {
                op.generalError(Translator.getMessage("op.denied"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void part(MWChatClient client, boolean isSignoff) {
        String userId = client.getUserId();
        ArrayList<MWChatClient> arrayList = this._users;
        synchronized (arrayList) {
            if (this._users.remove(client)) {
                if (this._server.getClient(userId) != null) {
                    client.ackPartRoom(this._roomName);
                }
                this.notifyPart(userId, isSignoff);
            }
        }
        this.deop(client);
    }
}

