/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer;

import common.CampaignData;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.LinkedList;
import java.util.zip.Deflater;
import server.campaign.CampaignMain;

public class WriterThread
extends Thread {
    protected static final int MAX_DEFLATED_SIZE = 29999;
    protected Socket _socket;
    protected PrintWriter _out;
    protected Deflater _deflater = new Deflater();
    protected byte[] _deflatedBytes = new byte[29999];
    protected boolean _keepGoing = true;
    protected LinkedList<String> _messages = new LinkedList();
    protected String _host;

    public WriterThread(Socket socket, PrintWriter out, String host) {
        super("WriterThread " + host);
        this._socket = socket;
        this._out = out;
        this._host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessage(String message) {
        LinkedList<String> linkedList = this._messages;
        synchronized (linkedList) {
            this._messages.add(message);
        }
    }

    public synchronized void run() {
        if (this._keepGoing) {
            try {
                if (this._socket == null || this._socket.isClosed() || !this._socket.isConnected() || this._socket.isInputShutdown() || this._socket.isOutputShutdown()) {
                    this.pleaseStop();
                    return;
                }
                this.flush();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this._messages.size() == 0) {
            return;
        }
        LinkedList<String> linkedList = this._messages;
        synchronized (linkedList) {
            String s;
            StringBuilder sb = new StringBuilder();
            while (!this._messages.isEmpty()) {
                sb.append(this._messages.remove());
                sb.append("\n");
                if (CampaignMain.cm.getBooleanConfig("SendSingleCommandAtATime")) break;
                if (sb.length() < 9000) continue;
                this.deflateAndSend(sb.toString());
                sb.setLength(0);
            }
            if ((s = sb.toString()).length() < 200) {
                try {
                    CampaignData.mwlog.debugLog("Sending data to " + this._host + ":Size:" + s.length());
                    this._out.print(s);
                    this._out.flush();
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Socket error; shutting down client at " + this._host);
                    CampaignData.mwlog.errLog(ex);
                    this.pleaseStop();
                    try {
                        this._socket.close();
                    }
                    catch (Exception se) {
                        CampaignData.mwlog.errLog(se);
                    }
                }
                return;
            }
            this.deflateAndSend(s);
        }
    }

    private void deflateAndSend(String s) {
        try {
            byte[] rawBytes = s.getBytes("UTF8");
            this._deflatedBytes = new byte[s.length()];
            this._deflater.reset();
            this._deflater.setInput(rawBytes);
            this._deflater.finish();
            int n = this._deflater.deflate(this._deflatedBytes);
            String o = "/deflated\t" + n + "\t" + s.length() + "\n";
            this._out.print(o);
            CampaignData.mwlog.debugLog("Sending deflated data to " + this._host + ":Size:" + s.length() + ":Deflated Size:" + Integer.toString(n));
            this._out.flush();
            this._socket.getOutputStream().write(this._deflatedBytes, 0, n);
            this._socket.getOutputStream().flush();
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("Socket error; shutting down client");
            CampaignData.mwlog.errLog(e);
            this.pleaseStop();
            try {
                this._socket.close();
            }
            catch (Exception se) {
                CampaignData.mwlog.errLog(se);
            }
        }
    }

    void pleaseStop() {
        this._keepGoing = false;
    }
}

