/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer.auth;

import common.CampaignData;
import java.io.IOException;
import server.MWChatServer.MWChatClient;
import server.MWChatServer.MWChatServer;
import server.MWChatServer.auth.Auth;
import server.MWChatServer.auth.NullAuthenticator;
import server.util.MWPasswd;
import server.util.MWPasswdRecord;

public class PasswdAuthenticator
extends NullAuthenticator {
    public PasswdAuthenticator(MWChatServer server, boolean allowGuests, boolean storeGuests) {
        super(server, allowGuests, storeGuests);
    }

    public Auth authenticate(MWChatClient client, String password) throws Exception {
        String userId = client.getUserId();
        try {
            MWPasswdRecord record = MWPasswd.getRecord(userId, password);
            if (record == null) {
                CampaignData.mwlog.debugLog("record is null for: " + userId);
                if (this._allowGuests) {
                    Auth auth = super.authenticate(client, password);
                    if (this._storeGuests) {
                        MWPasswd.writeRecord(auth.getUserId(), 1, password);
                    }
                    return auth;
                }
                throw new Exception(userId);
            }
            return new Auth(userId, record.access);
        }
        catch (IOException e) {
            CampaignData.mwlog.errLog(e);
            throw new Exception(userId);
        }
    }

    public String getUserId(String target) {
        return MWPasswd.getUserId(target);
    }
}

