/*
 * Decompiled with CFR 0.152.
 */
package server.MWChatServer.commands;

import common.CampaignData;
import common.util.StringUtils;
import server.MWChatServer.MWChatClient;
import server.MWChatServer.Translator;
import server.MWChatServer.commands.CommandBase;
import server.MWChatServer.commands.ICommands;
import server.MWServ;
import server.ServerWrapper;
import server.campaign.CampaignMain;

public class SignOn
extends CommandBase
implements ICommands {
    private int nobody_id = 0;

    public boolean process(MWChatClient client, String[] args) {
        args[1] = args[1].trim();
        if (args[1].length() < 2) {
            client.generalError("No single-char names allowed. Go away...");
            return false;
        }
        args[2] = args[2].trim();
        if (args.length < 2) {
            client.generalError(this.getUsage(args[0]));
            return false;
        }
        if (client.getUserId() != null) {
            client.generalError(Translator.getMessage("already_on"));
            return false;
        }
        client.setUserId(args[1]);
        String username = client.getUserId();
        String ProtocolVersion = "4";
        String UserColor = "black";
        String lowername = username.trim().toLowerCase();
        if (lowername.equals("nobody") || lowername.equals("admin") || lowername.equals("[dedicated]") || lowername.equals("dedicated") || lowername.equals("server") || lowername.equals("mod") || lowername.equals("moderator")) {
            client.generalError("nobody, admin, administrator, dedicated, [dedicated], mod, moderator, and server are reserved names.");
            return false;
        }
        if (StringUtils.hasBadChars(lowername).trim().length() > 0) {
            client.generalError(StringUtils.hasBadChars(lowername));
            return false;
        }
        try {
            if (args.length < 3) {
                if (!client.getServer().signOn(client, null)) {
                    client.getServer().kill(client.getUserId(), "Bye Bye");
                    return false;
                }
            } else {
                ProtocolVersion = args[3];
                client.setClientVersion(ProtocolVersion);
                if (args.length > 4) {
                    UserColor = args[4];
                }
            }
            if (!client.getServer().signOn(client, args[2])) {
                client.getServer().kill(client.getUserId(), "Bye Bye");
                return false;
            }
            MWServ server = ((ServerWrapper)client.getServer()).getMWServ();
            server.getUser(username).setColor(UserColor);
            server.sendNewUserToAll(username, true);
            if (username.startsWith("Nobody")) {
                CampaignMain.cm.toUser("<font color=\"navy\"><br>---<br>It appears that you've misentered your password or tried to sign on using a name that is already taken.<br>---<br></font>", username, true);
            } else if (username.startsWith("[Dedicated]")) {
                CampaignMain.cm.toUser("SSC|UseAdvanceRepair|" + CampaignMain.cm.getConfig("UseAdvanceRepair") + "|UseSimpleRepair|" + CampaignMain.cm.getConfig("UseSimpleRepair") + "|AllowedMegaMekVersion|" + CampaignMain.cm.getConfig("AllowedMegaMekVersion") + "|MMTimeStampLogFile|" + CampaignMain.cm.getConfig("MMTimeStampLogFile"), client.getUserId(), false);
            } else {
                CampaignMain.cm.doLoginPlayer(username);
                CampaignMain.cm.getOpsManager().doReconnectCheckOnPlayer(username);
                if (client.getAccessLevel() < 2) {
                    CampaignMain.cm.toUser("<font color=\"navy\"><br>---<br>Warning: Your account is not password protected. [<a href=\"MWREG\">Click to register</a>]<br>---<br></font>", username, true);
                }
            }
            return true;
        }
        catch (NullPointerException NPE) {
            CampaignData.mwlog.errLog("Sign On Error");
            CampaignData.mwlog.errLog(NPE);
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                CampaignData.mwlog.errLog("Sign On Error: Null exception message");
                CampaignData.mwlog.errLog(e);
            } else {
                if (e.getMessage().equals("/denied")) {
                    String key;
                    client.error("/denied", e.getMessage());
                    do {
                        ++this.nobody_id;
                        key = "Nobody (" + this.nobody_id + ")";
                    } while (client.getServer().userExists(key));
                    args[1] = key;
                    return this.process(client, args);
                }
                CampaignData.mwlog.errLog(e);
            }
            String userId = client.getUserId();
            client.signOnError(e.getMessage(), userId);
        }
        return false;
    }
}

