/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.CampaignData;
import common.MMGame;
import common.comm.Command;
import common.comm.ServerCommand;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import server.ISPFilter;
import server.MWChatServer.MWChatClient;
import server.MWChatServer.MWChatServer;
import server.MWClientInfo;
import server.ServerWrapper;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.util.IpCountry;
import server.util.TrackerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWServ {
    public static final String SERVER_VERSION = "0.2.40.0";
    private ServerWrapper myCommunicator;
    private Hashtable<String, MMGame> games = new Hashtable();
    private Hashtable<String, MWClientInfo> users = new Hashtable();
    private Hashtable<InetAddress, Vector<MWClientInfo>> ips = new Hashtable();
    private Hashtable<InetAddress, Long> banips = new Hashtable();
    private Hashtable<String, String> banaccounts = new Hashtable();
    private Hashtable<String, Long> ISPlog = new Hashtable();
    private Hashtable<MWClientInfo, InetAddress> iphelp = new Hashtable();
    private Properties config = new Properties();
    private Hashtable<String, String> mails = new Hashtable();
    private Hashtable<InetAddress, String> iplog = new Hashtable();
    private IpCountry ipToCountry = null;
    private CampaignMain campaign;
    private Command.Table myCommands = new Command.Table();
    private Vector<String> ignoreList = new Vector(1, 1);
    private Vector<String> factionLeaderIgnoreList = new Vector(1, 1);

    public static void main(String[] argv) {
        new MWServ(argv);
    }

    public static void stop() {
        System.exit(0);
    }

    MWServ(String[] argv) {
        PrintStream ps;
        String logFileName = "./logs/logFile.txt";
        String errorFileName = "./logs/errorFile.txt";
        CampaignData.mwlog.createServerLoggers();
        CampaignData.mwlog.setServer(true);
        try {
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFileName), 64));
            System.setOut(ps);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Unable to redirect standard output to " + logFileName);
        }
        try {
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(errorFileName), 64));
            System.setErr(ps);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Unable to redirect standard error to " + errorFileName);
        }
        CampaignData.mwlog.log("----- MekWars Server V 0.2.40.0 is starting up... -----");
        CampaignData.mwlog.log("Loading configuration...");
        this.loadConfig();
        CampaignData.mwlog.log("Configuration loaded.");
        if (Boolean.parseBoolean(this.getConfigParam("RESOLVECOUNTRY"))) {
            this.ipToCountry = new IpCountry("./data/iplist.txt", "./data/countrynames.txt");
        }
        CampaignData.mwlog.log("Loading mail file...");
        this.mails = this.checkAndCreateConfig("./data/mails.txt");
        CampaignData.mwlog.log("Mail file loaded.");
        CampaignData.mwlog.log("Creating new campaign environment...");
        this.campaign = new CampaignMain(this);
        CampaignData.mwlog.log("Environment created.");
        CampaignData.mwlog.log("Initializing log subsystem. Touching log files.");
        CampaignData.mwlog.mainLog("Main channel log touched.");
        CampaignData.mwlog.gameLog("Game log touched.");
        CampaignData.mwlog.cmdLog("Command log touched.");
        CampaignData.mwlog.pmLog("Private messages (PM) log touched.");
        CampaignData.mwlog.bmLog("Black Market (BM) log touched.");
        CampaignData.mwlog.infoLog("Server info log touched.");
        CampaignData.mwlog.warnLog("Server warnings log touched.");
        CampaignData.mwlog.errLog("Server errors log touched.");
        CampaignData.mwlog.modLog("Moderators log touched.");
        CampaignData.mwlog.tickLog("Tick report log touched.");
        boolean useTracker = Boolean.parseBoolean(this.getConfigParam("USETRACKER"));
        CampaignData.mwlog.infoLog("Use Tracker: " + useTracker);
        if (useTracker) {
            CampaignData.mwlog.infoLog("Attempting to create TrackerThread in MWServ.");
            TrackerThread trackT = new TrackerThread(this);
            trackT.start();
        }
        CampaignData.mwlog.log("Entering main loop cycle. Starting the server...");
        this.startServer(argv);
    }

    public void loadConfig() {
        try {
            this.config.load(new FileInputStream("./data/serverconfig.txt"));
        }
        catch (Exception e) {
            this.config.setProperty("SERVERNAME", "MekWars Server");
            this.config.setProperty("INFOMESSAGE", "For MekWars project info, visit http://www.sourceforge.net/projects/mekwars");
            this.config.setProperty("RESOLVECOUNTRY", "true");
            this.config.setProperty("CAMPAIGNCONFIG", "./data/campaignconfig.txt");
            this.config.setProperty("DATAPORT", "4867");
            this.config.setProperty("USETRACKER", "false");
            this.config.setProperty("TRACKERADDRESS", "none");
            this.config.setProperty("TRACKERLINK", "none");
            this.config.setProperty("TRACKERDESC", "none");
            this.config.setProperty("SERVERIP", "-1");
            this.config.setProperty("USECYCLOPS", "false");
            this.config.setProperty("CYCLOPSIP", "muposerver.dyndns.org");
            this.config.setProperty("CYCLOPSURL", "http://muposerver.dyndns.org/devel/cyclops/XMLRPC/");
            this.config.setProperty("CYCLOPSDEBUG", "false");
            this.config.setProperty("USEMYSQL", "false");
            this.config.setProperty("MYSQLUSER", "");
            this.config.setProperty("MYSQLPASS", "");
            this.config.setProperty("MYSQLHOST", "");
            this.config.setProperty("MYSQLDB", "mekwars");
            this.config.setProperty("MYSQL_SYNCHPPHPBB", "false");
            this.config.setProperty("PHPBB_USER", "sa");
            this.config.setProperty("PHPBB_PASS", "master");
            this.config.setProperty("PHPBB_HOST", "localhost");
            this.config.setProperty("PHPBB_DB", "phpbb");
            this.config.setProperty("PHPBB_TABLE_PREFIX", "phpbb_");
            this.config.setProperty("PHPBB_MAJOR_VERSION", "2");
            this.config.setProperty("PHPBB_URL", "http://localhost/phpbb/index.php");
            try {
                this.config.store(new FileOutputStream("./data/serverconfig.txt"), "Server config File");
            }
            catch (Exception e1) {
                CampaignData.mwlog.errLog("config file could not be read or written, defaults will be used.");
                CampaignData.mwlog.errLog(e1);
            }
        }
        this.loadBanPlayers();
        this.loadBanIP();
        this.loadISPs();
    }

    public void startServer(String[] args) {
        if (args == null) {
            CampaignData.mwlog.infoLog("Server started without parameters");
        }
        try {
            this.myCommunicator = ServerWrapper.createServer(this);
            this.myCommunicator.start();
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("== PROBLEM STARTING SERVER WRAPPER ==");
            CampaignData.mwlog.errLog(e);
        }
    }

    public Hashtable<String, String> checkAndCreateConfig(String filename) {
        try {
            File configFile = new File(filename);
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            dis.readLine();
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            try {
                CampaignData.mwlog.infoLog("Creating new File");
                CampaignData.mwlog.mainLog("Creating new File");
                if (filename.equals("./data/mails.txt")) {
                    FileOutputStream out = new FileOutputStream(filename);
                    PrintStream p = new PrintStream(out);
                    p.println("<EOF>");
                    p.close();
                    out.close();
                }
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog(e);
                CampaignData.mwlog.mainLog("No file named " + filename + " was found and cannot create one!");
                System.exit(1);
            }
        }
        if (filename.equals("./data/mails.txt")) {
            return this.getMails();
        }
        return new Hashtable<String, String>();
    }

    public boolean clientLogin(String name) {
        Long until;
        String originalName = name;
        name = name.toLowerCase();
        InetAddress hisip = this.getIP(name);
        MWChatClient client = this.myCommunicator.getClient(name);
        if (!originalName.startsWith("[Dedicated]") && !originalName.startsWith("Nobody")) {
            String logname;
            if (this.iplog.get(hisip) != null && !name.equals(logname = this.iplog.get(hisip))) {
                SPlayer b;
                String nametmp = name;
                SPlayer a = this.getCampaign().getPlayer(name);
                if (a != null) {
                    nametmp = nametmp + " " + this.getCampaign().getPlayer(name).getMyHouse().getAbbreviation();
                }
                if ((b = this.getCampaign().getPlayer(logname)) != null) {
                    logname = logname + " " + this.getCampaign().getPlayer(logname).getMyHouse().getAbbreviation();
                }
                if (a != null && b != null) {
                    if (a.getGroupAllowance() != 0 && a.getGroupAllowance() != b.getGroupAllowance()) {
                        this.getCampaign().doSendModMail("NOTE:", "Double Accounting: " + nametmp + " Group: " + a.getGroupAllowance() + " and " + logname + " Group: " + b.getGroupAllowance() + " IP: " + hisip);
                    }
                } else {
                    this.getCampaign().doSendModMail("NOTE:", "Double Accounting: " + nametmp + " and " + logname + " IP: " + hisip);
                }
            }
            this.iplog.put(hisip, name);
        }
        if (this.banips.get(hisip) != null) {
            until = this.banips.get(hisip);
            if (until > System.currentTimeMillis() || until == 0L) {
                if (until != 0L) {
                    this.clientSend("CH|You are banned. You may not join this server until " + new Date(until).toString(), name);
                    this.getCampaign().doSendModMail("NOTE:", name + " (IP: " + hisip + ") tried to gain access to the server");
                }
                try {
                    Thread.sleep(125L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.myCommunicator.kill(name, "");
                return false;
            }
            this.banips.remove(hisip);
            this.bansUpdate();
        }
        if (this.banaccounts.get(name.toLowerCase()) != null) {
            until = Long.valueOf(this.banaccounts.get(name.toLowerCase()));
            if (until > System.currentTimeMillis() || until == 0L) {
                if (until != 0L) {
                    this.clientSend("CH|You are banned. You may not join this server until " + new Date(until).toString(), name);
                    this.getCampaign().doSendModMail("NOTE:", name + " (IP: " + hisip + ") tried to gain access to the server");
                }
                try {
                    Thread.sleep(125L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.myCommunicator.kill(name, "");
                return false;
            }
            this.banaccounts.remove(name);
            this.bansUpdate();
        }
        if (this.ISPlog.containsKey(client.getClientVersion())) {
            until = this.ISPlog.get(client.getClientVersion());
            if (until > System.currentTimeMillis() || until == 0L) {
                if (until != 0L) {
                    this.clientSend("CH|You have been banned. You may not join this server until " + new Date(until).toString(), name);
                    this.getCampaign().doSendModMail("NOTE:", name + " (IP: " + hisip + ") tried to gain access to the server");
                }
                try {
                    Thread.sleep(125L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.myCommunicator.kill(name, "");
                return false;
            }
            this.ISPlog.remove(name);
            this.bansUpdate();
        }
        int status = 2;
        MWChatClient c = this.myCommunicator.getClient(MWChatServer.clientKey(name));
        if (c != null) {
            status = c.getAccessLevel();
        }
        boolean invis = false;
        if (this.getCampaign().getPlayer(name) != null) {
            invis = this.getCampaign().getPlayer(name).isInvisible();
        }
        MWClientInfo newUser = new MWClientInfo(originalName, this.getIP(name), System.currentTimeMillis(), status, invis);
        CampaignData.mwlog.infoLog(originalName + " logged in from " + this.getIP(name).toString() + " at " + new Date(System.currentTimeMillis()).toString());
        if (!originalName.startsWith("[Dedicated]")) {
            Vector<MWClientInfo> allthose;
            if (this.ips.get(hisip) != null) {
                allthose = this.ips.get(hisip);
                StringBuilder result = new StringBuilder("Warning: " + originalName + " has the same IP as ");
                boolean allowed = true;
                int groupid = 0;
                for (int i = 0; i < allthose.size(); ++i) {
                    MWClientInfo user = allthose.elementAt(i);
                    if (originalName.equalsIgnoreCase(user.getName())) continue;
                    SPlayer p = this.getCampaign().getPlayer(user.getName());
                    if (p != null) {
                        if (i == 0) {
                            groupid = p.getGroupAllowance();
                        } else if (p.getGroupAllowance() != groupid || groupid == 0) {
                            allowed = false;
                        }
                    } else {
                        allowed = false;
                    }
                    result.append(user.getName());
                    if (allthose.size() <= i + 1) continue;
                    result.append(" and ");
                }
                if (!allowed) {
                    this.getCampaign().doSendModMail("NOTE:", result.toString());
                }
                allthose.add(newUser);
            } else {
                allthose = new Vector(1, 1);
                allthose.add(newUser);
                this.ips.put(hisip, allthose);
            }
            this.iphelp.put(newUser, hisip);
        }
        String clientVersion = "any " + SERVER_VERSION.substring(0, SERVER_VERSION.lastIndexOf(".")) + ".x";
        this.clientSend("CH|Welcome to " + this.getConfigParam("SERVERNAME") + " (Server Version: " + SERVER_VERSION + ", Compatible Clients: " + clientVersion + ")", name);
        this.clientSend("CH|" + this.getConfigParam("INFOMESSAGE"), name);
        for (MMGame currGame : this.games.values()) {
            if (currGame == null) continue;
            this.clientSend("SL|NG|" + currGame.toString(), name);
            this.clientSend("SL|SHS|" + currGame.getHostName() + "|" + currGame.getStatus(), name);
        }
        Enumeration<MWClientInfo> u = this.users.elements();
        String toSend = "US";
        while (u.hasMoreElements()) {
            toSend = toSend.concat("|" + u.nextElement().toString());
        }
        this.clientSend(toSend, name);
        if (Boolean.parseBoolean(this.getConfigParam("RESOLVECOUNTRY"))) {
            newUser.setCountry(this.getCountryString(this.getIP(name).toString().substring(1)));
        }
        this.users.put(name, newUser);
        return true;
    }

    public InetAddress getIP(String name) {
        return this.myCommunicator.getIP(name);
    }

    public boolean isAdmin(String username) {
        MWChatClient c = this.myCommunicator.getClient(MWChatServer.clientKey(username));
        if (username.startsWith("[Dedicated] ")) {
            return true;
        }
        return c != null && c.getAccessLevel() >= 200;
    }

    public boolean isModerator(String username) {
        MWChatClient c = this.myCommunicator.getClient(MWChatServer.clientKey(username));
        if (username.startsWith("[Dedicated] ")) {
            return true;
        }
        return c != null && c.getAccessLevel() >= 100;
    }

    public int getUserLevel(String username) {
        MWChatClient c = this.myCommunicator.getClient(MWChatServer.clientKey(username));
        if (c != null) {
            return c.getAccessLevel();
        }
        return 0;
    }

    public void clientLogout(String name) {
        if (name == null) {
            return;
        }
        MWClientInfo user = this.getUser(name);
        if (user == null) {
            return;
        }
        InetAddress hisip = this.iphelp.get(user);
        if (hisip != null) {
            Vector<MWClientInfo> all = this.ips.get(hisip);
            if (all != null) {
                if (all.size() == 1) {
                    this.ips.remove(hisip);
                } else {
                    while (all.remove(user)) {
                    }
                }
            }
            this.iphelp.remove(user);
        }
        this.campaign.getOpsManager().doDisconnectCheckOnPlayer(name);
        this.campaign.doLogoutPlayer(name);
        this.sendRemoveUserToAll(name, true);
        CampaignData.mwlog.infoLog("Client " + name + "logged out.");
        this.users.remove(name.toLowerCase());
        if (this.games.get(name) != null) {
            MMGame game = this.games.get(name);
            this.games.remove(name);
            this.doCloseGame(game);
        }
        for (MMGame currGame : this.games.values()) {
            this.doRemoveUserFromGame(name, currGame);
        }
    }

    public void clientSend(String msg, String name) {
        if (msg != null && !msg.trim().equals("CH|")) {
            this.myCommunicator.sendServerMessage(msg, name);
        }
    }

    public void broadcastRaw(String msg) {
        this.myCommunicator.broadcastComm(msg);
    }

    public void clientRecieve(String lineIn, String name) {
        block38: {
            StringTokenizer st = new StringTokenizer(lineIn, "|");
            try {
                String task = (String)st.nextElement();
                ServerCommand c = null;
                c = (ServerCommand)this.myCommands.get(task.toUpperCase());
                if (c != null) {
                    c.reset();
                    c.setUsername(name);
                    c.parseArguments(lineIn.substring(lineIn.indexOf("|") + 1));
                    return;
                }
                if (task.equals("NG")) {
                    MMGame newGame = new MMGame(st.nextToken());
                    if (newGame.getIp().equals("127.0.0.1") || newGame.getIp().equals("localhost")) {
                        newGame.setIp(this.myCommunicator.getClient(name).getHost());
                    }
                    this.games.put(name, newGame);
                    this.myCommunicator.broadcastComm("SL|NG|" + newGame.toString());
                } else if (task.equals("SGR")) {
                    String gameHost = st.nextToken();
                    if (this.games.containsKey(gameHost)) {
                        this.clientSend("RGTS|", gameHost);
                    }
                } else if (task.equals("CG")) {
                    MMGame game = this.games.remove(name);
                    this.doCloseGame(game);
                } else if (task.equals("LG")) {
                    MMGame toUpdate = this.games.get(st.nextToken());
                    if (toUpdate != null) {
                        this.doRemoveUserFromGame(name, toUpdate);
                    }
                } else if (task.equals("JG")) {
                    String hostName = st.nextToken();
                    MMGame toUpdate = this.games.get(hostName);
                    if (toUpdate != null && toUpdate.getCurrentPlayers().add(name)) {
                        this.myCommunicator.broadcastComm("SL|JG|" + toUpdate.getHostName() + "|" + name);
                    }
                    if (hostName.startsWith("[Dedicated]")) {
                        this.clientSend("PM|SERVER|You joined " + hostName + ". Please remember where you parked.", name);
                    }
                } else if (task.equals("SHS")) {
                    MMGame toUpdate = this.games.get(st.nextToken());
                    if (toUpdate.getHostName().startsWith("[Dedicated]") || name.equals(toUpdate.getHostName())) {
                        toUpdate.setStatus(st.nextToken());
                        this.myCommunicator.broadcastComm("SL|SHS|" + toUpdate.getHostName() + "|" + toUpdate.getStatus());
                    }
                } else if (task.equals("CH")) {
                    String text = st.nextToken();
                    while (st.hasMoreElements()) {
                        text = text + "|" + st.nextToken();
                    }
                    if (text.indexOf("href") != -1 && text.indexOf("MEKWARS") != -1 && !this.isAdmin(name)) {
                        this.clientSend("CH|Message deleted (external hyperlinks not allowed).", name);
                        return;
                    }
                    if (!text.startsWith("/") && text.length() > 450 && !this.isModerator(name)) {
                        this.clientSend("CH|Message blocked by the spam protector (450 char limit).", name);
                        return;
                    }
                    if (text.startsWith("/")) {
                        if ((text = text.substring(1)).toLowerCase().startsWith("c ")) {
                            this.campaign.fromUser(text, name);
                        } else {
                            text = "c " + text.trim().replaceFirst(" ", "#");
                            this.campaign.fromUser(text, name);
                        }
                    } else {
                        MWClientInfo client = this.getUser(name);
                        if (client != null) {
                            if (!this.ignoreList.contains(client.getName()) && !this.factionLeaderIgnoreList.contains(client.getName())) {
                                this.sendChat(name + "|" + text);
                            } else {
                                this.clientSend("CH|You've been set to ignore mode and cannot participate in chat.", name);
                            }
                        } else {
                            this.sendChat(name + "|" + text);
                        }
                    }
                } else if (task.equals("CR")) {
                    String result = st.nextToken();
                    CampaignData.mwlog.gameLog("Starting report process by " + name);
                    CampaignData.mwlog.gameLog(name + " reported: " + lineIn);
                    this.getCampaign().doProcessAutomaticReport(result, name);
                } else if (task.equals("IPU")) {
                    String result = st.nextToken();
                    this.getCampaign().addInProgressUpdate(result, name);
                } else {
                    this.clientSend("CH|Unknown command. Please make sure your client is up to date.", name);
                    CampaignData.mwlog.warnLog("Got a strange command, " + task + ", from " + name);
                }
            }
            catch (Exception ex) {
                if (lineIn.equals("GB")) break block38;
                this.clientSend("CH|Your Client sent a false packet or caused a server error. You probably entered an illegal server command.", name);
                CampaignData.mwlog.errLog("False packet/illegal command (from " + name + "):");
                CampaignData.mwlog.errLog(ex);
            }
        }
    }

    public void statusMessage() {
        CampaignData.mwlog.mainLog("Open Games: " + this.games.size());
        CampaignData.mwlog.infoLog("Open Games: " + this.games.size());
    }

    private void doCloseGame(MMGame game) {
        if (game != null) {
            this.myCommunicator.broadcastComm("SL|CG|" + game.getHostName());
        }
    }

    public void retreiveISPS(Long time, String name) {
        File tempFile = new File("./data/Providers/");
        if (!tempFile.exists()) {
            return;
        }
        ISPFilter filter = new ISPFilter();
        File[] fileList = tempFile.listFiles(filter);
        for (int i = 0; i < fileList.length; ++i) {
            try {
                File newFile = fileList[i];
                FileInputStream in = new FileInputStream(newFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(in));
                while (dis.ready()) {
                    String player = dis.readLine();
                    if (!player.equalsIgnoreCase(name)) continue;
                    String provderName = newFile.getName().substring(0, newFile.getName().lastIndexOf(".prv"));
                    CampaignData.mwlog.errLog("Provider: " + provderName);
                    this.ISPlog.put(provderName, time);
                    in.close();
                    dis.close();
                    break;
                }
                dis.close();
                in.close();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void sendRemoveUserToAll(String name, boolean userGone) {
        if (userGone) {
            CampaignData.mwlog.infoLog(name + " left the room.");
        }
        this.myCommunicator.broadcastComm("UG|" + this.getUser(name) + (userGone ? "|GONE" : ""));
    }

    public void sendNewUserToAll(String name, boolean newUser) {
        this.myCommunicator.broadcastComm("NU|" + this.getUser(name) + (newUser ? "|NEW" : ""));
    }

    public void sendChat(String s) {
        this.myCommunicator.broadcastComm("CH|" + s);
        CampaignData.mwlog.mainLog(s);
    }

    public void checkAndSendMail(String name) {
        if (this.mails.get(name.toLowerCase()) != null) {
            this.clientSend("PM|SERVER|You have stored mail.[<a href=\"MEKWARS/c requestservermail\">Read</a>]", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int userCount(boolean includeDeds) {
        if (includeDeds) {
            return this.users.size();
        }
        Hashtable<String, MWClientInfo> hashtable = this.users;
        synchronized (hashtable) {
            int toReturn = this.users.size();
            for (String client : this.users.keySet()) {
                if (client.toLowerCase().indexOf("[dedicated]") < 0 && !client.toLowerCase().startsWith("nobody")) continue;
                --toReturn;
            }
            return toReturn;
        }
    }

    public Hashtable<String, MWClientInfo> getUsers() {
        return this.users;
    }

    public CampaignMain getCampaign() {
        return this.campaign;
    }

    public Hashtable<String, String> getMails() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            File configFile = new File("./data/mails.txt");
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            String tmp = dis.readLine();
            while (tmp != null) {
                StringTokenizer st = new StringTokenizer(tmp, "|");
                if (st.hasMoreElements()) {
                    String name = (String)st.nextElement();
                    if (st.hasMoreElements()) {
                        String mail = (String)st.nextElement();
                        if (result.get(name) != null) {
                            result.put(name, this.mails.get(name) + "<br>" + mail);
                        } else {
                            result.put(name, mail);
                        }
                    }
                }
                tmp = dis.readLine();
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems reading mail file:");
            CampaignData.mwlog.errLog(ex);
        }
        return result;
    }

    public void doWriteMailFile() {
        try {
            FileOutputStream out = new FileOutputStream("./data/mails.txt");
            PrintStream p = new PrintStream(out);
            Enumeration<String> e = this.mails.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                p.println(key + "|" + this.mails.get(key));
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems writing mail file:");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void doStoreMailToHashtable(String from, String name, String text) {
        String[] ids;
        if (name == null || text == null) {
            return;
        }
        if (text.trim().startsWith("CH|")) {
            text = text.substring(3);
        }
        if (text.trim().startsWith("FSM|")) {
            text = text.substring(4);
        }
        if ((ids = TimeZone.getAvailableIDs(0)).length != 0) {
            SimpleTimeZone pdt = new SimpleTimeZone(0, ids[0]);
            GregorianCalendar now = new GregorianCalendar(pdt);
            Date currentTime = new Date();
            now.setTime(currentTime);
            text = now.get(2) + 1 + "/" + now.get(5) + " " + now.get(10) + ":" + now.get(12) + " " + text;
        }
        if (this.mails.get(name.toLowerCase()) == null) {
            this.mails.put(name.toLowerCase(), text);
        } else {
            this.mails.put(name.toLowerCase(), this.mails.get(name.toLowerCase()) + "<br>" + text);
        }
        this.doWriteMailFile();
    }

    public void doStoreMail(String s, String name) {
        StringTokenizer st = new StringTokenizer(s, ",");
        String target = "";
        String text = "";
        if (st.hasMoreElements()) {
            target = ((String)st.nextElement()).trim();
            if (st.hasMoreElements()) {
                text = "from " + name + ": ";
                String mailtext = "";
                while (st.hasMoreElements()) {
                    mailtext = mailtext + st.nextElement();
                }
                text = text + mailtext;
                if (this.getUser(target).getName().equalsIgnoreCase(target)) {
                    if (this.getUser(target).isInvis() && this.getUser(target).getLevel() > this.getUser(name).getLevel()) {
                        this.clientSend("CH|AM:Saved mail to " + target + ".", name);
                    }
                    this.clientSend("PM|" + name + "|" + mailtext, target);
                } else {
                    this.doStoreMailToHashtable(name, target, text);
                    this.clientSend("CH|AM:Saved mail to " + target + ".", name);
                }
                if (this.campaign.getPlayer(name) != null) {
                    if (this.campaign.getPlayer(target) != null) {
                        CampaignData.mwlog.pmLog(name + "[" + this.campaign.getPlayer(name).getMyHouse().getAbbreviation() + "] -> " + target + "[" + this.campaign.getPlayer(target).getMyHouse().getAbbreviation() + "]: " + mailtext);
                    } else {
                        CampaignData.mwlog.pmLog(name + "[" + this.campaign.getPlayer(name).getMyHouse().getAbbreviation() + "] -> " + target + ": " + mailtext);
                    }
                } else {
                    CampaignData.mwlog.pmLog(name + " -> " + target + ": " + mailtext);
                }
            }
        }
    }

    public String getCountryString(String ip) {
        String result;
        if (this.ipToCountry == null) {
            return "";
        }
        if (ip.startsWith("/")) {
            ip = ip.substring(1);
        }
        if ((result = this.ipToCountry.seachIpCountry(ip)).equals("LOC")) {
            result = "The LAN";
        }
        return result;
    }

    public MWClientInfo getUser(String name) {
        if (name == null || this.users.get(name.toLowerCase()) == null) {
            return new MWClientInfo();
        }
        return this.users.get(name.toLowerCase());
    }

    public String getConfigParam(String p) {
        String res = this.config.getProperty(p);
        if (res != null) {
            return res;
        }
        return "-1";
    }

    public void setConfigParam(String config, String text) {
        String res = this.config.getProperty(config);
        if (res != null) {
            this.config.setProperty(config, text);
        }
    }

    public void fromCampaignMod(String txt, String username) {
        try {
            MWClientInfo usr = this.users.get(username.toLowerCase());
            if (usr != null) {
                this.clientSend(txt, username);
            } else if (txt.startsWith("CH|") || txt.startsWith("FSM|")) {
                this.doStoreMailToHashtable(null, username, txt);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void doRemoveUserFromGame(String name, MMGame mygame) {
        if (mygame.getCurrentPlayers().remove(name)) {
            this.myCommunicator.broadcastComm("SL|LG|" + mygame.getHostName() + "|" + name);
        }
    }

    public void bansUpdate() {
        try {
            Object q;
            FileOutputStream out = new FileOutputStream("./data/accountbans.txt");
            PrintStream p = new PrintStream(out);
            Enumeration<Object> e = this.banaccounts.keys();
            while (e.hasMoreElements()) {
                q = e.nextElement();
                p.println(q + "=" + this.banaccounts.get(q));
            }
            p.close();
            out.close();
            out = new FileOutputStream("./data/ipbans.txt");
            p = new PrintStream(out);
            e = this.banips.keys();
            while (e.hasMoreElements()) {
                q = e.nextElement();
                p.println(q + "=" + this.banips.get(q));
            }
            p.close();
            out.close();
            out = new FileOutputStream("./data/isps.txt");
            p = new PrintStream(out);
            for (String key : this.ISPlog.keySet()) {
                p.println(key + "=" + this.ISPlog.get(key));
            }
            p.close();
            out.close();
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("Problem updating ban files:");
            CampaignData.mwlog.errLog(e);
        }
    }

    public Vector<String> getIgnoreList() {
        return this.ignoreList;
    }

    public Vector<String> getFactionLeaderIgnoreList() {
        return this.factionLeaderIgnoreList;
    }

    public Hashtable<String, String> getServerMail() {
        return this.mails;
    }

    public void loadBanIP() {
        try {
            File banFile = new File("./data/ipbans.txt");
            if (!banFile.exists()) {
                banFile.createNewFile();
            }
            FileInputStream fis = new FileInputStream(banFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                InetAddress ia;
                String line = dis.readLine();
                StringTokenizer ST = new StringTokenizer(line, "=");
                String ip = ST.nextToken();
                Long time = Long.valueOf(ST.nextToken());
                if (ip.indexOf("/") > -1) {
                    ip = ip.substring(ip.indexOf("/") + 1);
                }
                if ((ia = InetAddress.getByName(ip)) != null) {
                    this.banips.put(ia, time);
                    CampaignData.mwlog.infoLog("Added " + line + " to the list of banned IPs");
                    CampaignData.mwlog.mainLog("Added " + line + " to the list of banned IP's");
                    continue;
                }
                CampaignData.mwlog.warnLog("Importing IP bans; offending line: " + line);
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems with loading IP banlist:");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void loadBanPlayers() {
        try {
            CampaignData.mwlog.infoLog("Loading Ban Players");
            File banFile = new File("./data/accountbans.txt");
            if (!banFile.exists()) {
                banFile.createNewFile();
            }
            FileInputStream fis = new FileInputStream(banFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                String input = dis.readLine();
                StringTokenizer st = new StringTokenizer(input, "=");
                String toBan = st.nextToken().trim();
                String howLong = st.nextToken().trim();
                if (toBan != null && howLong != null) {
                    this.banaccounts.put(toBan.toLowerCase(), howLong);
                    CampaignData.mwlog.infoLog("Added " + toBan + " to the banlist (for " + howLong + ")");
                    CampaignData.mwlog.mainLog("Added " + toBan + " to the banlist (for " + howLong + ")");
                    continue;
                }
                CampaignData.mwlog.warnLog("Initial bans warning: " + toBan + " / " + howLong);
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems reading ban file at startup!");
        }
    }

    public void loadISPs() {
        try {
            CampaignData.mwlog.infoLog("Loading ISPs");
            File ispFile = new File("./data/isps.txt");
            if (!ispFile.exists()) {
                ispFile.createNewFile();
            }
            FileInputStream fis = new FileInputStream(ispFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                String input = dis.readLine();
                StringTokenizer st = new StringTokenizer(input, "=");
                String isp = st.nextToken().trim();
                Long address = Long.parseLong(st.nextToken().trim());
                if (isp == null || address == null) continue;
                this.ISPlog.put(isp.toLowerCase(), address);
                CampaignData.mwlog.infoLog("Added " + isp + " to the ISP List");
                CampaignData.mwlog.mainLog("Added " + isp + " to the ISP List");
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems reading ISP file at startup!");
        }
    }

    public void killClient(String toKick, String kicker) {
        this.myCommunicator.kill(toKick, this.myCommunicator.getClient(MWChatServer.clientKey(this.myCommunicator.getClient(kicker))), "");
    }

    public MWChatClient getClient(String name) {
        return this.myCommunicator.getClient(name);
    }

    public Hashtable<MWClientInfo, InetAddress> getIPHelp() {
        return this.iphelp;
    }

    public Hashtable<InetAddress, Long> getBanIps() {
        return this.banips;
    }

    public Hashtable<String, String> getBanAccounts() {
        return this.banaccounts;
    }
}

