/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.CampaignData;
import common.comm.TransportCodec;
import common.util.StringUtils;
import java.net.InetAddress;
import java.util.Map;
import server.MWChatServer.MWChatClient;
import server.MWChatServer.MWChatServer;
import server.MWChatServer.auth.Auth;
import server.MWServ;

public class ServerWrapper
extends MWChatServer {
    MWServ myServer;

    public static ServerWrapper createServer(MWServ server) throws Exception {
        return new ServerWrapper(server);
    }

    public ServerWrapper(MWServ server) throws Exception {
        super(server.getConfigParam("SERVERIP"), Integer.parseInt(server.getConfigParam("SERVERPORT")));
        this.myServer = server;
    }

    public void start() {
        CampaignData.mwlog.mainLog("Starting");
        this.acceptConnections();
    }

    public MWServ getMWServ() {
        return this.myServer;
    }

    public void processCommand(String username, String command) {
        if (username == null) {
            return;
        }
        try {
            this.myServer.clientRecieve(command, username);
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
        }
    }

    public void sendServerMessage(String msg, String name) {
        MWChatClient client = this.getClient(MWChatServer.clientKey(name));
        if (client != null) {
            try {
                client.sendRaw("/comm\t" + TransportCodec.encode(msg));
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastComm(String command) {
        Map map = this._users;
        synchronized (map) {
            for (MWChatClient cc : this._users.values()) {
                this.sendServerMessage(command, MWChatServer.clientKey(cc));
            }
        }
    }

    public InetAddress getIP(String username) {
        try {
            MWChatClient c = this.getClient(username);
            if (c == null) {
                CampaignData.mwlog.mainLog("WARNING: Tried to get the IP from " + username + ", who is not here.");
                try {
                    return InetAddress.getLocalHost();
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                    return null;
                }
            }
            return InetAddress.getByName(c.getHost());
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
            try {
                return InetAddress.getLocalHost();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signOn(MWChatClient client, String password) throws Exception {
        CampaignData.mwlog.infoLog(client.getUserId() + " is attempting a signon: ");
        String userId = client.getUserId();
        this.validateUserId(userId);
        Auth auth = null;
        auth = this._authenticator.authenticate(client, password);
        client.setUserId(auth.getUserId());
        Map map = this._users;
        synchronized (map) {
            if (this.userExists(ServerWrapper.clientKey(client))) {
                if (auth.getAccess() >= 2 || auth.getAccess() < 2 && client.getUserId().startsWith("[Dedicated]")) {
                    this.signOff(client.getServer().getClient(ServerWrapper.clientKey(client)));
                } else {
                    throw new Exception("/denied");
                }
            }
            int access = auth.getAccess();
            client.setAccessLevel(access);
            this._users.put(ServerWrapper.clientKey(client), client);
            CampaignData.mwlog.infoLog(client.getUserId() + " is authenticated.  Access = " + access + (client.getTunneling() ? " (tunneling)" : ""));
            ++this._cumulativeLogins;
        }
        client.ackSignon(auth.getUserId());
        return this.myServer.clientLogin(client.getUserId());
    }

    public void signOff(MWChatClient client) {
        super.signOff(client);
        try {
            this.myServer.clientLogout(client.getUserId());
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog(e);
        }
    }

    protected void validateUserId(String user) throws Exception {
        if (this.getName().toLowerCase().equals(user.toLowerCase())) {
            throw new Exception(user + " is a reserved name");
        }
        if (StringUtils.hasBadChars(user).trim().length() > 0) {
            throw new Exception("/badchars");
        }
    }
}

