/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoArmy {
    private Vector<SUnit> theUnits;

    public AutoArmy(int i, boolean Guns) {
        this.theUnits = Guns ? this.generateGuns(i) : this.generateAuto(i);
    }

    private Vector<SUnit> generateAuto(int i) {
        int bvOfSArmy = i;
        Vector<SUnit> autoUnits = new Vector<SUnit>(1, 1);
        if (i <= 0) {
            return autoUnits;
        }
        int maxLight = CampaignMain.cm.getIntegerConfig("MaxLightArtillery");
        int maxMedium = CampaignMain.cm.getIntegerConfig("MaxMediumArtillery");
        int maxHeavy = CampaignMain.cm.getIntegerConfig("MaxHeavyArtillery");
        int maxAssault = CampaignMain.cm.getIntegerConfig("MaxAssaultArtillery");
        int[] maxNumOfEachWeight = new int[]{maxLight, maxMedium, maxHeavy, maxAssault};
        int bvForLight = CampaignMain.cm.getIntegerConfig("BVForLightArtillery");
        int bvForMedium = CampaignMain.cm.getIntegerConfig("BVForMediumArtillery");
        int bvForHeavy = CampaignMain.cm.getIntegerConfig("BVForHeavyArtillery");
        int bvForAssault = CampaignMain.cm.getIntegerConfig("BVForAssaultArtillery");
        int[] bvForEachWeight = new int[]{bvForLight, bvForMedium, bvForHeavy, bvForAssault};
        boolean topToBottom = CampaignMain.cm.getBooleanConfig("HeaviestArtilleryFirst");
        int[] loadOrder = new int[]{0, 1, 2, 3};
        loadOrder[0] = 1;
        int[] remainingWeights = new int[]{1, 2, 3};
        int preferedWeight = loadOrder[0];
        int currentWeight = 0;
        for (int j = 0; j < 3; ++j) {
            if (currentWeight == preferedWeight) {
                // empty if block
            }
            remainingWeights[j] = ++currentWeight;
            ++currentWeight;
        }
        if (topToBottom) {
            loadOrder[1] = remainingWeights[2];
            loadOrder[2] = remainingWeights[1];
            loadOrder[3] = remainingWeights[0];
        } else {
            loadOrder[1] = remainingWeights[0];
            loadOrder[2] = remainingWeights[1];
            loadOrder[3] = remainingWeights[2];
        }
        for (int k = 0; k < 4; ++k) {
            int currWeight = loadOrder[k];
            int bvForCurrWeight = bvForEachWeight[currWeight];
            int maxNumOfCurrWeight = maxNumOfEachWeight[currWeight];
            for (int numOfCurrWeight = 0; bvOfSArmy >= bvForCurrWeight && numOfCurrWeight < maxNumOfCurrWeight; bvOfSArmy -= bvForCurrWeight, ++numOfCurrWeight) {
                autoUnits.add(this.makeNewArtilleryPiece(currWeight));
            }
        }
        return autoUnits;
    }

    public SUnit makeNewArtilleryPiece(int i) {
        StringTokenizer list;
        String filename = "";
        int size = 0;
        int position = 0;
        if (0 == i) {
            list = new StringTokenizer(CampaignMain.cm.getConfig("LightArtilleryFile"), "$");
            size = list.countTokens();
            if (size == 1) {
                filename = list.nextToken();
            } else {
                position = CampaignMain.cm.getRandomNumber(size) + 1;
                for (int count = 0; count < position; ++count) {
                    filename = list.nextToken();
                }
            }
        } else if (1 == i) {
            list = new StringTokenizer(CampaignMain.cm.getConfig("MediumArtilleryFile"), "$");
            size = list.countTokens();
            if (size == 1) {
                filename = list.nextToken();
            } else {
                position = CampaignMain.cm.getRandomNumber(size) + 1;
                for (int count = 0; count < position; ++count) {
                    filename = list.nextToken();
                }
            }
        } else if (2 == i) {
            list = new StringTokenizer(CampaignMain.cm.getConfig("HeavyArtilleryFile"), "$");
            size = list.countTokens();
            if (size == 1) {
                filename = list.nextToken();
            } else {
                position = CampaignMain.cm.getRandomNumber(size) + 1;
                for (int count = 0; count < position; ++count) {
                    filename = list.nextToken();
                }
            }
        } else {
            list = new StringTokenizer(CampaignMain.cm.getConfig("AssaultArtilleryFile"), "$");
            size = list.countTokens();
            if (size == 1) {
                filename = list.nextToken();
            } else {
                position = CampaignMain.cm.getRandomNumber(size) + 1;
                for (int count = 0; count < position; ++count) {
                    filename = list.nextToken();
                }
            }
        }
        SUnit cm = new SUnit("autoassigned unit", filename, i);
        return cm;
    }

    private Vector<SUnit> generateGuns(int i) {
        int bvOfSArmy = i;
        Vector<SUnit> autoUnits = new Vector<SUnit>(1, 1);
        if (i <= 0) {
            return autoUnits;
        }
        int maxLight = CampaignMain.cm.getIntegerConfig("MaxLightGunEmplacement");
        int maxMedium = CampaignMain.cm.getIntegerConfig("MaxMediumGunEmplacement");
        int maxHeavy = CampaignMain.cm.getIntegerConfig("MaxHeavyGunEmplacement");
        int maxAssault = CampaignMain.cm.getIntegerConfig("MaxAssaultGunEmplacement");
        int[] maxNumOfEachWeight = new int[]{maxLight, maxMedium, maxHeavy, maxAssault};
        int bvForLight = CampaignMain.cm.getIntegerConfig("BVForLightGunEmplacement");
        int bvForMedium = CampaignMain.cm.getIntegerConfig("BVForMediumGunEmplacement");
        int bvForHeavy = CampaignMain.cm.getIntegerConfig("BVForHeavyGunEmplacement");
        int bvForAssault = CampaignMain.cm.getIntegerConfig("BVForAssaultGunEmplacement");
        int[] bvForEachWeight = new int[]{bvForLight, bvForMedium, bvForHeavy, bvForAssault};
        boolean topToBottom = CampaignMain.cm.getBooleanConfig("HeaviestGunEmplacementFirst");
        int[] loadOrder = new int[]{0, 1, 2, 3};
        loadOrder[0] = 1;
        int[] remainingWeights = new int[]{1, 2, 3};
        int preferedWeight = loadOrder[0];
        int currentWeight = 0;
        for (int j = 0; j < 3; ++j) {
            if (currentWeight == preferedWeight) {
                // empty if block
            }
            remainingWeights[j] = ++currentWeight;
            ++currentWeight;
        }
        if (topToBottom) {
            loadOrder[1] = remainingWeights[2];
            loadOrder[2] = remainingWeights[1];
            loadOrder[3] = remainingWeights[0];
        } else {
            loadOrder[1] = remainingWeights[0];
            loadOrder[2] = remainingWeights[1];
            loadOrder[3] = remainingWeights[2];
        }
        for (int k = 0; k < 4; ++k) {
            int currWeight = loadOrder[k];
            int bvForCurrWeight = bvForEachWeight[currWeight];
            int maxNumOfCurrWeight = maxNumOfEachWeight[currWeight];
            for (int numOfCurrWeight = 0; bvOfSArmy >= bvForCurrWeight && numOfCurrWeight < maxNumOfCurrWeight; bvOfSArmy -= bvForCurrWeight, ++numOfCurrWeight) {
                autoUnits.addAll(this.makeNewGunEmplacement(currWeight));
            }
        }
        return autoUnits;
    }

    public Vector<SUnit> makeNewGunEmplacement(int i) {
        String filename = "";
        int size = 0;
        int position = 0;
        Vector<SUnit> returnedUnits = new Vector<SUnit>(1, 1);
        if (0 == i) {
            StringTokenizer list = new StringTokenizer(CampaignMain.cm.getConfig("LightGunEmplacementFile"), "$");
            size = list.countTokens();
            if (size == 1) {
                filename = list.nextToken();
            } else {
                position = CampaignMain.cm.getRandomNumber(size) + 1;
                for (int count = 0; count < position; ++count) {
                    filename = list.nextToken();
                }
            }
        } else if (1 == i) {
            StringTokenizer list = new StringTokenizer(CampaignMain.cm.getConfig("MediumGunEmplacementFile"), "$");
            size = list.countTokens();
            if (size == 1) {
                filename = list.nextToken();
            } else {
                position = CampaignMain.cm.getRandomNumber(size) + 1;
                for (int count = 0; count < position; ++count) {
                    filename = list.nextToken();
                }
            }
        } else if (2 == i) {
            StringTokenizer list = new StringTokenizer(CampaignMain.cm.getConfig("HeavyGunEmplacementFile"), "$");
            size = list.countTokens();
            if (size == 1) {
                filename = list.nextToken();
            } else {
                position = CampaignMain.cm.getRandomNumber(size) + 1;
                for (int count = 0; count < position; ++count) {
                    filename = list.nextToken();
                }
            }
        } else {
            StringTokenizer list = new StringTokenizer(CampaignMain.cm.getConfig("AssaultGunEmplacementFile"), "$");
            size = list.countTokens();
            if (size == 1) {
                filename = list.nextToken();
            } else {
                position = CampaignMain.cm.getRandomNumber(size) + 1;
                for (int count = 0; count < position; ++count) {
                    filename = list.nextToken();
                }
            }
        }
        if (filename.toLowerCase().endsWith(".mul")) {
            returnedUnits.addAll(SUnit.createMULUnits(filename));
        } else {
            returnedUnits.add(new SUnit("autoassigned unit", filename, i));
        }
        return returnedUnits;
    }

    public Vector<SUnit> getUnits() {
        return this.theUnits;
    }

    public int getBV() {
        int toReturn = 0;
        for (SUnit currU : this.getUnits()) {
            toReturn += currU.getBV();
        }
        return toReturn;
    }

    public String toString(String delimiter) {
        StringBuilder result = new StringBuilder();
        Vector<SUnit> v = this.getUnits();
        try {
            v.elements();
        }
        catch (Exception e) {
            CampaignData.mwlog.mainLog("AUTOARMY UNITS WERE NULL");
        }
        for (SUnit currU : this.getUnits()) {
            result.append(currU.getEntity().getChassis());
            result.append(" ");
            result.append(currU.getEntity().getModel());
            result.append(delimiter);
        }
        return result.toString();
    }
}

