/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import common.Unit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import server.campaign.CampaignMain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTable {
    public static final String STANDARD = "standard";
    public static final String RARE = "rare";
    public static final String REWARD = "reward";
    public static final String TECH = "tech";

    public static String getUnitFilename(String unitProducer, String size, int type_id, String dir) {
        boolean fileFound = false;
        String Filename = "";
        Vector<String> table = null;
        while (!fileFound) {
            String fileToRead = BuildTable.getFileName(unitProducer, size, dir, type_id);
            table = BuildTable.getListFromFile(new File(fileToRead));
            if (table.size() < 1) {
                return "Error OMG URFD.mtf";
            }
            int ran = CampaignMain.cm.getRandomNumber(table.size());
            Filename = table.elementAt(ran);
            if (Filename.indexOf(".") == -1) {
                unitProducer = Filename;
                continue;
            }
            fileFound = true;
        }
        return Filename;
    }

    public static String getUnitFilename(String unitFileName) {
        boolean fileFound = false;
        String Filename = "";
        Vector<String> table = null;
        while (!fileFound) {
            table = BuildTable.getListFromFile(new File(unitFileName));
            if (table.size() < 1) {
                return "Error OMG URFD.mtf";
            }
            int ran = CampaignMain.cm.getRandomNumber(table.size());
            Filename = table.elementAt(ran);
            if (Filename.indexOf(".") == -1) {
                unitFileName = Filename;
                continue;
            }
            fileFound = true;
        }
        return Filename;
    }

    public static String getFileName(String faction, String weightclass, String dir, int Type2) {
        String result;
        String addon = "";
        if (Type2 != 0) {
            addon = Unit.getTypeClassDesc(Type2);
        }
        if (!new File(result = "./data/buildtables/" + dir + "/" + faction + "_" + weightclass + addon + ".txt").exists()) {
            if (!result.trim().toLowerCase().endsWith(".txt")) {
                CampaignData.mwlog.errLog("Unable to find build table file " + result + " using ./data/buildtables/" + dir + "/Common_" + weightclass + addon + ".txt");
            }
            result = "./data/buildtables/" + dir + "/Common_" + weightclass + addon + ".txt";
        }
        return result;
    }

    public static String getTechFileName(String faction, String weightclass, int Type2) {
        String result;
        String addon = "";
        if (Type2 != 0) {
            addon = Unit.getTypeClassDesc(Type2);
        }
        if (!new File(result = "./data/buildtables/tech/" + faction + "_" + weightclass + addon + ".txt").exists()) {
            result = "";
        }
        return result;
    }

    private static Vector<String> getListFromFile(File prodFile) {
        Vector<String> result = new Vector<String>();
        ConcurrentHashMap<String, Integer> unitHolder = new ConcurrentHashMap<String, Integer>();
        try {
            FileInputStream fis = new FileInputStream(prodFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                StringTokenizer ST;
                String l = dis.readLine();
                if (l == null || l.trim().length() == 0) continue;
                l = l.trim();
                if ((l = l.replaceAll("\\s+", " ")).indexOf(" ") == 0) {
                    l = l.substring(1, l.length());
                }
                if (!(ST = new StringTokenizer(l.trim())).hasMoreElements()) continue;
                int amount = Integer.parseInt((String)ST.nextElement());
                StringBuilder filename = new StringBuilder();
                while (ST.hasMoreElements()) {
                    filename.append(ST.nextToken());
                    if (!ST.hasMoreTokens()) continue;
                    filename.append(" ");
                }
                if (amount <= 0) continue;
                unitHolder.put(filename.toString(), amount);
            }
            dis.close();
            fis.close();
            while (unitHolder.size() > 0) {
                for (String filename : unitHolder.keySet()) {
                    result.add(filename);
                    int count = (Integer)unitHolder.get(filename);
                    if (--count < 1) {
                        unitHolder.remove(filename);
                        continue;
                    }
                    unitHolder.put(filename, count);
                }
            }
            result.trimToSize();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        return result;
    }

    public static void saveBuildTableFile(String name, String folder, ConcurrentHashMap<String, Integer> unitHolder) {
        File prodFile = new File("./data/buildtables/" + folder + "/" + name);
        BuildTable.saveBuildTableFile(prodFile, unitHolder);
    }

    public static void saveBuildTableFile(File file, ConcurrentHashMap<String, Integer> unitHolder) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream ps = new PrintStream(fos);
            for (String key : unitHolder.keySet()) {
                ps.println(unitHolder.get(key) + " " + key);
            }
            ps.close();
            fos.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public static ConcurrentHashMap<String, Integer> loadBuildTable(File prodFile) {
        ConcurrentHashMap<String, Integer> unitHolder = new ConcurrentHashMap<String, Integer>();
        try {
            FileInputStream fis = new FileInputStream(prodFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                StringTokenizer ST;
                String l = dis.readLine();
                if (l == null || l.trim().length() == 0) continue;
                l = l.trim();
                if ((l = l.replaceAll("\\s+", " ")).indexOf(" ") == 0) {
                    l = l.substring(1, l.length());
                }
                if (!(ST = new StringTokenizer(l.trim())).hasMoreElements()) continue;
                int amount = Integer.parseInt((String)ST.nextElement());
                StringBuilder filename = new StringBuilder();
                while (ST.hasMoreElements()) {
                    filename.append(ST.nextToken());
                    if (!ST.hasMoreTokens()) continue;
                    filename.append(" ");
                }
                if (amount <= 0) continue;
                unitHolder.put(filename.toString(), amount);
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        return unitHolder;
    }
}

