/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import common.Equipment;
import common.House;
import common.Influences;
import common.Planet;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import megamek.MegaMek;
import megamek.client.Client;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.WeaponType;
import megamek.common.options.IOption;
import server.MWServ;
import server.campaign.DefaultServerOptions;
import server.campaign.ImmunityThread;
import server.campaign.NewbieHouse;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SliceThread;
import server.campaign.TickThread;
import server.campaign.UnitCosts;
import server.campaign.commands.AcceptAttackFromReserveCommand;
import server.campaign.commands.AcceptContractCommand;
import server.campaign.commands.ActivateCommand;
import server.campaign.commands.ArmyLowerLimiterCommand;
import server.campaign.commands.ArmyOpForceSizeCommand;
import server.campaign.commands.ArmyUpperLimiterCommand;
import server.campaign.commands.AttackCommand;
import server.campaign.commands.AttackFromReserveCommand;
import server.campaign.commands.AutoPlanetStatusCommand;
import server.campaign.commands.BMStatusCommand;
import server.campaign.commands.BidCommand;
import server.campaign.commands.BuildTableListCommand;
import server.campaign.commands.BuyBaysCommand;
import server.campaign.commands.BuyPartsCommand;
import server.campaign.commands.BuyPilotsFromHouseCommand;
import server.campaign.commands.CalcDistCommand;
import server.campaign.commands.CancelOfferCommand;
import server.campaign.commands.CheckArmyEligibilityCommand;
import server.campaign.commands.CheckArmyLinkCommand;
import server.campaign.commands.CheckAttackCommand;
import server.campaign.commands.CheckDistCommand;
import server.campaign.commands.CodeTestCommand;
import server.campaign.commands.ColorCommand;
import server.campaign.commands.Command;
import server.campaign.commands.CommenceOperationCommand;
import server.campaign.commands.CreateArmyCommand;
import server.campaign.commands.DeactivateCommand;
import server.campaign.commands.DeclineAttackFromReserveCommand;
import server.campaign.commands.DefectCommand;
import server.campaign.commands.DefendCommand;
import server.campaign.commands.DirectSellUnitCommand;
import server.campaign.commands.DisplayPlayerPersonalPilotQueueCommand;
import server.campaign.commands.DisplayUnitRepairJobsCommand;
import server.campaign.commands.DonateCommand;
import server.campaign.commands.DonatePilotCommand;
import server.campaign.commands.EmployeeHouseMailCommand;
import server.campaign.commands.EnrollCommand;
import server.campaign.commands.ExchangePilotInUnitCommand;
import server.campaign.commands.ExchangeUnitCommand;
import server.campaign.commands.FireTechsCommand;
import server.campaign.commands.GamesCommand;
import server.campaign.commands.GetFactionConfigsCommand;
import server.campaign.commands.GetSavedMailCommand;
import server.campaign.commands.GetServerMegaMekGameOptionsCommand;
import server.campaign.commands.GetServerOpFlagsCommand;
import server.campaign.commands.HireTechsCommand;
import server.campaign.commands.HouseCommand;
import server.campaign.commands.HouseContractsCommand;
import server.campaign.commands.HouseMailCommand;
import server.campaign.commands.HouseRankingCommand;
import server.campaign.commands.HouseStatusCommand;
import server.campaign.commands.ISStatusCommand;
import server.campaign.commands.InCharacterCommand;
import server.campaign.commands.JoinAttackCommand;
import server.campaign.commands.LastOnlineCommand;
import server.campaign.commands.LinkUnitCommand;
import server.campaign.commands.ListCommandsCommand;
import server.campaign.commands.ListServerOpFlagsCommand;
import server.campaign.commands.ListSubFactionCommand;
import server.campaign.commands.LoginCommand;
import server.campaign.commands.LogoutCommand;
import server.campaign.commands.MOTDCommand;
import server.campaign.commands.MailCommand;
import server.campaign.commands.MeCommand;
import server.campaign.commands.MercStatusCommand;
import server.campaign.commands.MyBidsCommand;
import server.campaign.commands.MyStatusCommand;
import server.campaign.commands.MyVotesCommand;
import server.campaign.commands.NameArmyCommand;
import server.campaign.commands.NamePilotCommand;
import server.campaign.commands.NoPlayCommand;
import server.campaign.commands.OfferContractCommand;
import server.campaign.commands.PlanetCommand;
import server.campaign.commands.PlayerLockArmyCommand;
import server.campaign.commands.PlayerUnlockArmyCommand;
import server.campaign.commands.PlayersCommand;
import server.campaign.commands.PromotePilotCommand;
import server.campaign.commands.RangeCommand;
import server.campaign.commands.RecallBidCommand;
import server.campaign.commands.RecallCommand;
import server.campaign.commands.RefreshFactoryCommand;
import server.campaign.commands.RefuseContractCommand;
import server.campaign.commands.RegisterCommand;
import server.campaign.commands.ReloadAllAmmoCommand;
import server.campaign.commands.RemoveArmyCommand;
import server.campaign.commands.RemoveVoteCommand;
import server.campaign.commands.RepairUnitCommand;
import server.campaign.commands.RepodCommand;
import server.campaign.commands.RequestBuildTableCommand;
import server.campaign.commands.RequestCommand;
import server.campaign.commands.RequestDonatedCommand;
import server.campaign.commands.RequestOperationSettingsCommand;
import server.campaign.commands.RequestServerMailCommand;
import server.campaign.commands.RequestSubFactionPromotionCommand;
import server.campaign.commands.RetirePilotCommand;
import server.campaign.commands.RollCommand;
import server.campaign.commands.SMOTDCommand;
import server.campaign.commands.SalvageUnitCommand;
import server.campaign.commands.ScrapCommand;
import server.campaign.commands.SellBaysCommand;
import server.campaign.commands.SellCommand;
import server.campaign.commands.SendClientDataCommand;
import server.campaign.commands.SendToMiscCommand;
import server.campaign.commands.ServerVersionCommand;
import server.campaign.commands.SetAutoEjectCommand;
import server.campaign.commands.SetAutoReorderCommand;
import server.campaign.commands.SetClientVersionCommand;
import server.campaign.commands.SetEdgeSkillsCommand;
import server.campaign.commands.SetMOTDCommand;
import server.campaign.commands.SetMaintainedCommand;
import server.campaign.commands.SetMyLogoCommand;
import server.campaign.commands.SetTargetSystemTypeCommand;
import server.campaign.commands.SetUnitAmmoByCritCommand;
import server.campaign.commands.SetUnitAmmoCommand;
import server.campaign.commands.SetUnitBurstCommand;
import server.campaign.commands.SetUnitCommanderCommand;
import server.campaign.commands.SetUnmaintainedCommand;
import server.campaign.commands.ShowToHouseCommand;
import server.campaign.commands.SignOffCommand;
import server.campaign.commands.SimpleRepairCommand;
import server.campaign.commands.StopRepairJobCommand;
import server.campaign.commands.TerminateCommand;
import server.campaign.commands.TickCommand;
import server.campaign.commands.ToggleArmyDisabledCommand;
import server.campaign.commands.TransferMoneyCommand;
import server.campaign.commands.TransferPilotCommand;
import server.campaign.commands.TransferUnitCommand;
import server.campaign.commands.UnemployedMercsCommand;
import server.campaign.commands.UnenrollCommand;
import server.campaign.commands.UnitPositionCommand;
import server.campaign.commands.UseRewardPointsCommand;
import server.campaign.commands.ValidateEmailCommand;
import server.campaign.commands.VoteCommand;
import server.campaign.commands.admin.AddOmniVariantModCommand;
import server.campaign.commands.admin.AddSongCommand;
import server.campaign.commands.admin.AddTraitCommand;
import server.campaign.commands.admin.AdminAddServerOpFlagsCommand;
import server.campaign.commands.admin.AdminAllowHouseDefectionCommand;
import server.campaign.commands.admin.AdminCalculateHouseRankingsCommand;
import server.campaign.commands.admin.AdminChangeFactionConfigCommand;
import server.campaign.commands.admin.AdminChangePlanetOwnerCommand;
import server.campaign.commands.admin.AdminChangeServerConfigCommand;
import server.campaign.commands.admin.AdminCreateFactionCommand;
import server.campaign.commands.admin.AdminCreateFactoryCommand;
import server.campaign.commands.admin.AdminCreatePlanetCommand;
import server.campaign.commands.admin.AdminCreateSolarisCommand;
import server.campaign.commands.admin.AdminCreateTerrainCommand;
import server.campaign.commands.admin.AdminDestroyFactoryCommand;
import server.campaign.commands.admin.AdminDestroyPlanetCommand;
import server.campaign.commands.admin.AdminDestroyTerrainCommand;
import server.campaign.commands.admin.AdminDonateCommand;
import server.campaign.commands.admin.AdminExchangePlanetOwnershipCommand;
import server.campaign.commands.admin.AdminGetUnitComponentsCommand;
import server.campaign.commands.admin.AdminGrantComponentsCommand;
import server.campaign.commands.admin.AdminHousePilotsCommand;
import server.campaign.commands.admin.AdminHouseStatusCommand;
import server.campaign.commands.admin.AdminListAndRemoveOMGCommand;
import server.campaign.commands.admin.AdminListHouseBannedAmmoCommand;
import server.campaign.commands.admin.AdminListServerBannedAmmoCommand;
import server.campaign.commands.admin.AdminLockCampaignCommand;
import server.campaign.commands.admin.AdminLockFactoryCommand;
import server.campaign.commands.admin.AdminMovePlanetCommand;
import server.campaign.commands.admin.AdminPasswordCommand;
import server.campaign.commands.admin.AdminPlayerStatusCommand;
import server.campaign.commands.admin.AdminPurgeHouseBaysCommand;
import server.campaign.commands.admin.AdminPurgeHouseConfigsCommand;
import server.campaign.commands.admin.AdminRandomlySetPlanetProductionCommand;
import server.campaign.commands.admin.AdminReloadHouseConfigsCommand;
import server.campaign.commands.admin.AdminRemoveAllFactoriesCommand;
import server.campaign.commands.admin.AdminRemoveAllTerrainCommand;
import server.campaign.commands.admin.AdminRemovePlanetOwnershipCommand;
import server.campaign.commands.admin.AdminRemoveServerOpFlagsCommand;
import server.campaign.commands.admin.AdminRemoveUnitsOnMarketCommand;
import server.campaign.commands.admin.AdminRequestBuildTableCommand;
import server.campaign.commands.admin.AdminResetHouseRankingsCommand;
import server.campaign.commands.admin.AdminResetPlayerCommand;
import server.campaign.commands.admin.AdminReturnPlanetsToOriginalOwnersCommand;
import server.campaign.commands.admin.AdminSaveBlackMarketConfigsCommand;
import server.campaign.commands.admin.AdminSaveCommand;
import server.campaign.commands.admin.AdminSaveCommandLevelsCommand;
import server.campaign.commands.admin.AdminSaveFactionConfigsCommand;
import server.campaign.commands.admin.AdminSavePlanetsToXMLCommand;
import server.campaign.commands.admin.AdminSaveServerConfigsCommand;
import server.campaign.commands.admin.AdminScrapCommand;
import server.campaign.commands.admin.AdminSetBanTargetingCommand;
import server.campaign.commands.admin.AdminSetBlackMarketSettingCommand;
import server.campaign.commands.admin.AdminSetCommandLevelCommand;
import server.campaign.commands.admin.AdminSetHomeWorldCommand;
import server.campaign.commands.admin.AdminSetHouseAbbreviationCommand;
import server.campaign.commands.admin.AdminSetHouseAmmoBanCommand;
import server.campaign.commands.admin.AdminSetHouseFluFileCommand;
import server.campaign.commands.admin.AdminSetHousePlayerColorCommand;
import server.campaign.commands.admin.AdminSetHouseTechLevelCommand;
import server.campaign.commands.admin.AdminSetPlanetBoardSizeCommand;
import server.campaign.commands.admin.AdminSetPlanetGravityCommand;
import server.campaign.commands.admin.AdminSetPlanetMapSizeCommand;
import server.campaign.commands.admin.AdminSetPlanetOpFlagsCommand;
import server.campaign.commands.admin.AdminSetPlanetOriginalOwnerCommand;
import server.campaign.commands.admin.AdminSetPlanetTemperatureCommand;
import server.campaign.commands.admin.AdminSetPlanetVacuumCommand;
import server.campaign.commands.admin.AdminSetServerAmmoBanCommand;
import server.campaign.commands.admin.AdminSpoofCommand;
import server.campaign.commands.admin.AdminTerminateAllCommand;
import server.campaign.commands.admin.AdminTransferCommand;
import server.campaign.commands.admin.AdminUnlockCampaignCommand;
import server.campaign.commands.admin.AdminUpdateClientParamCommand;
import server.campaign.commands.admin.AdminUpdatePlanetOwnershipCommand;
import server.campaign.commands.admin.AdminUploadBuildTableCommand;
import server.campaign.commands.admin.AdminViewLogCommand;
import server.campaign.commands.admin.AutoFillBlackMarketSettingCommand;
import server.campaign.commands.admin.CampaignConfigCommand;
import server.campaign.commands.admin.ChangeHouseColorCommand;
import server.campaign.commands.admin.ChangeNameCommand;
import server.campaign.commands.admin.CreateArmyFromMulCommand;
import server.campaign.commands.admin.CreateMercFactionCommand;
import server.campaign.commands.admin.CreatePilotCommand;
import server.campaign.commands.admin.CreateUnitCommand;
import server.campaign.commands.admin.CyclopsCheckupCommand;
import server.campaign.commands.admin.CyclopsOptimizeCommand;
import server.campaign.commands.admin.CyclopsPostMaxSizeCommand;
import server.campaign.commands.admin.CyclopsResetCommand;
import server.campaign.commands.admin.CyclopsTemplateLoaderCommand;
import server.campaign.commands.admin.CyclopsVersionCommand;
import server.campaign.commands.admin.DeleteAccountCommand;
import server.campaign.commands.admin.FluffCommand;
import server.campaign.commands.admin.ForceUpdateCommand;
import server.campaign.commands.admin.ForcedDefectCommand;
import server.campaign.commands.admin.InvisCommand;
import server.campaign.commands.admin.ListMulsCommand;
import server.campaign.commands.admin.RemoveFactionPilotCommand;
import server.campaign.commands.admin.RemovePilotCommand;
import server.campaign.commands.admin.RemoveSongCommand;
import server.campaign.commands.admin.RemoveTraitCommand;
import server.campaign.commands.admin.RestartRepairThreadCommand;
import server.campaign.commands.admin.RetrieveAllMulsCommand;
import server.campaign.commands.admin.RetrieveAllOperationsCommand;
import server.campaign.commands.admin.RetrieveMulCommand;
import server.campaign.commands.admin.RetrieveOperationCommand;
import server.campaign.commands.admin.ServerGameOptionsCommand;
import server.campaign.commands.admin.SetAdvancedPlanetTerrainCommand;
import server.campaign.commands.admin.SetFactionToFactionRewardPointMultiplierCommand;
import server.campaign.commands.admin.SetHouseBasePilotingSkillsCommand;
import server.campaign.commands.admin.SetHouseConquerCommand;
import server.campaign.commands.admin.SetHouseInHouseAttacksCommand;
import server.campaign.commands.admin.SetHouseLogoCommand;
import server.campaign.commands.admin.SetMultiPlayerGroupCommand;
import server.campaign.commands.admin.SetOperationCommand;
import server.campaign.commands.admin.SetPlanetCompProductionCommand;
import server.campaign.commands.admin.SetPlanetConquerCommand;
import server.campaign.commands.admin.SetPlanetConquerPointsCommand;
import server.campaign.commands.admin.SetPlanetMinOwnerShipCommand;
import server.campaign.commands.admin.SetPlanetWareHouseCommand;
import server.campaign.commands.admin.ShutdownCommand;
import server.campaign.commands.admin.SingASongCommand;
import server.campaign.commands.admin.StripUnitsCommand;
import server.campaign.commands.admin.UpdateOperationsCommand;
import server.campaign.commands.admin.UploadMulCommand;
import server.campaign.commands.helpers.HireAndMaintainHelper;
import server.campaign.commands.helpers.HireAndRequestNewHelper;
import server.campaign.commands.helpers.HireAndRequestUsedHelper;
import server.campaign.commands.helpers.RemoveAndAddNoPlayHelper;
import server.campaign.commands.leader.DemotePlayerCommand;
import server.campaign.commands.leader.FactionLeaderFluffCommand;
import server.campaign.commands.leader.FactionLeaderMuteCommand;
import server.campaign.commands.leader.GetComponentConversionCommand;
import server.campaign.commands.leader.PromotePlayerCommand;
import server.campaign.commands.leader.PurchaseFactoryCommand;
import server.campaign.commands.leader.ResearchTechLevelCommand;
import server.campaign.commands.leader.ResearchUnitCommand;
import server.campaign.commands.leader.SetComponentConversionCommand;
import server.campaign.commands.leader.ViewFactionPartsCacheCommand;
import server.campaign.commands.mod.AddLeaderCommand;
import server.campaign.commands.mod.AddPartsCommand;
import server.campaign.commands.mod.BanCommand;
import server.campaign.commands.mod.BanIPCommand;
import server.campaign.commands.mod.BanListCommand;
import server.campaign.commands.mod.BuildTableValidatorCommand;
import server.campaign.commands.mod.CheckCommand;
import server.campaign.commands.mod.ConfigCommand;
import server.campaign.commands.mod.CreateSubFactionCommand;
import server.campaign.commands.mod.FixAmmoCommand;
import server.campaign.commands.mod.GetModLogCommand;
import server.campaign.commands.mod.GetPlayerUnitsCommand;
import server.campaign.commands.mod.GooseCommand;
import server.campaign.commands.mod.GrantEXPCommand;
import server.campaign.commands.mod.GrantInfluenceCommand;
import server.campaign.commands.mod.GrantMoneyCommand;
import server.campaign.commands.mod.GrantRewardCommand;
import server.campaign.commands.mod.GrantTechPointsCommand;
import server.campaign.commands.mod.GrantTechsCommand;
import server.campaign.commands.mod.HardTerminateCommand;
import server.campaign.commands.mod.IPListCommand;
import server.campaign.commands.mod.IgnoreCommand;
import server.campaign.commands.mod.IgnoreListCommand;
import server.campaign.commands.mod.KickCommand;
import server.campaign.commands.mod.ListMultiPlayerGroupsCommand;
import server.campaign.commands.mod.MMOTDCommand;
import server.campaign.commands.mod.ModDeactivateCommand;
import server.campaign.commands.mod.ModFullRepairCommand;
import server.campaign.commands.mod.ModGamesCommand;
import server.campaign.commands.mod.ModLogCommand;
import server.campaign.commands.mod.ModNoPlayCommand;
import server.campaign.commands.mod.ModRefreshFactoryCommand;
import server.campaign.commands.mod.ModTerminateCommand;
import server.campaign.commands.mod.ModeratorMailCommand;
import server.campaign.commands.mod.NotifyFightingCommand;
import server.campaign.commands.mod.RemoveLeaderCommand;
import server.campaign.commands.mod.RemovePartsCommand;
import server.campaign.commands.mod.RemoveSubFactionCommand;
import server.campaign.commands.mod.ServerAnnouncementCommand;
import server.campaign.commands.mod.SetEloCommand;
import server.campaign.commands.mod.SetHouseBasePilotSkillsCommand;
import server.campaign.commands.mod.SetMMOTDCommand;
import server.campaign.commands.mod.SetSMOTDCommand;
import server.campaign.commands.mod.SetSubFactionConfigCommand;
import server.campaign.commands.mod.StripAllPartsCacheCommand;
import server.campaign.commands.mod.TerminateContractCommand;
import server.campaign.commands.mod.TouchCommand;
import server.campaign.commands.mod.UnBanCommand;
import server.campaign.commands.mod.UnBanIPCommand;
import server.campaign.commands.mod.UnlockLancesCommand;
import server.campaign.commands.mod.UpdateServerUnitsCacheCommand;
import server.campaign.commands.mod.ValidateUserCommand;
import server.campaign.commands.mod.ViewPlayerPartsCommand;
import server.campaign.commands.mod.ViewPlayerPersonalPilotQueueCommand;
import server.campaign.commands.mod.ViewPlayerUnitCommand;
import server.campaign.market2.Market2;
import server.campaign.market2.PartsMarket;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;
import server.campaign.operations.ShortOperation;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.AstechSkill;
import server.campaign.pilot.skills.BufferedVDNI;
import server.campaign.pilot.skills.ClanPilotTrainingSkill;
import server.campaign.pilot.skills.DodgeManeuverSkill;
import server.campaign.pilot.skills.EdgeSkill;
import server.campaign.pilot.skills.EnhancedInterfaceSkill;
import server.campaign.pilot.skills.GiftedSkill;
import server.campaign.pilot.skills.GunneryBallisticSkill;
import server.campaign.pilot.skills.GunneryLaserSkill;
import server.campaign.pilot.skills.GunneryMissileSkill;
import server.campaign.pilot.skills.IronManSkill;
import server.campaign.pilot.skills.ManeuveringAceSkill;
import server.campaign.pilot.skills.MedTechSkill;
import server.campaign.pilot.skills.MeleeSpecialistSkill;
import server.campaign.pilot.skills.NaturalAptitudeGunnerySkill;
import server.campaign.pilot.skills.NaturalAptitudePilotingSkill;
import server.campaign.pilot.skills.PainResistanceSkill;
import server.campaign.pilot.skills.PainShunt;
import server.campaign.pilot.skills.QuickStudySkill;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.SurvivalistSkill;
import server.campaign.pilot.skills.TacticalGeniusSkill;
import server.campaign.pilot.skills.TraitSkill;
import server.campaign.pilot.skills.VDNI;
import server.campaign.pilot.skills.WeaponSpecialistSkill;
import server.campaign.util.HouseRankingHelpContainer;
import server.campaign.util.MechStatistics;
import server.campaign.util.Statistics;
import server.campaign.util.XMLFactionDataParser;
import server.campaign.util.XMLPlanetDataParser;
import server.campaign.util.XMLTerrainDataParser;
import server.campaign.votes.VoteManager;
import server.dataProvider.Server;
import server.mwcyclopscomm.MWCyclopsComm;
import server.mwmysql.mysqlHandler;
import server.util.AutomaticBackup;
import server.util.MWPasswd;
import server.util.RepairTrackingThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CampaignMain
implements Serializable {
    private static final long serialVersionUID = -8671163467590633378L;
    public static CampaignMain cm;
    public static DefaultServerOptions dso;
    private MWServ myServer;
    private Client megaMekClient = new Client("MWServer", "None", 0);
    private Server dataProviderServer;
    private MWCyclopsComm mwcc = null;
    private CampaignData data = new CampaignData();
    private Properties config = new Properties();
    private Hashtable<String, Command> Commands = new Hashtable();
    private Hashtable<String, MechStatistics> MechStats = new Hashtable();
    private Hashtable<String, String> omniVariantMods = new Hashtable();
    private Hashtable<Integer, SPilotSkill> pilotSkills = new Hashtable();
    private Hashtable<String, Equipment> blackMarketEquipmentCostTable = new Hashtable();
    private int gamesCompleted;
    private int currentUnitID = 1;
    private int currentPilotID = 1;
    private TickThread TThread;
    private SliceThread SThread;
    private ImmunityThread IThread;
    private RepairTrackingThread RTT;
    private AutomaticBackup aub = new AutomaticBackup(System.currentTimeMillis());
    private Market2 market;
    private PartsMarket partsmarket;
    private VoteManager voteManager;
    private OperationManager opsManager;
    private Vector<ContractInfo> unresolvedContracts = new Vector(1, 1);
    private UnitCosts unitCostLists = null;
    private TreeMap<String, String> NewsFeed = new TreeMap();
    private boolean isArchiving = false;
    private Random r = new Random(System.currentTimeMillis());
    public mysqlHandler MySQL = null;
    private boolean validBBVersion = true;
    private Date housePlanetDate = new Date();
    private Hashtable<String, SPlayer> lostSouls = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CampaignMain(MWServ serv) {
        String line;
        BufferedReader dis;
        FileInputStream fis;
        File configFile;
        File cache;
        cm = this;
        this.myServer = serv;
        dso = new DefaultServerOptions();
        dso.createDefaults();
        File f = new File("./campaign/");
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File("./campaign/players/")).exists()) {
            f.mkdir();
        }
        if ((cache = new File("./data/mechfiles/units.cache")).exists()) {
            cache.delete();
        }
        try {
            this.config.putAll((Map<?, ?>)dso.getServerDefaults());
            this.config.load(new FileInputStream(this.myServer.getConfigParam("CAMPAIGNCONFIG")));
            if (this.isUsingMySQL()) {
                if (Boolean.parseBoolean(this.getServer().getConfigParam("MYSQL_SYNCHPHPBB"))) {
                    this.config.put("REQUIREEMAILFORREGISTRATION", "true");
                } else {
                    this.config.put("REQUIREEMAILFORREGISTRATION", "false");
                }
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems with loading campaign config");
            CampaignData.mwlog.errLog(ex);
            dso.createConfig();
            try {
                this.config.load(new FileInputStream(this.myServer.getConfigParam("CAMPAIGNCONFIG")));
            }
            catch (Exception ex1) {
                CampaignData.mwlog.errLog("Problems with loading campaing config from defaults");
                CampaignData.mwlog.errLog(ex1);
                System.exit(1);
            }
        }
        if (!this.getConfig("AllowedMegaMekVersion").equals("-1")) {
            this.getConfig().setProperty("AllowedMegaMekVersion", MegaMek.VERSION);
        }
        dso.createConfig();
        cm.isUsingMySQL();
        this.market = new Market2();
        this.partsmarket = new PartsMarket();
        this.initializePilotSkills();
        this.data = new CampaignData();
        CampaignData.mwlog.infoLog("Loading MegaMek Game Options");
        CampaignMain.cm.megaMekClient.game.getOptions().loadOptions();
        new XMLTerrainDataParser("./data/terrain.xml");
        cm.loadTopUnitID();
        this.gamesCompleted = 0;
        this.loadFactionData();
        this.loadPlanetData();
        try {
            configFile = new File("./campaign/banammo.dat");
            fis = new FileInputStream(configFile);
            dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                line = dis.readLine();
                this.loadBanAmmo(line);
            }
            dis.close();
            fis.close();
        }
        catch (FileNotFoundException fne) {
            CampaignData.mwlog.mainLog("No banned ammo data found.");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems reading banned ammo data.");
        }
        cm.loadBannedTargetingSystems();
        cm.loadOmniVariantMods();
        cm.loadBlackMarketSettings();
        this.init();
        if (Boolean.parseBoolean(cm.getConfig("UseCalculatedCosts"))) {
            this.unitCostLists = new UnitCosts();
            this.unitCostLists.loadUnitCosts();
        }
        if (cm.isUsingMySQL()) {
            this.loadMechStatsFromDB();
        } else {
            try {
                configFile = new File("./campaign/mechstat.dat");
                fis = new FileInputStream(configFile);
                dis = new BufferedReader(new InputStreamReader(fis));
                while (dis.ready()) {
                    line = dis.readLine();
                    MechStatistics m = new MechStatistics(line);
                    this.MechStats.put(m.getMechFileName(), m);
                }
                dis.close();
                fis.close();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Problems reading unit statistics data");
                CampaignData.mwlog.errLog(ex);
                CampaignData.mwlog.mainLog("No Mech Statistic Data found");
            }
        }
        if (Boolean.parseBoolean(this.getConfig("HTMLOUTPUT"))) {
            Statistics.doRanking();
        }
        this.voteManager = new VoteManager(this);
        this.createNewOpsManager();
        int dataport = -1;
        try {
            dataport = Integer.parseInt(this.myServer.getConfigParam("DATAPORT"));
        }
        catch (NumberFormatException e) {
            CampaignData.mwlog.errLog("Non-number given as dataport. Defaulting to 4867.");
            CampaignData.mwlog.errLog(e);
            dataport = 4867;
        }
        finally {
            this.dataProviderServer = new Server(this.data, dataport, this.myServer.getConfigParam("SERVERIP"));
            Thread t = new Thread(this.dataProviderServer);
            t.start();
        }
        if (this.isUsingCyclops()) {
            this.getMWCC().skillWriteFromList(this.pilotSkills);
            this.getMWCC().houseWriteFromList(this.getData().getAllHouses());
            this.getMWCC().planetWriteFromList(this.getData().getAllPlanets());
        }
        this.TThread = new TickThread(this, Integer.parseInt(this.getConfig("TickTime")));
        this.TThread.start();
        this.SThread = new SliceThread(this, Integer.parseInt(this.getConfig("SliceTime")));
        this.SThread.start();
        this.IThread = new ImmunityThread();
        this.IThread.start();
        this.isUsingAdvanceRepair();
        this.addToNewsFeed("MekWars Server Started!");
    }

    public void toFile() {
        try {
            while (cm.isArchiving()) {
                Thread.sleep(125L);
            }
            this.saveFactionData();
            this.savePlanetData();
            cm.saveOmniVariantMods();
            FileOutputStream out = new FileOutputStream("./campaign/mechstat.dat");
            PrintStream p = new PrintStream(out);
            if (cm.isUsingMySQL()) {
                for (MechStatistics currStats : this.MechStats.values()) {
                    currStats.toDB();
                }
            } else {
                for (MechStatistics currStats : this.MechStats.values()) {
                    p.println(currStats.toString());
                }
                p.close();
                out.close();
            }
            if (!cm.isUsingMySQL()) {
                try {
                    out = new FileOutputStream(this.getConfig("MechstatPath"));
                    p = new PrintStream(out);
                    p.println("<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"format.css\"><style type=\"text/css\"></style></head><body><font face=\"Verdana, Arial, Helvetica, sans-serif\">");
                    for (int i = 0; i <= 3; ++i) {
                        p.println(Statistics.doGetMechStats(i));
                        p.println("<br>");
                    }
                    p.println("</font></body></style></html>");
                    p.close();
                    out.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            CampaignData.mwlog.mainLog("STATUS SAVED");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems saving configuration to file");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public boolean isLoggedIn(String Username) {
        if (Username.startsWith("[Dedicated]")) {
            return true;
        }
        String lowerName = Username.toLowerCase();
        for (House vh : this.data.getAllHouses()) {
            SHouse h = (SHouse)vh;
            if (h.getReservePlayers().containsKey(lowerName)) {
                return true;
            }
            if (h.getActivePlayers().containsKey(lowerName)) {
                return true;
            }
            if (!h.getFightingPlayers().containsKey(lowerName)) continue;
            return true;
        }
        return false;
    }

    public boolean getBooleanConfig(String key) {
        try {
            return Boolean.parseBoolean(cm.getConfig(key));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int getIntegerConfig(String key) {
        try {
            return Integer.parseInt(cm.getConfig(key));
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public long getLongConfig(String key) {
        try {
            return Long.parseLong(cm.getConfig(key));
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public double getDoubleConfig(String key) {
        try {
            return Double.parseDouble(cm.getConfig(key));
        }
        catch (Exception ex) {
            return -1.0;
        }
    }

    public float getFloatConfig(String key) {
        try {
            return Float.parseFloat(cm.getConfig(key));
        }
        catch (Exception ex) {
            return -1.0f;
        }
    }

    public String getConfig(String key) {
        if (this.config.getProperty(key) == null) {
            if (dso.getServerDefaults().getProperty(key) == null) {
                CampaignData.mwlog.mainLog("You're missing the config variable: " + key + " in campaignconfig!");
                CampaignData.mwlog.errLog("You're missing the config variable: " + key + " in campaignconfig! returning -1");
                return "-1";
            }
            return dso.getServerDefaults().getProperty(key).trim();
        }
        return this.config.getProperty(key).trim();
    }

    public OperationManager getOpsManager() {
        return this.opsManager;
    }

    public void createNewOpsManager() {
        this.opsManager = new OperationManager();
    }

    public void fromUser(String text, String Username) {
        if (cm.getServer().getClient(Username) == null) {
            return;
        }
        if (!this.isLoggedIn(Username) && text.toUpperCase().indexOf("ENROLL") == -1 && text.toUpperCase().indexOf("LOGIN") == -1 && text.toUpperCase().indexOf("REGISTER") == -1 && text.toUpperCase().indexOf("GETSERVERCONFIGS") == -1 && text.toUpperCase().indexOf("SETCLIENTVERSION") == -1 && text.toUpperCase().indexOf("GETSAVEDMAIL") == -1) {
            this.toUser("You are not logged in!", Username, true);
            return;
        }
        StringTokenizer ST = new StringTokenizer(text = text.substring(2), "#");
        if (ST.hasMoreElements()) {
            String task;
            block10: {
                task = ((String)ST.nextElement()).toUpperCase();
                if (!task.equals("PONG")) {
                    try {
                        this.getPlayer(Username).setLastTimeCommandSent(System.currentTimeMillis());
                    }
                    catch (Exception ex) {
                        if (Username.startsWith("[Dedicated]")) break block10;
                        CampaignData.mwlog.errLog("Command received from a null player (" + Username + ")?");
                    }
                }
            }
            if (this.Commands.get(task) != null) {
                if (!(task.equals("MAIL") || task.equals("HOUSEMAIL") || task.equals("HM") || task.equals("MODERATORMAIL") || task.equals("MM") || task.equals("INCHARACTER") || task.equals("IC"))) {
                    CampaignData.mwlog.cmdLog(Username + ": " + text);
                }
                Command c = this.Commands.get(task);
                try {
                    c.process(ST, Username);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                    cm.toUser("AM:Invalid Syntax: /" + task + " " + c.getSyntax(), Username);
                }
                return;
            }
        }
    }

    public SPlanet getPlanetFromPartialString(String PlanetName, String Username) {
        int numMatches = 0;
        SPlanet theMatch = null;
        for (Planet currP : this.data.getAllPlanets()) {
            SPlanet p = (SPlanet)currP;
            if (p.getName().equals(PlanetName)) {
                return p;
            }
            if (!p.getName().startsWith(PlanetName)) continue;
            theMatch = p;
            ++numMatches;
        }
        if (numMatches > 1) {
            if (Username != null) {
                this.toUser("\"" + PlanetName + "\" is not unique [" + numMatches + " matches]. Please be more specific.", Username);
            }
            return null;
        }
        if (numMatches == 0) {
            if (Username != null) {
                this.toUser("Couldn't find a planet whose name begins with \"" + PlanetName + "\". Try again.", Username, true);
            }
            return null;
        }
        return theMatch;
    }

    public void doSendHouseMail(SHouse h, String Username, String text) {
        text = "(Housemail)" + Username + ":" + text;
        this.doSendToAllOnlinePlayers(h, text, true);
        CampaignData.mwlog.factionLog(text.substring(11), h.getName());
    }

    public void doSendModMail(String Username, String text) {
        int sendCommandLevel = 0;
        int commandLevel = cm.getServerCommands().get("MM").getExecutionLevel();
        int userLevel = 0;
        try {
            if (Username.equalsIgnoreCase("NOTE")) {
                sendCommandLevel = !cm.getBooleanConfig("AllowLowerLevelUsersToSeeUpperLevelUsersDoings") ? cm.getServer().getUserLevel(text.substring(0, text.indexOf(" ")).trim()) : 100;
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        CampaignData.mwlog.modLog(Username + ": " + text);
        text = "(Moderator Mail) " + Username + ": " + text;
        for (House vh : this.data.getAllHouses()) {
            SHouse h = (SHouse)vh;
            for (String currName : h.getReservePlayers().keySet()) {
                userLevel = cm.getServer().getUserLevel(currName);
                if (userLevel < commandLevel || userLevel < sendCommandLevel) continue;
                this.toUser(text, currName, true);
            }
            for (String currName : h.getActivePlayers().keySet()) {
                userLevel = cm.getServer().getUserLevel(currName);
                if (userLevel < commandLevel || userLevel < sendCommandLevel) continue;
                this.toUser(text, currName, true);
            }
            for (String currName : h.getFightingPlayers().keySet()) {
                userLevel = cm.getServer().getUserLevel(currName);
                if (userLevel < commandLevel || userLevel < sendCommandLevel) continue;
                this.toUser(text, currName, true);
            }
        }
    }

    public void doSendErrLog(String text) {
        text = "(Error Log): " + text;
        for (House vh : this.data.getAllHouses()) {
            Command command;
            SHouse h = (SHouse)vh;
            for (String currName : h.getReservePlayers().keySet()) {
                command = cm.getServerCommands().get("MM");
                if (cm.getServer().getUserLevel(currName) < command.getExecutionLevel()) continue;
                this.toUser(text, currName, true);
            }
            for (String currName : h.getActivePlayers().keySet()) {
                command = cm.getServerCommands().get("MM");
                if (cm.getServer().getUserLevel(currName) < command.getExecutionLevel()) continue;
                this.toUser(text, currName, true);
            }
            for (String currName : h.getFightingPlayers().keySet()) {
                command = cm.getServerCommands().get("MM");
                if (cm.getServer().getUserLevel(currName) < command.getExecutionLevel()) continue;
                this.toUser(text, currName, true);
            }
        }
    }

    public Hashtable<String, MechStatistics> getMechStats() {
        return this.MechStats;
    }

    public void doProcessAutomaticReport(String s, String Username) {
        TreeSet<String> players = new TreeSet<String>();
        StringTokenizer report = new StringTokenizer(s, "#");
        SPlayer reporter = this.getPlayer(report.nextToken());
        block0: while (report.hasMoreElements()) {
            StringTokenizer report2 = new StringTokenizer(report.nextToken(), "*");
            String test = report2.nextToken();
            if (test.equals("MW") || test.equals("-1")) continue;
            while (report2.hasMoreTokens()) {
                SPlayer player = this.getPlayer(report2.nextToken(), false, true);
                if (player == null) continue;
                if (!players.contains(player.getName().toLowerCase())) {
                    players.add(player.getName().toLowerCase());
                }
                if (reporter != null) continue block0;
                reporter = player;
                continue block0;
            }
        }
        if (reporter == null) {
            CampaignData.mwlog.errLog("reporter is null! " + s);
            return;
        }
        ShortOperation so = this.getOpsManager().getShortOpForPlayer(reporter);
        if (so == null) {
            return;
        }
        if (!so.validatePlayers(players)) {
            CampaignData.mwlog.errLog("Unable to validate all players for: " + s);
            return;
        }
        if (so.hasPlayer(reporter)) {
            Operation o = this.getOpsManager().getOperation(so.getName());
            this.getOpsManager().resolveShortAttack(o, so, s);
            return;
        }
    }

    public void addInProgressUpdate(String s, String Username) {
        SPlayer reporter = this.getPlayer(Username);
        if (reporter == null) {
            return;
        }
        ShortOperation so = this.getOpsManager().getShortOpForPlayer(reporter);
        if (so == null) {
            return;
        }
        if (so.getAllPlayerNames().size() > 2) {
            return;
        }
        so.addInProgressUpdate(s);
    }

    public CampaignData getData() {
        return this.data;
    }

    public Vector<MercHouse> getMercHouses() {
        Vector<MercHouse> result = new Vector<MercHouse>(1, 1);
        for (House currH : this.data.getAllHouses()) {
            SHouse sh = (SHouse)currH;
            if (!sh.isMercHouse()) continue;
            result.add((MercHouse)currH);
        }
        result.trimToSize();
        return result;
    }

    public void doLoginPlayer(String Username) {
        String s;
        for (House vh : this.data.getAllHouses()) {
            SHouse currH = (SHouse)vh;
            if (!currH.isLoggedIntoFaction(Username)) continue;
            this.toUser("You are already logged in to " + currH.getColoredNameAsLink() + ".", Username, true);
            return;
        }
        SPlayer toLogin = this.getPlayer(Username);
        if (toLogin == null) {
            this.toUser("<font color=\"navy\"><br>---<br>It appears that you haven't signed up for this server's campaign.<br><a href=\"MEKWARS/c enroll\">Click here to get started.</a><br>---<br></font>", Username, true);
            return;
        }
        SHouse loginHouse = toLogin.getMyHouse();
        if (loginHouse == null) {
            this.toUser("    . Major problem. Report ASAP.", Username, true);
            cm.doSendModMail("NOTE", toLogin.getName() + " has a null login faction! Moving to " + cm.getConfig("NewbieHouseName"));
            loginHouse = cm.getHouseFromPartialString(cm.getConfig("NewbieHouseName"));
            toLogin.setMyHouse(loginHouse);
        }
        if ((s = loginHouse.doLogin(toLogin)) != null) {
            this.toUser(s, Username, true);
            cm.toUser("PS|" + toLogin.toString(true), Username, false);
            if (this.isUsingAdvanceRepair()) {
                if (!toLogin.hasRepairingUnits()) {
                    cm.toUser("PL|UTT|" + toLogin.totalTechsToString(), Username, false);
                    cm.toUser("PL|UAT|" + toLogin.totalTechsToString(), Username, false);
                } else {
                    cm.toUser("PL|UTT|" + toLogin.totalTechsToString(), Username, false);
                    cm.toUser("PL|UAT|" + toLogin.availableTechsToString(), Username, false);
                }
            }
            for (SArmy currA : toLogin.getArmies()) {
                currA.getLegalOperations().clear();
                cm.getOpsManager().checkOperations(currA, false);
            }
            StringBuilder result = new StringBuilder("PI|PL|");
            for (House vh : this.data.getAllHouses()) {
                SHouse currH = (SHouse)vh;
                for (SPlayer currP : currH.getReservePlayers().values()) {
                    result.append(this.getPlayerUpdateString(currP) + "|");
                }
                for (SPlayer currP : currH.getActivePlayers().values()) {
                    result.append(this.getPlayerUpdateString(currP) + "|");
                }
                for (SPlayer currP : currH.getFightingPlayers().values()) {
                    result.append(this.getPlayerUpdateString(currP) + "|");
                }
            }
            this.toUser(result.toString(), Username, false);
            this.doSendToAllOnlinePlayers("PI|DA|" + this.getPlayerUpdateString(toLogin), false);
            toLogin.setLastTimeCommandSent(System.currentTimeMillis());
            toLogin.setLastOnline(System.currentTimeMillis());
            if (cm.getServer().isModerator(Username)) {
                cm.toUser("(Moderator Mail) Mod MOTD: " + cm.getConfig("MMOTD"), Username);
            }
            CampaignData.mwlog.ipLog("Name: " + Username + " IP: " + cm.getServer().getIP(Username));
            cm.toUser("PL|SUD|1", Username, false);
            cm.toUser("CC|NT|" + this.TThread.getRemainingSleepTime() + "|" + false, Username, false);
        }
    }

    public void doLogoutPlayer(String name) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        SPlayer toLogout = this.getPlayer(name);
        if (toLogout == null) {
            return;
        }
        this.releaseLostSoul(name);
        toLogout.setSave();
        toLogout.getMyHouse().doLogout(toLogout);
        this.doSendToAllOnlinePlayers("PI|CS|" + name + "|" + 1, false);
        this.toUser("[*] You've logged out of the campaign.", name, true);
    }

    public MWServ getServer() {
        return this.myServer;
    }

    public String getPlayerUpdateString(SPlayer p) {
        StringBuffer result = new StringBuffer();
        if (p == null) {
            return result.toString();
        }
        int Status2 = p.getDutyStatus();
        if (Status2 == 2 && Boolean.parseBoolean(this.getConfig("HideActiveStatus"))) {
            Status2 = 3;
        }
        result.append(p.getName());
        result.append("|");
        result.append(p.getExperience());
        result.append("#");
        if (Boolean.parseBoolean(this.getConfig("HideELO"))) {
            result.append("0");
        } else {
            result.append(p.getRatingRounded());
        }
        result.append("#");
        result.append(Status2);
        result.append("#");
        if (p.getFluffText().equals("")) {
            result.append(" #");
        } else {
            result.append(p.getFluffText());
            result.append("#");
        }
        result.append(p.getHouseFightingFor().getName());
        result.append("#");
        result.append(p.getMyHouse().isMercHouse());
        result.append("#");
        result.append(p.getSubFactionName());
        return result.toString();
    }

    public void sendPlayerStatusUpdate(SPlayer p, boolean sendToAll) {
        int realStatus;
        int sendStatus = realStatus = p.getDutyStatus();
        if (realStatus == 2 && Boolean.parseBoolean(this.getConfig("HideActiveStatus"))) {
            sendStatus = 3;
        }
        if (sendToAll) {
            this.doSendToAllOnlinePlayers("PI|CS|" + p.getName() + "|" + sendStatus, false);
        }
        this.toUser("CS|" + realStatus, p.getName(), false);
    }

    public SPlayer getPlayer(String pName) {
        return this.getPlayer(pName, true, false);
    }

    public SPlayer getPlayer(String pName, boolean save, boolean mute) {
        if (pName.equalsIgnoreCase("DRAW") || pName.toUpperCase().startsWith("DRAW#")) {
            return null;
        }
        if (this.lostSouls.containsKey(pName.toLowerCase())) {
            return this.lostSouls.get(pName.toLowerCase());
        }
        SPlayer result = null;
        for (House vh : this.data.getAllHouses()) {
            SHouse h = (SHouse)vh;
            result = h.getPlayer(pName);
            if (result == null) continue;
            return result;
        }
        result = this.loadPlayerFile(pName, false, mute);
        if (result != null) {
            this.lostSouls.put(pName.toLowerCase(), result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SPlayer loadPlayerFile(String name, boolean explicitName, boolean mute) {
        if (!name.startsWith("[Dedicated]") && !name.startsWith("War Bot")) {
            SPlayer sPlayer;
            FileInputStream fis = null;
            BufferedReader dis = null;
            try {
                if (cm.isUsingMySQL()) {
                    if (CampaignMain.cm.MySQL.playerExists(name)) {
                        SPlayer p = new SPlayer();
                        int pid = CampaignMain.cm.MySQL.getPlayerIDByName(name);
                        p.fromDB(pid);
                        SPlayer sPlayer2 = p;
                        return sPlayer2;
                    }
                    if (!(name.toLowerCase().startsWith("nobody") || name.equals("SERVER") || name.toLowerCase().startsWith("war bot") || name.toLowerCase().startsWith("[dedicated]"))) {
                        CampaignData.mwlog.errLog("Player not in database: " + name);
                    }
                    SPlayer p = null;
                    return p;
                }
                CampaignData.mwlog.mainLog("Loading pfile for: " + name);
                File pFile = null;
                pFile = explicitName ? new File("./campaign/players/" + name) : new File("./campaign/players/" + name.toLowerCase() + ".dat");
                if (!pFile.exists()) {
                    SPlayer ex = null;
                    return ex;
                }
                fis = new FileInputStream(pFile);
                dis = new BufferedReader(new InputStreamReader(fis));
                SPlayer p = new SPlayer();
                String pString = dis.readLine();
                if (pString == null) {
                    SPlayer sPlayer3 = null;
                    return sPlayer3;
                }
                p.fromString(pString);
                SPlayer sPlayer4 = p;
                return sPlayer4;
            }
            catch (FileNotFoundException fnf) {
                if (!(name.toLowerCase().startsWith("nobody") || name.equals("SERVER") || name.toLowerCase().startsWith("war bot") || name.toLowerCase().startsWith("[dedicated]") || mute)) {
                    CampaignData.mwlog.errLog("could not find a pfile for " + name);
                    CampaignData.mwlog.debugLog(fnf);
                    CampaignData.mwlog.debugLog("could not find a pfile for " + name);
                }
                sPlayer = null;
                return sPlayer;
            }
            catch (Exception ex) {
                if (!mute) {
                    CampaignData.mwlog.errLog(ex);
                    CampaignData.mwlog.errLog("Unable to load pfile for " + name);
                }
                sPlayer = null;
                return sPlayer;
            }
            finally {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                }
            }
        }
        return null;
    }

    public void toUser(String txt, String Username) {
        this.toUser(txt, Username, true);
    }

    public void toUser(String txt, String Username, boolean isChat) {
        if (isChat) {
            this.myServer.fromCampaignMod("CH|" + txt, Username);
        } else {
            this.myServer.fromCampaignMod(txt, Username);
        }
    }

    public void init() {
        Object parser;
        CampaignData.mwlog.modLog("SERVER STARTED");
        this.Commands.put("ACCEPTATTACKFROMRESERVE", new AcceptAttackFromReserveCommand());
        this.Commands.put("ACCEPTCONTRACT", new AcceptContractCommand());
        this.Commands.put("ACTIVATE", new ActivateCommand());
        this.Commands.put("ADDLEADER", new AddLeaderCommand());
        this.Commands.put("ADDOMNIVARIANTMOD", new AddOmniVariantModCommand());
        this.Commands.put("ADDPARTS", new AddPartsCommand());
        this.Commands.put("ADDSONG", new AddSongCommand());
        this.Commands.put("ADDTRAIT", new AddTraitCommand());
        this.Commands.put("ADMINADDSERVEROPFLAGS", new AdminAddServerOpFlagsCommand());
        this.Commands.put("ADMINALLOWHOUSEDEFECTION", new AdminAllowHouseDefectionCommand());
        this.Commands.put("ADMINCALCULATEHOUSERANKINGS", new AdminCalculateHouseRankingsCommand());
        this.Commands.put("ADMINCHANGEFACTIONCONFIG", new AdminChangeFactionConfigCommand());
        this.Commands.put("ADMINCHANGEPLANETOWNER", new AdminChangePlanetOwnerCommand());
        this.Commands.put("ADMINCHANGESERVERCONFIG", new AdminChangeServerConfigCommand());
        this.Commands.put("ADMINCREATEFACTION", new AdminCreateFactionCommand());
        this.Commands.put("ADMINCREATEPLANET", new AdminCreatePlanetCommand());
        this.Commands.put("ADMINCREATEFACTORY", new AdminCreateFactoryCommand());
        this.Commands.put("ADMINCREATESOLARIS", new AdminCreateSolarisCommand());
        this.Commands.put("ADMINCREATETERRAIN", new AdminCreateTerrainCommand());
        this.Commands.put("ADMINDESTROYFACTORY", new AdminDestroyFactoryCommand());
        this.Commands.put("ADMINDESTROYPLANET", new AdminDestroyPlanetCommand());
        this.Commands.put("ADMINDESTROYTERRAIN", new AdminDestroyTerrainCommand());
        this.Commands.put("ADMINDONATE", new AdminDonateCommand());
        this.Commands.put("ADMINEXCHANGEPLANETOWNERSHIP", new AdminExchangePlanetOwnershipCommand());
        this.Commands.put("ADMINGETUNITCOMPONENTS", new AdminGetUnitComponentsCommand());
        this.Commands.put("ADMINGRANTCOMPONENTS", new AdminGrantComponentsCommand());
        this.Commands.put("ADMINHOUSEPILOTS", new AdminHousePilotsCommand());
        this.Commands.put("ADMINHOUSESTATUS", new AdminHouseStatusCommand());
        this.Commands.put("ADMINLOCKCAMPAIGN", new AdminLockCampaignCommand());
        this.Commands.put("ADMINLOCKFACTORY", new AdminLockFactoryCommand());
        this.Commands.put("ADMINLISTANDREMOVEOMG", new AdminListAndRemoveOMGCommand());
        this.Commands.put("ADMINLISTHOUSEBANNEDAMMO", new AdminListHouseBannedAmmoCommand());
        this.Commands.put("ADMINLISTSERVERBANNEDAMMO", new AdminListServerBannedAmmoCommand());
        this.Commands.put("ADMINMOVEPLANET", new AdminMovePlanetCommand());
        this.Commands.put("ADMINPASSWORD", new AdminPasswordCommand());
        this.Commands.put("ADMINPLAYERSTATUS", new AdminPlayerStatusCommand());
        this.Commands.put("ADMINPURGEHOUSEBAYS", new AdminPurgeHouseBaysCommand());
        this.Commands.put("ADMINPURGEHOUSECONFIGS", new AdminPurgeHouseConfigsCommand());
        this.Commands.put("ADMINRANDOMLYSETPLANETPRODUCTION", new AdminRandomlySetPlanetProductionCommand());
        this.Commands.put("ADMINRELOADHOUSECONFIGS", new AdminReloadHouseConfigsCommand());
        this.Commands.put("ADMINREMOVEALLFACTORIES", new AdminRemoveAllFactoriesCommand());
        this.Commands.put("ADMINREMOVEALLTERRAIN", new AdminRemoveAllTerrainCommand());
        this.Commands.put("ADMINREMOVEPLANETOWNERSHIP", new AdminRemovePlanetOwnershipCommand());
        this.Commands.put("ADMINREMOVESERVEROPFLAGS", new AdminRemoveServerOpFlagsCommand());
        this.Commands.put("ADMINREMOVEUNITSONMARKET", new AdminRemoveUnitsOnMarketCommand());
        this.Commands.put("ADMINREQUESTBUILDTABLE", new AdminRequestBuildTableCommand());
        this.Commands.put("ADMINRESETHOUSERANKINGS", new AdminResetHouseRankingsCommand());
        this.Commands.put("ADMINRESETPLAYER", new AdminResetPlayerCommand());
        this.Commands.put("ADMINRETURNPLANETSTOORIGINALOWNERS", new AdminReturnPlanetsToOriginalOwnersCommand());
        this.Commands.put("ADMINSAVE", new AdminSaveCommand());
        this.Commands.put("ADMINSAVEBLACKMARKETCONFIGS", new AdminSaveBlackMarketConfigsCommand());
        this.Commands.put("ADMINSAVECOMMANDLEVELS", new AdminSaveCommandLevelsCommand());
        this.Commands.put("ADMINSAVEFACTIONCONFIGS", new AdminSaveFactionConfigsCommand());
        this.Commands.put("ADMINSAVEPLANETSTOXML", new AdminSavePlanetsToXMLCommand());
        this.Commands.put("ADMINSAVESERVERCONFIGS", new AdminSaveServerConfigsCommand());
        this.Commands.put("ADMINSETBANTARGETING", new AdminSetBanTargetingCommand());
        this.Commands.put("ADMINSETBLACKMARKETSETTING", new AdminSetBlackMarketSettingCommand());
        this.Commands.put("ADMINSETCOMMANDLEVEL", new AdminSetCommandLevelCommand());
        this.Commands.put("ADMINSETHOMEWORLD", new AdminSetHomeWorldCommand());
        this.Commands.put("ADMINSETHOUSEABBREVIATION", new AdminSetHouseAbbreviationCommand());
        this.Commands.put("ADMINSETHOUSEFLUFILE", new AdminSetHouseFluFileCommand());
        this.Commands.put("ADMINSETHOUSEPLAYERCOLOR", new AdminSetHousePlayerColorCommand());
        this.Commands.put("ADMINSETHOUSETECHLEVEL", new AdminSetHouseTechLevelCommand());
        this.Commands.put("ADMINSETPLANETBOARDSIZE", new AdminSetPlanetBoardSizeCommand());
        this.Commands.put("ADMINSETPLANETGRAVITY", new AdminSetPlanetGravityCommand());
        this.Commands.put("ADMINSETPLANETOPFLAGS", new AdminSetPlanetOpFlagsCommand());
        this.Commands.put("ADMINSETPLANETORIGINALOWNER", new AdminSetPlanetOriginalOwnerCommand());
        this.Commands.put("ADMINSETPLANETMAPSIZE", new AdminSetPlanetMapSizeCommand());
        this.Commands.put("ADMINSETPLANETTEMPERATURE", new AdminSetPlanetTemperatureCommand());
        this.Commands.put("ADMINSETPLANETVACUUM", new AdminSetPlanetVacuumCommand());
        this.Commands.put("ADMINSETHOUSEAMMOBAN", new AdminSetHouseAmmoBanCommand());
        this.Commands.put("ADMINSETSERVERAMMOBAN", new AdminSetServerAmmoBanCommand());
        this.Commands.put("ADMINSCRAP", new AdminScrapCommand());
        this.Commands.put("ADMINSPOOF", new AdminSpoofCommand());
        this.Commands.put("ADMINTERMINATEALL", new AdminTerminateAllCommand());
        this.Commands.put("ADMINTRANSFER", new AdminTransferCommand());
        this.Commands.put("ADMINUNLOCKCAMPAIGN", new AdminUnlockCampaignCommand());
        this.Commands.put("ADMINUPDATECLIENTPARAM", new AdminUpdateClientParamCommand());
        this.Commands.put("ADMINUPDATEPLANETOWNERSHIP", new AdminUpdatePlanetOwnershipCommand());
        this.Commands.put("ADMINUPLOADBUILDTABLE", new AdminUploadBuildTableCommand());
        this.Commands.put("ADMINVIEWLOG", new AdminViewLogCommand());
        this.Commands.put("ALL", new ArmyLowerLimiterCommand());
        this.Commands.put("AOFS", new ArmyOpForceSizeCommand());
        this.Commands.put("AUL", new ArmyUpperLimiterCommand());
        this.Commands.put("ATTACK", new AttackCommand());
        this.Commands.put("ATTACKFROMRESERVE", new AttackFromReserveCommand());
        this.Commands.put("AUTOFILLBLACKMARKETSETTING", new AutoFillBlackMarketSettingCommand());
        this.Commands.put("AUTOPLANETSTATUS", new AutoPlanetStatusCommand());
        this.Commands.put("BID", new BidCommand());
        this.Commands.put("BMSTATUS", new BMStatusCommand());
        this.Commands.put("BUILDTABLELIST", new BuildTableListCommand());
        this.Commands.put("BUILDTABLEVALIDATOR", new BuildTableValidatorCommand());
        this.Commands.put("BUYBAYS", new BuyBaysCommand());
        this.Commands.put("BUYPARTS", new BuyPartsCommand());
        this.Commands.put("BUYPILOTSFROMHOUSE", new BuyPilotsFromHouseCommand());
        this.Commands.put("CALCDIST", new CalcDistCommand());
        this.Commands.put("CAMPAIGNCONFIG", new CampaignConfigCommand());
        this.Commands.put("CANCELOFFER", new CancelOfferCommand());
        this.Commands.put("CHANGEHOUSECOLOR", new ChangeHouseColorCommand());
        this.Commands.put("CHANGENAME", new ChangeNameCommand());
        this.Commands.put("CHECKATTACK", new CheckAttackCommand());
        this.Commands.put("CA", new CheckAttackCommand());
        this.Commands.put("CHECK", new CheckCommand());
        this.Commands.put("CHECKARMYELIGIBILITY", new CheckArmyEligibilityCommand());
        this.Commands.put("CHECKARMYLINK", new CheckArmyLinkCommand());
        this.Commands.put("CHECKDIST", new CheckDistCommand());
        this.Commands.put("COMMENCEOPERATION", new CommenceOperationCommand());
        this.Commands.put("CREATEARMY", new CreateArmyCommand());
        this.Commands.put("CRA", new CreateArmyCommand());
        this.Commands.put("CREATEARMYFROMMUL", new CreateArmyFromMulCommand());
        this.Commands.put("CREATEMERCFACTION", new CreateMercFactionCommand());
        this.Commands.put("CREATESUBFACTION", new CreateSubFactionCommand());
        this.Commands.put("CREATEPILOT", new CreatePilotCommand());
        this.Commands.put("CREATEUNIT", new CreateUnitCommand());
        this.Commands.put("CYCLOPSCHECKUP", new CyclopsCheckupCommand());
        this.Commands.put("CYCLOPSOPTIMIZE", new CyclopsOptimizeCommand());
        this.Commands.put("CYCLOPSPOSTMAXSIZE", new CyclopsPostMaxSizeCommand());
        this.Commands.put("CYCLOPSRESET", new CyclopsResetCommand());
        this.Commands.put("CYCLOPSTEMPLATELOADER", new CyclopsTemplateLoaderCommand());
        this.Commands.put("CYCLOPSVERSION", new CyclopsVersionCommand());
        this.Commands.put("DEACTIVATE", new DeactivateCommand());
        this.Commands.put("DECLINEATTACKFROMRESERVE", new DeclineAttackFromReserveCommand());
        this.Commands.put("DEFECT", new DefectCommand());
        this.Commands.put("DEFEND", new DefendCommand());
        this.Commands.put("DELETEACCOUNT", new DeleteAccountCommand());
        this.Commands.put("DEMOTEPLAYER", new DemotePlayerCommand());
        this.Commands.put("DIRECTSELLUNIT", new DirectSellUnitCommand());
        this.Commands.put("DISPLAYPLAYERPERSONALPILOTQUEUE", new DisplayPlayerPersonalPilotQueueCommand());
        this.Commands.put("DISPLAYUNITREPAIRJOBS", new DisplayUnitRepairJobsCommand());
        this.Commands.put("DONATE", new DonateCommand());
        this.Commands.put("DONATEPILOT", new DonatePilotCommand());
        this.Commands.put("EHM", new EmployeeHouseMailCommand());
        this.Commands.put("EMPLOYEEHOUSEMAIL", new EmployeeHouseMailCommand());
        this.Commands.put("ENROLL", new EnrollCommand());
        this.Commands.put("EXCHANGEUNIT", new ExchangeUnitCommand());
        this.Commands.put("EXU", new ExchangeUnitCommand());
        this.Commands.put("EXM", new ExchangeUnitCommand());
        this.Commands.put("EXCHANGEPILOTINUNIT", new ExchangePilotInUnitCommand());
        this.Commands.put("EXP", new ExchangePilotInUnitCommand());
        this.Commands.put("FACTION", new HouseCommand());
        this.Commands.put("FACTIONLEADERFLUFF", new FactionLeaderFluffCommand());
        this.Commands.put("FLF", new FactionLeaderFluffCommand());
        this.Commands.put("FACTIONLEADERMUTE", new FactionLeaderMuteCommand());
        this.Commands.put("FLM", new FactionLeaderMuteCommand());
        this.Commands.put("FIRETECHS", new FireTechsCommand());
        this.Commands.put("FIXAMMO", new FixAmmoCommand());
        this.Commands.put("FLUFF", new FluffCommand());
        this.Commands.put("FORCEDDEFECT", new ForcedDefectCommand());
        this.Commands.put("FORCEUPDATE", new ForceUpdateCommand());
        this.Commands.put("GAMES", new GamesCommand());
        this.Commands.put("GETCOMPONENTCONVERSION", new GetComponentConversionCommand());
        this.Commands.put("GETFACTIONCONFIGS", new GetFactionConfigsCommand());
        this.Commands.put("GETMODLOG", new GetModLogCommand());
        this.Commands.put("GETPLAYERUNITS", new GetPlayerUnitsCommand());
        this.Commands.put("GETSERVERMEGAMEKGAMEOPTIONS", new GetServerMegaMekGameOptionsCommand());
        this.Commands.put("GETSERVEROPFLAGS", new GetServerOpFlagsCommand());
        this.Commands.put("GOOSE", new GooseCommand());
        this.Commands.put("GRANTEXP", new GrantEXPCommand());
        this.Commands.put("GRANTINFLUENCE", new GrantInfluenceCommand());
        this.Commands.put("GRANTMONEY", new GrantMoneyCommand());
        this.Commands.put("GRANTREWARD", new GrantRewardCommand());
        this.Commands.put("GRANTTECHPOINTS", new GrantTechPointsCommand());
        this.Commands.put("GRANTTECHS", new GrantTechsCommand());
        this.Commands.put("HARDTERMINATE", new HardTerminateCommand());
        this.Commands.put("HIREANDMAINTAIN", new HireAndMaintainHelper());
        this.Commands.put("HIREANDREQUESTNEW", new HireAndRequestNewHelper());
        this.Commands.put("HIREANDREQUESTUSED", new HireAndRequestUsedHelper());
        this.Commands.put("HIRETECHS", new HireTechsCommand());
        this.Commands.put("HOUSE", new HouseCommand());
        this.Commands.put("HOUSECONTRACTS", new HouseContractsCommand());
        this.Commands.put("HOUSEMAIL", new HouseMailCommand());
        this.Commands.put("HM", new HouseMailCommand());
        this.Commands.put("HOUSERANKING", new HouseRankingCommand());
        this.Commands.put("HOUSESTATUS", new HouseStatusCommand());
        this.Commands.put("INCHARACTER", new InCharacterCommand());
        this.Commands.put("IC", new InCharacterCommand());
        this.Commands.put("INVIS", new InvisCommand());
        this.Commands.put("ISSTATUS", new ISStatusCommand());
        this.Commands.put("ISS", new ISStatusCommand());
        this.Commands.put("US", new ISStatusCommand());
        this.Commands.put("UNIVERSESTATUS", new ISStatusCommand());
        this.Commands.put("JOINATTACK", new JoinAttackCommand());
        this.Commands.put("LASTONLINE", new LastOnlineCommand());
        this.Commands.put("LINKUNIT", new LinkUnitCommand());
        this.Commands.put("LISTCOMMANDS", new ListCommandsCommand());
        this.Commands.put("LISTMULS", new ListMulsCommand());
        this.Commands.put("LISTMULTIPLAYERGROUPS", new ListMultiPlayerGroupsCommand());
        this.Commands.put("LISTSERVEROPFLAGS", new ListServerOpFlagsCommand());
        this.Commands.put("LISTSUBFACTIONS", new ListSubFactionCommand());
        this.Commands.put("LOGIN", new LoginCommand());
        this.Commands.put("LOGOUT", new LogoutCommand());
        this.Commands.put("MERCSTATUS", new MercStatusCommand());
        this.Commands.put("MSTATUS", new MercStatusCommand());
        this.Commands.put("MMOTD", new MMOTDCommand());
        this.Commands.put("MODERATORMAIL", new ModeratorMailCommand());
        this.Commands.put("MM", new ModeratorMailCommand());
        this.Commands.put("MODDEACTIVATE", new ModDeactivateCommand());
        this.Commands.put("MODGAMES", new ModGamesCommand());
        this.Commands.put("MODFULLREPAIR", new ModFullRepairCommand());
        this.Commands.put("MODLOG", new ModLogCommand());
        this.Commands.put("MODNOPLAY", new ModNoPlayCommand());
        this.Commands.put("MODREFRESHFACTORY", new ModRefreshFactoryCommand());
        this.Commands.put("MODTERMINATE", new ModTerminateCommand());
        this.Commands.put("MOTD", new MOTDCommand());
        this.Commands.put("MYBIDS", new MyBidsCommand());
        this.Commands.put("MYSTATUS", new MyStatusCommand());
        this.Commands.put("MYVOTES", new MyVotesCommand());
        this.Commands.put("NAMEARMY", new NameArmyCommand());
        this.Commands.put("NAMEPILOT", new NamePilotCommand());
        this.Commands.put("NOPLAY", new NoPlayCommand());
        this.Commands.put("NOTIFYFIGHTING", new NotifyFightingCommand());
        this.Commands.put("OFFERCONTRACT", new OfferContractCommand());
        this.Commands.put("PLANET", new PlanetCommand());
        this.Commands.put("PLAYERLOCKARMY", new PlayerLockArmyCommand());
        this.Commands.put("PLAYERS", new PlayersCommand());
        this.Commands.put("PLAYERUNLOCKARMY", new PlayerUnlockArmyCommand());
        this.Commands.put("PROMOTEPLAYER", new PromotePlayerCommand());
        this.Commands.put("PROMOTEPILOT", new PromotePilotCommand());
        this.Commands.put("PURCHASEFACTORY", new PurchaseFactoryCommand());
        this.Commands.put("RANGE", new RangeCommand());
        this.Commands.put("RECALL", new RecallCommand());
        this.Commands.put("RECALLBID", new RecallBidCommand());
        this.Commands.put("REPOD", new RepodCommand());
        this.Commands.put("REFRESHFACTORY", new RefreshFactoryCommand());
        this.Commands.put("REFUSECONTRACT", new RefuseContractCommand());
        this.Commands.put("RELOADALLAMMO", new ReloadAllAmmoCommand());
        this.Commands.put("REMOVEANDADDNOPLAY", new RemoveAndAddNoPlayHelper());
        this.Commands.put("REMOVEARMY", new RemoveArmyCommand());
        this.Commands.put("RMA", new RemoveArmyCommand());
        this.Commands.put("REMOVEFACTIONPILOT", new RemoveFactionPilotCommand());
        this.Commands.put("REMOVELEADER", new RemoveLeaderCommand());
        this.Commands.put("REMOVEPARTS", new RemovePartsCommand());
        this.Commands.put("REMOVEPILOT", new RemovePilotCommand());
        this.Commands.put("REMOVESONG", new RemoveSongCommand());
        this.Commands.put("REMOVESUBFACTION", new RemoveSubFactionCommand());
        this.Commands.put("REMOVETRAIT", new RemoveTraitCommand());
        this.Commands.put("REMOVEVOTE", new RemoveVoteCommand());
        this.Commands.put("REPAIRUNIT", new RepairUnitCommand());
        this.Commands.put("REQUEST", new RequestCommand());
        this.Commands.put("REQUESTBUILDTABLE", new RequestBuildTableCommand());
        this.Commands.put("REQUESTDONATED", new RequestDonatedCommand());
        this.Commands.put("REQUESTOPERATIONSETTINGS", new RequestOperationSettingsCommand());
        this.Commands.put("REQUESTSERVERMAIL", new RequestServerMailCommand());
        this.Commands.put("REQUESTSUBFACTIONPROMOTION", new RequestSubFactionPromotionCommand());
        this.Commands.put("RESEARCHTECHLEVEL", new ResearchTechLevelCommand());
        this.Commands.put("RESEARCHUNIT", new ResearchUnitCommand());
        this.Commands.put("RESTARTREPAIRTHREAD", new RestartRepairThreadCommand());
        this.Commands.put("RETRIEVEALLOPERATIONS", new RetrieveAllOperationsCommand());
        this.Commands.put("RETRIEVEOPERATION", new RetrieveOperationCommand());
        this.Commands.put("RETRIEVEMUL", new RetrieveMulCommand());
        this.Commands.put("RETRIEVEALLMULS", new RetrieveAllMulsCommand());
        this.Commands.put("RETIREPILOT", new RetirePilotCommand());
        this.Commands.put("SALVAGEUNIT", new SalvageUnitCommand());
        this.Commands.put("SCRAP", new ScrapCommand());
        this.Commands.put("SENDCLIENTDATA", new SendClientDataCommand());
        this.Commands.put("SELL", new SellCommand());
        this.Commands.put("SELLBAYS", new SellBaysCommand());
        this.Commands.put("SENDTOMISC", new SendToMiscCommand());
        this.Commands.put("SERVERVERSION", new ServerVersionCommand());
        this.Commands.put("SERVERGAMEOPTIONS", new ServerGameOptionsCommand());
        this.Commands.put("SETADVANCEDPLANETTERRAIN", new SetAdvancedPlanetTerrainCommand());
        this.Commands.put("SETAUTOEJECT", new SetAutoEjectCommand());
        this.Commands.put("SETAUTOREORDER", new SetAutoReorderCommand());
        this.Commands.put("SETCLIENTVERSION", new SetClientVersionCommand());
        this.Commands.put("SETCOMPONENTCONVERSION", new SetComponentConversionCommand());
        this.Commands.put("SETEDGESKILLS", new SetEdgeSkillsCommand());
        this.Commands.put("SETELO", new SetEloCommand());
        this.Commands.put("SETFACTIONTOFACTIONREWARDPOINTMULTIPLIER", new SetFactionToFactionRewardPointMultiplierCommand());
        this.Commands.put("SETHOUSEBASEPILOTSKILLS", new SetHouseBasePilotSkillsCommand());
        this.Commands.put("SETHOUSEBASEPILOTINGSKILLS", new SetHouseBasePilotingSkillsCommand());
        this.Commands.put("SETHOUSELOGO", new SetHouseLogoCommand());
        this.Commands.put("SETHOUSECONQUER", new SetHouseConquerCommand());
        this.Commands.put("SETHOUSEINHOUSEATTACKS", new SetHouseInHouseAttacksCommand());
        this.Commands.put("SETOPERATION", new SetOperationCommand());
        this.Commands.put("SETMAINTAINED", new SetMaintainedCommand());
        this.Commands.put("SETMMOTD", new SetMMOTDCommand());
        this.Commands.put("SETMOTD", new SetMOTDCommand());
        this.Commands.put("SETMULTIPLAYERGROUP", new SetMultiPlayerGroupCommand());
        this.Commands.put("SETMYLOGO", new SetMyLogoCommand());
        this.Commands.put("SETPLANETCONQUER", new SetPlanetConquerCommand());
        this.Commands.put("SETPLANETCONQUERPOINTS", new SetPlanetConquerPointsCommand());
        this.Commands.put("SETPLANETMINOWNERSHIP", new SetPlanetMinOwnerShipCommand());
        this.Commands.put("SETPLANETWAREHOUSE", new SetPlanetWareHouseCommand());
        this.Commands.put("SETPLANETCOMPPRODUCTION", new SetPlanetCompProductionCommand());
        this.Commands.put("SETSUBFACTIONCONFIG", new SetSubFactionConfigCommand());
        this.Commands.put("SETTARGETSYSTEMTYPE", new SetTargetSystemTypeCommand());
        this.Commands.put("SETUNITAMMO", new SetUnitAmmoCommand());
        this.Commands.put("SETUNITAMMOBYCRIT", new SetUnitAmmoByCritCommand());
        this.Commands.put("SETUNITBURST", new SetUnitBurstCommand());
        this.Commands.put("SETUNITCOMMANDER", new SetUnitCommanderCommand());
        this.Commands.put("SETUNMAINTAINED", new SetUnmaintainedCommand());
        this.Commands.put("SHOWTOHOUSE", new ShowToHouseCommand());
        this.Commands.put("STH", new ShowToHouseCommand());
        this.Commands.put("SIMPLEREPAIR", new SimpleRepairCommand());
        this.Commands.put("SINGASONG", new SingASongCommand());
        this.Commands.put("SAS", new SingASongCommand());
        this.Commands.put("STOPREPAIRJOB", new StopRepairJobCommand());
        this.Commands.put("STRIPALLPARTSCACHE", new StripAllPartsCacheCommand());
        this.Commands.put("STRIPUNITS", new StripUnitsCommand());
        this.Commands.put("TERMINATE", new TerminateCommand());
        this.Commands.put("TERMINATECONTRACT", new TerminateContractCommand());
        this.Commands.put("TICK", new TickCommand());
        this.Commands.put("TOGGLEARMYDISABLED", new ToggleArmyDisabledCommand());
        this.Commands.put("TOUCH", new TouchCommand());
        this.Commands.put("TRANSFERMONEY", new TransferMoneyCommand());
        this.Commands.put("TRANSFERPILOT", new TransferPilotCommand());
        this.Commands.put("TRANSFERUNIT", new TransferUnitCommand());
        this.Commands.put("UPDATEOPERATIONS", new UpdateOperationsCommand());
        this.Commands.put("UPDATESERVERUNITSCACHE", new UpdateServerUnitsCacheCommand());
        this.Commands.put("UPLOADMUL", new UploadMulCommand());
        this.Commands.put("UNEMPLOYEDMERCS", new UnemployedMercsCommand());
        this.Commands.put("UNENROLL", new UnenrollCommand());
        this.Commands.put("UNITPOSITION", new UnitPositionCommand());
        this.Commands.put("UNLOCKLANCES", new UnlockLancesCommand());
        this.Commands.put("USEREWARDPOINTS", new UseRewardPointsCommand());
        this.Commands.put("VALIDATEEMAIL", new ValidateEmailCommand());
        this.Commands.put("VALIDATEUSER", new ValidateUserCommand());
        this.Commands.put("VIEWFACTIONPARTSCACHE", new ViewFactionPartsCacheCommand());
        this.Commands.put("VIEWPLAYERPARTS", new ViewPlayerPartsCommand());
        this.Commands.put("VIEWPLAYERPERSONALPILOTQUEUE", new ViewPlayerPersonalPilotQueueCommand());
        this.Commands.put("VIEWPLAYERUNIT", new ViewPlayerUnitCommand());
        this.Commands.put("VOTE", new VoteCommand());
        this.Commands.put("AM", new ServerAnnouncementCommand());
        this.Commands.put("SA", new ServerAnnouncementCommand());
        this.Commands.put("SERVERANNOUNCEMENT", new ServerAnnouncementCommand());
        this.Commands.put("BAN", new BanCommand());
        this.Commands.put("BANIP", new BanIPCommand());
        this.Commands.put("BANLIST", new BanListCommand());
        this.Commands.put("COLOR", new ColorCommand());
        this.Commands.put("COLOUR", new ColorCommand());
        this.Commands.put("CONFIG", new ConfigCommand());
        this.Commands.put("GETSAVEDMAIL", new GetSavedMailCommand());
        this.Commands.put("IGNORE", new IgnoreCommand());
        this.Commands.put("IGNORELIST", new IgnoreListCommand());
        this.Commands.put("IPLIST", new IPListCommand());
        this.Commands.put("KICK", new KickCommand());
        this.Commands.put("MAIL", new MailCommand());
        this.Commands.put("ME", new MeCommand());
        this.Commands.put("ROLL", new RollCommand());
        this.Commands.put("REGISTER", new RegisterCommand());
        this.Commands.put("SHUTDOWN", new ShutdownCommand());
        this.Commands.put("SETSMOTD", new SetSMOTDCommand());
        this.Commands.put("SIGNOFF", new SignOffCommand());
        this.Commands.put("SMOTD", new SMOTDCommand());
        this.Commands.put("UNBAN", new UnBanCommand());
        this.Commands.put("UNBANIP", new UnBanIPCommand());
        this.Commands.put("CODETEST", new CodeTestCommand());
        try {
            File configFile = new File("./data/commands/commands.dat");
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                StringTokenizer command = new StringTokenizer(dis.readLine(), "#");
                String commandName = command.nextToken();
                if (!this.Commands.containsKey(commandName)) continue;
                this.Commands.get(commandName).setExecutionLevel(Integer.parseInt(command.nextToken()));
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to find commands.dat. Continuing with defaults in place");
            TreeMap<String, Command> commandTable = new TreeMap<String, Command>(cm.getServerCommands());
            try {
                File fp = new File("./data/commands");
                if (!fp.exists()) {
                    fp.mkdir();
                }
                FileOutputStream out = new FileOutputStream("./data/commands/commands.dat");
                PrintStream p = new PrintStream(out);
                for (String commandName : commandTable.keySet()) {
                    Command commandMethod = cm.getServerCommands().get(commandName);
                    if (commandMethod == null) continue;
                    p.println(commandName.toUpperCase() + "#" + commandMethod.getExecutionLevel());
                }
            }
            catch (Exception ex1) {
                CampaignData.mwlog.errLog(ex1);
                CampaignData.mwlog.errLog("Unable to save command levels");
            }
        }
        if (this.data.getAllPlanets().size() > 0 && this.data.getAllHouses().size() > 0) {
            return;
        }
        if (!cm.isUsingMySQL() && this.data.getAllHouses().size() == 0 || cm.isUsingMySQL() && CampaignMain.cm.MySQL.countFactions() == 0) {
            try {
                parser = new XMLFactionDataParser("./data/factions.xml");
                for (SHouse h : ((XMLFactionDataParser)parser).getFactions()) {
                    this.addHouse(h);
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error while reading faction data -- bailing out");
                CampaignData.mwlog.errLog(ex);
                CampaignData.mwlog.mainLog("Error while reading Faction Data!");
                System.exit(1);
            }
            NewbieHouse solaris = new NewbieHouse(this.data.getUnusedHouseID(), cm.getConfig("NewbieHouseName"), "#33CCCC", 4, 5, "SOL");
            this.addHouse(solaris);
            MercHouse none = new MercHouse();
            none.createNoneHouse();
            this.addHouse(none);
        }
        if (this.data.getAllPlanets().size() == 0) {
            for (House h : this.data.getAllHouses()) {
                SHouse sh = (SHouse)h;
                sh.setInitialHouseRanking(0);
            }
            try {
                parser = new XMLPlanetDataParser("./data/planets.xml");
                for (SPlanet p : ((XMLPlanetDataParser)parser).getPlanets()) {
                    this.addPlanet(p);
                    for (House h : p.getInfluence().getHouses()) {
                        SHouse sh = (SHouse)h;
                        if (sh == null) {
                            CampaignData.mwlog.errLog("Null faction found while loading Planets.xml. Planet: " + p.getName());
                            continue;
                        }
                        if (p.getInfluence().getOwner() != null && sh.getId() == p.getInfluence().getOwner().intValue()) {
                            sh.addPlanet(p);
                        }
                        sh.setInitialHouseRanking(sh.getInitialHouseRanking() + p.getInfluence().getInfluence(sh.getId()));
                    }
                }
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Error while reading planet data -- bailing out");
                CampaignData.mwlog.errLog(ex);
                CampaignData.mwlog.mainLog("Error while reading Planet Data!");
                System.exit(1);
            }
            HashMap<Integer, Integer> solFlu = new HashMap<Integer, Integer>();
            solFlu.put(new Integer(cm.getHouseFromPartialString(cm.getConfig("NewbieHouseName"), null).getId()), new Integer(100));
            SPlanet newbieP = new SPlanet(0, "Solaris VII", new Influences(solFlu), 0, 0, -3.0, -2.0);
            if (this.data.getPlanetByName("Solaris VII") == null) {
                this.addPlanet(newbieP);
                cm.getHouseFromPartialString(cm.getConfig("NewbieHouseName"), null).addPlanet(newbieP);
            }
        }
        this.toFile();
    }

    public void addHouse(SHouse s) {
        this.data.addHouse(s);
    }

    public void addPlanet(SPlanet p) {
        if (p.getOriginalOwner().trim().equals("")) {
            if (p.getOwner() == null) {
                p.setOriginalOwner(cm.getConfig("NewbieHouseName"));
            }
            p.setOriginalOwner(p.getOwner().getName());
        }
        this.data.addPlanet(p);
    }

    public synchronized void userRoll(String text, String Username) {
        int dice = 2;
        int sides = 6;
        int total = 0;
        int roll = 0;
        String x = "";
        if (text.trim().length() > 0) {
            StringTokenizer ST = new StringTokenizer(text, "d");
            try {
                if (ST.hasMoreElements()) {
                    x = (String)ST.nextElement();
                    dice = Integer.parseInt(x.trim());
                }
                if (ST.hasMoreElements()) {
                    x = (String)ST.nextElement();
                    sides = Integer.parseInt(x.trim());
                }
            }
            catch (NumberFormatException ex) {
                this.toUser("AM:/roll: error parsing arguments.", Username, true);
                return;
            }
            catch (StringIndexOutOfBoundsException ex) {
                this.toUser("AM:/roll: error parsing arguments.", Username, true);
                return;
            }
        }
        if (dice < 1 || sides < 2) {
            this.doSendToAllOnlinePlayers("AM:" + Username + " loves the smell of napalm in the morning.", true);
            return;
        }
        if (dice > 20 || sides > 100) {
            this.doSendToAllOnlinePlayers("AM:" + Username + " is a stupid haxx0r!", true);
            return;
        }
        StringBuilder diceBuffer = new StringBuilder();
        for (int i = 0; i < dice; ++i) {
            roll = cm.getRandomNumber(sides) + 1;
            total += roll;
            if (dice < 2) {
                diceBuffer.append(roll);
                continue;
            }
            if (i < dice - 1) {
                diceBuffer.append(roll);
                diceBuffer.append(", ");
                continue;
            }
            diceBuffer.append("and ");
            diceBuffer.append(roll);
        }
        if (text != "") {
            this.doSendToAllOnlinePlayers("AM:" + Username + " rolled " + diceBuffer + " for a total of " + total + ", using " + text + ".", true);
        } else {
            this.doSendToAllOnlinePlayers("AM:" + Username + " rolled " + diceBuffer + " for a total of " + total + ", using 2d6.", true);
        }
    }

    public void addMechStat(String Filename, int mechsize, int gameplayed, int gamewon, int scrapped) {
        this.addMechStat(Filename, mechsize, gameplayed, gamewon, scrapped, 0);
    }

    public void addMechStat(String Filename, int mechsize, int gameplayed, int gamewon, int scrapped, int destroyed) {
        MechStatistics m = null;
        m = this.MechStats.get(Filename) == null ? new MechStatistics(Filename, mechsize) : this.MechStats.get(Filename);
        m.setOriginalBV(SUnit.loadMech(Filename).calculateBattleValue());
        m.addStats(gameplayed, gamewon, m.getOriginalBV());
        m.setTimesScrapped(m.getTimesScrapped() + scrapped);
        m.setTimesDestroyed(m.getTimesDestroyed() + destroyed);
        this.MechStats.put(Filename, m);
    }

    private void checkAndRemoveIdle(SPlayer p, long maxIdleTime) {
        if (this.getServer().isModerator(p.getName())) {
            return;
        }
        if (p.getDutyStatus() <= 1) {
            return;
        }
        if (p.getDutyStatus() == 4) {
            return;
        }
        if (System.currentTimeMillis() - p.getLastTimeCommandSent() > maxIdleTime) {
            cm.toUser("You were logged out by the server (excessive idle time).", p.getName(), true);
            cm.toUser("KI|idler", p.getName(), false);
        }
    }

    public synchronized void slice(int sliceID) {
        CampaignData.mwlog.mainLog("Slice #" + sliceID + " Started");
        CampaignData.mwlog.cmdLog("Slice #" + sliceID + " Started");
        CampaignData.mwlog.infoLog("Slice #" + sliceID + " Started: " + System.currentTimeMillis());
        for (House vh : this.data.getAllHouses()) {
            SHouse currH = (SHouse)vh;
            long maxIdleTime = Long.parseLong(cm.getConfig("MaxIdleTime")) * 60000L;
            if (maxIdleTime > 0L) {
                for (SPlayer currP : currH.getReservePlayers().values()) {
                    this.checkAndRemoveIdle(currP, maxIdleTime);
                }
            }
            for (SPlayer currP : currH.getActivePlayers().values()) {
                currP.doMaintainance();
                this.toUser(currP.addInfluenceAtSlice(), currP.getName(), true);
                if (maxIdleTime <= 0L) continue;
                this.checkAndRemoveIdle(currP, maxIdleTime);
            }
            for (SPlayer currP : currH.getFightingPlayers().values()) {
                currP.doMaintainance();
                if (maxIdleTime <= 0L) continue;
                currP.setLastTimeCommandSent(System.currentTimeMillis() + maxIdleTime);
            }
        }
        int saveOnSlice = cm.getIntegerConfig("SaveEverySlice");
        if (saveOnSlice < 1) {
            saveOnSlice = 1;
        }
        if (sliceID % saveOnSlice == 0) {
            this.savePlayers();
            this.saveTopUnitID();
        }
        CampaignData.mwlog.mainLog("Slice #" + sliceID + " Finished");
        CampaignData.mwlog.cmdLog("Slice #" + sliceID + " Finished");
        CampaignData.mwlog.infoLog("Slice #" + sliceID + " Finished: " + System.currentTimeMillis());
    }

    public synchronized void tick(boolean real, int tickid) {
        CampaignData.mwlog.mainLog("Tick #" + tickid + " Started");
        CampaignData.mwlog.cmdLog("Tick #" + tickid + " Started");
        CampaignData.mwlog.infoLog("Tick #" + tickid + " Started");
        int gameCount = 0;
        for (ShortOperation currO : this.getOpsManager().getRunningOps().values()) {
            if (currO.getStatus() != ShortOperation.STATUS_INPROGRESS) continue;
            ++gameCount;
        }
        CampaignData.mwlog.tickLog(gameCount + " games in progress.");
        int totalPlayersOnline = 0;
        for (House vh : this.data.getAllHouses()) {
            SHouse currH = (SHouse)vh;
            int activePs = currH.getActivePlayers().size();
            int fightingPs = currH.getFightingPlayers().size();
            int totalFactionPlayers = currH.getReservePlayers().size() + activePs + fightingPs;
            CampaignData.mwlog.tickLog(currH.getName() + " has " + totalFactionPlayers + " members online (" + activePs + " active, " + fightingPs + " fighting)");
            if (totalFactionPlayers <= 0 && real) continue;
            String houseTickInfo = "";
            if (!cm.getBooleanConfig("ProcessHouseTicksAtSlice")) {
                try {
                    CampaignData.mwlog.debugLog("Starting Faction Tick");
                    houseTickInfo = currH.tick(real, tickid);
                    CampaignData.mwlog.debugLog("Finished Faction Tick");
                }
                catch (Exception e) {
                    CampaignData.mwlog.errLog("Problems with faction tick.");
                    CampaignData.mwlog.errLog(e);
                }
            }
            for (SPlayer currP : currH.getAllOnlinePlayers().values()) {
                if (this.getServer().getClient(currP.getName()) == null) {
                    CampaignData.mwlog.debugLog("Logging out Player " + currP.getName());
                    this.doLogoutPlayer(currP.getName());
                    continue;
                }
                ++totalPlayersOnline;
                CampaignData.mwlog.debugLog("Setting Scraps This tick for " + currP.getName());
                currP.setScrapsThisTick(0);
                CampaignData.mwlog.debugLog("Setting Donations This tick for " + currP.getName());
                currP.setDonatonsThisTick(0);
                CampaignData.mwlog.debugLog("Healing pilots This tick for " + currP.getName());
                currP.healPilots();
                CampaignData.mwlog.debugLog("Updating faction info for " + currP.getName());
                this.toUser("SM|" + houseTickInfo, currP.getName(), false);
            }
        }
        CampaignData.mwlog.tickLog("Total players: " + this.getServer().userCount(true) + " online, " + totalPlayersOnline + " logged in.");
        String generalResult = "<br>";
        String opsTick = this.opsManager.tick();
        if (opsTick.length() > 0) {
            generalResult = generalResult + opsTick + "<br><br>";
        }
        String rankTick = "";
        if (Boolean.parseBoolean(this.getConfig("ShowFactionRanks"))) {
            rankTick = Statistics.getReadableHouseRanking(true);
        }
        if (rankTick.length() > 0) {
            generalResult = generalResult + rankTick + "<br><br>";
        }
        if (generalResult.toLowerCase().replace("<br>", " ").trim().length() > 0) {
            this.doSendToAllOnlinePlayers("PL|UDT|" + generalResult, false);
        }
        try {
            this.market.tick();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        CampaignData.mwlog.tickLog("Parts Market Tick Started");
        try {
            this.partsmarket.tick();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        CampaignData.mwlog.tickLog("Parts Market Tick Finished");
        CampaignData.mwlog.tickLog("doRanking");
        if (Boolean.parseBoolean(this.getConfig("HTMLOUTPUT"))) {
            Statistics.doRanking();
        }
        CampaignData.mwlog.tickLog("PurgePlayersFiles");
        this.purgePlayerFiles();
        CampaignData.mwlog.tickLog("Automated Backup");
        this.aub = new AutomaticBackup(System.currentTimeMillis());
        this.aub.run();
        CampaignData.mwlog.tickLog("GC");
        System.gc();
        CampaignData.mwlog.mainLog("Tick #" + tickid + " Finished");
        CampaignData.mwlog.cmdLog("Tick #" + tickid + " Finished");
        CampaignData.mwlog.infoLog("Tick #" + tickid + " Finished");
    }

    public TreeSet<HouseRankingHelpContainer> getHouseRanking() {
        Hashtable<String, HouseRankingHelpContainer> factionContainer = new Hashtable<String, HouseRankingHelpContainer>();
        for (House currHouse : this.data.getAllHouses()) {
            SHouse h = (SHouse)currHouse;
            if (h.isMercHouse() || h.isNewbieHouse()) continue;
            HouseRankingHelpContainer hrc = new HouseRankingHelpContainer(h);
            factionContainer.put(h.getName(), hrc);
        }
        for (Planet p : this.data.getAllPlanets()) {
            for (House currH : p.getInfluence().getHouses()) {
                SHouse hs = (SHouse)currH;
                if (hs == null || hs.isNewbieHouse() || hs.isMercHouse()) continue;
                ((HouseRankingHelpContainer)factionContainer.get(hs.getName())).addAmount(p.getInfluence().getInfluence(hs.getId()));
            }
        }
        TreeSet<HouseRankingHelpContainer> s = new TreeSet<HouseRankingHelpContainer>();
        for (HouseRankingHelpContainer currContainer : factionContainer.values()) {
            s.add(currContainer);
        }
        return s;
    }

    public void doSendToAllOnlinePlayers(String text, boolean isChat) {
        for (House vh : this.data.getAllHouses()) {
            SHouse h = (SHouse)vh;
            for (String currName : h.getReservePlayers().keySet()) {
                this.toUser(text, currName, isChat);
            }
            for (String currName : h.getActivePlayers().keySet()) {
                this.toUser(text, currName, isChat);
            }
            for (String currName : h.getFightingPlayers().keySet()) {
                this.toUser(text, currName, isChat);
            }
        }
    }

    public void doSendToAllOnlinePlayers(SHouse h, String text, boolean isChat) {
        for (String currName : h.getReservePlayers().keySet()) {
            this.toUser(text, currName, isChat);
        }
        for (String currName : h.getActivePlayers().keySet()) {
            this.toUser(text, currName, isChat);
        }
        for (String currName : h.getFightingPlayers().keySet()) {
            this.toUser(text, currName, isChat);
        }
    }

    public void updateAllOnlinePlayerArmies() {
        this.doSendToAllOnlinePlayers("PL|UOE|CLEAR", false);
        for (House vh : this.data.getAllHouses()) {
            SHouse h = (SHouse)vh;
            for (SPlayer currPlayer : h.getReservePlayers().values()) {
                for (SArmy a : currPlayer.getArmies()) {
                    a.getLegalOperations().clear();
                    cm.getOpsManager().checkOperations(a, true);
                }
            }
            for (SPlayer currPlayer : h.getActivePlayers().values()) {
                for (SArmy a : currPlayer.getArmies()) {
                    a.getLegalOperations().clear();
                    cm.getOpsManager().checkOperations(a, true);
                }
            }
            for (SPlayer currPlayer : h.getFightingPlayers().values()) {
                for (SArmy a : currPlayer.getArmies()) {
                    a.getLegalOperations().clear();
                    cm.getOpsManager().checkOperations(a, true);
                }
            }
        }
    }

    public SHouse getHouseForPlayer(String Username) {
        String lowerName = Username.toLowerCase();
        for (House vh : this.data.getAllHouses()) {
            SHouse h = (SHouse)vh;
            if (h.getReservePlayers().containsKey(lowerName)) {
                return h;
            }
            if (h.getActivePlayers().containsKey(lowerName)) {
                return h;
            }
            if (!h.getFightingPlayers().containsKey(lowerName)) continue;
            return h;
        }
        return null;
    }

    public boolean isUsingCyclops() {
        boolean isUsing = Boolean.parseBoolean(this.myServer.getConfigParam("USECYCLOPS"));
        if (isUsing && this.mwcc == null) {
            this.mwcc = new MWCyclopsComm(this.myServer.getConfigParam("CYCLOPSIP"), this.myServer.getConfigParam("SERVERNAME"), this.myServer.getConfigParam("CYCLOPSURL"), Boolean.parseBoolean(this.myServer.getConfigParam("CYCLOPSDEBUG")));
            this.mwcc.start();
        } else if (!isUsing && this.mwcc != null) {
            this.mwcc.interrupt();
            this.mwcc = null;
        } else if (isUsing && this.mwcc != null && (this.mwcc.isInterrupted() || !this.mwcc.isAlive())) {
            this.mwcc.start();
        }
        return isUsing;
    }

    public boolean isUsingMySQL() {
        boolean isUsing = Boolean.parseBoolean(this.myServer.getConfigParam("USEMYSQL"));
        if (isUsing && this.MySQL == null) {
            this.MySQL = new mysqlHandler();
        } else if (!isUsing && this.MySQL != null) {
            this.MySQL.closeMySQL();
            this.MySQL = null;
        }
        return isUsing;
    }

    public boolean isUsingIncreasedTechs() {
        return cm.getBooleanConfig("UseNonFactionUnitsIncreasedTechs") && !cm.isUsingAdvanceRepair();
    }

    public boolean isSynchingBB() {
        if (!this.validBBVersion) {
            return false;
        }
        if (this.isUsingMySQL()) {
            return this.MySQL.isSynchingBB();
        }
        return false;
    }

    public boolean requireEmailForRegistration() {
        return this.isUsingMySQL() && this.isSynchingBB() && cm.getBooleanConfig("REQUIREEMAILFORREGISTRATION");
    }

    public boolean isKeepingUnitHistory() {
        return this.isUsingMySQL() && cm.getBooleanConfig("StoreUnitHistoryInDatabase") && this.isUsingMySQL();
    }

    public void turnOffBBSynch() {
        this.validBBVersion = false;
    }

    public boolean isUsingAdvanceRepair() {
        boolean isUsing;
        boolean bl = isUsing = cm.getBooleanConfig("UseAdvanceRepair") || cm.getBooleanConfig("UseSimpleRepair");
        if (isUsing && this.RTT == null) {
            this.RTT = new RepairTrackingThread(cm.getLongConfig("TimeForEachRepairPoint") * 1000L);
            this.RTT.start();
        } else if (!isUsing && this.RTT != null) {
            this.RTT.interrupt();
            this.RTT = null;
        }
        return isUsing;
    }

    public void restartRTT() {
        boolean isUsing;
        boolean bl = isUsing = cm.getBooleanConfig("UseAdvanceRepair") || cm.getBooleanConfig("UseSimpleRepair");
        if (isUsing) {
            this.RTT = null;
            this.RTT = new RepairTrackingThread(cm.getLongConfig("TimeForEachRepairPoint") * 1000L);
            this.RTT.start();
        }
    }

    public Random getR() {
        return this.r;
    }

    public int getRandomNumber(int seed) {
        if (seed < 1) {
            return seed;
        }
        float answer = this.r.nextFloat() * (float)seed;
        return (int)Math.floor(answer);
    }

    public synchronized void addToNewsFeed(String s) {
        this.addToNewsFeed(s, "");
    }

    public synchronized void addToNewsFeed(String title, String body) {
        String dateTimeFormat = "yyyy/MM/dd HH:mm:ss z";
        SimpleDateFormat sDF = new SimpleDateFormat(dateTimeFormat);
        Date date = new Date(System.currentTimeMillis());
        String dateTime = "[" + sDF.format(date) + "] ";
        StringBuffer msgBody = new StringBuffer(body);
        while (msgBody.indexOf("<") > -1) {
            msgBody.delete(msgBody.indexOf("<"), msgBody.indexOf(">") + 1);
        }
        title = dateTime + title;
        this.NewsFeed.put(title, msgBody.toString());
        if (this.NewsFeed.size() > 200) {
            this.NewsFeed.remove(this.NewsFeed.firstKey());
        }
        try {
            FileOutputStream out = new FileOutputStream(this.getConfig("NewsPath"));
            PrintStream ps = new PrintStream(out);
            ps.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
            ps.println("<rdf:RDF");
            ps.println("xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
            ps.println("xmlns=\"http://my.netscape.com/rdf/simple/0.9/\">");
            ps.println("<channel>");
            ps.println("<title>" + this.getServer().getConfigParam("SERVERNAME") + " News Feed</title>");
            ps.println("<link>" + this.getServer().getConfigParam("TRACKERLINK") + "</link>");
            ps.println("<description>Campaign News</description>");
            ps.println("</channel>");
            for (String header : this.NewsFeed.keySet()) {
                String newsBody = this.NewsFeed.get(header);
                ps.println("<item>");
                ps.println("<title>" + header + "</title>");
                ps.println("<description>" + newsBody + "</description>");
                ps.println("<link>" + this.getServer().getConfigParam("TRACKERLINK") + "</link>");
                ps.println("</item>");
            }
            ps.println("</rdf:RDF>");
            ps.close();
        }
        catch (FileNotFoundException efnf) {
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems writing the news feed");
        }
    }

    public Market2 getMarket() {
        return this.market;
    }

    public PartsMarket getPartsMarket() {
        return this.partsmarket;
    }

    public void initializePilotSkills() {
        this.pilotSkills.put(new Integer(1), new DodgeManeuverSkill(1));
        this.pilotSkills.put(new Integer(7), new ManeuveringAceSkill(7));
        this.pilotSkills.put(new Integer(3), new MeleeSpecialistSkill(3));
        this.pilotSkills.put(new Integer(4), new PainResistanceSkill(4));
        this.pilotSkills.put(new Integer(2), new AstechSkill(2));
        this.pilotSkills.put(new Integer(5), new NaturalAptitudeGunnerySkill(5));
        this.pilotSkills.put(new Integer(6), new NaturalAptitudePilotingSkill(6));
        this.pilotSkills.put(new Integer(13), new IronManSkill(13));
        this.pilotSkills.put(new Integer(9), new GunneryBallisticSkill(9));
        this.pilotSkills.put(new Integer(10), new GunneryLaserSkill(10));
        this.pilotSkills.put(new Integer(11), new GunneryMissileSkill(11));
        this.pilotSkills.put(new Integer(8), new TacticalGeniusSkill(8));
        this.pilotSkills.put(new Integer(12), new WeaponSpecialistSkill(12));
        this.pilotSkills.put(new Integer(14), new SurvivalistSkill(14));
        this.pilotSkills.put(new Integer(15), new TraitSkill(15));
        this.pilotSkills.put(new Integer(16), new EnhancedInterfaceSkill(16));
        this.pilotSkills.put(new Integer(17), new QuickStudySkill(17));
        this.pilotSkills.put(new Integer(18), new GiftedSkill(18));
        this.pilotSkills.put(new Integer(19), new MedTechSkill(19));
        this.pilotSkills.put(new Integer(20), new EdgeSkill(20));
        this.pilotSkills.put(new Integer(21), new ClanPilotTrainingSkill(21));
        this.pilotSkills.put(new Integer(22), new VDNI(22));
        this.pilotSkills.put(new Integer(23), new BufferedVDNI(23));
        this.pilotSkills.put(new Integer(24), new PainShunt(24));
    }

    public Properties getConfig() {
        return this.config;
    }

    public Hashtable<String, Command> getServerCommands() {
        return this.Commands;
    }

    public Hashtable<String, String> getServerBannedAmmo() {
        return cm.getData().getServerBannedAmmo();
    }

    public double getAmmoCost(String ammo) {
        if (this.blackMarketEquipmentCostTable.containsKey(ammo) && this.blackMarketEquipmentCostTable.get(ammo).getMinCost() > 0.0) {
            return this.blackMarketEquipmentCostTable.get(ammo).getMinCost();
        }
        return -1.0;
    }

    public VoteManager getVoteManager() {
        return this.voteManager;
    }

    public Hashtable<String, Equipment> getBlackMarketEquipmentTable() {
        return this.blackMarketEquipmentCostTable;
    }

    public TickThread getTThread() {
        return this.TThread;
    }

    public ImmunityThread getIThread() {
        return this.IThread;
    }

    public Vector<ContractInfo> getUnresolvedContracts() {
        return this.unresolvedContracts;
    }

    public SPilotSkill getRandomSkill(SPilot p, int unitType) {
        int total = 0;
        Iterator<SPilotSkill> it = this.pilotSkills.values().iterator();
        Hashtable<Integer, Integer> skilltable = new Hashtable<Integer, Integer>();
        if (p.getSkills().has(15)) {
            String trait = p.getTraitName();
            if (trait.indexOf("*") > -1) {
                trait = trait.substring(0, trait.indexOf("*"));
            }
            Vector<String> traitsList = this.getFactionTraits(p.getCurrentFaction());
            traitsList.trimToSize();
            for (String traitNames : traitsList) {
                StringTokenizer traitName = new StringTokenizer(traitNames, "*");
                String traitString = traitName.nextToken();
                if (!traitString.equalsIgnoreCase(trait)) continue;
                while (traitName.hasMoreElements()) {
                    int traitid = Integer.parseInt(traitName.nextToken());
                    int traitMod = Integer.parseInt(traitName.nextToken());
                    skilltable.put(traitid, traitMod);
                }
            }
        }
        while (it.hasNext()) {
            SPilotSkill skill = it.next();
            total += skill.getChance(unitType, p);
        }
        if (total == 0) {
            return null;
        }
        it = this.pilotSkills.values().iterator();
        Vector<SPilotSkill> skillBuilder = new Vector<SPilotSkill>(total, 1);
        try {
            while (it.hasNext()) {
                SPilotSkill skill = it.next();
                int chance = skill.getChance(unitType, p);
                if (skilltable.get(new Integer(skill.getId())) != null) {
                    chance += ((Integer)skilltable.get(skill.getId())).intValue();
                }
                for (int pos = 0; pos < chance; ++pos) {
                    skillBuilder.add(skill);
                }
                skillBuilder.trimToSize();
            }
            return (SPilotSkill)skillBuilder.elementAt(cm.getRandomNumber(skillBuilder.size()));
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Problems during skill earning! Skill Table Size = " + skillBuilder.size() + " total = " + total);
            return null;
        }
    }

    public SPilotSkill getPilotSkill(String skill) {
        for (SPilotSkill pSkill : this.pilotSkills.values()) {
            if (!pSkill.getName().equalsIgnoreCase(skill) && !pSkill.getAbbreviation().equalsIgnoreCase(skill)) continue;
            return pSkill;
        }
        return null;
    }

    public SPilotSkill getPilotSkill(int id) {
        return this.pilotSkills.get(id);
    }

    public static String readableTime(long elapsed) {
        String result = "";
        long elapsedDays = elapsed / 86400000L;
        long elapsedHours = elapsed % 86400000L / 3600000L;
        long elapsedMinutes = elapsed % 3600000L / 60000L;
        if (elapsedDays > 0L) {
            result = result + elapsedDays + "d ";
        }
        if (elapsedHours > 0L || elapsedDays > 0L) {
            result = result + elapsedHours + "h ";
        }
        result = result + elapsedMinutes + "m";
        return result;
    }

    public static String readableTimeWithSeconds(long elapsed) {
        String result = "";
        long elapsedMinutes = elapsed / 60000L;
        long elapsedSeconds = elapsed % 60000L / 1000L;
        if (elapsedMinutes > 0L) {
            result = result + elapsedMinutes + " min";
        }
        if (elapsedSeconds > 0L && elapsedMinutes > 0L) {
            result = result + ", " + elapsedSeconds + " sec";
        } else if (elapsedSeconds > 0L) {
            result = result + elapsedSeconds + " sec";
        }
        return result;
    }

    public int getCurrentUnitID() {
        return this.currentUnitID;
    }

    public void setCurrentUnitID(int currentUnitID) {
        this.currentUnitID = currentUnitID;
    }

    public synchronized int getAndUpdateCurrentUnitID() {
        ++this.currentUnitID;
        return this.currentUnitID - 1;
    }

    public int getCurrentPilotID() {
        return this.currentPilotID;
    }

    public synchronized int getAndUpdateCurrentPilotID() {
        return ++this.currentPilotID;
    }

    public void setCurrentPilotID(int id) {
        this.currentPilotID = id;
    }

    public SHouse getHouseFromPartialString(String HouseString) {
        return this.getHouseFromPartialString(HouseString, null);
    }

    public SHouse getHouseFromDBID(int DBId) {
        for (House currH : this.data.getAllHouses()) {
            SHouse sh = (SHouse)currH;
            if (sh.getDBId() != DBId) continue;
            return sh;
        }
        return null;
    }

    public SHouse getHouseById(int id) {
        return (SHouse)this.data.getHouse(id);
    }

    public SHouse getHouseFromPartialString(String HouseString, String Username) {
        int numMatches = 0;
        SHouse theMatch = null;
        for (House currH : this.data.getAllHouses()) {
            SHouse sh = (SHouse)currH;
            if (sh.getName().equals(HouseString)) {
                return sh;
            }
            if (!sh.getName().startsWith(HouseString)) continue;
            theMatch = sh;
            ++numMatches;
        }
        if (numMatches > 1) {
            if (Username != null) {
                this.toUser("\"" + HouseString + "\" is not unique [" + numMatches + " matches]. Please be more specific.", Username);
            }
            return null;
        }
        if (numMatches == 0) {
            if (Username != null) {
                this.toUser("Couldn't find a factions whose name begins with \"" + HouseString + "\". Try again.", Username, true);
            }
            return null;
        }
        return theMatch;
    }

    public MWCyclopsComm getMWCC() {
        return this.mwcc;
    }

    private void savePlayers() {
        while (this.isArchiving()) {
            try {
                Thread.sleep(125L);
            }
            catch (Exception ex) {}
        }
        Date d = new Date(System.currentTimeMillis());
        CampaignData.mwlog.infoLog(d + ": Starting Player Saving cycle");
        for (House vh : cm.getData().getAllHouses()) {
            SHouse currH = (SHouse)vh;
            for (SPlayer currP : currH.getAllOnlinePlayers().values()) {
                this.savePlayerFile(currP);
            }
        }
        d = new Date(System.currentTimeMillis());
        CampaignData.mwlog.mainLog(d + ": Player save cycle completed.");
        CampaignData.mwlog.infoLog(d + ": Player saves finished.");
    }

    public void forceSavePlayers(String Username) {
        for (House vh : cm.getData().getAllHouses()) {
            SHouse currH = (SHouse)vh;
            for (SPlayer currP : currH.getAllOnlinePlayers().values()) {
                this.savePlayerFile(currP);
                if (Username == null) continue;
                cm.toUser("AM:" + currP.getName() + " saved", Username, true);
            }
        }
    }

    public void forceSavePlayer(SPlayer p) {
        this.savePlayerFile(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePlayerFile(SPlayer p) {
        try {
            if (cm.isUsingMySQL()) {
                p.toDB();
                return;
            }
            String fileName = p.getName().toLowerCase();
            FileOutputStream pout = new FileOutputStream("./campaign/players/" + fileName.toLowerCase() + ".dat");
            PrintStream pfile = new PrintStream(pout);
            SPlayer sPlayer = p;
            synchronized (sPlayer) {
                pfile.println(p.toString(false));
            }
            pfile.close();
            pout.close();
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Unable to save " + p.getName().toLowerCase());
        }
    }

    public void loadBanAmmo(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line, "#");
            String HouseName = (String)st.nextElement();
            SHouse faction = null;
            if (!HouseName.equalsIgnoreCase("server")) {
                faction = cm.getHouseFromPartialString(HouseName, null);
                while (st.hasMoreTokens()) {
                    faction.getBannedAmmo().put(st.nextToken(), "Banned");
                }
            } else {
                while (st.hasMoreElements()) {
                    cm.getServerBannedAmmo().put(st.nextToken(), "Banned");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadBlackMarketSettings() {
        try {
            File bmFile = new File("./data/blackmarketsettings.dat");
            if (!bmFile.exists()) {
                return;
            }
            FileInputStream fis = new FileInputStream(bmFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            dis.readLine();
            while (dis.ready()) {
                Equipment bme = new Equipment();
                String line = dis.readLine();
                StringTokenizer data = new StringTokenizer(line, "#");
                bme.setEquipmentInternalName(data.nextToken());
                bme.setMinCost(Double.parseDouble(data.nextToken()));
                bme.setMaxCost(Double.parseDouble(data.nextToken()));
                bme.setMinProduction(Integer.parseInt(data.nextToken()));
                bme.setMaxProduction(Integer.parseInt(data.nextToken()));
                cm.getBlackMarketEquipmentTable().put(bme.getEquipmentInternalName(), bme);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void saveTopUnitID() {
        int topID = cm.getCurrentUnitID();
        try {
            FileOutputStream pout = new FileOutputStream("./campaign/topserverid.dat");
            PrintStream unitIDFile = new PrintStream(pout);
            unitIDFile.println(topID);
            unitIDFile.println(cm.getCurrentPilotID());
            unitIDFile.close();
            pout.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void loadTopUnitID() {
        try {
            File idFile = new File("./campaign/topserverid.dat");
            FileInputStream fis = new FileInputStream(idFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            cm.setCurrentUnitID(Integer.parseInt(dis.readLine()));
            cm.setCurrentPilotID(Integer.parseInt(dis.readLine()));
            dis.close();
            fis.close();
        }
        catch (FileNotFoundException FNFE) {
            CampaignData.mwlog.errLog("Unable to fine/open ./campaign/topserverid.dat. moving on.");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void setGamesCompleted(int i) {
        this.gamesCompleted = i;
    }

    public void addGamesCompleted(int i) {
        this.setGamesCompleted(this.getGamesCompleted() + i);
    }

    public int getGamesCompleted() {
        return this.gamesCompleted;
    }

    public int getMachineGunCount(ArrayList<Mounted> weaponList) {
        int count = 0;
        for (Mounted weapons : weaponList) {
            WeaponType weapon = (WeaponType)weapons.getType();
            if (!weapon.hasFlag(512L)) continue;
            ++count;
        }
        return count;
    }

    public Vector<String> getFactionTraits(String faction) {
        Vector<String> traits = new Vector<String>(1, 1);
        File traitNames = new File("./data/pilotnames/" + faction.toLowerCase() + "traitnames.txt");
        if (!traitNames.exists()) {
            traitNames = new File("./data/pilotnames/commontraitnames.txt");
        }
        try {
            FileInputStream fis = new FileInputStream(traitNames);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                traits.addElement(dis.readLine());
            }
            dis.close();
            fis.close();
        }
        catch (FileNotFoundException nf) {
            CampaignData.mwlog.errLog("File Not Found: " + traitNames);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error loading Faction Traits: " + faction);
            CampaignData.mwlog.errLog(ex);
        }
        traits.trimToSize();
        return traits;
    }

    public void saveFactionTraits(String faction, Vector<String> traits) {
        File traitFile = new File("./data/pilotnames/" + faction.toLowerCase() + "traitnames.txt");
        try {
            if (!traitFile.exists()) {
                traitFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(traitFile);
            PrintStream p = new PrintStream(fos);
            for (String tempTrait : traits) {
                p.println(tempTrait);
            }
            p.close();
            fos.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error while saving trait file for faction: " + faction);
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void setOmniVariantMods(Hashtable<String, String> table) {
        this.omniVariantMods = table;
    }

    public Hashtable<String, String> getOmniVariantMods() {
        return this.omniVariantMods;
    }

    public void saveOmniVariantMods() {
        if (this.omniVariantMods.size() < 1) {
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream("./campaign/omnivariantmods.dat");
            PrintStream p = new PrintStream(out);
            for (String currKey : cm.getOmniVariantMods().keySet()) {
                String currMod = cm.getOmniVariantMods().get(currKey);
                p.println(currKey + "#" + currMod);
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error while saving omnivariantmods.dat");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void purgePlayerFiles() {
        File[] playerList;
        long days = Long.parseLong(cm.getConfig("PurgePlayerFilesDays"));
        if (days <= 0L) {
            return;
        }
        if (cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.purgeStalePlayers(days);
            return;
        }
        days *= 24L;
        days *= 60L;
        days *= 60L;
        days *= 1000L;
        for (File player : playerList = new File("./campaign/players").listFiles()) {
            if (player.isDirectory() || player.lastModified() + days >= System.currentTimeMillis()) continue;
            String playerName = player.getName().substring(0, player.getName().indexOf(".dat"));
            SPlayer p = this.getPlayer(playerName, false, true);
            p.addExperience(100, true);
            Command c = cm.getServerCommands().get("UNENROLL");
            c.process(new StringTokenizer("CONFIRM", "#"), playerName);
            CampaignData.mwlog.infoLog(playerName + " purged.");
        }
    }

    public String moneyOrFluMessage(boolean money, boolean shortname, int amount) {
        return this.moneyOrFluMessage(money, shortname, amount, false);
    }

    public String moneyOrFluMessage(boolean money, boolean shortname, int amount, boolean showSign) {
        String result = NumberFormat.getInstance().format(amount);
        String moneyShort = cm.getConfig("MoneyShortName").toLowerCase();
        String moneyLong = cm.getConfig("MoneyLongName");
        String fluShort = cm.getConfig("FluShortName").toLowerCase();
        String fluLong = cm.getConfig("FluLongName");
        String sign = "+";
        if (amount < 0) {
            sign = "-";
            result = NumberFormat.getInstance().format(amount *= -1);
        }
        if (!shortname) {
            result = result + " ";
        }
        result = money ? (shortname ? (amount == 1 && moneyShort.endsWith("s") ? result + moneyShort.substring(0, moneyShort.length() - 1) : (amount > 1 && !moneyShort.endsWith("s") ? result + moneyShort + "s" : result + moneyShort)) : (amount == 1 && moneyLong.endsWith("s") ? result + moneyLong.substring(0, moneyLong.length() - 1) : (amount > 1 && !moneyLong.endsWith("s") ? result + moneyLong + "s" : result + moneyLong))) : (shortname ? result + fluShort : result + fluLong);
        if (showSign) {
            return sign + result;
        }
        return result.trim();
    }

    public void updateISPLists(SPlayer player) {
        try {
            File file = new File("./data/Providers");
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(file = new File("./data/Providers/" + player.getLastISP() + ".prv")).exists()) {
                this.saveToISPLists(player);
                return;
            }
            FileInputStream in = new FileInputStream(file);
            BufferedReader buff = new BufferedReader(new InputStreamReader(in));
            while (buff.ready()) {
                String name = buff.readLine();
                if (!name.equalsIgnoreCase(player.getName())) continue;
                buff.close();
                in.close();
                return;
            }
            this.saveToISPLists(player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveToISPLists(SPlayer player) {
        try {
            FileOutputStream out = new FileOutputStream("./data/Providers/" + player.getLastISP() + ".prv", true);
            PrintStream p = new PrintStream(out);
            p.println(player.getName());
            p.close();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadOmniVariantMods() {
        try {
            File configFile = new File("./campaign/omnivariantmods.dat");
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                StringTokenizer line = new StringTokenizer(dis.readLine(), "#");
                cm.getOmniVariantMods().put(line.nextToken(), line.nextToken());
            }
            dis.close();
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setArchiving(boolean archive) {
        this.isArchiving = archive;
    }

    public boolean isArchiving() {
        return this.isArchiving;
    }

    public void saveConfigureFile(Properties config, String fileName) {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(fileName));
            ps.println("#Timestamp=" + System.currentTimeMillis());
            config.store(ps, "Server Config");
            ps.close();
        }
        catch (FileNotFoundException fe) {
            CampaignData.mwlog.errLog(fileName + " not found");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public UnitCosts getUnitCostLists() {
        return CampaignMain.cm.unitCostLists;
    }

    public Client getMegaMekClient() {
        return this.megaMekClient;
    }

    public void setMegaMekClient(Client mmClient) {
        CampaignMain.cm.megaMekClient = mmClient;
    }

    public RepairTrackingThread getRTT() {
        return this.RTT;
    }

    public int getTotalRepairCosts(Entity unit, Vector<Integer> techs, Vector<Integer> rolls, int pilotLevel, SHouse house) {
        Mounted mounted;
        CriticalSlot cs;
        int slot;
        int location;
        int location2;
        double cost = 0.0;
        double totalArmorCost = 0.0;
        double internalCost = 0.0;
        double systemsCost = 0.0;
        double equipmentCost = 0.0;
        double weaponsCost = 0.0;
        double engineCost = 0.0;
        int techType = techs.elementAt(1);
        int baseRoll = rolls.elementAt(1);
        double pointsToRepair = 0.0;
        double armorCost = SUnit.getArmorCost(unit);
        double techCost = 0.0;
        double techWorkMod = 0.0;
        if (techType != 4) {
            techCost = Integer.parseInt(cm.getConfig(UnitUtils.techDescription(techType) + "TechRepairCost"));
            techWorkMod = UnitUtils.getTechRoll(unit, 0, 13, techType, true, house.getTechLevel()) - baseRoll;
        } else {
            techType = pilotLevel;
        }
        techWorkMod = Math.max(techWorkMod, 0.0);
        for (location2 = 0; location2 < unit.locations(); ++location2) {
            if (unit.getArmor(location2) < unit.getOArmor(location2)) {
                totalArmorCost += armorCost * (pointsToRepair += (double)(unit.getOArmor(location2) - unit.getArmor(location2)));
                totalArmorCost += techCost * Math.abs(techWorkMod);
                totalArmorCost += techCost;
            }
            if (!unit.hasRearArmor(location2)) continue;
            totalArmorCost += armorCost * (pointsToRepair += (double)(unit.getOArmor(location2, true) - unit.getArmor(location2, true)));
            totalArmorCost += techCost * Math.abs(techWorkMod);
            totalArmorCost += techCost;
        }
        totalArmorCost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        totalArmorCost = Math.max(0.0, totalArmorCost);
        techType = techs.elementAt(2);
        baseRoll = rolls.elementAt(2);
        pointsToRepair = 0.0;
        armorCost = SUnit.getStructureCost(unit);
        techCost = 0.0;
        techWorkMod = 0.0;
        if (techType != 4) {
            techCost = Integer.parseInt(cm.getConfig(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        for (location2 = 0; location2 < unit.locations(); ++location2) {
            if (unit.getInternal(location2) >= unit.getOInternal(location2)) continue;
            if (techType != 4) {
                techWorkMod = UnitUtils.getTechRoll(unit, location2, 15, techType, true, house.getTechLevel()) - baseRoll;
            }
            techWorkMod = Math.max(techWorkMod, 0.0);
            pointsToRepair = unit.getOInternal(location2) - unit.getInternal(location2);
            internalCost += armorCost * pointsToRepair;
            internalCost += techCost * Math.abs(techWorkMod);
            internalCost += techCost;
        }
        internalCost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        internalCost = Math.max(0.0, internalCost);
        techType = techs.elementAt(5);
        baseRoll = rolls.elementAt(5);
        pointsToRepair = 0.0;
        double critCost = 0.0;
        techCost = 0.0;
        techWorkMod = 0.0;
        if (techType != 4) {
            techCost = Integer.parseInt(cm.getConfig(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        for (location = 0; location < unit.locations(); ++location) {
            for (slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                cs = unit.getCritical(location, slot);
                if (cs == null || !cs.isBreached() && !cs.isDamaged() || cs.getType() != 0 || cs.getIndex() == 3) continue;
                if (techType != 4) {
                    techWorkMod = UnitUtils.getTechRoll(unit, location, slot, techType, true, house.getTechLevel()) - baseRoll;
                }
                critCost = SUnit.getCritCost(unit, cs);
                techWorkMod = Math.max(techWorkMod, 0.0);
                pointsToRepair = UnitUtils.getNumberOfCrits(unit, cs);
                systemsCost += (critCost += techCost) * pointsToRepair;
                systemsCost += techCost * Math.abs(techWorkMod);
                systemsCost += techCost;
                slot = (int)((double)slot + (pointsToRepair - 1.0));
            }
        }
        systemsCost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        systemsCost = Math.max(0.0, systemsCost);
        techType = techs.elementAt(3);
        baseRoll = rolls.elementAt(3);
        pointsToRepair = 0.0;
        critCost = 0.0;
        techCost = 0.0;
        techWorkMod = 0.0;
        if (techType != 4) {
            techCost = Integer.parseInt(cm.getConfig(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        for (location = 0; location < unit.locations(); ++location) {
            for (slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                cs = unit.getCritical(location, slot);
                if (cs == null || !cs.isBreached() && !cs.isDamaged() || cs.getType() != 1 || !((mounted = unit.getEquipment(cs.getIndex())).getType() instanceof WeaponType)) continue;
                if (techType != 4) {
                    techWorkMod = UnitUtils.getTechRoll(unit, location, slot, techType, true, house.getTechLevel()) - baseRoll;
                }
                critCost = SUnit.getCritCost(unit, cs);
                techWorkMod = Math.max(techWorkMod, 0.0);
                pointsToRepair = UnitUtils.getNumberOfCrits(unit, cs);
                weaponsCost += (critCost += techCost) * pointsToRepair;
                weaponsCost += techCost * Math.abs(techWorkMod);
                weaponsCost += techCost;
                slot = (int)((double)slot + (pointsToRepair - 1.0));
            }
        }
        weaponsCost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        weaponsCost = Math.max(0.0, weaponsCost);
        techType = techs.elementAt(4);
        baseRoll = rolls.elementAt(4);
        pointsToRepair = 0.0;
        critCost = 0.0;
        techCost = 0.0;
        techWorkMod = 0.0;
        if (techType != 4) {
            techCost = Integer.parseInt(cm.getConfig(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        for (location = 0; location < unit.locations(); ++location) {
            for (slot = 0; slot < unit.getNumberOfCriticals(location); ++slot) {
                cs = unit.getCritical(location, slot);
                if (cs == null || !cs.isBreached() && !cs.isDamaged() || cs.getType() != 1 || (mounted = unit.getEquipment(cs.getIndex())).getType() instanceof WeaponType) continue;
                if (techType != 4) {
                    techWorkMod = UnitUtils.getTechRoll(unit, location, slot, techType, true, house.getTechLevel()) - baseRoll;
                }
                critCost = SUnit.getCritCost(unit, cs);
                techWorkMod = Math.max(techWorkMod, 0.0);
                pointsToRepair = UnitUtils.getNumberOfCrits(unit, cs);
                equipmentCost += (critCost += techCost) * pointsToRepair;
                equipmentCost += techCost * Math.abs(techWorkMod);
                equipmentCost += techCost;
                slot = (int)((double)slot + (pointsToRepair - 1.0));
            }
        }
        equipmentCost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        equipmentCost = Math.max(0.0, equipmentCost);
        techType = techs.elementAt(6);
        baseRoll = rolls.elementAt(6);
        pointsToRepair = 0.0;
        critCost = 0.0;
        techCost = 0.0;
        techWorkMod = 0.0;
        boolean found = false;
        int location3 = 0;
        int slot2 = 0;
        CriticalSlot cs2 = null;
        if (techType != 4) {
            techCost = Integer.parseInt(cm.getConfig(UnitUtils.techDescription(techType) + "TechRepairCost"));
        }
        for (int x = 1; x <= 3; ++x) {
            for (int y = 0; y < unit.getNumberOfCriticals(x); ++y) {
                cs2 = unit.getCritical(x, y);
                if (cs2 == null || !cs2.isDamaged() && !cs2.isBreached() || !UnitUtils.isEngineCrit(cs2)) continue;
                location3 = x;
                slot2 = y;
                found = true;
                break;
            }
            if (found) break;
        }
        if (techType != 4) {
            techWorkMod = UnitUtils.getTechRoll(unit, location3, slot2, techType, true, house.getTechLevel()) - baseRoll;
        }
        critCost = SUnit.getCritCost(unit, cs2);
        techWorkMod = Math.max(techWorkMod, 0.0);
        pointsToRepair = UnitUtils.getNumberOfCrits(unit, cs2);
        engineCost += (critCost += techCost) * pointsToRepair;
        engineCost += techCost * Math.abs(techWorkMod);
        engineCost += techCost;
        engineCost *= this.payOutIncreaseBasedOnRoll(baseRoll);
        engineCost = Math.max(0.0, engineCost);
        if (!found) {
            engineCost = 0.0;
        }
        cost = totalArmorCost + engineCost + systemsCost + internalCost + weaponsCost + equipmentCost;
        return (int)cost;
    }

    private double payOutIncreaseBasedOnRoll(int roll) {
        if (roll <= 2) {
            return 1.0;
        }
        if (roll > 12) {
            return 36.0;
        }
        double[] payout = new double[]{1.0, 1.0, 1.0, 1.03, 1.09, 1.2, 1.38, 1.72, 2.4, 3.6, 5.92, 12.0, 36.0};
        return payout[roll];
    }

    public int getRepairCost(Entity unit, int critLocation, int critSlot, int techType, boolean armor, int techWorkMod) {
        return this.getRepairCost(unit, critLocation, critSlot, techType, armor, techWorkMod, false);
    }

    public int getRepairCost(Entity unit, int critLocation, int critSlot, int techType, boolean armor, int techWorkMod, boolean salvage) {
        double totalCost = 1.0;
        double techCost = 0.0;
        double cost = 1.0;
        int totalCrits = 1;
        if (techType < 4) {
            techCost = cm.getIntegerConfig(UnitUtils.techDescription(techType) + "TechRepairCost");
        }
        if (Boolean.parseBoolean(cm.getConfig("UseRealRepairCosts"))) {
            double costMod;
            double realCost = UnitUtils.getPartCost(unit, critLocation, critSlot, armor);
            if (Boolean.parseBoolean(cm.getConfig("UsePartsRepair"))) {
                realCost = 0.0;
            }
            if ((costMod = Double.parseDouble(cm.getConfig("RealRepairCostMod"))) > 0.0) {
                realCost *= costMod;
            }
            cost += techCost * (double)Math.abs(techWorkMod) + techCost;
        } else if (armor) {
            if (critSlot == 13) {
                cost = SUnit.getArmorCost(unit);
                if (unit.getArmor(critLocation) > unit.getOArmor(critLocation)) {
                    UnitUtils.removeArmorRepair(unit, 13, critLocation);
                    cost *= (double)(unit.getOArmor(critLocation) - unit.getArmor(critLocation));
                    UnitUtils.setArmorRepair(unit, 13, critLocation);
                } else {
                    cost *= (double)(unit.getOArmor(critLocation) - unit.getArmor(critLocation));
                }
                cost += techCost * (double)Math.abs(techWorkMod);
                cost += techCost;
                cost = Math.max(1.0, cost);
            } else if (critSlot == 14) {
                cost = SUnit.getArmorCost(unit);
                if (critLocation >= 8) {
                    critLocation -= 7;
                }
                if (unit.getArmor(critLocation, true) > unit.getOArmor(critLocation, true)) {
                    UnitUtils.removeArmorRepair(unit, 14, critLocation);
                    cost *= (double)(unit.getOArmor(critLocation, true) - unit.getArmor(critLocation, true));
                    UnitUtils.setArmorRepair(unit, 14, critLocation);
                } else {
                    cost *= (double)(unit.getOArmor(critLocation, true) - unit.getArmor(critLocation, true));
                }
                cost += techCost * (double)Math.abs(techWorkMod);
                cost += techCost;
                cost = Math.max(1.0, cost);
            } else {
                cost = SUnit.getStructureCost(unit);
                if (unit.getInternal(critLocation) > unit.getOInternal(critLocation)) {
                    UnitUtils.removeArmorRepair(unit, 15, critLocation);
                    cost *= (double)(unit.getOInternal(critLocation) - unit.getInternal(critLocation));
                    UnitUtils.setArmorRepair(unit, 15, critLocation);
                } else {
                    cost *= (double)(unit.getOInternal(critLocation) - unit.getInternal(critLocation));
                }
                cost += techCost * (double)Math.abs(techWorkMod);
                cost += techCost;
                cost = Math.max(1.0, cost);
            }
        } else {
            CriticalSlot cs = unit.getCritical(critLocation, critSlot);
            totalCrits = salvage ? UnitUtils.getNumberOfCrits(unit, cs) - UnitUtils.getNumberOfDamagedCrits(unit, critSlot, critLocation, armor) : UnitUtils.getNumberOfDamagedCrits(unit, critSlot, critLocation, armor);
            cost = SUnit.getCritCost(unit, cs);
            totalCost = (int)((double)totalCrits * cost);
            totalCost += (double)((int)((double)totalCrits * techCost));
            totalCost += techCost;
            cost = Math.max(1.0, totalCost += techCost * (double)Math.abs(techWorkMod));
        }
        if (Boolean.parseBoolean(cm.getConfig("AllowCritRepairsForRewards")) && techType == 5) {
            cost = (double)totalCrits * Double.parseDouble(cm.getConfig("RewardPointsForCritRepair"));
            cost = Math.max(Math.ceil(cost), 1.0);
        }
        return (int)cost;
    }

    public void saveBannedAmmo() {
        try {
            FileOutputStream out = new FileOutputStream("./campaign/banammo.dat");
            PrintStream p = new PrintStream(out);
            p.println(System.currentTimeMillis());
            p.print("server#");
            for (String ammo : cm.getServerBannedAmmo().keySet()) {
                p.print(ammo);
                p.print("#");
            }
            p.println();
            for (House currH : this.data.getAllHouses()) {
                SHouse h = (SHouse)currH;
                if (h.getBannedAmmo().size() < 1) continue;
                p.print(h.getName() + "#");
                for (String ammo : h.getBannedAmmo().keySet()) {
                    p.print(ammo);
                    p.print("#");
                }
                p.println();
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error saving banned ammo.");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void loadBannedTargetingSystems() {
        try {
            File configFile = new File("./campaign/bantargeting.dat");
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            dis.readLine();
            StringTokenizer st = new StringTokenizer(dis.readLine(), "#");
            while (st.hasMoreTokens()) {
                cm.getData().getBannedTargetingSystems().put(Integer.parseInt(st.nextToken()), "Banned");
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            this.saveBannedTargetingSystems();
        }
    }

    public void saveBannedTargetingSystems() {
        try {
            FileOutputStream out = new FileOutputStream("./campaign/bantargeting.dat");
            PrintStream p = new PrintStream(out);
            p.println(System.currentTimeMillis());
            for (Integer targetingSytem : cm.getData().getBannedTargetingSystems().keySet()) {
                p.print(targetingSytem);
                p.print("#");
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error saving banned targetting systems.");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void loadPlanetOpFlags() {
        File configFile = new File("./campaign/planetOpFlags.dat");
        if (!configFile.exists()) {
            CampaignData.mwlog.errLog("No planetOpFlags.dat. Skipping.");
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            dis.readLine();
            String nextLine = dis.readLine();
            if (nextLine == null) {
                CampaignData.mwlog.errLog("Timestamp-only planetOpFlags.dat. Skipping.");
                return;
            }
            StringTokenizer st = new StringTokenizer(nextLine, "#");
            while (st.hasMoreTokens()) {
                this.data.getPlanetOpFlags().put(st.nextToken(), st.nextToken());
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error loading Planet Op Flags.");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void savePlanetOpFlags() {
        try {
            FileOutputStream out = new FileOutputStream("./campaign/planetOpFlags.dat");
            PrintStream p = new PrintStream(out);
            p.println(System.currentTimeMillis());
            for (String key : cm.getData().getPlanetOpFlags().keySet()) {
                p.print(key);
                p.print("#");
                p.print(cm.getData().getPlanetOpFlags().get(key));
                p.print("#");
            }
            p.close();
            out.close();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error saving Planet Op Flags.");
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void loadFactionData() {
        if (cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.loadFactions(this.data);
            return;
        }
        File factionFile = new File("./campaign/factions");
        if (!factionFile.exists() || factionFile.listFiles().length < 1) {
            CampaignData.mwlog.errLog("Unable to find and load faction data");
            CampaignData.mwlog.errLog("Going to create from XML");
            return;
        }
        datFileFilter filter = new datFileFilter();
        File[] factionFileList = factionFile.listFiles(filter);
        for (int pos = 0; pos < factionFileList.length; ++pos) {
            try {
                SHouse h;
                File faction = factionFileList[pos];
                FileInputStream fis = new FileInputStream(faction);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                String line = dis.readLine();
                if (line.startsWith("[N][C]")) {
                    line = line.substring(6);
                    h = new NewbieHouse(this.data.getUnusedHouseID());
                } else if (line.startsWith("[N]")) {
                    line = line.substring(3);
                    h = new NewbieHouse(this.data.getUnusedHouseID());
                } else if (line.startsWith("[M]")) {
                    line = line.substring(3);
                    h = new MercHouse(this.data.getUnusedHouseID());
                } else {
                    h = new SHouse(this.data.getUnusedHouseID());
                }
                h.fromString(line, this.r);
                if (this.isUsingIncreasedTechs()) {
                    h.addCommonUnitSupport();
                }
                this.addHouse(h);
                dis.close();
                fis.close();
                continue;
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog("Unable to load " + factionFileList[pos].getName());
            }
        }
        if (this.data.getHouse(-1) == null) {
            MercHouse none = new MercHouse();
            none.createNoneHouse();
            this.addHouse(none);
        }
        if (!(factionFile = new File("./campaign/costmodifiers")).exists()) {
            return;
        }
        for (House currH : this.data.getAllHouses()) {
            String saveName = currH.getName().toLowerCase().trim() + ".dat";
            File faction = new File("./campaign/costmodifiers/" + saveName);
            if (!faction.exists()) continue;
            try {
                FileInputStream fis = new FileInputStream(faction);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                String currLine = null;
                while ((currLine = dis.readLine()) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(currLine, "$");
                    String cost = tokenizer.nextToken();
                    int type = Integer.parseInt(tokenizer.nextToken());
                    int weight = Integer.parseInt(tokenizer.nextToken());
                    int mod = Integer.parseInt(tokenizer.nextToken());
                    if (cost.equals("Price")) {
                        currH.setHouseUnitPriceMod(type, weight, mod);
                        continue;
                    }
                    if (cost.equals("Flu")) {
                        currH.setHouseUnitFluMod(type, weight, mod);
                        continue;
                    }
                    if (!cost.equals("Comp")) continue;
                    currH.setHouseUnitComponentMod(type, weight, mod);
                }
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog("Unable to load cost modifiers for " + currH.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFactionData() {
        if (cm.isUsingMySQL()) {
            for (House currH : this.data.getAllHouses()) {
                SHouse h = (SHouse)currH;
                h.toDB();
            }
            return;
        }
        File factionFile = new File("./campaign/factions");
        if (!factionFile.exists()) {
            factionFile.mkdir();
            if (this.isUsingIncreasedTechs()) {
                File supportFile = new File("./campaign/factions/support");
                supportFile.mkdir();
            }
        }
        if (!(factionFile = new File("./campaign/costmodifiers")).exists()) {
            factionFile.mkdir();
        }
        Collection<House> collection = this.data.getAllHouses();
        synchronized (collection) {
            for (House currH : this.data.getAllHouses()) {
                SHouse h = (SHouse)currH;
                String saveName = h.getName().toLowerCase().trim() + ".dat";
                String backupName = h.getName().toLowerCase().trim() + ".bak";
                try {
                    File faction = new File("./campaign/factions/" + saveName);
                    if (faction.exists()) {
                        File backupFile = new File("./campaign/factions/" + backupName);
                        if (backupFile.exists()) {
                            backupFile.delete();
                        }
                        faction.renameTo(backupFile);
                    }
                    FileOutputStream out = new FileOutputStream(faction);
                    PrintStream p = new PrintStream(out);
                    p.println(h.toString());
                    try {
                        File factionCostMod = new File("./campaign/costmodifiers/" + saveName);
                        if (factionCostMod.exists()) {
                            File backupFile = new File("./campaign/costmodifiers/" + backupName);
                            if (backupFile.exists()) {
                                backupFile.delete();
                            }
                            factionCostMod.renameTo(backupFile);
                        }
                        FileOutputStream costModout = new FileOutputStream(factionCostMod);
                        PrintStream costModp = new PrintStream(costModout);
                        for (int type = 0; type < 5; ++type) {
                            for (int weight = 0; weight < 4; ++weight) {
                                if (h.getHouseUnitPriceMod(type, weight) != 0) {
                                    costModp.println("Price$" + type + "$" + weight + "$" + h.getHouseUnitPriceMod(type, weight));
                                }
                                if (h.getHouseUnitFluMod(type, weight) != 0) {
                                    costModp.println("Flu$" + type + "$" + weight + "$" + h.getHouseUnitFluMod(type, weight));
                                }
                                if (h.getHouseUnitComponentMod(type, weight) == 0) continue;
                                costModp.println("Comp$" + type + "$" + weight + "$" + h.getHouseUnitComponentMod(type, weight));
                            }
                        }
                        costModp.close();
                        costModout.close();
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog("Unable to save Faction: " + saveName + " cost Mods");
                        CampaignData.mwlog.errLog(ex);
                    }
                    p.close();
                    out.close();
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Unable to save Faction: " + saveName);
                    CampaignData.mwlog.errLog(ex);
                }
            }
        }
    }

    public void loadPlanetData() {
        this.loadPlanetOpFlags();
        File planetFile = new File("./campaign/planets");
        datFileFilter filter = new datFileFilter();
        if (!(cm.isUsingMySQL() || planetFile.exists() && planetFile.listFiles(filter).length != 0)) {
            CampaignData.mwlog.errLog("Unable to find and load /planets, or /planets is empty.");
            CampaignData.mwlog.errLog("Planets will be read from XML during init().");
            return;
        }
        if (cm.isUsingMySQL() && CampaignMain.cm.MySQL.countPlanets() == 0) {
            CampaignData.mwlog.errLog("Empty planet database.");
            CampaignData.mwlog.errLog("Planets will be read from XML during init().");
            return;
        }
        if (cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.loadPlanets(this.data);
        } else {
            File[] planetFileList = planetFile.listFiles(filter);
            for (int pos = 0; pos < planetFileList.length; ++pos) {
                try {
                    File planet = planetFileList[pos];
                    FileInputStream fis = new FileInputStream(planet);
                    BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                    String line = dis.readLine();
                    if (line.startsWith("[N]")) {
                        line = line.substring(3);
                    }
                    SPlanet p = new SPlanet();
                    p.fromString(line, this.r, this.data);
                    this.addPlanet(p);
                    dis.close();
                    fis.close();
                    continue;
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog("Unable to load " + planetFileList[pos].getName());
                    CampaignData.mwlog.errLog(ex);
                }
            }
        }
    }

    private void loadMechStatsFromDB() {
        try {
            Statement stmt = this.MySQL.getStatement();
            ResultSet rs = stmt.executeQuery("SELECT ID from mechstats ORDER BY ID");
            while (rs.next()) {
                MechStatistics m = new MechStatistics(rs.getInt("ID"));
                this.MechStats.put(m.getMechFileName(), m);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in UnitHandler.loadMechStats: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void updatePlayersAccessLevel(String playerName, int accessLevel) {
        SPlayer player = cm.getPlayer(playerName);
        if (player == null) {
            return;
        }
        try {
            cm.getServer().getClient(playerName).setAccessLevel(accessLevel);
            cm.getServer().getUser(playerName).setLevel(accessLevel);
            cm.getServer().sendRemoveUserToAll(playerName, false);
            cm.getServer().sendNewUserToAll(playerName, false);
            MWPasswd.writeRecord(player.getPassword(), playerName);
            cm.doSendToAllOnlinePlayers("PI|DA|" + cm.getPlayerUpdateString(player), false);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.forceSavePlayer(player);
    }

    public void releaseLostSoul(String soul) {
        this.lostSouls.remove(soul.toLowerCase());
    }

    public Date getHousePlanetUpdate() {
        return this.housePlanetDate;
    }

    public void updateHousePlanetUpdate() {
        this.housePlanetDate = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePlanetData() {
        if (cm.isUsingMySQL()) {
            for (Planet currP : this.data.getAllPlanets()) {
                SPlanet p = (SPlanet)currP;
                p.toDB();
            }
        } else {
            this.savePlanetOpFlags();
            File planetFile = new File("./campaign/planets");
            if (!planetFile.exists()) {
                planetFile.mkdir();
            }
            Collection<Planet> collection = this.data.getAllPlanets();
            synchronized (collection) {
                for (Planet currP : this.data.getAllPlanets()) {
                    SPlanet p = (SPlanet)currP;
                    String saveName = p.getName().toLowerCase().trim() + ".dat";
                    String backupName = p.getName().toLowerCase().trim() + ".bak";
                    try {
                        File planet = new File("./campaign/planets/" + saveName);
                        if (planet.exists()) {
                            File backupFile = new File("./campaign/planets/" + backupName);
                            if (backupFile.exists()) {
                                backupFile.delete();
                            }
                            planet.renameTo(backupFile);
                        }
                        FileOutputStream out = new FileOutputStream("./campaign/planets/" + saveName);
                        PrintStream ps = new PrintStream(out);
                        ps.println(p.toString());
                        ps.close();
                        out.close();
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.errLog("Unable to save planet: " + saveName);
                        CampaignData.mwlog.errLog(ex);
                    }
                }
            }
        }
    }

    public String getMegaMekOptionsToString() {
        StringBuffer result = new StringBuffer();
        Enumeration<IOption> options = CampaignMain.cm.getMegaMekClient().game.getOptions().getOptions();
        while (options.hasMoreElements()) {
            IOption option = options.nextElement();
            result.append(option.getName()).append("|").append(option.getValue()).append("|");
        }
        return result.toString();
    }

    class datFileFilter
    implements FilenameFilter {
        datFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".dat");
        }
    }
}

