/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import java.util.ArrayList;
import java.util.TreeMap;
import server.campaign.CampaignMain;
import server.campaign.NewbieHouse;
import server.campaign.SPlayer;
import server.campaign.util.OpponentListHelper;

public final class ImmunityThread
extends Thread {
    private TreeMap<String, Long> immunePlayers = new TreeMap();

    public ImmunityThread() {
        super("Immunity Thread");
    }

    public void extendedWait(int time) {
        try {
            this.wait(time);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImmunePlayer(SPlayer p) {
        int numResets;
        String lowername = p.getName().toLowerCase();
        int immunitySeconds = CampaignMain.cm.getIntegerConfig("ImmunityTime");
        if (immunitySeconds < 1) {
            return;
        }
        CampaignMain.cm.toUser("You are immune to attack for " + immunitySeconds + " seconds. [<a href=\"MEKWARS/c deactivate\">Deactivate</a>]", p.getName(), true);
        if (p.getMyHouse().isNewbieHouse() && (numResets = CampaignMain.cm.getIntegerConfig("NumResetsWhileImmune")) > 0) {
            NewbieHouse pHouse = (NewbieHouse)p.getMyHouse();
            pHouse.addResetPlayer(p, numResets);
            String toSend = "You may reset your units ";
            toSend = numResets == 1 ? toSend + " once" : toSend + numResets + " times";
            toSend = toSend + " while immune by selecting \"Reset Units\" in the HQ. You may only reset while in reserve.";
            CampaignMain.cm.toUser(toSend, p.getName(), true);
        }
        TreeMap<String, Long> treeMap = this.immunePlayers;
        synchronized (treeMap) {
            this.immunePlayers.put(lowername, System.currentTimeMillis() + (long)(immunitySeconds * 1000));
        }
    }

    public boolean isImmune(SPlayer p) {
        return this.immunePlayers.containsKey(p.getName().toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImmunity(SPlayer p) {
        TreeMap<String, Long> treeMap = this.immunePlayers;
        synchronized (treeMap) {
            this.immunePlayers.remove(p.getName().toLowerCase());
        }
        if (p.getMyHouse().isNewbieHouse()) {
            NewbieHouse pHouse = (NewbieHouse)p.getMyHouse();
            pHouse.removeResetPlayer(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            this.extendedWait(5000);
            TreeMap<String, Long> treeMap = this.immunePlayers;
            synchronized (treeMap) {
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String currName : this.immunePlayers.keySet()) {
                    Long startTime = System.currentTimeMillis();
                    if (startTime < this.immunePlayers.get(currName)) continue;
                    toRemove.add(currName);
                }
                for (String currName : toRemove) {
                    TreeMap<String, Long> treeMap2;
                    SPlayer p = CampaignMain.cm.getPlayer(currName);
                    if (p == null) {
                        treeMap2 = this.immunePlayers;
                        synchronized (treeMap2) {
                            this.immunePlayers.remove(currName);
                            continue;
                        }
                    }
                    if (p.getDutyStatus() == 3) {
                        CampaignMain.cm.toUser("[!] Your post-game immunity expired!", p.getName(), true);
                        OpponentListHelper olh = new OpponentListHelper(p, 0);
                        olh.sendInfoToOpponents(" finished an R&R cycle and returned to the front. You may attack it with ");
                        if (p.getMyHouse().isNewbieHouse()) {
                            NewbieHouse currH = (NewbieHouse)p.getMyHouse();
                            if (currH.getResetsRemaining(p) > 0) {
                                CampaignMain.cm.toUser("[!] Your post-game reset time expired!", p.getName(), true);
                            }
                            currH.removeResetPlayer(p);
                        }
                    }
                    treeMap2 = this.immunePlayers;
                    synchronized (treeMap2) {
                        this.immunePlayers.remove(currName);
                    }
                }
            }
        }
    }
}

