/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.Unit;
import java.util.TreeMap;
import java.util.Vector;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.NonConqHouse;
import server.campaign.SPlayer;
import server.campaign.SUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewbieHouse
extends NonConqHouse {
    private static final long serialVersionUID = -6530126180469336846L;
    TreeMap<String, Integer> resetPlayers = new TreeMap();

    public NewbieHouse() {
    }

    public NewbieHouse(int id, String name, String HouseColor, int BaseGunner, int BasePilot, String abbreviation) {
        super(id, name, HouseColor, BaseGunner, BasePilot, abbreviation);
    }

    public NewbieHouse(int id) {
        super(id);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[N]");
        result.append(super.toString());
        return result.toString();
    }

    @Override
    public int getBaysProvided() {
        int newbBays = CampaignMain.cm.getIntegerConfig("NewbieHouseBays");
        return newbBays;
    }

    public String cleanupHangarAndPP() {
        for (int type = 0; type < 3; ++type) {
            for (int size = 0; size < 4; ++size) {
                Vector<SUnit> Weightclass = this.getHangar(type).elementAt(size);
                Weightclass.clear();
            }
        }
        return "";
    }

    @Override
    public SUnit getEntity(int weightclass, int type_id) {
        SUnit m = super.getEntity(weightclass, type_id);
        if (m == null) {
            m = this.getRandomUnit(type_id, weightclass, null).firstElement();
        }
        return m;
    }

    public void setPP(int weight, int val) {
    }

    public String potentialHouseProduction() {
        return "";
    }

    @Override
    public int getMoney() {
        return 0;
    }

    @Override
    public int getPP(int weight, int type_id) {
        return 1 * this.getPPCost(weight, type_id);
    }

    public Vector<SUnit> getRandomUnit(int unitType, int weightClass, String houseName) {
        String factionName = houseName == null ? CampaignMain.cm.getConfig("NewbieHouseName") : houseName;
        String unitFilename = BuildTable.getUnitFilename(factionName, Unit.getWeightClassDesc(weightClass), unitType, "standard");
        Vector<SUnit> newbieUnits = new Vector<SUnit>(1, 1);
        if (unitFilename.toLowerCase().trim().endsWith(".mul")) {
            newbieUnits.addAll(SUnit.createMULUnits(unitFilename, "Training Unit"));
        } else {
            SUnit newbieUnit = new SUnit(factionName, unitFilename, weightClass);
            newbieUnit.setProducer("Training Unit");
            newbieUnits.add(newbieUnit);
        }
        return newbieUnits;
    }

    public String requestNewMech(SPlayer p, boolean forceReset, String houseName) {
        if (p.getDutyStatus() == 4) {
            return "You may not request new units while playing a game.";
        }
        if (p.getDutyStatus() == 3) {
            return "You may not request new units while on active duty.";
        }
        String lowerName = p.getName().toLowerCase();
        String toSend = "Your units were reset";
        int replace = CampaignMain.cm.getIntegerConfig("NumUnitsToQualifyForNew");
        if (forceReset) {
            replace = 999999;
        }
        if (this.resetPlayers.containsKey(lowerName) && this.resetPlayers.get(lowerName) > 0) {
            replace = 999999;
            int remainingResets = this.resetPlayers.get(lowerName) - 1;
            toSend = toSend + " (" + remainingResets + " post-game resets remaining).";
            this.resetPlayers.put(lowerName, remainingResets);
        } else {
            toSend = toSend + ".";
        }
        if (p.getUnits().size() > replace) {
            return "You already have enough units.";
        }
        p.stripOfAllUnits(false);
        if (CampaignMain.cm.getBooleanConfig("AllowPersonalPilotQueues")) {
            p.getPersonalPilotQueue().flushQueue();
            CampaignMain.cm.toUser("PL|PPQ|" + p.getPersonalPilotQueue().toString(true), p.getName(), false);
        }
        this.getNewSOLUnits(p, houseName);
        if (!forceReset) {
            CampaignMain.cm.toUser("PS|" + p.toString(true), p.getName(), false);
        }
        return toSend;
    }

    public void addResetPlayer(SPlayer p, Integer numResets) {
        this.resetPlayers.put(p.getName().toLowerCase(), numResets);
    }

    public void removeResetPlayer(SPlayer p) {
        this.resetPlayers.remove(p.getName().toLowerCase());
    }

    public int getResetsRemaining(SPlayer p) {
        return this.resetPlayers.get(p.getName().toLowerCase());
    }

    @Override
    public void removePlayer(SPlayer p, boolean donateMechs) {
        super.removePlayer(p, donateMechs);
        this.removeResetPlayer(p);
    }

    @Override
    public boolean isNewbieHouse() {
        return true;
    }

    public String getNewSOLUnits(SPlayer p, String houseName) {
        int i;
        Vector<SUnit> units = new Vector<SUnit>(1, 1);
        int numLMeks = CampaignMain.cm.getIntegerConfig("SOLLightMeks");
        int numMMeks = CampaignMain.cm.getIntegerConfig("SOLMediumMeks");
        int numHMeks = CampaignMain.cm.getIntegerConfig("SOLHeavyMeks");
        int numAMeks = CampaignMain.cm.getIntegerConfig("SOLAssaultMeks");
        int numLVehs = CampaignMain.cm.getIntegerConfig("SOLLightVehs");
        int numMVehs = CampaignMain.cm.getIntegerConfig("SOLMediumVehs");
        int numHVehs = CampaignMain.cm.getIntegerConfig("SOLHeavyVehs");
        int numAVehs = CampaignMain.cm.getIntegerConfig("SOLAssaultVehs");
        int numLInf = CampaignMain.cm.getIntegerConfig("SOLLightInf");
        int numMInf = CampaignMain.cm.getIntegerConfig("SOLMediumInf");
        int numHInf = CampaignMain.cm.getIntegerConfig("SOLHeavyInf");
        int numAInf = CampaignMain.cm.getIntegerConfig("SOLAssaultInf");
        int numLPM = CampaignMain.cm.getIntegerConfig("SOLLightProtoMek");
        int numMPM = CampaignMain.cm.getIntegerConfig("SOLMediumProtoMek");
        int numHPM = CampaignMain.cm.getIntegerConfig("SOLHeavyProtoMek");
        int numAPM = CampaignMain.cm.getIntegerConfig("SOLAssaultProtoMek");
        int numLBA = CampaignMain.cm.getIntegerConfig("SOLLightBattleArmor");
        int numMBA = CampaignMain.cm.getIntegerConfig("SOLMediumBattleArmor");
        int numHBA = CampaignMain.cm.getIntegerConfig("SOLHeavyBattleArmor");
        int numABA = CampaignMain.cm.getIntegerConfig("SOLAssaultBattleArmor");
        int numLAero = CampaignMain.cm.getIntegerConfig("SOLLightAero");
        int numMAero = CampaignMain.cm.getIntegerConfig("SOLMediumAero");
        int numHAero = CampaignMain.cm.getIntegerConfig("SOLHeavyAero");
        int numAAero = CampaignMain.cm.getIntegerConfig("SOLAssaultAero");
        for (i = 0; i < numLMeks; ++i) {
            units.addAll(this.getRandomUnit(0, 0, houseName));
        }
        for (i = 0; i < numMMeks; ++i) {
            units.addAll(this.getRandomUnit(0, 1, houseName));
        }
        for (i = 0; i < numHMeks; ++i) {
            units.addAll(this.getRandomUnit(0, 2, houseName));
        }
        for (i = 0; i < numAMeks; ++i) {
            units.addAll(this.getRandomUnit(0, 3, houseName));
        }
        for (i = 0; i < numLVehs; ++i) {
            units.addAll(this.getRandomUnit(1, 0, houseName));
        }
        for (i = 0; i < numMVehs; ++i) {
            units.addAll(this.getRandomUnit(1, 1, houseName));
        }
        for (i = 0; i < numHVehs; ++i) {
            units.addAll(this.getRandomUnit(1, 2, houseName));
        }
        for (i = 0; i < numAVehs; ++i) {
            units.addAll(this.getRandomUnit(1, 3, houseName));
        }
        for (i = 0; i < numLInf; ++i) {
            units.addAll(this.getRandomUnit(2, 0, houseName));
        }
        for (i = 0; i < numMInf; ++i) {
            units.addAll(this.getRandomUnit(2, 1, houseName));
        }
        for (i = 0; i < numHInf; ++i) {
            units.addAll(this.getRandomUnit(2, 2, houseName));
        }
        for (i = 0; i < numAInf; ++i) {
            units.addAll(this.getRandomUnit(2, 3, houseName));
        }
        for (i = 0; i < numLPM; ++i) {
            units.addAll(this.getRandomUnit(3, 0, houseName));
        }
        for (i = 0; i < numMPM; ++i) {
            units.addAll(this.getRandomUnit(3, 1, houseName));
        }
        for (i = 0; i < numHPM; ++i) {
            units.addAll(this.getRandomUnit(3, 2, houseName));
        }
        for (i = 0; i < numAPM; ++i) {
            units.addAll(this.getRandomUnit(3, 3, houseName));
        }
        for (i = 0; i < numLBA; ++i) {
            units.addAll(this.getRandomUnit(4, 0, houseName));
        }
        for (i = 0; i < numMBA; ++i) {
            units.addAll(this.getRandomUnit(4, 1, houseName));
        }
        for (i = 0; i < numHBA; ++i) {
            units.addAll(this.getRandomUnit(4, 2, houseName));
        }
        for (i = 0; i < numABA; ++i) {
            units.addAll(this.getRandomUnit(4, 3, houseName));
        }
        for (i = 0; i < numLAero; ++i) {
            units.addAll(this.getRandomUnit(5, 0, houseName));
        }
        for (i = 0; i < numMAero; ++i) {
            units.addAll(this.getRandomUnit(5, 1, houseName));
        }
        for (i = 0; i < numHAero; ++i) {
            units.addAll(this.getRandomUnit(5, 2, houseName));
        }
        for (i = 0; i < numAAero; ++i) {
            units.addAll(this.getRandomUnit(5, 3, houseName));
        }
        StringBuilder toReturn = new StringBuilder();
        for (SUnit currUnit : units) {
            p.addUnit(currUnit, true, false);
            toReturn.append(currUnit.getVerboseModelName());
            toReturn.append(", ");
        }
        if (units.size() > 0) {
            toReturn.delete(toReturn.length() - 2, toReturn.length());
        }
        return toReturn.toString();
    }
}

