/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import common.campaign.pilot.skills.PilotSkill;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.TraitSkill;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PilotQueues {
    private Vector<LinkedList<SPilot>> queues = new Vector(6, 1);
    private Vector<Integer> baseGunnery = new Vector(6, 1);
    private Vector<Integer> basePiloting = new Vector(6, 1);
    private Vector<String> basePilotSkills = new Vector(6, 1);
    private String factionString = "";
    private int factionID;

    public PilotQueues(Vector<Integer> baseGunnery, Vector<Integer> basePiloting, Vector<String> basePilotSkill) {
        for (int i = 0; i < 6; ++i) {
            LinkedList v = new LinkedList();
            this.queues.add(i, v);
        }
        this.baseGunnery = baseGunnery;
        this.basePiloting = basePiloting;
        this.basePilotSkills = basePilotSkill;
        this.factionString = "";
    }

    public PilotQueues() {
    }

    public void addPilot(int type, SPilot p, boolean skipSkillChange) {
        if (p.getName().equalsIgnoreCase("Vacant")) {
            p = null;
            return;
        }
        p.setCurrentFaction(this.factionString);
        if (p.getSkills().has(12) && !p.getWeapon().equals("Default")) {
            Iterator<PilotSkill> ski = p.getSkills().getSkillIterator();
            while (ski.hasNext()) {
                SPilotSkill skill = (SPilotSkill)ski.next();
                if (!skill.getName().equals("Weapon Specialist")) continue;
                p.getSkills().remove(skill);
                break;
            }
        }
        if (!skipSkillChange) {
            this.addPilot(type, p);
        } else {
            this.queues.get(type).addLast(p);
            if (CampaignMain.cm.isUsingMySQL() && !p.getName().equalsIgnoreCase("Vacant")) {
                p.toDB(type, -1);
            }
        }
    }

    public void addPilot(int type, SPilot p) {
        if (p.getName().equalsIgnoreCase("Vacant")) {
            p = null;
            return;
        }
        p.setCurrentFaction(this.factionString);
        if (p.getSkills().has(12) && !p.getWeapon().equals("Default")) {
            Iterator<PilotSkill> ski = p.getSkills().getSkillIterator();
            while (ski.hasNext()) {
                SPilotSkill skill = (SPilotSkill)ski.next();
                if (!skill.getName().equals("Weapon Specialist")) continue;
                p.getSkills().remove(skill);
                break;
            }
        }
        if (CampaignMain.cm.getBooleanConfig("ReduceSkillsInQue")) {
            int rnd = CampaignMain.cm.getRandomNumber(100);
            if (rnd >= CampaignMain.cm.getIntegerConfig("ClearXPInQue")) {
                p.setExperience(0);
            }
            boolean gunnerAdjust = false;
            boolean pilotAdjust = false;
            if (p.getGunnery() < this.getBaseGunnery(type)) {
                gunnerAdjust = true;
            }
            if (p.getPiloting() < this.getBasePiloting(type)) {
                pilotAdjust = true;
            }
            if (!gunnerAdjust && !pilotAdjust) {
                int i;
                if (p.getGunnery() > this.getBaseGunnery(type)) {
                    int i2 = CampaignMain.cm.getRandomNumber(100);
                    if (i2 >= 50) {
                        p.setGunnery(this.getBaseGunnery(type));
                    }
                } else if (p.getPiloting() > this.getBasePiloting(type) && (i = CampaignMain.cm.getRandomNumber(100)) >= 50) {
                    p.setPiloting(this.getBasePiloting(type));
                }
            } else if (gunnerAdjust && !pilotAdjust) {
                p.setGunnery(p.getGunnery() + 1);
            } else if (!gunnerAdjust && pilotAdjust) {
                if (p.getPiloting() < this.getBasePiloting(type) - 1 && p.getGunnery() > this.getBaseGunnery(type)) {
                    p.setGunnery(this.getBaseGunnery(type));
                    p.setPiloting(this.getBasePiloting(type));
                } else {
                    p.setPiloting(p.getPiloting() + 1);
                }
            } else if (gunnerAdjust && pilotAdjust) {
                if (p.getGunnery() + 1 == p.getPiloting()) {
                    int i = CampaignMain.cm.getRandomNumber(100);
                    if (i >= 50) {
                        p.setPiloting(p.getPiloting() + 1);
                    } else {
                        p.setGunnery(p.getGunnery() + 1);
                    }
                } else if (p.getGunnery() < p.getPiloting()) {
                    p.setGunnery(p.getGunnery() + 1);
                } else {
                    p.setPiloting(p.getPiloting() + 1);
                }
            }
        }
        this.queues.get(type).addLast(p);
        if (CampaignMain.cm.isUsingMySQL() && !p.getName().equalsIgnoreCase("Vacant")) {
            p.toDB(type, -1);
        }
    }

    public void loadPilot(int type, SPilot p) {
        p.setCurrentFaction(this.factionString);
        this.queues.get(type).addLast(p);
    }

    public SPilot getPilot(int type) {
        LinkedList<SPilot> list = this.queues.get(type);
        while (list.size() < 10) {
            this.addPilot(type, this.rollNewPilot(type), true);
        }
        SPilot pilot = list.remove(CampaignMain.cm.getRandomNumber(list.size()));
        StringTokenizer ST = new StringTokenizer(this.getBasePilotSkill(type), "$");
        while (ST.hasMoreTokens()) {
            SPilotSkill pSkill = CampaignMain.cm.getPilotSkill(ST.nextToken());
            if (pilot.getSkills().has(pSkill)) continue;
            pilot.getSkills().add(pSkill);
        }
        return pilot;
    }

    private SPilot rollNewPilot(int unitType) {
        SPilotSkill skill;
        int gunnery = this.getBaseGunnery(unitType);
        int piloting = this.getBasePiloting(unitType);
        int skillChance = CampaignMain.cm.getIntegerConfig("BornSkillChance");
        int rnd = CampaignMain.cm.getRandomNumber(100);
        boolean allowGreenPilots = CampaignMain.cm.getBooleanConfig("AllowGreenPilots");
        boolean allowVetPilots = CampaignMain.cm.getBooleanConfig("AllowVetPilots");
        if (rnd < 10 && allowGreenPilots) {
            if (rnd < 5) {
                ++gunnery;
            } else if (rnd >= 5 && rnd < 10) {
                ++piloting;
            }
            skillChance = 100;
        }
        if (rnd >= 90 && allowVetPilots) {
            if (rnd >= 90 && rnd < 95) {
                --piloting;
            } else if (rnd >= 95) {
                --gunnery;
            }
        }
        SPilot result = new SPilot(this.getRandomPilotName(), gunnery, piloting);
        result.setCurrentFaction(this.factionString);
        rnd = CampaignMain.cm.getRandomNumber(100);
        if (rnd <= skillChance && CampaignMain.cm.getBooleanConfig("PilotSkills") && (skill = CampaignMain.cm.getRandomSkill(result, unitType)) != null) {
            if (skill instanceof TraitSkill) {
                ((TraitSkill)skill).assignTrait(result);
            }
            skill.addToPilot(result);
            skill.modifyPilot(result);
        }
        result.setPilotId(CampaignMain.cm.getAndUpdateCurrentPilotID());
        return result;
    }

    public int getQueueSize(int type) {
        return this.queues.get(type).size();
    }

    public void setFactionString(String s) {
        this.factionString = s;
    }

    public String getFactionString() {
        return this.factionString;
    }

    public void setFactionBasePilotSkills(String skills) {
        StringTokenizer ST = new StringTokenizer(skills);
        while (ST.hasMoreTokens()) {
        }
    }

    public int getBasePiloting(int type) {
        return this.basePiloting.elementAt(type);
    }

    public int getBaseGunnery(int type) {
        return this.baseGunnery.elementAt(type);
    }

    public String getBasePilotSkill(int type) {
        return this.basePilotSkills.elementAt(type);
    }

    public void setBasePiloting(int piloting, int type) {
        this.basePiloting.set(type, piloting);
    }

    public void setBaseGunnery(int gunnery, int type) {
        this.baseGunnery.set(type, gunnery);
    }

    public void setBasePilotSkill(String skills, int type) {
        this.basePilotSkills.set(type, skills);
    }

    public void setFactionID(int factionID) {
        this.factionID = factionID;
    }

    public int getFactionID() {
        return this.factionID;
    }

    public String getRandomPilotName() {
        String result = "Noelle";
        if (CampaignMain.cm.getBooleanConfig("UseCommonPilotNameFileOnly")) {
            return SPilot.getRandomPilotName(CampaignMain.cm.getR());
        }
        try {
            File configFile = new File("./data/pilotnames/" + this.factionString + "Pilotnames.txt");
            FileInputStream fis = new FileInputStream(configFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int names = Integer.parseInt(dis.readLine());
            int pilotid = CampaignMain.cm.getRandomNumber(names);
            while (dis.ready()) {
                String line = dis.readLine();
                if (pilotid <= 0) {
                    return line;
                }
                --pilotid;
            }
            dis.close();
            fis.close();
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("A problem occured while retreiving a name from the " + this.factionString + " Pilotnames File! Tried using Pilotnames.txt instead.");
            result = SPilot.getRandomPilotName(CampaignMain.cm.getR());
        }
        return result;
    }

    public LinkedList<SPilot> getPilotQueue(int type) {
        LinkedList<SPilot> list = this.queues.get(type);
        return list;
    }

    public void flushQueue() {
        this.queues.removeAllElements();
        for (int i = 0; i < 6; ++i) {
            LinkedList v = new LinkedList();
            this.queues.add(v);
        }
    }
}

