/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.Army;
import common.CampaignData;
import common.Unit;
import common.util.TokenReader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Mounted;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.operations.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SArmy
extends Army {
    private float rawForceSize = 0.0f;
    private Vector<SArmy> opponents = new Vector(1, 1);
    private TreeMap<String, String> legalOperations = new TreeMap();
    private String playerName = "";
    private boolean isLoading = false;

    public SArmy(String ownerName) {
        this.opponents = new Vector(1, 1);
        this.playerName = ownerName;
    }

    public SArmy(int id, String ownerName) {
        this.setID(id);
        this.opponents = new Vector(1, 1);
        this.playerName = ownerName;
    }

    public synchronized void toDB() {
        if (this.isLoading) {
            return;
        }
        this.deleteFromDB();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT into playerarmies set playerID = " + CampaignMain.cm.MySQL.getPlayerIDByName(this.playerName) + ", armyID = " + this.getID() + ", armyString = ?");
            PreparedStatement ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString());
            ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString());
            ps.setString(1, super.toString(false, "%"));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in SArmy.toDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void deleteFromDB() {
        try {
            PreparedStatement ps = CampaignMain.cm.MySQL.getPreparedStatement("DELETE from playerarmies WHERE playerID = ? AND armyID = ?");
            ps.setInt(1, CampaignMain.cm.MySQL.getPlayerIDByName(this.playerName));
            ps.setInt(2, this.getID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQLException in SArmy.deleteFromDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void addUnit(SUnit u) {
        super.addUnit(u);
        super.setBV(0);
        this.setRawForceSize(0.0f);
        if (CampaignMain.cm.isUsingMySQL()) {
            this.toDB();
        }
    }

    public void addUnit(SUnit u, int position) {
        super.addUnit(u, position);
        super.setBV(0);
        this.setRawForceSize(0.0f);
        if (CampaignMain.cm.isUsingMySQL()) {
            this.toDB();
        }
    }

    public void removeUnit(int id) {
        Iterator<Unit> i = this.getUnits().iterator();
        while (i.hasNext()) {
            if (i.next().getId() != id) continue;
            i.remove();
            break;
        }
        this.removeUnitFromC3Network(id);
        super.setBV(0);
        this.setRawForceSize(0.0f);
        this.removeCommander(id);
        if (CampaignMain.cm.isUsingMySQL()) {
            this.toDB();
        }
    }

    public int getUnitPosition(int id) {
        Vector<Unit> v = this.getUnits();
        for (int i = 0; i < v.size(); ++i) {
            SUnit unit = (SUnit)v.elementAt(i);
            if (unit.getId() != id) continue;
            return i;
        }
        return -1;
    }

    public float getRawForceSize() {
        if (this.rawForceSize != 0.0f) {
            return this.rawForceSize;
        }
        for (Unit u : this.getUnits()) {
            if (u.getType() == 2) {
                this.rawForceSize += CampaignMain.cm.getFloatConfig("InfantryOperationsBVMod");
                continue;
            }
            if (u.getType() == 1) {
                this.rawForceSize += CampaignMain.cm.getFloatConfig("VehicleOperationsBVMod");
                continue;
            }
            if (u.getType() == 4) {
                this.rawForceSize += CampaignMain.cm.getFloatConfig("BAOperationsBVMod");
                continue;
            }
            if (u.getType() == 3) {
                this.rawForceSize += CampaignMain.cm.getFloatConfig("ProtoOperationsBVMod");
                continue;
            }
            if (u.getType() == 5) {
                this.rawForceSize += CampaignMain.cm.getFloatConfig("AeroOperationsBVMod");
                continue;
            }
            this.rawForceSize += CampaignMain.cm.getFloatConfig("MekOperationsBVMod");
        }
        return this.rawForceSize;
    }

    public void setRawForceSize(float rfs) {
        this.rawForceSize = rfs;
    }

    public int getOperationsBV(SArmy OpposingForce) {
        boolean usingOpRules = CampaignMain.cm.getBooleanConfig("UseOperationsRule");
        if (!usingOpRules) {
            return this.getBV();
        }
        if (OpposingForce == null) {
            return this.getBV();
        }
        double finalMultiplier = this.forceSizeModifier(OpposingForce);
        return (int)Math.round((double)this.getBV() * finalMultiplier);
    }

    public boolean hasTAGAndHomingCombo() {
        boolean hasTAG = false;
        boolean hasHoming = false;
        try {
            for (Unit currU : this.getUnits()) {
                SUnit u = (SUnit)currU;
                if (u.hasTAG()) {
                    hasTAG = true;
                }
                if (u.hasHoming()) {
                    hasHoming = true;
                }
                if (!hasTAG || !hasHoming) continue;
                return true;
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Bad unit in army for TAGandHomingCombo. Returning false.");
            CampaignData.mwlog.errLog(ex);
            return false;
        }
        return false;
    }

    public boolean hasTAGAndSemiGuidedCombo() {
        boolean hasTAG = false;
        boolean hasSemiGuided = false;
        try {
            for (Unit currU : this.getUnits()) {
                SUnit u = (SUnit)currU;
                if (u.hasTAG()) {
                    hasTAG = true;
                }
                if (u.hasSemiGuided()) {
                    hasSemiGuided = true;
                }
                if (!hasTAG || !hasSemiGuided) continue;
                return true;
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Bad unit in army for hasTAGAndSemiGuidedCombo. Returning false.");
            CampaignData.mwlog.errLog(ex);
            return false;
        }
        return false;
    }

    public int getSemiGuidedBV() {
        int bv = 0;
        for (Unit currU : this.getUnits()) {
            SUnit unit = (SUnit)currU;
            for (Mounted ammo : unit.getEntity().getAmmo()) {
                if (((AmmoType)ammo.getType()).getMunitionType() != 524288L) continue;
                bv = (int)((double)bv + ((AmmoType)ammo.getType()).getBV(unit.getEntity()));
            }
        }
        return bv;
    }

    @Override
    public int getBV() {
        if (super.getBV() == 0) {
            this.calcBV();
        }
        return super.getBV();
    }

    public void calcBV() {
        int total = 0;
        int subTotal = 0;
        int c3Count = 0;
        int c3BV = 0;
        boolean hasTAGHomingCombo = this.hasTAGAndHomingCombo();
        boolean hasSemiGuided = this.hasTAGAndSemiGuidedCombo();
        for (Unit currU : this.getUnits()) {
            if (currU == null) continue;
            SUnit u = (SUnit)currU;
            if (u.hasBeenC3LinkedTo(this) || this.getC3Network().get(u.getId()) != null) {
                c3BV += u.getBV();
                ++c3Count;
            }
            subTotal = u.getBV();
            if (hasTAGHomingCombo) {
                double temp = (double)subTotal / u.getEntity().getCrew().getBVSkillMultiplier();
                if (u.hasTAG()) {
                    temp += 200.0;
                }
                if (u.hasHoming()) {
                    temp += 200.0;
                }
                subTotal = (int)(temp *= u.getEntity().getCrew().getBVSkillMultiplier());
            }
            total += subTotal;
        }
        total = (int)((double)total + (double)c3Count * ((double)c3BV * 0.05));
        if (hasSemiGuided) {
            total += this.getSemiGuidedBV();
        }
        super.setBV(total);
    }

    public boolean matches(SArmy enemy, Operation o) {
        int flatCap = o.getIntValue("MaxBVDifference");
        double percentCap = o.getDoubleValue("MaxBVPercent");
        if (enemy.getBV() == 0 && !o.getBooleanValue("MULArmiesOnly")) {
            return false;
        }
        int enemyOpBV = enemy.getOperationsBV(this);
        int myOpBV = this.getOperationsBV(enemy);
        int bvDiff = Math.abs(enemyOpBV - myOpBV);
        if (percentCap == 0.0) {
            if (bvDiff > flatCap) {
                return false;
            }
        } else {
            double percentDiff = 0.0;
            double smallestDiff = Math.min(enemyOpBV, myOpBV);
            double smallestBV = Math.min(enemyOpBV, myOpBV);
            double precentTotal = percentCap * smallestBV;
            percentDiff = (double)bvDiff / smallestDiff;
            if (precentTotal < (double)flatCap ? bvDiff > flatCap : percentDiff > percentCap) {
                return false;
            }
        }
        return true;
    }

    public int getAmountOfUnitsWithoutInfantry() {
        int total = 0;
        for (Unit unit : this.getUnits()) {
            if (unit.getType() == 2) continue;
            ++total;
        }
        return total;
    }

    public String getInaccurateDescription() {
        return "(Units: " + this.getAmountOfUnits() + " / BV: " + this.getBV() + ")";
    }

    public String getDescription(boolean accurate, boolean showID, boolean idShouldLink) {
        String toReturn = "";
        if (accurate) {
            if (showID && !idShouldLink) {
                toReturn = toReturn + "#" + this.getID();
            } else if (showID && idShouldLink) {
                toReturn = toReturn + "<a href=\"MEKWARS/c sth#a#" + this.getID() + "\">#" + this.getID() + "</a>";
            }
            if (this.isDisabled()) {
                toReturn = toReturn + " (disabled)";
            }
            toReturn = toReturn + " - ";
            toReturn = toReturn + this.getDescription(accurate);
        } else {
            toReturn = toReturn + this.getDescription(accurate);
        }
        return toReturn;
    }

    public String getDescription(boolean accurate) {
        return this.getDescription(accurate, null);
    }

    public String getDescription(boolean accurate, SArmy opposingArmy) {
        if (accurate) {
            StringBuilder result = new StringBuilder();
            if (this.getName().trim().length() != 0) {
                result.append("\"" + this.getName() + "\" - ");
            }
            Iterator<Unit> i = this.getUnits().iterator();
            while (i.hasNext()) {
                result.append(((SUnit)i.next()).getSmallDescription());
                if (!i.hasNext()) continue;
                result.append(", ");
            }
            result.append("; BV: " + this.getBV());
            if (opposingArmy != null && this.getBV() != this.getOperationsBV(opposingArmy)) {
                result.append(" (BV vs " + opposingArmy.getRawForceSize() + " units : " + this.getOperationsBV(opposingArmy) + ")");
            }
            return result.toString();
        }
        return this.getInaccurateDescription();
    }

    public int getTotalTonnage() {
        int tonnage = 0;
        for (Unit currU : this.getUnits()) {
            tonnage = (int)((float)tonnage + ((SUnit)currU).getEntity().getWeight());
        }
        return tonnage;
    }

    public void fromString(String s, String delimiter, SPlayer p) {
        int i;
        this.isLoading = true;
        StringTokenizer ST = new StringTokenizer(s, delimiter);
        this.setID(TokenReader.readInt(ST));
        this.setName(TokenReader.readString(ST));
        this.setLowerLimiter(TokenReader.readInt(ST));
        this.setUpperLimiter(TokenReader.readInt(ST));
        int count = TokenReader.readInt(ST);
        for (i = 0; i < count; ++i) {
            int id = TokenReader.readInt(ST);
            if (id == 0) continue;
            this.addUnit(p.getUnit(id));
        }
        count = TokenReader.readInt(ST);
        for (i = 0; i < count; ++i) {
            int key = TokenReader.readInt(ST);
            int unit = TokenReader.readInt(ST);
            this.getC3Network().put(new Integer(key), new Integer(unit));
        }
        this.setOpForceSize(TokenReader.readFloat(ST));
        count = TokenReader.readInt(ST);
        for (i = 0; i < count; ++i) {
            int unit = TokenReader.readInt(ST);
            this.addCommander(unit);
        }
        boolean lock = TokenReader.readBoolean(ST);
        if (lock) {
            this.playerLockArmy();
        } else {
            this.playerUnlockArmy();
        }
        boolean disabled = TokenReader.readBoolean(ST);
        if (disabled) {
            this.disableArmy();
        } else {
            this.enableArmy();
        }
        this.isLoading = false;
    }

    public String getMinimalInfo() {
        return this.getDescription(true);
    }

    public String getInfo() {
        return this.getDescription(true);
    }

    public TreeMap<String, String> getLegalOperations() {
        return this.legalOperations;
    }

    public void setOpponents(Vector<SArmy> v) {
        this.opponents = v;
    }

    public Vector<SArmy> getOpponents() {
        return this.opponents;
    }

    public void addOpponent(SArmy a) {
        try {
            this.opponents.add(a);
            this.opponents.trimToSize();
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("Error adding army to opponentList. Trace follows.");
            CampaignData.mwlog.errLog(e);
        }
    }

    public void removeOpponent(SArmy a) {
        try {
            this.opponents.remove(a);
            this.opponents.trimToSize();
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("Error removing army from opponentList. Trace follows.");
            CampaignData.mwlog.errLog(e);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name.trim().length() > 0) {
            CampaignMain.cm.toUser("PL|RNA|" + this.getID() + "#" + name, this.getPlayerName(), false);
        }
    }

    public void setPlayerLock(int aid, boolean lock) {
        if (lock) {
            super.playerLockArmy();
            CampaignMain.cm.toUser("PL|LA|" + this.getID(), this.getPlayerName(), false);
        } else {
            super.playerUnlockArmy();
            CampaignMain.cm.toUser("PL|ULA|" + this.getID(), this.getPlayerName(), false);
        }
    }

    @Override
    public void toggleArmyDisabled() {
        super.toggleArmyDisabled();
        CampaignMain.cm.toUser("PL|TAD|" + this.getID(), this.getPlayerName(), false);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean equals(Object o) {
        SArmy a = null;
        try {
            a = (SArmy)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (a == null) {
            return false;
        }
        if (!a.getPlayerName().equals(this.getPlayerName())) {
            return false;
        }
        return a.getID() == this.getID();
    }

    private boolean isLegalMekToInfantryRatio() {
        int infcount = 0;
        int mekcount = 0;
        for (Unit unit : this.getUnits()) {
            if (unit.getType() == 2) {
                ++infcount;
                continue;
            }
            if (unit.getType() != 0) continue;
            ++mekcount;
        }
        if (infcount == 0) {
            return true;
        }
        if (mekcount == 0) {
            return false;
        }
        int ratio = infcount * 100 / mekcount;
        return ratio <= CampaignMain.cm.getIntegerConfig("MekToInfantryRatio");
    }

    private boolean isLegalMekToVehicleRatio() {
        int veecount = 0;
        int mekcount = 0;
        for (Unit unit : this.getUnits()) {
            if (unit.getType() == 1) {
                ++veecount;
                continue;
            }
            if (unit.getType() != 0) continue;
            ++mekcount;
        }
        if (veecount == 0) {
            return true;
        }
        if (mekcount == 0) {
            return false;
        }
        int ratio = veecount * 100 / mekcount;
        return ratio <= CampaignMain.cm.getIntegerConfig("MekToVehicleRatio");
    }

    public void checkLegalRatio(String Username) {
        if (CampaignMain.cm.getBooleanConfig("AllowRatios")) {
            if (!this.isLegalMekToInfantryRatio()) {
                CampaignMain.cm.toUser("This army has an Illegal Mek to Infantry ratio and will not be allowed to participate in games.", Username, true);
            } else if (!this.isLegalMekToVehicleRatio()) {
                CampaignMain.cm.toUser("This army has an Illegal Mek to Vehicle ratio and will not be allowed to participate in games.", Username, true);
            } else {
                CampaignMain.cm.toUser("Army Ratio Checks", Username, true);
            }
        }
    }

    @Override
    public void setLowerLimiter(int lowerLimit) {
        int buffer = CampaignMain.cm.getIntegerConfig("LowerLimitBuffer");
        if (lowerLimit < buffer && lowerLimit != -1) {
            lowerLimit = buffer;
            CampaignMain.cm.toUser("Army " + this.getID() + "'s lower limit set to " + buffer + ".", this.getPlayerName(), true);
            CampaignMain.cm.toUser("PL|SAB|" + this.getID() + "#" + this.getLowerLimiter() + "#" + this.getUpperLimiter(), this.getPlayerName(), false);
        }
        super.setLowerLimiter(lowerLimit);
    }

    @Override
    public void setUpperLimiter(int upperLimit) {
        int buffer = CampaignMain.cm.getIntegerConfig("UpperLimitBuffer");
        if (upperLimit < buffer && upperLimit != -1) {
            upperLimit = buffer;
            CampaignMain.cm.toUser("Army " + this.getID() + "'s upper limit set to " + buffer + ".", this.getPlayerName(), true);
            CampaignMain.cm.toUser("PL|SAB|" + this.getID() + "#" + this.getLowerLimiter() + "#" + this.getUpperLimiter(), this.getPlayerName(), false);
        }
        super.setUpperLimiter(upperLimit);
    }

    public boolean isUnitInArmy(SUnit unit) {
        if (unit == null) {
            return false;
        }
        Vector<Unit> v = this.getUnits();
        for (int i = 0; i < v.size(); ++i) {
            SUnit newUnit = (SUnit)v.elementAt(i);
            if (!newUnit.equals(unit)) continue;
            return true;
        }
        return false;
    }

    public double forceSizeModifier(SArmy opposingForce) {
        double myForceSize = 0.0;
        double opposingForceSize = 0.0;
        this.setRawForceSize(0.0f);
        myForceSize = this.getRawForceSize();
        opposingForce.setRawForceSize(0.0f);
        opposingForceSize = opposingForce.getRawForceSize();
        if (myForceSize > opposingForceSize) {
            return opposingForceSize / myForceSize + myForceSize / opposingForceSize - 1.0;
        }
        return 1.0;
    }
}

