/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.BMEquipment;
import common.CampaignData;
import common.SubFaction;
import common.Unit;
import common.util.ComponentToCritsConverter;
import common.util.StringUtils;
import common.util.TokenReader;
import common.util.UnitComponents;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.PilotQueues;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.SUnitFactory;
import server.campaign.SmallPlayer;
import server.campaign.commands.Command;
import server.campaign.data.TimeUpdateHouse;
import server.campaign.market2.IBuyer;
import server.campaign.market2.ISeller;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;
import server.campaign.operations.Operation;
import server.campaign.operations.ShortOperation;
import server.campaign.pilot.SPilot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SHouse
extends TimeUpdateHouse
implements Comparable<Object>,
ISeller,
IBuyer,
Serializable {
    private static final long serialVersionUID = -1558672678021355218L;
    private ConcurrentHashMap<String, SPlayer> reservePlayers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, SPlayer> activePlayers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, SPlayer> fightingPlayers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, SPlanet> Planets = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Vector<Vector<SUnit>>> Hangar = new ConcurrentHashMap();
    private Hashtable<String, SmallPlayer> SmallPlayers = new Hashtable();
    private Hashtable<Integer, Vector<Integer>> Components = new Hashtable();
    private Hashtable<Integer, Integer> unitComponents = new Hashtable();
    private int Money;
    private int BaysProvided = 0;
    private int ComponentProduction = 0;
    private int showProductionCountNext = 0;
    private int initialHouseRanking = 0;
    private String motd = "";
    private PilotQueues pilotQueues = new PilotQueues(this.getBaseGunnerVect(), this.getBasePilotVect(), this.getBasePilotSkillVect());
    private boolean inHouseAttacks = false;
    private Properties config = new Properties();
    private String forumName = "";
    private int forumID = 0;
    private Vector<String> leaders = new Vector(1, 1);
    private int techResearchPoints = 0;
    private UnitComponents unitParts = new UnitComponents();
    private Hashtable<String, ComponentToCritsConverter> componentConverter = new Hashtable();

    public String toString() {
        int pos;
        int i;
        Vector<SUnit> tmpVec;
        int i2;
        StringBuilder result = new StringBuilder();
        result.append(this.getName());
        result.append("|");
        result.append(this.getMoney());
        result.append("|");
        result.append(this.getHouseColor());
        result.append("|");
        result.append(this.getBaseGunner());
        result.append("|");
        result.append(this.getBasePilot());
        result.append("|");
        result.append(this.getAbbreviation());
        result.append("|");
        for (i2 = 0; i2 < 4; ++i2) {
            tmpVec = this.getHangar(0).elementAt(i2);
            tmpVec.trimToSize();
            result.append(tmpVec.size());
            result.append("|");
            for (SUnit currU : tmpVec) {
                result.append(currU.toString(false));
                result.append("|");
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            tmpVec = this.getHangar(1).elementAt(i2);
            tmpVec.trimToSize();
            result.append(tmpVec.size());
            result.append("|");
            for (SUnit currU : tmpVec) {
                result.append(currU.toString(false));
                result.append("|");
            }
        }
        if (Boolean.parseBoolean(this.getConfig("UseInfantry"))) {
            for (i2 = 0; i2 < 4; ++i2) {
                tmpVec = this.getHangar(2).elementAt(i2);
                tmpVec.trimToSize();
                result.append(tmpVec.size());
                result.append("|");
                for (SUnit currU : tmpVec) {
                    result.append(currU.toString(false));
                    result.append("|");
                }
            }
        }
        result.append(this.getLogo());
        result.append("|");
        result.append(0);
        result.append("|");
        result.append("Components|");
        Enumeration<Integer> e = this.getComponents().keys();
        while (e.hasMoreElements()) {
            Integer id = e.nextElement();
            Vector<Integer> v = this.getComponents().get(id);
            result.append(id + "|" + v.size() + "|");
            for (int i3 = 0; i3 < v.size(); ++i3) {
                result.append(v.elementAt(i3) + "|");
            }
        }
        result.append("EndComponents");
        result.append("|");
        result.append(this.getInitialHouseRanking());
        result.append("|");
        result.append(this.isConquerable());
        result.append("|");
        result.append(this.isInHouseAttacks());
        result.append("|");
        result.append(this.getId());
        result.append("|");
        result.append(this.getHousePlayerColor());
        result.append("|");
        result.append(this.getHouseDefectionFrom());
        result.append("|");
        result.append(this.getPilotQueues().getQueueSize(0));
        result.append("|");
        LinkedList<SPilot> PilotList = this.getPilotQueues().getPilotQueue(0);
        for (SPilot currP : PilotList) {
            result.append(currP.toFileFormat("#", false));
            result.append("|");
        }
        result.append(this.getPilotQueues().getQueueSize(1));
        result.append("|");
        PilotList = this.getPilotQueues().getPilotQueue(1);
        for (SPilot currP : PilotList) {
            result.append(currP.toFileFormat("#", false));
            result.append("|");
        }
        result.append(this.getPilotQueues().getQueueSize(2));
        result.append("|");
        PilotList = this.getPilotQueues().getPilotQueue(2);
        for (SPilot currP : PilotList) {
            result.append(currP.toFileFormat("#", false));
            result.append("|");
        }
        result.append(this.getHouseFluFile());
        result.append("|");
        for (i = 0; i < 4; ++i) {
            Vector<SUnit> tmpVec2 = this.getHangar(4).elementAt(i);
            tmpVec2.trimToSize();
            result.append(tmpVec2.size());
            result.append("|");
            for (SUnit currU : tmpVec2) {
                result.append(currU.toString(false));
                result.append("|");
            }
        }
        for (i = 0; i < 4; ++i) {
            Vector<SUnit> tmpVec3 = this.getHangar(3).elementAt(i);
            tmpVec3.trimToSize();
            result.append(tmpVec3.size());
            result.append("|");
            for (SUnit currU : tmpVec3) {
                result.append(currU.toString(false));
                result.append("|");
            }
        }
        result.append(this.getPilotQueues().getQueueSize(4));
        result.append("|");
        PilotList = this.getPilotQueues().getPilotQueue(4);
        for (SPilot currPilot : PilotList) {
            result.append(currPilot.toFileFormat("#", false));
            result.append("|");
        }
        result.append(this.getPilotQueues().getQueueSize(3));
        result.append("|");
        PilotList = this.getPilotQueues().getPilotQueue(3);
        for (SPilot currPilot : PilotList) {
            result.append(currPilot.toFileFormat("#", false));
            result.append("|");
        }
        if (this.getMotd().equals("")) {
            result.append(" ");
        } else {
            result.append(this.getMotd());
        }
        result.append("|");
        result.append(this.getHouseDefectionTo());
        result.append("|");
        for (pos = 0; pos < 6; ++pos) {
            result.append(this.getBaseGunner(pos));
            result.append("|");
            result.append(this.getBasePilot(pos));
            result.append("|");
        }
        for (pos = 0; pos < 6; ++pos) {
            String skill = this.getBasePilotSkill(pos);
            if (skill.length() < 1) {
                result.append(" ");
            } else {
                result.append(skill);
            }
            result.append("|");
        }
        result.append(this.getTechLevel());
        result.append("|");
        result.append(this.getSubFactionList().size());
        result.append("|");
        for (String key : this.getSubFactionList().keySet()) {
            result.append(this.getSubFactionList().get(key).toString());
            result.append("|");
        }
        result.append(this.leaders.size());
        result.append("|");
        for (String leader : this.leaders) {
            result.append(leader);
            result.append("|");
        }
        result.append(this.techResearchPoints);
        result.append("|");
        result.append(this.unitParts.toString("#"));
        result.append("|");
        result.append(this.componentConverter.size());
        result.append("|");
        for (String key : this.componentConverter.keySet()) {
            result.append(this.componentConverter.get(key).toString());
        }
        for (int i4 = 0; i4 < 4; ++i4) {
            Vector<SUnit> tmpVec4 = this.getHangar(5).elementAt(i4);
            tmpVec4.trimToSize();
            result.append(tmpVec4.size());
            result.append("|");
            for (SUnit currU : tmpVec4) {
                result.append(currU.toString(false));
                result.append("|");
            }
        }
        result.append(this.getPilotQueues().getQueueSize(5));
        result.append("|");
        PilotList = this.getPilotQueues().getPilotQueue(5);
        for (SPilot currPilot : PilotList) {
            result.append(currPilot.toFileFormat("#", false));
            result.append("|");
        }
        return result.toString();
    }

    public Hashtable<Integer, Vector<Integer>> getComponents() {
        return this.Components;
    }

    public void toDB() {
        if (this.getName().equalsIgnoreCase("None")) {
            return;
        }
        CampaignData.mwlog.dbLog("Saving Faction " + this.getName());
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        ResultSet rs = null;
        try {
            int pos;
            Vector<SUnit> tmpVec;
            int i;
            if (this.getDBId() == 0) {
                CampaignData.mwlog.dbLog("House " + this.getName() + " has no DBId");
                Statement s = CampaignMain.cm.MySQL.getStatement();
                ResultSet r = s.executeQuery("SELECT ID from factions WHERE fName = '" + this.getName() + "'");
                if (r.next()) {
                    this.setDBId(r.getInt("ID"));
                    r.close();
                    s.close();
                    return;
                }
                s.close();
                r.close();
                sql.setLength(0);
                sql.append("INSERT into factions set ");
                sql.append("fName = ?, ");
                sql.append("fMoney = ?, ");
                sql.append("fColor = ?, ");
                sql.append("fAbbreviation = ?, ");
                sql.append("fLogo = ?, ");
                sql.append("fInitialHouseRanking = ?, ");
                sql.append("fConquerable = ?, ");
                sql.append("fPlayerColors = ?, ");
                sql.append("fInHouseAttacks = ?, ");
                sql.append("fAllowDefectionsFrom = ?, ");
                sql.append("fFluFile = ?, ");
                sql.append("fMOTD = ?, ");
                sql.append("fAllowDefectionsTo = ?, ");
                sql.append("fTechLevel = ?, ");
                sql.append("fBaseGunner = ?, ");
                sql.append("fBasePilot = ?, ");
                sql.append("fIsNewbieHouse = ?, ");
                sql.append("fIsMercHouse = ?, ");
                sql.append("fString = ?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString(), 1);
                ps.setString(1, this.getName());
                ps.setInt(2, this.getMoney());
                ps.setString(3, this.getHouseColor());
                ps.setString(4, this.getAbbreviation());
                ps.setString(5, this.getLogo());
                ps.setInt(6, this.getInitialHouseRanking());
                ps.setBoolean(7, this.isConquerable());
                ps.setString(8, this.getHousePlayerColor());
                ps.setBoolean(9, this.isInHouseAttacks());
                ps.setBoolean(10, this.getHouseDefectionFrom());
                ps.setString(11, this.getHouseFluFile());
                ps.setString(12, this.getMotd());
                ps.setBoolean(13, this.getHouseDefectionTo());
                ps.setInt(14, this.getTechLevel());
                ps.setInt(15, this.getBaseGunner());
                ps.setInt(16, this.getBasePilot());
                ps.setBoolean(17, this.isNewbieHouse());
                ps.setBoolean(18, this.isMercHouse());
                ps.setString(19, this.toString());
                ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                rs.next();
                this.setDBId(rs.getInt(1));
            } else {
                sql.setLength(0);
                sql.append("UPDATE factions set ");
                sql.append("fName = ?, ");
                sql.append("fMoney = ?, ");
                sql.append("fColor = ?, ");
                sql.append("fAbbreviation = ?, ");
                sql.append("fLogo = ?, ");
                sql.append("fInitialHouseRanking = ?, ");
                sql.append("fConquerable = ?, ");
                sql.append("fPlayerColors = ?, ");
                sql.append("fInHouseAttacks = ?, ");
                sql.append("fAllowDefectionsFrom = ?, ");
                sql.append("fFluFile = ?, ");
                sql.append("fMOTD = ?, ");
                sql.append("fAllowDefectionsTo = ?, ");
                sql.append("fTechLevel = ?, ");
                sql.append("fBaseGunner = ?, ");
                sql.append("fBasePilot = ?, ");
                sql.append("fIsNewbieHouse = ?, ");
                sql.append("fIsMercHouse = ?, ");
                sql.append("fString = ? ");
                sql.append("WHERE ID = ?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString());
                ps.setString(1, this.getName());
                ps.setInt(2, this.getMoney());
                ps.setString(3, this.getHouseColor());
                ps.setString(4, this.getAbbreviation());
                ps.setString(5, this.getLogo());
                ps.setInt(6, this.getInitialHouseRanking());
                ps.setBoolean(7, this.isConquerable());
                ps.setString(8, this.getHousePlayerColor());
                ps.setBoolean(9, this.isInHouseAttacks());
                ps.setBoolean(10, this.getHouseDefectionFrom());
                ps.setString(11, this.getHouseFluFile());
                ps.setString(12, this.getMotd());
                ps.setBoolean(13, this.getHouseDefectionTo());
                ps.setInt(14, this.getTechLevel());
                ps.setInt(15, this.getBaseGunner());
                ps.setInt(16, this.getBasePilot());
                ps.setBoolean(17, this.isNewbieHouse());
                ps.setBoolean(18, this.isMercHouse());
                ps.setString(19, this.toString());
                ps.setInt(20, this.getDBId());
                ps.executeUpdate();
            }
            for (i = 0; i < 4; ++i) {
                tmpVec = this.getHangar(0).elementAt(i);
                tmpVec.trimToSize();
                for (SUnit currU : tmpVec) {
                    currU.toDB();
                }
            }
            for (i = 0; i < 4; ++i) {
                tmpVec = this.getHangar(1).elementAt(i);
                tmpVec.trimToSize();
                for (SUnit currU : tmpVec) {
                    currU.toDB();
                }
            }
            if (Boolean.parseBoolean(this.getConfig("UseInfantry"))) {
                for (i = 0; i < 4; ++i) {
                    tmpVec = this.getHangar(2).elementAt(i);
                    tmpVec.trimToSize();
                    for (SUnit currU : tmpVec) {
                        currU.toDB();
                    }
                }
            }
            for (i = 0; i < 4; ++i) {
                tmpVec = this.getHangar(4).elementAt(i);
                tmpVec.trimToSize();
                for (SUnit currU : tmpVec) {
                    currU.toDB();
                }
            }
            for (i = 0; i < 4; ++i) {
                tmpVec = this.getHangar(3).elementAt(i);
                tmpVec.trimToSize();
                for (SUnit currU : tmpVec) {
                    currU.toDB();
                }
            }
            ConcurrentLinkedQueue<SPilot> PilotList = new ConcurrentLinkedQueue<SPilot>(this.getPilotQueues().getPilotQueue(0));
            for (SPilot currP : PilotList) {
                currP.toDB(0, -1);
            }
            PilotList = new ConcurrentLinkedQueue<SPilot>(this.getPilotQueues().getPilotQueue(1));
            for (SPilot currP : PilotList) {
                currP.toDB(1, -1);
            }
            PilotList = new ConcurrentLinkedQueue<SPilot>(this.getPilotQueues().getPilotQueue(2));
            for (SPilot currP : PilotList) {
                currP.toDB(2, -1);
            }
            PilotList = new ConcurrentLinkedQueue<SPilot>(this.getPilotQueues().getPilotQueue(4));
            for (SPilot currP : PilotList) {
                currP.toDB(4, -1);
            }
            PilotList = new ConcurrentLinkedQueue<SPilot>(this.getPilotQueues().getPilotQueue(3));
            for (SPilot currP : PilotList) {
                currP.toDB(3, -1);
            }
            ps.executeUpdate("DELETE from factioncomponents WHERE factionID = " + this.getDBId());
            Enumeration<Integer> en = this.getComponents().keys();
            while (en.hasMoreElements()) {
                Integer id = en.nextElement();
                Vector<Integer> v = this.getComponents().get(id);
                for (int i2 = 0; i2 < v.size(); ++i2) {
                    ps.executeUpdate("INSERT into factioncomponents set factionID = " + this.getDBId() + ", unitType = " + id + ", unitWeight = " + i2 + ", components = " + v.elementAt(i2));
                }
            }
            ps.executeUpdate("DELETE from faction_pilot_skills WHERE factionID = " + this.getDBId());
            for (pos = 0; pos < 6; ++pos) {
                String skill = this.getBasePilotSkill(pos);
                ps.close();
                ps = CampaignMain.cm.MySQL.getPreparedStatement("INSERT into faction_pilot_skills set factionID = ?, skillID = ?, pilotSkills = ?");
                ps.setInt(1, this.getDBId());
                ps.setString(3, skill);
                ps.setInt(2, pos);
                ps.executeUpdate();
            }
            ps.executeUpdate("DELETE from faction_base_gunnery_piloting where factionId = " + this.getDBId());
            for (pos = 0; pos < 6; ++pos) {
                ps.executeUpdate("INSERT into faction_base_gunnery_piloting set factionID = " + this.getDBId() + ", unitType = " + pos + ", baseGunnery = " + this.getBaseGunner(pos) + ", basePiloting = " + this.getBasePilot(pos));
            }
            for (String key : this.getSubFactionList().keySet()) {
                CampaignMain.cm.MySQL.saveSubFaction(this.getSubFactionList().get(key).toString(), this.getDBId());
            }
            ps.executeUpdate("DELETE from faction_leaders WHERE faction_id = " + this.getDBId());
            if (rs != null) {
                rs.close();
            }
            for (String leader : this.leaders) {
                ps.close();
                ps = CampaignMain.cm.MySQL.getPreparedStatement("REPLACE into faction_leaders set faction_id = ?, leader_name=?");
                ps.setInt(1, this.getDBId());
                ps.setString(2, leader);
                ps.execute();
            }
            if (rs != null) {
                rs.close();
            }
            ps.close();
            CampaignData.mwlog.dbLog("Faction " + this.getName() + " saved");
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in FactionHandler.saveFaction: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public String fromString(String s, Random r) {
        try {
            int amount;
            int rareSalesTime;
            int priceForUnit;
            int j;
            int i;
            int pilotCount;
            int rareSalesTime2;
            int priceForUnit2;
            int j2;
            SUnit m;
            int i2;
            StringTokenizer ST = new StringTokenizer(s, "|");
            this.setName(TokenReader.readString(ST));
            CampaignData.mwlog.createFactionLogger(this.getName());
            this.setMoney(TokenReader.readInt(ST));
            this.setHouseColor(TokenReader.readString(ST));
            this.setBaseGunner(TokenReader.readInt(ST));
            this.setBasePilot(TokenReader.readInt(ST));
            this.setAbbreviation(TokenReader.readString(ST));
            this.getHangar().put(0, new Vector(5, 1));
            this.getHangar().put(1, new Vector(5, 1));
            this.getHangar().put(2, new Vector(5, 1));
            this.getHangar().put(3, new Vector(5, 1));
            this.getHangar().put(4, new Vector(5, 1));
            this.getHangar().put(5, new Vector(5, 1));
            for (int i3 = 0; i3 < 4; ++i3) {
                this.getHangar(0).add(new Vector(1, 1));
                this.getHangar(1).add(new Vector(1, 1));
                this.getHangar(2).add(new Vector(1, 1));
                this.getHangar(4).add(new Vector(1, 1));
                this.getHangar(3).add(new Vector(1, 1));
                this.getHangar(5).add(new Vector(1, 1));
            }
            boolean newbieHouse = this.isNewbieHouse();
            for (i2 = 0; i2 < 4; ++i2) {
                int numofmechs = TokenReader.readInt(ST);
                m = null;
                for (j2 = 0; j2 < numofmechs; ++j2) {
                    m = new SUnit();
                    m.fromString(TokenReader.readString(ST));
                    if (newbieHouse) {
                        priceForUnit2 = this.getPriceForUnit(m.getWeightclass(), m.getType());
                        rareSalesTime2 = Integer.parseInt(this.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + this.getName(), m, priceForUnit2, rareSalesTime2);
                        m.setStatus(3);
                    }
                    this.addUnit(m, false);
                }
            }
            for (i2 = 0; i2 < 4; ++i2) {
                int numofvehicles = TokenReader.readInt(ST);
                for (j2 = 0; j2 < numofvehicles; ++j2) {
                    m = new SUnit();
                    m.fromString(TokenReader.readString(ST));
                    if (newbieHouse) {
                        priceForUnit2 = this.getPriceForUnit(m.getWeightclass(), m.getType());
                        rareSalesTime2 = Integer.parseInt(this.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + this.getName(), m, priceForUnit2, rareSalesTime2);
                        m.setStatus(3);
                    }
                    this.addUnit(m, false);
                }
            }
            if (Boolean.parseBoolean(this.getConfig("UseInfantry"))) {
                for (i2 = 0; i2 < 4; ++i2) {
                    int numofinfantry = TokenReader.readInt(ST);
                    for (j2 = 0; j2 < numofinfantry; ++j2) {
                        m = new SUnit();
                        m.fromString(TokenReader.readString(ST));
                        if (newbieHouse) {
                            priceForUnit2 = this.getPriceForUnit(m.getWeightclass(), m.getType());
                            rareSalesTime2 = Integer.parseInt(this.getConfig("RareMinSaleTime"));
                            CampaignMain.cm.getMarket().addListing("Faction_" + this.getName(), m, priceForUnit2, rareSalesTime2);
                            m.setStatus(3);
                        }
                        this.addUnit(m, false);
                    }
                }
            }
            TokenReader.readString(ST);
            String next = TokenReader.readString(ST);
            while (!next.equals("Components")) {
                next = TokenReader.readString(ST);
            }
            this.getComponents().put(0, new Vector(4, 1));
            this.getComponents().put(1, new Vector(4, 1));
            this.getComponents().put(2, new Vector(4, 1));
            this.getComponents().put(4, new Vector(4, 1));
            this.getComponents().put(3, new Vector(4, 1));
            this.getComponents().put(5, new Vector(4, 1));
            for (int i4 = 0; i4 < 4; ++i4) {
                this.getComponents().get(0).add(0);
                this.getComponents().get(1).add(0);
                this.getComponents().get(2).add(0);
                this.getComponents().get(4).add(0);
                this.getComponents().get(3).add(0);
                this.getComponents().get(5).add(0);
            }
            boolean finished = false;
            while (!finished) {
                next = TokenReader.readString(ST);
                if (!next.equals("EndComponents")) {
                    Integer id = new Integer(next);
                    int count = TokenReader.readInt(ST);
                    for (int i5 = 0; i5 < count; ++i5) {
                        Vector<Integer> v = this.getComponents().get(id);
                        int val = TokenReader.readInt(ST);
                        v.setElementAt(val, i5);
                    }
                    continue;
                }
                finished = true;
            }
            this.setInitialHouseRanking(TokenReader.readInt(ST));
            this.setConquerable(TokenReader.readBoolean(ST));
            this.setInHouseAttacks(TokenReader.readBoolean(ST));
            TokenReader.readString(ST);
            this.setId(-1);
            String housePlayerColor = TokenReader.readString(ST);
            try {
                int redColor = Integer.parseInt(housePlayerColor);
                int greenColor = TokenReader.readInt(ST);
                int blueColor = TokenReader.readInt(ST);
                this.setHousePlayerColors(Integer.toHexString(redColor) + Integer.toHexString(greenColor) + Integer.toHexString(blueColor));
            }
            catch (Exception ex) {
                this.setHousePlayerColors(housePlayerColor);
            }
            this.setHouseDefectionFrom(TokenReader.readBoolean(ST));
            for (pilotCount = TokenReader.readInt(ST); pilotCount > 0; --pilotCount) {
                SPilot p = new SPilot();
                p.fromFileFormat(TokenReader.readString(ST), "#");
                this.getPilotQueues().loadPilot(0, p);
            }
            for (pilotCount = TokenReader.readInt(ST); pilotCount > 0; --pilotCount) {
                SPilot p = new SPilot();
                p.fromFileFormat(TokenReader.readString(ST), "#");
                this.getPilotQueues().loadPilot(1, p);
            }
            for (pilotCount = TokenReader.readInt(ST); pilotCount > 0; --pilotCount) {
                SPilot p = new SPilot();
                p.fromFileFormat(TokenReader.readString(ST), "#");
                this.getPilotQueues().loadPilot(2, p);
            }
            this.setHouseFluFile(TokenReader.readString(ST));
            for (i = 0; i < 4; ++i) {
                int numofmechs = TokenReader.readInt(ST);
                SUnit m2 = null;
                for (j = 0; j < numofmechs; ++j) {
                    m2 = new SUnit();
                    m2.fromString(TokenReader.readString(ST));
                    if (newbieHouse) {
                        priceForUnit = this.getPriceForUnit(m2.getWeightclass(), m2.getType());
                        rareSalesTime = Integer.parseInt(this.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + this.getName(), m2, priceForUnit, rareSalesTime);
                        m2.setStatus(3);
                    }
                    this.addUnit(m2, false);
                }
            }
            for (i = 0; i < 4; ++i) {
                int numofmechs = TokenReader.readInt(ST);
                SUnit m3 = null;
                for (j = 0; j < numofmechs; ++j) {
                    m3 = new SUnit();
                    m3.fromString(TokenReader.readString(ST));
                    if (newbieHouse) {
                        priceForUnit = this.getPriceForUnit(m3.getWeightclass(), m3.getType());
                        rareSalesTime = Integer.parseInt(this.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + this.getName(), m3, priceForUnit, rareSalesTime);
                        m3.setStatus(3);
                    }
                    this.addUnit(m3, false);
                }
            }
            for (pilotCount = TokenReader.readInt(ST); pilotCount > 0; --pilotCount) {
                SPilot p = new SPilot();
                p.fromFileFormat(TokenReader.readString(ST), "#");
                this.getPilotQueues().loadPilot(4, p);
            }
            for (pilotCount = TokenReader.readInt(ST); pilotCount > 0; --pilotCount) {
                SPilot p = new SPilot();
                p.fromFileFormat(TokenReader.readString(ST), "#");
                this.getPilotQueues().loadPilot(3, p);
            }
            this.setMotd(TokenReader.readString(ST));
            this.setHouseDefectionTo(TokenReader.readBoolean(ST));
            try {
                for (int pos = 0; pos < 6; ++pos) {
                    this.setBaseGunner(TokenReader.readInt(ST), pos);
                    this.setBasePilot(TokenReader.readInt(ST), pos);
                }
            }
            catch (Exception ex) {
                this.setPilotQueues(new PilotQueues(this.getBaseGunnerVect(), this.getBasePilotVect(), this.getBasePilotSkillVect()));
                this.getPilotQueues().setFactionString(this.getName());
            }
            try {
                for (int pos = 0; pos < 6; ++pos) {
                    String skill = TokenReader.readString(ST);
                    this.setBasePilotSkill(skill, pos);
                }
            }
            catch (Exception ex) {
                this.setPilotQueues(new PilotQueues(this.getBaseGunnerVect(), this.getBasePilotVect(), this.getBasePilotSkillVect()));
                this.getPilotQueues().setFactionString(this.getName());
            }
            this.setTechLevel(TokenReader.readInt(ST));
            for (amount = TokenReader.readInt(ST); amount > 0; --amount) {
                SubFaction newSubFaction = new SubFaction();
                newSubFaction.fromString(TokenReader.readString(ST));
                this.getSubFactionList().put(newSubFaction.getConfig("Name"), newSubFaction);
            }
            for (amount = TokenReader.readInt(ST); amount > 0; --amount) {
                this.leaders.add(TokenReader.readString(ST));
            }
            this.techResearchPoints = TokenReader.readInt(ST);
            if (CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
                this.unitParts.fromString(TokenReader.readString(ST), "#");
            } else {
                TokenReader.readString(ST);
            }
            for (int size = TokenReader.readInt(ST); size > 0; --size) {
                ComponentToCritsConverter converter = new ComponentToCritsConverter();
                converter.setCritName(TokenReader.readString(ST));
                converter.setMinCritLevel(TokenReader.readInt(ST));
                converter.setComponentUsedType(TokenReader.readInt(ST));
                converter.setComponentUsedWeight(TokenReader.readInt(ST));
            }
            for (int i6 = 0; i6 < 4; ++i6) {
                int numofmechs = TokenReader.readInt(ST);
                SUnit m4 = null;
                for (int j3 = 0; j3 < numofmechs; ++j3) {
                    m4 = new SUnit();
                    m4.fromString(TokenReader.readString(ST));
                    if (newbieHouse) {
                        int priceForUnit3 = this.getPriceForUnit(m4.getWeightclass(), m4.getType());
                        int rareSalesTime3 = Integer.parseInt(this.getConfig("RareMinSaleTime"));
                        CampaignMain.cm.getMarket().addListing("Faction_" + this.getName(), m4, priceForUnit3, rareSalesTime3);
                        m4.setStatus(3);
                    }
                    this.addUnit(m4, false);
                }
            }
            for (pilotCount = TokenReader.readInt(ST); pilotCount > 0; --pilotCount) {
                SPilot p = new SPilot();
                p.fromFileFormat(TokenReader.readString(ST), "#");
                this.getPilotQueues().loadPilot(5, p);
            }
            if (this.getComponentConverter().size() < 1 && CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
                ComponentToCritsConverter converter = new ComponentToCritsConverter();
                converter.setComponentUsedType(0);
                converter.setComponentUsedWeight(0);
                converter.setMinCritLevel(100);
                this.getComponentConverter().put(converter.getCritName(), converter);
            }
            this.setPilotQueues(new PilotQueues(this.getBaseGunnerVect(), this.getBasePilotVect(), this.getBasePilotSkillVect()));
            this.getPilotQueues().setFactionString(this.getName());
            if (this.isMercHouse()) {
                CampaignData.mwlog.mainLog("Merc House");
                int contractamount = 0;
                contractamount = TokenReader.readInt(ST);
                Hashtable<String, ContractInfo> merctable = new Hashtable<String, ContractInfo>();
                for (int i7 = 0; i7 < contractamount; ++i7) {
                    ContractInfo ci = new ContractInfo();
                    ci.fromString(TokenReader.readString(ST));
                    merctable.put(ci.getPlayerName(), ci);
                }
                ((MercHouse)this).setOutstandingContracts(merctable);
            }
            CampaignData.mwlog.mainLog("House loaded: " + this.getName());
            this.loadConfigFile();
            this.setUsedMekBayMultiplier(Float.parseFloat(this.getConfig("UsedPurchaseCostMulti")));
            return s;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Error while loading faction: " + this.getName() + " Going forward anyway ...");
            return s;
        }
    }

    public SHouse(int id) {
        super(id);
    }

    public SHouse() {
        this.reservePlayers = new ConcurrentHashMap();
        this.activePlayers = new ConcurrentHashMap();
        this.fightingPlayers = new ConcurrentHashMap();
        this.SmallPlayers = new Hashtable();
        for (int pos = 0; pos < 6; ++pos) {
            this.setBaseGunner(4, pos);
            this.setBasePilot(5, pos);
        }
    }

    public ConcurrentHashMap<String, SPlayer> getReservePlayers() {
        return this.reservePlayers;
    }

    public ConcurrentHashMap<String, SPlayer> getActivePlayers() {
        return this.activePlayers;
    }

    public ConcurrentHashMap<String, SPlayer> getFightingPlayers() {
        return this.fightingPlayers;
    }

    public int getBaysProvided() {
        return this.BaysProvided;
    }

    public int getComponentProduction() {
        return this.ComponentProduction;
    }

    public void setPilotQueues(PilotQueues q) {
        this.pilotQueues = q;
    }

    public SHouse(int id, String name, String HouseColor, int BaseGunner, int BasePilot, String abbreviation) {
        super(id);
        int i;
        this.setAbbreviation(abbreviation);
        this.setHouseColor(HouseColor);
        this.setName(name);
        CampaignData.mwlog.createFactionLogger(this.getName());
        for (int j = 0; j < 5; ++j) {
            Vector<Integer> v = new Vector<Integer>();
            for (int i2 = 0; i2 < 4; ++i2) {
                v.add(0);
            }
            v.trimToSize();
            this.getComponents().put(j, v);
        }
        this.setMoney(0);
        this.getHangar().put(0, new Vector(1, 1));
        this.getHangar().put(1, new Vector(1, 1));
        this.getHangar().put(2, new Vector(1, 1));
        this.getHangar().put(3, new Vector(1, 1));
        this.getHangar().put(4, new Vector(1, 1));
        this.getHangar().put(5, new Vector(1, 1));
        for (i = 0; i < 4; ++i) {
            this.getHangar(0).add(new Vector(1, 1));
            this.getHangar(1).add(new Vector(1, 1));
            this.getHangar(2).add(new Vector(1, 1));
            this.getHangar(3).add(new Vector(1, 1));
            this.getHangar(4).add(new Vector(1, 1));
            this.getHangar(5).add(new Vector(1, 1));
        }
        this.getComponents().put(0, new Vector(4, 1));
        this.getComponents().put(1, new Vector(4, 1));
        this.getComponents().put(2, new Vector(4, 1));
        this.getComponents().put(4, new Vector(4, 1));
        this.getComponents().put(5, new Vector(4, 1));
        this.getComponents().put(3, new Vector(4, 1));
        for (i = 0; i < 4; ++i) {
            this.getComponents().get(0).add(0);
            this.getComponents().get(1).add(0);
            this.getComponents().get(2).add(0);
            this.getComponents().get(4).add(0);
            this.getComponents().get(3).add(0);
            this.getComponents().get(5).add(0);
        }
    }

    public ConcurrentHashMap<Integer, Vector<Vector<SUnit>>> getHangar() {
        return this.Hangar;
    }

    public Vector<Vector<SUnit>> getHangar(int Type_id) {
        if (this.Hangar == null || this.Hangar.size() < Type_id) {
            return null;
        }
        return this.Hangar.get(Type_id);
    }

    public boolean isNewbieHouse() {
        return false;
    }

    public boolean isMercHouse() {
        return false;
    }

    public SHouse getHouseFightingFor(SPlayer player) {
        return this;
    }

    public boolean equals(Object o) {
        SHouse h = null;
        try {
            h = (SHouse)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (h == null) {
            return false;
        }
        return h.getName().equals(this.getName());
    }

    public void addDispossessedPilot(SUnit u, boolean skipSkillChange) {
        if (u.hasVacantPilot()) {
            return;
        }
        if (skipSkillChange) {
            this.getPilotQueues().addPilot(u.getType(), (SPilot)u.getPilot(), true);
        } else {
            this.getPilotQueues().addPilot(u.getType(), (SPilot)u.getPilot());
        }
    }

    public PilotQueues getPilotQueues() {
        return this.pilotQueues;
    }

    public SPilot getNewPilot(int uType) {
        SPilot pilot = this.getPilotQueues().getPilot(uType);
        pilot.setCurrentFaction(this.getName());
        return pilot;
    }

    public boolean isLoggedIntoFaction(String playerName) {
        String lowerName = playerName.toLowerCase();
        if (this.getReservePlayers().containsKey(lowerName)) {
            return true;
        }
        if (this.getActivePlayers().containsKey(lowerName)) {
            return true;
        }
        return this.getFightingPlayers().containsKey(lowerName);
    }

    public int remainingHangarSpaceForWeightclass(int Weightclass, int TypeID) {
        int trueHangarSize = this.getNumberOfNonSaleUnits(this.getHangar(TypeID).elementAt(Weightclass));
        if (Weightclass == 0) {
            if (TypeID != 0) {
                return Integer.parseInt(this.getConfig("MaxLightUnits")) / 2 - trueHangarSize;
            }
            return Integer.parseInt(this.getConfig("MaxLightUnits")) - trueHangarSize;
        }
        if (TypeID != 0) {
            return Integer.parseInt(this.getConfig("MaxOtherUnits")) / 2 - trueHangarSize;
        }
        return Integer.parseInt(this.getConfig("MaxOtherUnits")) - trueHangarSize;
    }

    private double getNumberOfPlayersWhoCountForProduction() {
        double result = 0.0;
        boolean showOutput = Boolean.parseBoolean(this.getConfig("ShowOutputMultiplierOnTick"));
        CampaignData.mwlog.debugLog("Staring getNumberOfPlayersWhoCountForProduction");
        for (SPlayer currP : this.getActivePlayers().values()) {
            CampaignData.mwlog.debugLog("Counting " + currP.getName());
            if (System.currentTimeMillis() < currP.getActiveSince() + Long.parseLong(this.getConfig("InfluenceTimeMin"))) continue;
            CampaignData.mwlog.debugLog("Getting army weight");
            double value = currP.getWeightedArmyNumber();
            if (value <= 0.0) continue;
            result += value;
            CampaignData.mwlog.debugLog("Showing output");
            if (!showOutput) continue;
            String toShow = "AM:You counted towards production this tick";
            DecimalFormat myFormatter = new DecimalFormat("###.##");
            String output = myFormatter.format(value);
            toShow = toShow + " (" + output + " points worth)";
            CampaignMain.cm.toUser(toShow + ".", currP.getName(), true);
        }
        CampaignData.mwlog.debugLog("Getting all fighting players");
        for (SPlayer currP : this.getFightingPlayers().values()) {
            CampaignData.mwlog.debugLog("checking short operation for " + currP.getName());
            ShortOperation so = CampaignMain.cm.getOpsManager().getShortOpForPlayer(currP);
            if (so == null) continue;
            CampaignData.mwlog.debugLog("Getting data for op " + so.getName() + " for player " + currP.getName());
            Operation o = CampaignMain.cm.getOpsManager().getOperation(so.getName());
            double value = o.getDoubleValue("CountGameForProduction");
            if (value < 0.0) {
                value = 0.0;
            }
            CampaignData.mwlog.debugLog("adding value.");
            result += value;
            CampaignData.mwlog.debugLog("Showing output");
            if (!(value > 0.0) || !showOutput) continue;
            String toReturn = "AM:You counted towards production this tick";
            DecimalFormat myFormatter = new DecimalFormat("###.##");
            String output = myFormatter.format(value);
            toReturn = toReturn + " (" + output + " points worth)";
            CampaignMain.cm.toUser(toReturn + ".", currP.getName(), true);
        }
        CampaignData.mwlog.debugLog("returning with results.");
        return result;
    }

    public String tick(boolean real, int tickid) {
        int type_id;
        CampaignData.mwlog.debugLog("Inside SHouse.Tick for: " + this.getName());
        String result = "-------> <b>Tick! [" + tickid + "]</b><br>";
        StringBuilder hsUpdates = new StringBuilder();
        double tickworth = 0.0;
        CampaignData.mwlog.debugLog("Getting number of players who count for production");
        tickworth = !real ? 10.0 : this.getNumberOfPlayersWhoCountForProduction();
        CampaignData.mwlog.debugLog("     -> " + tickworth);
        CampaignData.mwlog.debugLog("Calculating refresh points");
        double cComp = this.getComponentProduction();
        int componentsToAdd = (int)(tickworth * cComp);
        int refreshToAdd = (int)Math.ceil(tickworth);
        if (this.getIntegerConfig("FactoryRefreshPoints") > -1) {
            refreshToAdd = this.getIntegerConfig("FactoryRefreshPoints");
        }
        CampaignData.mwlog.debugLog("     -> " + refreshToAdd);
        CampaignData.mwlog.debugLog("Geting planet income and refreshing factories");
        for (SPlanet p : this.getPlanets().values()) {
            if (!this.equals(p.getOwner())) continue;
            CampaignData.mwlog.debugLog("Updating planet " + p.getName());
            hsUpdates.append(p.tick(refreshToAdd));
        }
        boolean useMekPP = Boolean.parseBoolean(this.getConfig("UseMek"));
        boolean useVehiclePP = Boolean.parseBoolean(this.getConfig("UseVehicle"));
        boolean useInfantryPP = Boolean.parseBoolean(this.getConfig("UseInfantry"));
        boolean useProtoMekPP = Boolean.parseBoolean(this.getConfig("UseProtoMek"));
        boolean useBattleArmorPP = Boolean.parseBoolean(this.getConfig("UseBattleArmor"));
        boolean useAeroPP = Boolean.parseBoolean(this.getConfig("UseAero"));
        for (int i = 0; i < 4; ++i) {
            if (useMekPP) {
                CampaignData.mwlog.debugLog("Updating House Mek Parts: " + i);
                hsUpdates.append(this.addPP(i, 0, componentsToAdd, false));
                this.addComponentsProduced(0, componentsToAdd);
            }
            if (useVehiclePP) {
                CampaignData.mwlog.debugLog("Updating House Vehicle Parts: " + i);
                hsUpdates.append(this.addPP(i, 1, componentsToAdd, false));
                this.addComponentsProduced(1, componentsToAdd);
            }
            if (useInfantryPP) {
                CampaignData.mwlog.debugLog("Updating House Infantry: " + i);
                if (!Boolean.parseBoolean(this.getConfig("UseOnlyLightInfantry")) || i == 0) {
                    hsUpdates.append(this.addPP(i, 2, componentsToAdd, false));
                }
                this.addComponentsProduced(2, componentsToAdd);
            }
            if (useProtoMekPP) {
                CampaignData.mwlog.debugLog("Updating House ProtoMek: " + i);
                hsUpdates.append(this.addPP(i, 3, componentsToAdd, false));
                this.addComponentsProduced(3, componentsToAdd);
            }
            if (useBattleArmorPP) {
                CampaignData.mwlog.debugLog("Updating House BA: " + i);
                hsUpdates.append(this.addPP(i, 4, componentsToAdd, false));
                this.addComponentsProduced(4, componentsToAdd);
            }
            if (!useAeroPP) continue;
            CampaignData.mwlog.debugLog("Updating House Aero: " + i);
            hsUpdates.append(this.addPP(i, 5, componentsToAdd, false));
            this.addComponentsProduced(5, componentsToAdd);
        }
        StringBuilder mechsProduced = new StringBuilder();
        StringBuilder industrialAccidents = new StringBuilder();
        StringBuilder scrapExcuses = new StringBuilder();
        StringBuilder marketAdditions = new StringBuilder();
        CampaignData.mwlog.debugLog("Checking for Unit Overflow");
        for (type_id = 0; type_id < 6; ++type_id) {
            for (int i = 0; i <= 3; ++i) {
                while (this.remainingHangarSpaceForWeightclass(i, type_id) < 0) {
                    Vector<SUnit> v = this.getHangar(type_id).elementAt(i);
                    SUnit randUnit = v.elementAt(CampaignMain.cm.getRandomNumber(v.size()));
                    if (randUnit.getStatus() == 3) continue;
                    int bmPercent = Integer.parseInt(this.getConfig("ChanceToSendUnitToBM"));
                    if (this.maySellOnBM() && CampaignMain.cm.getRandomNumber(101) < bmPercent && SUnit.mayBeSoldOnMarket(randUnit)) {
                        int minPrice = this.getPriceForUnit(i, type_id);
                        String saleTicksString = Unit.getWeightClassDesc(randUnit.getWeightclass()) + "SaleTicks";
                        int saleTicks = Integer.parseInt(this.getConfig(saleTicksString)) + 1;
                        CampaignMain.cm.getMarket().addListing(this.getName(), randUnit, minPrice, saleTicks);
                        marketAdditions.append(StringUtils.aOrAn(randUnit.getModelName(), false) + " was added to the black market.<br>");
                        hsUpdates.append(this.getHSUnitRemovalString(randUnit));
                        randUnit.setStatus(3);
                        continue;
                    }
                    String currScrapExcuse = this.getExcuseForUnitFailure(randUnit);
                    scrapExcuses.append(currScrapExcuse + "<br>");
                    hsUpdates.append(this.removeUnit(randUnit, false));
                }
            }
        }
        if (this.getComponentConverter().size() > 0) {
            this.produceCrits();
        }
        CampaignData.mwlog.debugLog("Doing Component Overflow");
        for (type_id = 0; type_id < 6; ++type_id) {
            for (int weight = 0; weight < 4; ++weight) {
                while (this.getPP(weight, type_id) > this.getMaxAllowedPP(weight, type_id)) {
                    int randomLossFactor = CampaignMain.cm.getRandomNumber(this.getPPCost(weight, type_id)) + 1;
                    boolean accident = false;
                    SUnitFactory m = this.getNativeFactoryForProduction(type_id, weight);
                    if (CampaignMain.cm.getRandomNumber(100) + 1 <= Integer.parseInt(this.getConfig("AutoProductionFailureRate"))) {
                        accident = true;
                    }
                    if (m == null || accident) {
                        hsUpdates.append(this.addPP(weight, type_id, -randomLossFactor, false));
                        if (type_id == 2) {
                            industrialAccidents.append("a cache of " + Unit.getWeightClassDesc(weight) + " " + Unit.getTypeClassDesc(type_id) + " supplies is donated to the Salvation Army.<br>");
                            continue;
                        }
                        industrialAccidents.append("An industrial accident destroys a substantial cache of " + Unit.getWeightClassDesc(weight) + " " + Unit.getTypeClassDesc(type_id) + " components.<br>");
                        continue;
                    }
                    Vector<SUnit> newUnits = m.getMechProduced(type_id, this.getNewPilot(type_id));
                    for (SUnit newUnit : newUnits) {
                        CampaignData.mwlog.debugLog("AP Unit " + newUnit.getModelName());
                        hsUpdates.append(this.addUnit(newUnit, false));
                        hsUpdates.append(this.addPP(weight, type_id, -this.getPPCost(weight, type_id), false));
                        if (!Boolean.parseBoolean(this.getConfig("UseCalculatedCosts"))) {
                            if (m.getWeightclass() == 0) {
                                hsUpdates.append(m.addRefresh(Integer.parseInt(this.getConfig("LightRefresh")) * 100 / m.getRefreshSpeed(), false));
                            } else if (m.getWeightclass() == 1) {
                                hsUpdates.append(m.addRefresh(Integer.parseInt(this.getConfig("MediumRefresh")) * 100 / m.getRefreshSpeed(), false));
                            } else if (m.getWeightclass() == 2) {
                                hsUpdates.append(m.addRefresh(Integer.parseInt(this.getConfig("HeavyRefresh")) * 100 / m.getRefreshSpeed(), false));
                            } else if (m.getWeightclass() == 3) {
                                hsUpdates.append(m.addRefresh(Integer.parseInt(this.getConfig("AssaultRefresh")) * 100 / m.getRefreshSpeed(), false));
                            }
                        }
                        if (type_id == 2) {
                            mechsProduced.append("A militia unit [" + newUnit.getModelName() + "] from " + m.getPlanet().getName() + " activated for front line duty!<br>");
                            continue;
                        }
                        mechsProduced.append("Technicians assembled a " + newUnit.getModelName() + " at " + m.getName() + " on " + m.getPlanet().getName() + ".<br>");
                    }
                }
            }
        }
        result = result + mechsProduced.toString() + marketAdditions.toString() + industrialAccidents.toString() + scrapExcuses.toString();
        CampaignData.mwlog.debugLog("show Production Count");
        if (this.getShowProductionCountNext() - 1 <= 0) {
            this.setShowProductionCountNext(Integer.parseInt(this.getConfig("ShowComponentGainEvery")));
            int MekComponents = this.getComponentsProduced(0);
            int VehComponents = this.getComponentsProduced(1);
            int InfComponents = this.getComponentsProduced(2);
            int ProtoComponents = this.getComponentsProduced(3);
            int BAComponents = this.getComponentsProduced(4);
            int AeroComponents = this.getComponentsProduced(5);
            DecimalFormat myFormatter = new DecimalFormat("###.##");
            result = result + "<br><i><b>Your factories produced enough components to make:</b></i><br>";
            if (Boolean.parseBoolean(this.getConfig("UseMek"))) {
                result = result + myFormatter.format((double)MekComponents / Double.parseDouble(this.getConfig("LightPP"))) + " Light meks<br>";
                result = result + myFormatter.format((double)MekComponents / Double.parseDouble(this.getConfig("MediumPP"))) + " Medium meks<br>";
                result = result + myFormatter.format((double)MekComponents / Double.parseDouble(this.getConfig("HeavyPP"))) + " Heavy meks<br>";
                result = result + myFormatter.format((double)MekComponents / Double.parseDouble(this.getConfig("AssaultPP"))) + " Assault meks<br>";
            }
            if (Boolean.parseBoolean(this.getConfig("UseVehicle"))) {
                result = result + myFormatter.format((double)VehComponents / Double.parseDouble(this.getConfig("LightVehiclePP"))) + " Light vehicles<br>";
                result = result + myFormatter.format((double)VehComponents / Double.parseDouble(this.getConfig("MediumVehiclePP"))) + " Medium vehicles<br>";
                result = result + myFormatter.format((double)VehComponents / Double.parseDouble(this.getConfig("HeavyVehiclePP"))) + " Heavy vehicles<br>";
                result = result + myFormatter.format((double)VehComponents / Double.parseDouble(this.getConfig("AssaultVehiclePP"))) + " Assault vehicles<br>";
            }
            if (Boolean.parseBoolean(this.getConfig("UseInfantry"))) {
                if (Boolean.parseBoolean(this.getConfig("UseOnlyLightInfantry"))) {
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(this.getConfig("LightInfantryPP"))) + " Infantry<br>";
                } else {
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(this.getConfig("LightInfantryPP"))) + " Light infantry<br>";
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(this.getConfig("MediumInfantryPP"))) + " Medium infantry<br>";
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(this.getConfig("HeavyInfantryPP"))) + " Heavy infantry<br>";
                    result = result + myFormatter.format((double)InfComponents / Double.parseDouble(this.getConfig("AssaultInfantryPP"))) + " Assault infantry<br>";
                }
            }
            if (Boolean.parseBoolean(this.getConfig("UseProtoMek"))) {
                result = result + myFormatter.format((double)ProtoComponents / Double.parseDouble(this.getConfig("LightProtoMekPP"))) + " Light protomechs<br>";
                result = result + myFormatter.format((double)ProtoComponents / Double.parseDouble(this.getConfig("MediumProtoMekPP"))) + " Medium protomechs<br>";
                result = result + myFormatter.format((double)ProtoComponents / Double.parseDouble(this.getConfig("HeavyProtoMekPP"))) + " Heavy protomechs<br>";
                result = result + myFormatter.format((double)ProtoComponents / Double.parseDouble(this.getConfig("AssaultProtoMekPP"))) + " Assault protomechs<br>";
            }
            if (Boolean.parseBoolean(this.getConfig("UseBattleArmor"))) {
                result = result + myFormatter.format((double)BAComponents / Double.parseDouble(this.getConfig("LightBattleArmorPP"))) + " Light battle armor<br>";
                result = result + myFormatter.format((double)BAComponents / Double.parseDouble(this.getConfig("MediumBattleArmorPP"))) + " Medium battle armor<br>";
                result = result + myFormatter.format((double)BAComponents / Double.parseDouble(this.getConfig("HeavyBattleArmorPP"))) + " Heavy battle armor<br>";
                result = result + myFormatter.format((double)BAComponents / Double.parseDouble(this.getConfig("AssaultBattleArmorPP"))) + " Assault battle armor<br>";
            }
            if (Boolean.parseBoolean(this.getConfig("UseAero"))) {
                result = result + myFormatter.format((double)AeroComponents / Double.parseDouble(this.getConfig("LightAeroPP"))) + " Light aero<br>";
                result = result + myFormatter.format((double)AeroComponents / Double.parseDouble(this.getConfig("MediumAeroPP"))) + " Medium aero<br>";
                result = result + myFormatter.format((double)AeroComponents / Double.parseDouble(this.getConfig("HeavyAeroPP"))) + " Heavy aero<br>";
                result = result + myFormatter.format((double)AeroComponents / Double.parseDouble(this.getConfig("AssaultAeroPP"))) + " Assault aero<br>";
            }
            CampaignData.mwlog.debugLog("SetComponentsProduced");
            this.setComponentsProduced(0, 0);
            this.setComponentsProduced(1, 0);
            this.setComponentsProduced(2, 0);
            this.setComponentsProduced(3, 0);
            this.setComponentsProduced(4, 0);
            this.setComponentsProduced(5, 0);
        } else {
            this.addShowProductionCountNext(-1);
        }
        CampaignData.mwlog.debugLog("Send House Updates: ");
        CampaignData.mwlog.debugLog("     -> " + hsUpdates.toString());
        if (hsUpdates.length() > 0) {
            CampaignMain.cm.doSendToAllOnlinePlayers(this, "HS|" + hsUpdates.toString(), false);
        }
        CampaignData.mwlog.debugLog("returning from tick: " + this.getName());
        return result;
    }

    private String getExcuseForUnitFailure(SUnit m) {
        if (m.getType() == 0) {
            return this.scrapExcuseHelper("./data/scrapmessages/mekscrapmessages.txt", m);
        }
        if (m.getType() == 1) {
            return this.scrapExcuseHelper("./data/scrapmessages/vehiclescrapmessages.txt", m);
        }
        if (m.getType() == 3) {
            return this.scrapExcuseHelper("./data/scrapmessages/protoscrapmessages.txt", m);
        }
        if (m.getType() == 4) {
            return this.scrapExcuseHelper("./data/scrapmessages/bascrapmessages.txt", m);
        }
        if (m.getType() == 2) {
            return this.scrapExcuseHelper("./data/scrapmessages/infantryscrapmessages.txt", m);
        }
        if (m.getType() == 5) {
            return this.scrapExcuseHelper("./data/scrapmessages/aeroscrapmessages.txt", m);
        }
        return "A " + m.getModelName() + " was kidnapped by aliens from outer space";
    }

    private String scrapExcuseHelper(String filepath, SUnit unit) {
        try {
            FileInputStream fis = new FileInputStream(filepath);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            int messages = Integer.parseInt(dis.readLine());
            int id = CampaignMain.cm.getRandomNumber(messages);
            String scrapMessage = "";
            while (dis.ready()) {
                scrapMessage = dis.readLine();
                if (id <= 0) break;
                --id;
            }
            dis.close();
            fis.close();
            String scrapMessageWithPilot = scrapMessage.replaceAll("PILOT", unit.getPilot().getName());
            String scrapMessageForPlayer = scrapMessageWithPilot.replaceAll("UNIT", unit.getModelName());
            return scrapMessageForPlayer;
        }
        catch (Exception e) {
            CampaignData.mwlog.errLog("A problem occured with your " + filepath.substring(21, filepath.length()) + " file!");
            return "A " + unit.getModelName() + " was kidnapped by aliens from outer space";
        }
    }

    public int getPP(int weight, int type_id) {
        Vector<Integer> v = this.getComponents().get(type_id);
        if (v == null) {
            return 0;
        }
        Integer i = v.elementAt(weight);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public Vector<SUnitFactory> getPossibleFactoryForProduction(int type, int weight, boolean ignoreRefresh) {
        Vector<SUnitFactory> possible = new Vector<SUnitFactory>(1, 1);
        for (SPlanet p : this.Planets.values()) {
            Vector<SUnitFactory> v = p.getFactoriesOfWeighclass(weight);
            for (int i = 0; i < v.size(); ++i) {
                SUnitFactory MF = v.elementAt(i);
                if (!MF.canProduce(type) || !ignoreRefresh && MF.getTicksUntilRefresh() >= 1) continue;
                possible.add(MF);
            }
        }
        return possible;
    }

    public SUnitFactory getNativeFactoryForProduction(int type, int weight) {
        Vector<SUnitFactory> allPossible = this.getPossibleFactoryForProduction(type, weight, false);
        if (allPossible.size() == 0) {
            return null;
        }
        Vector<SUnitFactory> factionPossible = new Vector<SUnitFactory>(1, 1);
        for (SUnitFactory currFac : allPossible) {
            if (!currFac.getFounder().equalsIgnoreCase(this.getName())) continue;
            factionPossible.add(currFac);
        }
        if (factionPossible.size() == 0) {
            return null;
        }
        int rand = CampaignMain.cm.getRandomNumber(factionPossible.size());
        return (SUnitFactory)factionPossible.elementAt(rand);
    }

    public int getMaxAllowedPP(int weight, int type_id) {
        String unitAPMax = "APAtMax" + Unit.getWeightClassDesc(weight) + "Units";
        int maxUnits = Integer.parseInt(this.getConfig(unitAPMax));
        return maxUnits * this.getPPCost(weight, type_id);
    }

    public int getPPCost(int weight, int type_id) {
        int result = Integer.MAX_VALUE;
        String classtype = Unit.getWeightClassDesc(weight) + Unit.getTypeClassDesc(type_id) + "PP";
        result = type_id == 0 ? Integer.parseInt(this.getConfig(Unit.getWeightClassDesc(weight) + "PP")) : Integer.parseInt(this.getConfig(classtype));
        result += this.getHouseUnitComponentMod(type_id, weight);
        result = Math.max(1, result);
        return result;
    }

    public String addPP(int weight, int type_id, int val, boolean sendUpdate) {
        int startingPP = this.getPP(weight, type_id);
        try {
            if (!Boolean.parseBoolean(this.getConfig("ProduceComponentsWithNoFactory")) && this.getPossibleFactoryForProduction(type_id, weight, true).size() < 1 && val > 0) {
                return "";
            }
            Vector<Integer> v = this.getComponents().get(type_id);
            v.setElementAt(new Integer(v.elementAt(weight) + val), weight);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Error in addPP()");
            CampaignData.mwlog.errLog("weight: " + weight + " type: " + type_id + " value: " + val);
            Vector<Integer> v = new Vector<Integer>(4, 1);
            for (int i = 0; i < 4; ++i) {
                v.add(0);
            }
            this.getComponents().put(type_id, v);
        }
        if (startingPP == this.getPP(weight, type_id)) {
            return "";
        }
        String hsUpdate = this.getHSPPChangeString(weight, type_id);
        if (sendUpdate) {
            CampaignMain.cm.doSendToAllOnlinePlayers(this, "HS|" + hsUpdate, false);
        }
        return hsUpdate;
    }

    public SUnit getEntity(int weightclass, int type_id) {
        Vector<SUnit> s;
        try {
            s = this.getHangar(type_id).elementAt(weightclass);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Empty Vector in getEntity");
            return null;
        }
        if (s == null) {
            return null;
        }
        if (this.getNumberOfNonSaleUnits(s) > 0) {
            SUnit m = null;
            Vector<SUnit> unitsToBuy = new Vector<SUnit>(s.size(), 1);
            for (int pos = 0; pos < s.size(); ++pos) {
                m = s.elementAt(pos);
                if (m.getStatus() == 3) continue;
                unitsToBuy.add(m);
                m.setStatus(1);
            }
            unitsToBuy.trimToSize();
            int ran = CampaignMain.cm.getRandomNumber(unitsToBuy.size());
            m = (SUnit)unitsToBuy.elementAt(ran);
            s.removeElement(m);
            unitsToBuy.clear();
            return m;
        }
        return null;
    }

    private int getNumberOfNonSaleUnits(Vector<SUnit> units) {
        int count = 0;
        for (SUnit unit : units) {
            if (unit.getStatus() == 3) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isHuman() {
        return false;
    }

    @Override
    public SUnit getUnit(int unitIDtoFind) {
        for (int type_id = 0; type_id < 6; ++type_id) {
            for (int i = 0; i <= 3; ++i) {
                for (SUnit currU : this.getHangar(type_id).elementAt(i)) {
                    if (currU.getId() != unitIDtoFind) continue;
                    return currU;
                }
            }
        }
        return null;
    }

    public boolean maySellOnBM() {
        StringTokenizer blockedFactions = new StringTokenizer(this.getConfig("BMNoSell"), "$");
        while (blockedFactions.hasMoreTokens()) {
            if (!this.getName().equals(blockedFactions.nextToken())) continue;
            return false;
        }
        return true;
    }

    public boolean mayBuyFromBM() {
        StringTokenizer blockedFactions = new StringTokenizer(this.getConfig("BMNoBuy"), "$");
        while (blockedFactions.hasMoreTokens()) {
            if (!this.getName().equals(blockedFactions.nextToken())) continue;
            return false;
        }
        return true;
    }

    public SPlayer getPlayer(String s) {
        String lowerName = s.toLowerCase();
        if (this.getReservePlayers().containsKey(lowerName)) {
            return this.getReservePlayers().get(lowerName);
        }
        if (this.getActivePlayers().containsKey(lowerName)) {
            return this.getActivePlayers().get(lowerName);
        }
        if (this.getFightingPlayers().containsKey(lowerName)) {
            return this.getFightingPlayers().get(lowerName);
        }
        return null;
    }

    public int getPriceForUnit(int weightclass, int type_id) {
        int result = Integer.MAX_VALUE;
        String classtype = Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(type_id) + "Price";
        if (Boolean.parseBoolean(this.getConfig("UseCalculatedCosts"))) {
            double cost = 0.0;
            if (type_id == 0) {
                cost = CampaignMain.cm.getUnitCostLists().getMinCostValue(weightclass, type_id);
                cost = Math.max(cost, this.getDoubleConfig(Unit.getWeightClassDesc(weightclass) + "Price"));
            } else if (type_id == 1) {
                cost = CampaignMain.cm.getUnitCostLists().getMinCostValue(weightclass, type_id);
                cost = Math.max(cost, this.getDoubleConfig(classtype));
            } else {
                cost = CampaignMain.cm.getUnitCostLists().getMinCostValue(0, type_id);
                cost = Math.max(cost, this.getDoubleConfig(classtype));
            }
            result = (int)(cost * Double.valueOf(this.getConfig("CostModifier")));
            return result;
        }
        result = type_id == 0 ? Integer.parseInt(this.getConfig(Unit.getWeightClassDesc(weightclass) + "Price")) : Integer.parseInt(this.getConfig(classtype));
        if ((result += this.getHouseUnitPriceMod(type_id, weightclass)) < 0) {
            result = 0;
        }
        return result;
    }

    public int getInfluenceForUnit(int weightclass, int type_id) {
        int result = Integer.MAX_VALUE;
        String classtype = Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(type_id) + "Inf";
        result = type_id == 0 ? Integer.parseInt(this.getConfig(Unit.getWeightClassDesc(weightclass) + "Inf")) : Integer.parseInt(this.getConfig(classtype));
        if ((result += this.getHouseUnitFluMod(type_id, weightclass)) < 0) {
            result = 0;
        }
        return result;
    }

    private void parseSupportFile(String fileName, boolean addUnits) {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            while (dis.ready()) {
                if (addUnits) {
                    this.addUnitSupported(dis.readLine(), true);
                    continue;
                }
                this.removeUnitSupported(dis.readLine(), true);
            }
            dis.close();
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            CampaignData.mwlog.mainLog("FNFE!!!!");
        }
        catch (IOException ioe) {
            CampaignData.mwlog.mainLog("IOE!!!");
        }
    }

    public void addUnitSupported(String fileName, boolean sendMail) {
        if (fileName.trim().length() < 1) {
            return;
        }
        fileName = fileName.trim();
        StringBuilder toReturn = new StringBuilder();
        if (this.houseSupportsUnit(fileName)) {
            int num = this.getSupportedUnits().get(fileName);
            this.supportedUnits.put(fileName, num + 1);
        } else {
            this.supportedUnits.put(fileName, 1);
            toReturn.append(fileName);
        }
        if (toReturn.length() == 0) {
            return;
        }
        CampaignMain.cm.doSendToAllOnlinePlayers(this, "PL|USU||true|" + fileName, false);
        CampaignMain.cm.doSendHouseMail(this, "NOTE", "The faction is now able to support the " + toReturn.toString());
    }

    public void removeUnitSupported(String fileName, boolean sendMail) {
        if (fileName.trim().length() < 1) {
            return;
        }
        fileName = fileName.trim();
        StringBuilder toReturn = new StringBuilder();
        if (this.houseSupportsUnit(fileName)) {
            int num = (Integer)this.supportedUnits.get(fileName);
            if (num == 1) {
                this.supportedUnits.remove(fileName);
                toReturn.append(fileName);
            } else {
                this.supportedUnits.put(fileName, num - 1);
            }
        } else {
            CampaignData.mwlog.mainLog("Error in House.removeUnitProduction(): trying to remove a unit that is not produced.");
            CampaignData.mwlog.mainLog("  --> House: " + this.getName() + ", Unit: " + fileName);
        }
        if (toReturn.length() == 0) {
            return;
        }
        CampaignMain.cm.doSendToAllOnlinePlayers(this, "PL|USU||false|" + fileName, false);
        CampaignMain.cm.doSendHouseMail(this, "NOTE", "The faction has lost the ability to support the following units: " + toReturn.toString());
    }

    public void addPlanet(SPlanet p) {
        if (this.getPlanets().get(p.getName()) == null) {
            this.getPlanets().put(p.getName(), p);
            this.setBaysProvided(this.getBaysProvided() + p.getBaysProvided());
            this.setComponentProduction(this.getComponentProduction() + p.getCompProduction());
            if (CampaignMain.cm.isUsingIncreasedTechs() && p.getFactoryCount() > 0) {
                this.modifyUnitSupport(p, true);
            }
        }
    }

    public void removePlanet(SPlanet p) {
        if (this.getPlanets().get(p.getName()) != null) {
            this.getPlanets().remove(p.getName());
            this.setBaysProvided(this.getBaysProvided() - p.getBaysProvided());
            this.setComponentProduction(this.getComponentProduction() - p.getCompProduction());
            if (CampaignMain.cm.isUsingIncreasedTechs() && p.getFactoryCount() > 0) {
                this.modifyUnitSupport(p, false);
            }
        }
    }

    public void transferMoney(SPlayer p, int amount) {
        if (p != null) {
            p.addMoney(amount);
            this.setMoney(this.getMoney() - amount);
        }
    }

    @Override
    public String removeUnit(SUnit unitToRemove, boolean sendUpdate) {
        Vector<SUnit> Weightclass = this.getHangar(unitToRemove.getType()).elementAt(unitToRemove.getWeightclass());
        Weightclass.remove(unitToRemove);
        String hsUpdate = this.getHSUnitRemovalString(unitToRemove);
        if (sendUpdate) {
            CampaignMain.cm.doSendToAllOnlinePlayers(this, "HS|" + hsUpdate, false);
        }
        return hsUpdate;
    }

    @Override
    public String addUnit(SUnit unit, boolean isNew, boolean sendUpdate) {
        return this.addUnit(unit, sendUpdate);
    }

    public String addUnit(SUnit unit, boolean sendUpdate) {
        Vector<SUnit> weightClass;
        if (Boolean.parseBoolean(this.getConfig("AllowPersonalPilotQueues")) && unit.isSinglePilotUnit() && !unit.hasVacantPilot()) {
            this.getPilotQueues().addPilot(unit.getType(), (SPilot)unit.getPilot());
            unit.setPilot(new SPilot("Vacant", 99, 99));
        }
        if (Boolean.parseBoolean(this.getConfig("UseOnlyOneVehicleSize")) && unit.getType() == 1) {
            unit.setWeightclass(0);
        }
        if ((weightClass = this.getHangar(unit.getType()).elementAt(unit.getWeightclass())).contains(unit)) {
            return "";
        }
        if (CampaignMain.cm.isUsingMySQL()) {
            if (unit.getDBId() == 0) {
                unit.toDB();
            }
            CampaignMain.cm.MySQL.linkUnitToFaction(unit.getDBId(), this.getDBId());
        }
        weightClass.add(unit);
        String hsUpdate = this.getHSUnitAdditionString(unit);
        if (sendUpdate) {
            CampaignMain.cm.doSendToAllOnlinePlayers(this, "HS|" + hsUpdate, false);
        }
        return hsUpdate;
    }

    protected String doLogin(SPlayer p) {
        String realName = p.getName();
        String lowerName = realName.toLowerCase();
        CampaignMain.cm.releaseLostSoul(p.getName());
        if (this.isLoggedIntoFaction(lowerName)) {
            CampaignMain.cm.toUser("CS|2", realName, false);
            return null;
        }
        if (p.getPassword() == null) {
            if (this.isLeader(p.getName())) {
                this.removeLeader(p.getName());
            }
        } else if (this.isLeader(p.getName()) && p.getPassword().getAccess() < CampaignMain.cm.getIntegerConfig("factionLeaderLevel")) {
            CampaignMain.cm.updatePlayersAccessLevel(p.getName(), CampaignMain.cm.getIntegerConfig("factionLeaderLevel"));
        } else if (p.getPassword().getAccess() == CampaignMain.cm.getIntegerConfig("factionLeaderLevel") && !this.isLeader(p.getName())) {
            CampaignMain.cm.updatePlayersAccessLevel(p.getName(), 2);
        }
        CampaignMain.cm.toUser("PL|SH|" + this.getName(), realName, false);
        CampaignMain.cm.toUser("PL|SSN|" + p.getSubFactionName(), realName, false);
        Date d = new Date(System.currentTimeMillis());
        CampaignData.mwlog.mainLog(d + ":" + "User Logged into House: " + realName);
        CampaignMain.cm.toUser("GO|" + CampaignMain.cm.getMegaMekOptionsToString(), realName, false);
        this.reservePlayers.remove(lowerName);
        this.activePlayers.remove(lowerName);
        this.fightingPlayers.remove(lowerName);
        this.getReservePlayers().put(lowerName, p);
        p.setLastSentStatus("");
        CampaignMain.cm.toUser("CS|2", realName, false);
        CampaignMain.cm.toUser("PL|PPQ|" + p.getPersonalPilotQueue().toString(true), realName, false);
        CampaignMain.cm.toUser("PL|AEU|" + p.getExclusionList().adminExcludeToString("$"), realName, false);
        CampaignMain.cm.toUser("PL|PEU|" + p.getExclusionList().playerExcludeToString("$"), realName, false);
        CampaignMain.cm.getIThread().removeImmunity(p);
        Command c = CampaignMain.cm.getServerCommands().get("MOTD");
        c.process(new StringTokenizer("", ""), realName);
        CampaignMain.cm.getMarket().sendCompleteMarketStatus(p);
        CampaignMain.cm.toUser("HS|CA|0", realName, false);
        CampaignMain.cm.toUser(this.getCompleteStatus(), realName, false);
        CampaignMain.cm.getPartsMarket().updatePartsBlackMarketPlayer(p);
        SmallPlayer smallp = this.SmallPlayers.get(lowerName);
        if (smallp == null) {
            smallp = new SmallPlayer(p.getExperience(), p.getLastOnline(), p.getRating(), realName, p.getFluffText(), this);
            this.SmallPlayers.put(lowerName, smallp);
        }
        if (CampaignMain.cm.isUsingIncreasedTechs()) {
            CampaignMain.cm.toUser("PL|CSU|0", realName, false);
            StringBuilder toSend = new StringBuilder();
            toSend.append("PL|USU|");
            int num = 0;
            for (String unitName : this.getSupportedUnits().keySet()) {
                for (num = this.getSupportedUnits().get(unitName).intValue(); num > 0; --num) {
                    toSend.append("true|");
                    toSend.append(unitName + "|");
                }
            }
            CampaignMain.cm.toUser(toSend.toString(), realName, false);
        }
        if (CampaignMain.cm.isSynchingBB() && p.getForumID() < 1) {
            CampaignMain.cm.doSendModMail("NOTE", p.getName() + " does not have a valid forum account.");
        }
        if (this.isLeader(p.getName()) && CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
            Command cmd = CampaignMain.cm.getServerCommands().get("GETCOMPONENTCONVERSION");
            cmd.process(new StringTokenizer("", "#"), p.getName());
        }
        p.setLastOnline(System.currentTimeMillis());
        return "<b>[*] Logged into " + this.getColoredNameAsLink() + ".</b>";
    }

    protected void doLogout(SPlayer p) {
        String realName = p.getName();
        String lowerName = realName.toLowerCase();
        if (!this.isLoggedIntoFaction(lowerName)) {
            return;
        }
        p.setActive(false);
        this.reservePlayers.remove(lowerName);
        this.activePlayers.remove(lowerName);
        this.fightingPlayers.remove(lowerName);
        CampaignMain.cm.forceSavePlayer(p);
        Date d = new Date(System.currentTimeMillis());
        CampaignData.mwlog.mainLog(d + ":" + "User Logged out: " + realName);
        CampaignMain.cm.toUser("CS|1", realName, false);
    }

    public void removePlayer(SPlayer p, boolean donateMechs) {
        if (p == null) {
            return;
        }
        this.doLogout(p);
        this.removeLeader(p.getName());
        if (this.isNewbieHouse()) {
            donateMechs = false;
        }
        if (donateMechs) {
            StringBuilder hsUpdates = new StringBuilder();
            boolean allowDamagedUnits = CampaignMain.cm.isUsingAdvanceRepair() && Boolean.parseBoolean(this.getConfig("AllowDonatingOfDamagedUnits"));
            for (SUnit currUnit : p.getUnits()) {
                boolean damaged;
                boolean bl = damaged = !UnitUtils.canStartUp(currUnit.getEntity()) || UnitUtils.hasArmorDamage(currUnit.getEntity()) || UnitUtils.hasCriticalDamage(currUnit.getEntity());
                if ((!damaged || !allowDamagedUnits) && damaged) continue;
                hsUpdates.append(this.addUnit(currUnit, false));
            }
            if (hsUpdates.length() > 0) {
                CampaignMain.cm.doSendToAllOnlinePlayers(this, "HS|" + hsUpdates.toString(), false);
            }
        }
        CampaignMain.cm.getVoteManager().removeAllVotesByPlayer(p);
        CampaignMain.cm.getVoteManager().removeAllVotesForPlayer(p);
        p.getMyHouse().getSmallPlayers().remove(p.getName().toLowerCase());
    }

    public int getDistanceTo(SPlanet p, SPlayer player) {
        if (p.getInfluence().getInfluence(this.getId()) > 10) {
            return 0;
        }
        double distSq = 2.147483647E9;
        for (SPlanet sPlanet : CampaignMain.cm.getData().getAllPlanets()) {
            double tdist;
            if (sPlanet.getInfluence().getInfluence(this.getId()) < 25 || !((tdist = sPlanet.getPosition().distanceSq(p.getPosition())) < distSq)) continue;
            distSq = tdist;
        }
        return (int)distSq;
    }

    public String getCompleteStatus() {
        String cmdDelim = "|";
        String internalDelim = "$";
        StringBuilder result = new StringBuilder();
        result.append("HS|FN|" + this.getName() + cmdDelim);
        for (int type_id = 0; type_id < 6; ++type_id) {
            for (int weight = 0; weight <= 3; ++weight) {
                result.append(this.getHSPPChangeString(weight, type_id));
            }
        }
        for (SPlanet currPlanet : this.getPlanets().values()) {
            if (!this.equals(currPlanet.getOwner())) continue;
            for (int i = 0; i < currPlanet.getUnitFactories().size(); ++i) {
                SUnitFactory currFactory = (SUnitFactory)currPlanet.getUnitFactories().get(i);
                result.append("AF" + cmdDelim);
                result.append(currFactory.getWeightclass() + internalDelim);
                result.append(currFactory.getType() + internalDelim);
                result.append(currFactory.getFounder() + internalDelim);
                result.append(currFactory.getPlanet().getName() + internalDelim);
                result.append(currFactory.getName() + internalDelim);
                result.append(currFactory.getTicksUntilRefresh() + internalDelim);
                result.append(currFactory.getAccessLevel() + internalDelim);
                result.append(cmdDelim);
            }
        }
        for (int type_id = 0; type_id < 6; ++type_id) {
            for (int weight = 0; weight <= 3; ++weight) {
                Vector<SUnit> unitSet = this.getHangar(type_id).elementAt(weight);
                for (SUnit currU : unitSet) {
                    if (currU.getStatus() == 3) continue;
                    result.append(this.getHSUnitAdditionString(currU));
                }
            }
        }
        return result.toString();
    }

    public String getHSUnitAdditionString(SUnit u) {
        StringBuilder result = new StringBuilder();
        result.append("AU|");
        result.append(u.getWeightclass());
        result.append("$");
        result.append(u.getType());
        result.append("$");
        Entity currE = u.getEntity();
        result.append(u.getUnitFilename());
        result.append("$");
        result.append(u.getId());
        if (!u.hasVacantPilot()) {
            result.append("$");
            result.append(u.getPilot().getGunnery());
            result.append("$");
            result.append(u.getPilot().getPiloting());
        } else {
            result.append("$");
            result.append(this.getBaseGunner(u.getType()));
            result.append("$");
            result.append(this.getBasePilot(u.getType()));
        }
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            result.append("$" + UnitUtils.unitBattleDamage(currE));
        }
        result.append("|");
        return result.toString();
    }

    public String getHSPPChangeString(int weight, int type_id) {
        StringBuilder result = new StringBuilder();
        int costPerUnit = Math.max(1, this.getPPCost(weight, type_id));
        int currentPP = this.getPP(weight, type_id);
        result.append("CC|");
        result.append(weight + "$" + type_id + "$");
        result.append(currentPP + "$" + currentPP / costPerUnit);
        result.append("|");
        return result.toString();
    }

    public String getHSUnitRemovalString(SUnit u) {
        StringBuilder result = new StringBuilder();
        result.append("RU|");
        result.append(u.getWeightclass() + "$" + u.getType() + "$");
        result.append(u.getId());
        result.append("|");
        return result.toString();
    }

    @Override
    public int getMoney() {
        return this.Money;
    }

    public String getColoredName() {
        return "<font color=\"" + this.getHouseColor() + "\">" + this.getName() + "</font>";
    }

    public String getColoredNameAsLink() {
        return "<font color=\"" + this.getHouseColor() + "\">" + this.getNameAsLink() + "</font>";
    }

    public String getColoredAbbreviation(boolean includeBrackets) {
        String toReturn = "<font color=\"" + this.getHouseColor() + "\">";
        if (includeBrackets) {
            toReturn = toReturn + "[";
        }
        toReturn = toReturn + this.getAbbreviation();
        if (includeBrackets) {
            toReturn = toReturn + "]";
        }
        toReturn = toReturn + "</font>";
        return toReturn;
    }

    public ConcurrentHashMap<String, SPlanet> getPlanets() {
        return this.Planets;
    }

    public void setMoney(int newMoney) {
        this.Money = newMoney;
    }

    public int getComponentsProduced(int unitType) {
        if (!this.unitComponents.containsKey(unitType)) {
            return 0;
        }
        int component = this.unitComponents.get(unitType);
        return component;
    }

    public int getShowProductionCountNext() {
        return this.showProductionCountNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, SmallPlayer> getSmallPlayers() {
        Hashtable<String, SmallPlayer> hashtable = this.SmallPlayers;
        synchronized (hashtable) {
            return this.SmallPlayers;
        }
    }

    @Override
    public int compareTo(Object o) {
        SHouse h = (SHouse)o;
        if (this.getMoney() > h.getMoney()) {
            return 1;
        }
        if (this.getMoney() < h.getMoney()) {
            return -1;
        }
        return this.getName().compareTo(h.getName());
    }

    @Override
    public void addMoney(int amount) {
        this.setMoney(this.getMoney() + amount);
    }

    public void addComponentsProduced(int unitType, int amount) {
        this.setComponentsProduced(unitType, this.getComponentsProduced(unitType) + amount);
    }

    public void addShowProductionCountNext(int amount) {
        this.setShowProductionCountNext(this.getShowProductionCountNext() + amount);
    }

    public Hashtable<String, SPlayer> getAllOnlinePlayers() {
        Hashtable<String, SPlayer> allPlayers = new Hashtable<String, SPlayer>();
        allPlayers.putAll(this.getReservePlayers());
        allPlayers.putAll(this.getActivePlayers());
        allPlayers.putAll(this.getFightingPlayers());
        return allPlayers;
    }

    public void setBaysProvided(int baysProvided) {
        this.BaysProvided = baysProvided;
    }

    public void setComponentProduction(int componentProduction) {
        this.ComponentProduction = componentProduction;
    }

    public void setComponentsProduced(int unitType, int components) {
        this.unitComponents.put(unitType, components);
    }

    public void setShowProductionCountNext(int i) {
        this.showProductionCountNext = i;
    }

    public int getInitialHouseRanking() {
        return this.initialHouseRanking;
    }

    public void setInitialHouseRanking(int initialHouseRanking) {
        this.initialHouseRanking = initialHouseRanking;
    }

    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String motd) {
        this.motd = motd;
    }

    public boolean isInHouseAttacks() {
        return this.inHouseAttacks;
    }

    public void setInHouseAttacks(boolean inHouseAttacks) {
        this.inHouseAttacks = inHouseAttacks;
    }

    public float getHighestUnitCost(int weight, int type) {
        Vector<SUnit> s;
        float cost = 0.0f;
        try {
            s = this.getHangar(type).elementAt(weight);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Empty Vector in getHighestUnitCost");
            return Float.MAX_VALUE;
        }
        if (s == null) {
            return Float.MAX_VALUE;
        }
        for (SUnit unit : s) {
            if (!(unit.getEntity().getCost() > (double)cost)) continue;
            cost = (float)unit.getEntity().getCost();
        }
        return cost;
    }

    public Properties getConfig() {
        return this.config;
    }

    public boolean getBooleanConfig(String key) {
        try {
            return Boolean.parseBoolean(this.getConfig(key));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int getIntegerConfig(String key) {
        try {
            return Integer.parseInt(this.getConfig(key));
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public double getDoubleConfig(String key) {
        try {
            return Double.parseDouble(this.getConfig(key));
        }
        catch (Exception ex) {
            return -1.0;
        }
    }

    public float getFloatConfig(String key) {
        try {
            return Float.parseFloat(this.getConfig(key));
        }
        catch (Exception ex) {
            return -1.0f;
        }
    }

    public float getLongConfig(String key) {
        try {
            return Long.parseLong(this.getConfig(key));
        }
        catch (Exception ex) {
            return -1.0f;
        }
    }

    public String getConfig(String key) {
        if (this.config == null || this.config.getProperty(key) == null) {
            return CampaignMain.cm.getConfig(key);
        }
        return this.config.getProperty(key).trim();
    }

    public void saveConfigFile() {
        if (this.config == null) {
            return;
        }
        if (this.config.size() < 1) {
            this.config = null;
            return;
        }
        String fileName = "./data/" + this.getName().toLowerCase() + "_configs.dat";
        try {
            this.config.setProperty("TIMESTAMP", Long.toString(System.currentTimeMillis()));
            PrintStream ps = new PrintStream(new FileOutputStream(fileName));
            this.config.store(ps, "Faction Config");
            ps.close();
        }
        catch (FileNotFoundException fe) {
            CampaignData.mwlog.errLog(fileName + " not found");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void saveConfigFileToDB() {
        if (this.config == null) {
            return;
        }
        if (this.config.size() < 1) {
            this.config = null;
            return;
        }
        int dbId = this.getDBId();
        PreparedStatement ps = null;
        try {
            ps = CampaignMain.cm.MySQL.getPreparedStatement("DELETE from faction_configs WHERE factionID = " + dbId);
            ps.executeUpdate();
            this.config.setProperty("TIMESTAMP", Long.toString(System.currentTimeMillis()));
            Enumeration<Object> e = this.config.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = this.config.getProperty(key);
                String sql = "INSERT into faction_configs SET factionID = " + dbId + ", configKey = ?, configValue = ?";
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql);
                ps.setString(1, key);
                ps.setString(2, val);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in SHouse.saveConfigFileToDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void loadConfigFile() {
        File configFile = new File("./data/" + this.getName().toLowerCase() + "_configs.dat");
        if (!configFile.exists()) {
            return;
        }
        try {
            this.config = new Properties();
            this.config.load(new FileInputStream(configFile));
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void loadConfigFileFromDB() {
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = CampaignMain.cm.MySQL.getStatement();
            rs = stmt.executeQuery("SELECT configKey, configValue from faction_configs WHERE factionID = " + this.getDBId());
            boolean configCreated = false;
            while (rs.next()) {
                if (!configCreated) {
                    this.config = new Properties();
                    configCreated = true;
                }
                this.config.setProperty(rs.getString("configKey"), rs.getString("configValue"));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in SHouse.loadConfigFileFromDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void setForumName(String name) {
        this.forumName = name;
    }

    public String getForumName() {
        return this.forumName;
    }

    public void sendMessageToHouseLeaders(String msg) {
        if (this.leaders.size() < 1) {
            return;
        }
        for (String name : this.leaders) {
            CampaignMain.cm.toUser(msg, name);
        }
    }

    public void addLeader(String leader) {
        this.leaders.add(leader.toLowerCase());
    }

    public void removeLeader(String leader) {
        this.leaders.remove(leader.toLowerCase());
    }

    public boolean isLeader(String leader) {
        return this.leaders.contains(leader.toLowerCase());
    }

    public String getZeroLevelSubFaction() {
        if (this.getSubFactionList().size() < 1) {
            return "";
        }
        for (SubFaction subFac : this.getSubFactionList().values()) {
            if (Integer.parseInt(subFac.getConfig("AccessLevel")) != 0) continue;
            return subFac.getConfig("Name");
        }
        return "";
    }

    public void addCommonUnitSupport() {
        this.parseSupportFile("./campaign/factions/support/common_meks.txt", true);
        this.parseSupportFile("./campaign/factions/support/common_vehicles.txt", true);
        this.parseSupportFile("./campaign/factions/support/common_infantry.txt", true);
        this.parseSupportFile("./campaign/factions/support/common_battlearmor.txt", true);
        this.parseSupportFile("./campaign/factions/support/common_protomeks.txt", true);
        this.parseSupportFile("./campaign/factions/support/common_aero.txt", true);
    }

    private void modifyUnitSupport(SPlanet p, boolean addProduction) {
        if (p.getFactoryCount() > 0) {
            for (int weightclass = 0; weightclass <= 3; ++weightclass) {
                for (SUnitFactory uf : p.getFactoriesOfWeighclass(weightclass)) {
                    String typeString = uf.getTypeString();
                    String dirName = "./campaign/factions/support/" + uf.getFounder() + "_" + uf.getSize() + "_";
                    dirName = dirName.toLowerCase();
                    if (typeString.contains("M")) {
                        this.parseSupportFile(dirName + "meks.txt", addProduction);
                    }
                    if (typeString.contains("V")) {
                        this.parseSupportFile(dirName + "vehicles.txt", addProduction);
                    }
                    if (typeString.contains("I")) {
                        this.parseSupportFile(dirName + "infantry.txt", addProduction);
                    }
                    if (typeString.contains("P")) {
                        this.parseSupportFile(dirName + "protomeks.txt", addProduction);
                    }
                    if (typeString.contains("B")) {
                        this.parseSupportFile(dirName + "battlearmor.txt", addProduction);
                    }
                    if (!typeString.contains("A")) continue;
                    this.parseSupportFile(dirName + "aero.txt", addProduction);
                }
            }
        }
    }

    public int getForumID() {
        if (this.forumID > 0) {
            return this.forumID;
        }
        if (!CampaignMain.cm.isSynchingBB()) {
            return 0;
        }
        this.forumID = CampaignMain.cm.MySQL.getHouseForumID(this.getForumName());
        return this.forumID;
    }

    public void setForumID(int fID) {
        this.forumID = fID;
    }

    public void createNoneHouse() {
        int i;
        this.setName("None");
        this.setId(-1);
        this.setConquerable(false);
        this.setHouseDefectionTo(false);
        this.setHouseDefectionFrom(false);
        this.setAbbreviation("None");
        this.setHouseColor(CampaignMain.cm.getConfig("DisputedPlanetColor"));
        this.setHousePlayerColors(CampaignMain.cm.getConfig("DisputedPlanetColor"));
        CampaignData.mwlog.createFactionLogger(this.getName());
        for (int j = 0; j < 5; ++j) {
            Vector<Integer> v = new Vector<Integer>();
            for (int i2 = 0; i2 < 4; ++i2) {
                v.add(0);
            }
            v.trimToSize();
            this.getComponents().put(j, v);
        }
        this.setMoney(0);
        this.getHangar().put(0, new Vector(1, 1));
        this.getHangar().put(1, new Vector(1, 1));
        this.getHangar().put(2, new Vector(1, 1));
        this.getHangar().put(3, new Vector(1, 1));
        this.getHangar().put(4, new Vector(1, 1));
        this.getHangar().put(5, new Vector(1, 1));
        for (i = 0; i < 4; ++i) {
            this.getHangar(0).add(new Vector(1, 1));
            this.getHangar(1).add(new Vector(1, 1));
            this.getHangar(2).add(new Vector(1, 1));
            this.getHangar(3).add(new Vector(1, 1));
            this.getHangar(4).add(new Vector(1, 1));
            this.getHangar(5).add(new Vector(1, 1));
        }
        this.getComponents().put(0, new Vector(4, 1));
        this.getComponents().put(1, new Vector(4, 1));
        this.getComponents().put(2, new Vector(4, 1));
        this.getComponents().put(4, new Vector(4, 1));
        this.getComponents().put(3, new Vector(4, 1));
        this.getComponents().put(5, new Vector(4, 1));
        for (i = 0; i < 4; ++i) {
            this.getComponents().get(0).add(0);
            this.getComponents().get(1).add(0);
            this.getComponents().get(2).add(0);
            this.getComponents().get(4).add(0);
            this.getComponents().get(3).add(0);
            this.getComponents().get(5).add(0);
        }
        this.updated();
    }

    public void addTechResearchPoint(int points) {
        this.setTechResearchPoints(points + this.getTechResearchPoints());
    }

    public void setTechResearchPoints(int points) {
        this.techResearchPoints = points;
    }

    public int getTechResearchPoints() {
        return this.techResearchPoints;
    }

    public int getTechResearchLevel() {
        return this.getTechResearchLevel(this.getTechLevel());
    }

    public int getTechResearchLevel(int tech) {
        int techLevel = 1;
        switch (tech) {
            case 0: 
            case 1: 
            case 4: {
                techLevel = 1;
                break;
            }
            case 5: {
                techLevel = 2;
                break;
            }
            case 7: {
                techLevel = 3;
                break;
            }
            case 9: {
                techLevel = 4;
                break;
            }
            case 2: {
                techLevel = 5;
                break;
            }
            case 6: {
                techLevel = 6;
                break;
            }
            case 8: {
                techLevel = 7;
                break;
            }
            case 10: {
                techLevel = 8;
                break;
            }
            case -2: 
            case 11: {
                techLevel = 9;
                break;
            }
            default: {
                techLevel = 1;
            }
        }
        return techLevel;
    }

    public void updateHouseTechLevel() {
        switch (this.getTechResearchLevel()) {
            case 1: {
                this.setTechLevel(3);
                break;
            }
            case 2: {
                this.setTechLevel(5);
                break;
            }
            case 3: {
                this.setTechLevel(7);
                break;
            }
            case 4: {
                this.setTechLevel(9);
                break;
            }
            case 5: {
                this.setTechLevel(2);
                break;
            }
            case 6: {
                this.setTechLevel(6);
                break;
            }
            case 7: {
                this.setTechLevel(8);
                break;
            }
            case 8: {
                this.setTechLevel(10);
                break;
            }
            case 9: {
                this.setTechLevel(11);
                break;
            }
            default: {
                this.setTechLevel(3);
            }
        }
        this.techResearchPoints = 0;
    }

    public UnitComponents getUnitParts() {
        return this.unitParts;
    }

    public void updatePartsCache(String part, int amount) {
        if (amount < 0) {
            this.getUnitParts().remove(part, amount);
        } else {
            this.getUnitParts().add(part, amount);
        }
    }

    public int getPartsAmount(String part) {
        int amount = 0;
        return amount += this.getUnitParts().getPartsCritCount(part);
    }

    public void addComponentConverter(ComponentToCritsConverter converter) {
        this.componentConverter.put(converter.getCritName(), converter);
    }

    public Hashtable<String, ComponentToCritsConverter> getComponentConverter() {
        return this.componentConverter;
    }

    private void produceCrits() {
        if (!CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
            return;
        }
        boolean cacheUpdate = false;
        double baseCost = CampaignMain.cm.getDoubleConfig("BaseComponentToMoneyRatio");
        if (this.getComponentConverter().containsKey("All")) {
            ComponentToCritsConverter converter = this.getComponentConverter().get("All");
            int minCrits = converter.getMinCritLevel();
            baseCost *= CampaignMain.cm.getDoubleConfig("ComponentToPartsModifier" + SUnit.getTypeClassDesc(converter.getComponentUsedType()));
            baseCost *= CampaignMain.cm.getDoubleConfig("ComponentToPartsModifier" + SUnit.getWeightClassDesc(converter.getComponentUsedWeight()));
            for (BMEquipment eq : CampaignMain.cm.getPartsMarket().getEquipmentList().values()) {
                if (eq.getCost() <= 0.0) continue;
                if (!CampaignMain.cm.getBooleanConfig("AllowCrossOverTech")) {
                    eq.getTech();
                    if (eq.getTechLevel() != 11 && eq.getTechLevel() > this.getTechLevel()) continue;
                }
                if (this.getPartsAmount(eq.getEquipmentInternalName()) >= minCrits) continue;
                int critsToAdd = minCrits - this.getPartsAmount(eq.getEquipmentInternalName());
                double costInComponents = eq.getCost() / baseCost;
                double components = (double)critsToAdd * costInComponents;
                components = Math.ceil(components);
                components = Math.max(1.0, components);
                if ((double)this.getComponents().get(converter.getComponentUsedType()).get(converter.getComponentUsedWeight()).intValue() < components) continue;
                this.addPP(converter.getComponentUsedWeight(), converter.getComponentUsedType(), (int)(-components), false);
                this.updatePartsCache(eq.getEquipmentInternalName(), critsToAdd);
                cacheUpdate = true;
            }
        } else {
            for (ComponentToCritsConverter converter : this.getComponentConverter().values()) {
                int minCrits = converter.getMinCritLevel();
                baseCost = CampaignMain.cm.getDoubleConfig("BaseComponentToMoneyRatio");
                baseCost *= CampaignMain.cm.getDoubleConfig("ComponentToPartsModifier" + SUnit.getTypeClassDesc(converter.getComponentUsedType()));
                baseCost *= CampaignMain.cm.getDoubleConfig("ComponentToPartsModifier" + SUnit.getWeightClassDesc(converter.getComponentUsedWeight()));
                BMEquipment eq = CampaignMain.cm.getPartsMarket().getEquipmentList().get(converter.getCritName());
                if (eq == null || eq.getCost() <= 0.0) continue;
                if (!CampaignMain.cm.getBooleanConfig("AllowCrossOverTech")) {
                    eq.getTech();
                    if (eq.getTechLevel() != 11 && eq.getTechLevel() > this.getTechLevel()) continue;
                }
                if (this.getPartsAmount(eq.getEquipmentInternalName()) >= minCrits) continue;
                int critsToAdd = minCrits - this.getPartsAmount(eq.getEquipmentInternalName());
                double costInComponents = eq.getCost() / baseCost;
                double components = (double)critsToAdd * costInComponents;
                components = Math.ceil(components);
                components = Math.max(1.0, components);
                if ((double)this.getComponents().get(converter.getComponentUsedType()).get(converter.getComponentUsedWeight()).intValue() < components) continue;
                this.addPP(converter.getComponentUsedWeight(), converter.getComponentUsedType(), (int)(-components), false);
                this.updatePartsCache(eq.getEquipmentInternalName(), critsToAdd);
                cacheUpdate = true;
            }
        }
        if (cacheUpdate) {
            CampaignMain.cm.doSendHouseMail(this, "NOTE", "The house crits have been updated");
            CampaignMain.cm.doSendToAllOnlinePlayers(this, this.getCompleteStatus(), false);
        }
    }
}

