/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import common.Unit;
import common.campaign.pilot.Pilot;
import common.util.TokenReader;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.pilot.SPilot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPersonalPilotQueues
implements Serializable {
    private static final long serialVersionUID = 8106810403277431436L;
    private Vector<LinkedList<Pilot>> mekPilots = new Vector(4, 1);
    private Vector<LinkedList<Pilot>> protoPilots = new Vector(4, 1);
    private Vector<LinkedList<Pilot>> aeroPilots = new Vector(4, 1);
    private int playerID = 0;

    public SPersonalPilotQueues() {
        for (int i = 0; i <= 3; ++i) {
            this.mekPilots.add(i, new LinkedList());
            this.protoPilots.add(i, new LinkedList());
            this.aeroPilots.add(i, new LinkedList());
        }
    }

    private Vector<LinkedList<Pilot>> getUnitTypeQueue(int typeToGet) {
        if (typeToGet == 3) {
            return this.protoPilots;
        }
        if (typeToGet == 5) {
            return this.aeroPilots;
        }
        return this.mekPilots;
    }

    public void addPilot(Pilot p, int type, int weightClass) {
        p.setUnitType(type);
        this.addPilot(p, weightClass);
    }

    public void setOwnerID(int ID) {
        this.playerID = ID;
    }

    public int getOwnerID() {
        return this.playerID;
    }

    public void addPilot(Pilot p, int weightClass) {
        if (p.getName().trim().equalsIgnoreCase("Vacant")) {
            p = null;
            return;
        }
        this.getUnitTypeQueue(p.getUnitType()).get(weightClass).addLast(p);
        if (CampaignMain.cm.isUsingMySQL()) {
            int type = p.getUnitType();
            ((SPilot)p).toDB(type, weightClass);
        }
    }

    public void checkQueueAndWarn(String playerName, int unitType, int weightClass) {
        int size = this.getPilotQueue(unitType, weightClass).size();
        if (size > CampaignMain.cm.getIntegerConfig("MaxAllowedPilotsInQueueToBuyFromHouse")) {
            CampaignMain.cm.toUser("WARNING: You have more " + Unit.getWeightClassDesc(weightClass) + " " + Unit.getTypeClassDesc(unitType) + " pilots than allowed. HQ will randomly reassign some of them, if you do not.", playerName);
        }
    }

    public Pilot getPilot(int unitType, int weightClass, int position) {
        try {
            LinkedList<Pilot> list = this.getUnitTypeQueue(unitType).get(weightClass);
            return list.remove(position);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public LinkedList<Pilot> getPilotQueue(int unitType, int weightClass) {
        return this.getUnitTypeQueue(unitType).get(weightClass);
    }

    public void flushQueue() {
        this.mekPilots.clear();
        this.protoPilots.clear();
        this.aeroPilots.clear();
        for (int i = 0; i <= 3; ++i) {
            this.mekPilots.add(i, new LinkedList());
            this.protoPilots.add(i, new LinkedList());
            this.aeroPilots.add(i, new LinkedList());
        }
    }

    public String toString(boolean toClient) {
        int position;
        LinkedList<Pilot> currList;
        int weightClass;
        StringBuilder result = new StringBuilder();
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            currList = this.getPilotQueue(0, weightClass);
            result.append(currList.size());
            result.append("$");
            for (position = 0; position < currList.size(); ++position) {
                result.append(((SPilot)currList.get(position)).toFileFormat("#", toClient));
                result.append("$");
            }
        }
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            currList = this.getPilotQueue(3, weightClass);
            result.append(currList.size());
            result.append("$");
            for (position = 0; position < currList.size(); ++position) {
                result.append(((SPilot)currList.get(position)).toFileFormat("#", toClient));
                result.append("$");
            }
        }
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            currList = this.getPilotQueue(5, weightClass);
            result.append(currList.size());
            result.append("$");
            for (position = 0; position < currList.size(); ++position) {
                result.append(((SPilot)currList.get(position)).toFileFormat("#", toClient));
                result.append("$");
            }
        }
        return result.toString();
    }

    public synchronized void fromDB(int playerID) {
        int capSize = CampaignMain.cm.getIntegerConfig("MaxAllowedPilotsInQueueToBuyFromHouse");
        int currentCount = 0;
        try {
            Statement stmt = CampaignMain.cm.MySQL.getStatement();
            ResultSet rs = stmt.executeQuery("SELECT pilotID, pilotType, pilotSize from pilots WHERE playerID = " + playerID);
            while (rs.next()) {
                SPilot p = CampaignMain.cm.MySQL.loadPilot(rs.getInt("pilotID"));
                if (capSize < 1 || currentCount < capSize) {
                    this.addPilot(p, rs.getInt("pilotType"), rs.getInt("pilotSize"));
                }
                ++currentCount;
            }
            rs.close();
            stmt.close();
            for (int weightClass = 0; weightClass <= 3; ++weightClass) {
                while (this.getPilotQueue(0, weightClass).size() > capSize) {
                    this.getPilot(0, weightClass, CampaignMain.cm.getRandomNumber(this.getPilotQueue(0, weightClass).size()));
                }
                while (this.getPilotQueue(3, weightClass).size() > capSize) {
                    this.getPilot(3, weightClass, CampaignMain.cm.getRandomNumber(this.getPilotQueue(3, weightClass).size()));
                }
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in SPersonalPilotQueues.fromDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void fromString(String buffer, String delimiter) {
        SPilot filePilot;
        int count;
        int listSize;
        int weightClass;
        StringTokenizer mainTokenizer = new StringTokenizer(buffer, delimiter);
        int capSize = CampaignMain.cm.getIntegerConfig("MaxAllowedPilotsInQueueToBuyFromHouse");
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            listSize = TokenReader.readInt(mainTokenizer);
            for (count = 0; count < listSize; ++count) {
                filePilot = new SPilot();
                filePilot.fromFileFormat(TokenReader.readString(mainTokenizer), "#");
                this.addPilot(filePilot, 0, weightClass);
            }
            while (this.getPilotQueue(0, weightClass).size() > capSize) {
                this.getPilot(0, weightClass, CampaignMain.cm.getRandomNumber(this.getPilotQueue(0, weightClass).size()));
            }
        }
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            listSize = TokenReader.readInt(mainTokenizer);
            for (count = 0; count < listSize; ++count) {
                filePilot = new SPilot();
                filePilot.fromFileFormat(TokenReader.readString(mainTokenizer), "#");
                this.addPilot(filePilot, 3, weightClass);
            }
            while (this.getPilotQueue(3, weightClass).size() > capSize) {
                this.getPilot(3, weightClass, CampaignMain.cm.getRandomNumber(this.getPilotQueue(3, weightClass).size()));
            }
        }
        for (weightClass = 0; weightClass <= 3; ++weightClass) {
            listSize = TokenReader.readInt(mainTokenizer);
            for (count = 0; count < listSize; ++count) {
                filePilot = new SPilot();
                filePilot.fromFileFormat(TokenReader.readString(mainTokenizer), "#");
                this.addPilot(filePilot, 5, weightClass);
            }
            while (this.getPilotQueue(5, weightClass).size() > capSize) {
                this.getPilot(5, weightClass, CampaignMain.cm.getRandomNumber(this.getPilotQueue(5, weightClass).size()));
            }
        }
    }
}

