/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.AdvancedTerrain;
import common.CampaignData;
import common.Continent;
import common.House;
import common.Influences;
import common.Terrain;
import common.UnitFactory;
import common.util.Position;
import common.util.TokenReader;
import java.awt.Dimension;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SUnitFactory;
import server.campaign.data.TimeUpdatePlanet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPlanet
extends TimeUpdatePlanet
implements Serializable,
Comparable<Object> {
    private static final long serialVersionUID = -2266871107987235842L;
    private SHouse owner = null;

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("PL#");
        result.append(this.getName());
        result.append("#");
        result.append(this.getCompProduction());
        if (this.getUnitFactories() != null) {
            result.append("#" + this.getUnitFactories().size());
            for (UnitFactory factory : this.getUnitFactories()) {
                result.append("#" + ((SUnitFactory)factory).toString());
            }
        } else {
            result.append("#0");
        }
        result.append("#" + this.getPosition().getX());
        result.append("#" + this.getPosition().getY());
        result.append("#");
        for (House house : this.getInfluence().getHouses()) {
            SHouse next = (SHouse)house;
            if (next == null) continue;
            result.append(next.getName());
            result.append("$");
            result.append(this.getInfluence().getInfluence(next.getId()));
            result.append("$");
        }
        if (this.getInfluence().getHouses().size() < 1) {
            result.append(CampaignMain.cm.getConfig("NewbieHouseName"));
            result.append("$");
            result.append(this.getConquestPoints());
            result.append("$");
        }
        result.append("#");
        result.append(this.getEnvironments().size());
        result.append("#");
        for (Continent t : this.getEnvironments().toArray()) {
            result.append(t.getSize());
            result.append("#");
            result.append(t.getEnvironment().getName());
            result.append("#");
            if (!CampaignMain.cm.getBooleanConfig("UseStaticMaps")) continue;
            AdvancedTerrain aTerrain = this.getAdvancedTerrain().get(new Integer(t.getEnvironment().getId()));
            if (aTerrain == null) {
                aTerrain = new AdvancedTerrain();
            }
            if (aTerrain.getDisplayName().length() <= 1) {
                aTerrain.setDisplayName(t.getEnvironment().getName());
            }
            result.append(aTerrain.toString());
            result.append("#");
        }
        if (this.getDescription().equals("")) {
            result.append(" ");
        } else {
            result.append(this.getDescription());
        }
        result.append("#");
        result.append(this.getBaysProvided());
        result.append("#");
        result.append(this.isConquerable());
        result.append("#");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        result.append(sdf.format(this.getLastChanged()));
        result.append("#");
        result.append(-1);
        result.append("#");
        result.append(this.getMapSize().width);
        result.append("#");
        result.append(this.getMapSize().height);
        result.append("#");
        result.append(this.getBoardSize().width);
        result.append("#");
        result.append(this.getBoardSize().height);
        result.append("#");
        result.append(this.getTemp().width);
        result.append("#");
        result.append(this.getTemp().height);
        result.append("#");
        result.append(this.getGravity());
        result.append("#");
        result.append(this.isVacuum());
        result.append("#");
        result.append(this.getNightChance());
        result.append("#");
        result.append(this.getNightTempMod());
        result.append("#");
        result.append(this.getMinPlanetOwnerShip());
        result.append("#");
        result.append(this.isHomeWorld());
        result.append("#");
        result.append(this.getOriginalOwner());
        result.append("#");
        if (this.getPlanetFlags().size() > 0) {
            for (String key : this.getPlanetFlags().keySet()) {
                result.append(key + "^");
            }
            result.append("#");
        } else {
            result.append("^^#");
        }
        result.append(this.getConquestPoints());
        result.append("#");
        return result.toString();
    }

    public void toDB() {
        try {
            if (this.getDBID() == 0) {
                Statement stmt = CampaignMain.cm.MySQL.getStatement();
                ResultSet rs = null;
                StringBuffer sql = new StringBuffer();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                PreparedStatement ps = null;
                sql.append("INSERT into planets set pCompProd = ?, ");
                sql.append("pXpos = ?, ");
                sql.append("pYpos = ?, ");
                sql.append("pDesc = ?, ");
                sql.append("pBays = ?, ");
                sql.append("pIsConquerable = ?, ");
                sql.append("pLastChanged = ?, ");
                sql.append("pMWID = ?, ");
                sql.append("pMapSizeWidth = ?, ");
                sql.append("pMapSizeHeight = ?, ");
                sql.append("pBoardSizeWidth = ?, ");
                sql.append("pBoardSizeHeight = ?, ");
                sql.append("pTempWidth = ?, ");
                sql.append("pTempHeight = ?, ");
                sql.append("pGravity = ?, ");
                sql.append("pVacuum = ?, ");
                sql.append("pNightChance = ?, ");
                sql.append("pNightTempMod = ?, ");
                sql.append("pMinPlanetOwnership = ?, ");
                sql.append("pIsHomeworld = ?, ");
                sql.append("pOriginalOwner = ?, ");
                sql.append("pMaxConquestPoints = ?, ");
                sql.append("pName = ?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString(), 1);
                ps.setInt(1, this.getCompProduction());
                ps.setDouble(2, this.getPosition().getX());
                ps.setDouble(3, this.getPosition().getY());
                ps.setString(4, this.getDescription());
                ps.setInt(5, this.getBaysProvided());
                ps.setBoolean(6, this.isConquerable());
                ps.setString(7, sdf.format(this.getLastChanged()));
                ps.setInt(8, this.getId());
                ps.setInt(9, this.getMapSize().width);
                ps.setInt(10, this.getMapSize().height);
                ps.setInt(11, this.getBoardSize().width);
                ps.setInt(12, this.getBoardSize().height);
                ps.setInt(13, this.getTemp().width);
                ps.setInt(14, this.getTemp().height);
                ps.setDouble(15, this.getGravity());
                ps.setBoolean(16, this.isVacuum());
                ps.setInt(17, this.getNightChance());
                ps.setInt(18, this.getNightTempMod());
                ps.setInt(19, this.getMinPlanetOwnerShip());
                ps.setBoolean(20, this.isHomeWorld());
                ps.setString(21, this.getOriginalOwner());
                ps.setInt(22, this.getConquestPoints());
                ps.setString(23, this.getName());
                ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    int pid = rs.getInt(1);
                    this.setDBID(pid);
                    if (this.getUnitFactories() != null) {
                        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
                            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
                            MF.toDB();
                        }
                    }
                    CampaignMain.cm.MySQL.saveInfluences(this);
                    CampaignMain.cm.MySQL.saveEnvironments(this);
                    if (this.getPlanetFlags().size() > 0) {
                        CampaignMain.cm.MySQL.savePlanetFlags(this);
                    }
                }
                rs.close();
                ps.close();
                if (stmt != null) {
                    stmt.close();
                }
            } else {
                Statement stmt = CampaignMain.cm.MySQL.getStatement();
                StringBuffer sql = new StringBuffer();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                PreparedStatement ps = null;
                sql.append("UPDATE planets set pCompProd = ?, ");
                sql.append("pXpos = ?, ");
                sql.append("pYpos = ?, ");
                sql.append("pDesc = ?, ");
                sql.append("pBays = ?, ");
                sql.append("pIsConquerable = ?, ");
                sql.append("pLastChanged = ?, ");
                sql.append("pMWID = ?, ");
                sql.append("pMapSizeWidth = ?, ");
                sql.append("pMapSizeHeight = ?, ");
                sql.append("pBoardSizeWidth = ?, ");
                sql.append("pBoardSizeHeight = ?, ");
                sql.append("pTempWidth = ?, ");
                sql.append("pTempHeight = ?, ");
                sql.append("pGravity = ?, ");
                sql.append("pVacuum = ?, ");
                sql.append("pNightChance = ?, ");
                sql.append("pNightTempMod = ?, ");
                sql.append("pMinPlanetOwnership = ?, ");
                sql.append("pIsHomeworld = ?, ");
                sql.append("pOriginalOwner = ?, ");
                sql.append("pMaxConquestPoints = ?, ");
                sql.append("pName = ? ");
                sql.append("WHERE PlanetID = ?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString());
                ps.setInt(1, this.getCompProduction());
                ps.setDouble(2, this.getPosition().getX());
                ps.setDouble(3, this.getPosition().getY());
                ps.setString(4, this.getDescription());
                ps.setInt(5, this.getBaysProvided());
                ps.setBoolean(6, this.isConquerable());
                ps.setString(7, sdf.format(this.getLastChanged()));
                ps.setInt(8, this.getId());
                ps.setInt(9, this.getMapSize().width);
                ps.setInt(10, this.getMapSize().height);
                ps.setInt(11, this.getBoardSize().width);
                ps.setInt(12, this.getBoardSize().height);
                ps.setInt(13, this.getTemp().width);
                ps.setInt(14, this.getTemp().height);
                ps.setDouble(15, this.getGravity());
                ps.setBoolean(16, this.isVacuum());
                ps.setInt(17, this.getNightChance());
                ps.setInt(18, this.getNightTempMod());
                ps.setInt(19, this.getMinPlanetOwnerShip());
                ps.setBoolean(20, this.isHomeWorld());
                ps.setString(21, this.getOriginalOwner());
                ps.setInt(22, this.getConquestPoints());
                ps.setString(23, this.getName());
                ps.setInt(24, this.getDBID());
                ps.executeUpdate();
                if (this.getUnitFactories() != null) {
                    for (int i = 0; i < this.getUnitFactories().size(); ++i) {
                        SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
                        MF.toDB();
                    }
                }
                CampaignMain.cm.MySQL.saveInfluences(this);
                CampaignMain.cm.MySQL.saveEnvironments(this);
                if (this.getPlanetFlags().size() > 0) {
                    CampaignMain.cm.MySQL.savePlanetFlags(this);
                }
                ps.close();
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog(e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public String fromString(String s, Random r, CampaignData data) {
        int i;
        int hasMF;
        boolean singleFaction = CampaignMain.cm.getBooleanConfig("AllowSinglePlayerFactions");
        CampaignData.mwlog.mainLog(s);
        s = s.substring(3);
        StringTokenizer ST = new StringTokenizer(s, "#");
        this.setName(TokenReader.readString(ST));
        this.setCompProduction(TokenReader.readInt(ST));
        if (!CampaignMain.cm.isUsingMySQL()) {
            hasMF = TokenReader.readInt(ST);
            for (i = 0; i < hasMF; ++i) {
                SUnitFactory mft = new SUnitFactory();
                mft.fromString(TokenReader.readString(ST), this, r);
                if (singleFaction && CampaignMain.cm.getHouseFromPartialString(mft.getFounder()) == null) continue;
                this.getUnitFactories().add(mft);
            }
        } else {
            CampaignMain.cm.MySQL.loadFactories(this);
            hasMF = TokenReader.readInt(ST);
            for (i = 0; i < hasMF; ++i) {
                TokenReader.readString(ST);
            }
        }
        this.setPosition(new Position(TokenReader.readDouble(ST), TokenReader.readDouble(ST)));
        int Infcount = 0;
        try {
            HashMap<Integer, Integer> influence = new HashMap<Integer, Integer>();
            StringTokenizer influences = new StringTokenizer(TokenReader.readString(ST), "$");
            while (influences.hasMoreElements()) {
                String HouseName = TokenReader.readString(influences);
                SHouse h = (SHouse)data.getHouseByName(HouseName);
                int HouseInf = TokenReader.readInt(influences);
                Infcount += HouseInf;
                if (h != null) {
                    influence.put(h.getId(), HouseInf);
                    continue;
                }
                CampaignData.mwlog.errLog("House not found: " + HouseName);
            }
            this.setInfluence(new Influences(influence));
        }
        catch (RuntimeException ex) {
            CampaignData.mwlog.errLog("Problem on Planet: " + this.getName());
            CampaignData.mwlog.errLog(ex);
        }
        int Envs = TokenReader.readInt(ST);
        for (int i2 = 0; i2 < Envs; ++i2) {
            int size = TokenReader.readInt(ST);
            String terrain = TokenReader.readString(ST);
            int terrainNumber = 0;
            Terrain planetEnvironment = null;
            try {
                terrainNumber = Integer.parseInt(terrain);
                planetEnvironment = data.getTerrain(terrainNumber);
            }
            catch (Exception ex) {
                planetEnvironment = data.getTerrainByName(terrain);
            }
            if (planetEnvironment == null) {
                planetEnvironment = data.getTerrain(0);
            }
            Continent PE2 = new Continent(size, planetEnvironment);
            if (CampaignMain.cm.getBooleanConfig("UseStaticMaps")) {
                AdvancedTerrain aTerrain = new AdvancedTerrain();
                String tempHolder = TokenReader.readString(ST);
                if (tempHolder.indexOf("$") < 0) {
                    aTerrain.setDisplayName(tempHolder);
                    aTerrain.setXSize(TokenReader.readInt(ST));
                    aTerrain.setYSize(TokenReader.readInt(ST));
                    aTerrain.setStaticMap(TokenReader.readBoolean(ST));
                    aTerrain.setXBoardSize(TokenReader.readInt(ST));
                    aTerrain.setYBoardSize(TokenReader.readInt(ST));
                    aTerrain.setLowTemp(TokenReader.readInt(ST));
                    aTerrain.setHighTemp(TokenReader.readInt(ST));
                    aTerrain.setGravity(TokenReader.readDouble(ST));
                    TokenReader.readBoolean(ST);
                    aTerrain.setNightChance(TokenReader.readInt(ST));
                    aTerrain.setNightTempMod(TokenReader.readInt(ST));
                    aTerrain.setStaticMapName(TokenReader.readString(ST));
                } else {
                    aTerrain = new AdvancedTerrain(tempHolder);
                }
                this.getAdvancedTerrain().put(new Integer(PE2.getEnvironment().getId()), aTerrain);
            }
            this.getEnvironments().add(PE2);
        }
        this.setDescription(TokenReader.readString(ST));
        this.setBaysProvided(TokenReader.readInt(ST));
        this.setConquerable(TokenReader.readBoolean(ST));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            this.setTimestamp(sdf.parse(TokenReader.readString(ST)));
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("The following excepion is not critical, but will cause useless bandwith usage: please fix!");
            CampaignData.mwlog.errLog(ex);
            this.setTimestamp(new Date(System.currentTimeMillis()));
        }
        TokenReader.readString(ST);
        this.setId(-1);
        int x = TokenReader.readInt(ST);
        int y = TokenReader.readInt(ST);
        this.setMapSize(new Dimension(x, y));
        x = TokenReader.readInt(ST);
        y = TokenReader.readInt(ST);
        this.setBoardSize(new Dimension(x, y));
        x = TokenReader.readInt(ST);
        y = TokenReader.readInt(ST);
        this.setTemp(new Dimension(x, y));
        this.setGravity(TokenReader.readDouble(ST));
        this.setVacuum(TokenReader.readBoolean(ST));
        int chance = TokenReader.readInt(ST);
        int mod = TokenReader.readInt(ST);
        this.setNightChance(chance);
        this.setNightTempMod(mod);
        this.setMinPlanetOwnerShip(TokenReader.readInt(ST));
        this.setHomeWorld(TokenReader.readBoolean(ST));
        this.setOriginalOwner(TokenReader.readString(ST));
        StringTokenizer str = new StringTokenizer(TokenReader.readString(ST), "^");
        TreeMap<String, String> map = new TreeMap<String, String>();
        while (str.hasMoreTokens()) {
            String key = TokenReader.readString(str);
            if (!CampaignMain.cm.getData().getPlanetOpFlags().containsKey(key)) continue;
            map.put(key, CampaignMain.cm.getData().getPlanetOpFlags().get(key));
        }
        this.setPlanetFlags(map);
        this.setConquestPoints(TokenReader.readInt(ST));
        this.updateInfluences();
        if (singleFaction && this.isNullOwner()) {
            this.setConquestPoints(100);
            this.setBaysProvided(0);
            SHouse house = CampaignMain.cm.getHouseById(-1);
            this.getInfluence().moveInfluence(house, house, 100, 100);
        }
        this.setOwner(null, this.checkOwner(), false);
        return s;
    }

    public SPlanet() {
        this.setTimestamp(new Date(0L));
        this.setOriginalOwner(CampaignMain.cm.getConfig("NewbieHouseName"));
    }

    public SPlanet(int id, String name, Influences flu, int income, int CompProd, double xcood, double ycood) {
        super(id, name, new Position(xcood, ycood), flu);
        this.setCompProduction(CompProd);
        this.setTimestamp(new Date(0L));
        this.setOriginalOwner(CampaignMain.cm.getConfig("NewbieHouseName"));
    }

    public SUnitFactory getRandomUnitFactory() {
        if (this.getUnitFactories().size() == 0) {
            return null;
        }
        return (SUnitFactory)this.getUnitFactories().get(CampaignMain.cm.getRandomNumber(this.getUnitFactories().size()));
    }

    public SUnitFactory getBestUnitFactory() {
        if (this.getUnitFactories().size() == 0) {
            return null;
        }
        SUnitFactory result = null;
        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
            if (result == null) {
                result = MF;
                continue;
            }
            if (MF.getWeightclass() > result.getWeightclass()) {
                result = MF;
                continue;
            }
            if (MF.getWeightclass() != result.getWeightclass() || MF.getBestTypeProducable() >= result.getBestTypeProducable()) continue;
            result = MF;
        }
        return result;
    }

    public Vector<SUnitFactory> getFactoriesByName(String s) {
        Vector<SUnitFactory> result = new Vector<SUnitFactory>(this.getUnitFactories().size(), 1);
        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
            if (!MF.getName().equals(s)) continue;
            result.add(MF);
        }
        return result;
    }

    public Vector<SUnitFactory> getFactoriesOfWeighclass(int weightclass) {
        Vector<SUnitFactory> result = new Vector<SUnitFactory>(this.getUnitFactories().size(), 1);
        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
            if (MF.getWeightclass() != weightclass) continue;
            result.add(MF);
        }
        return result;
    }

    public Vector<House> getDefenders(SHouse Attacker) {
        Vector<House> result = new Vector<House>(this.getInfluence().getHouses());
        result.trimToSize();
        return result;
    }

    public boolean equals(Object o) {
        SPlanet p = null;
        try {
            p = (SPlanet)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return p.getId() == this.getId();
    }

    public String tick(int refreshminiticks) {
        StringBuilder hsUpdates = new StringBuilder();
        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
            int total = 0;
            if (MF.canProduce(0)) {
                total += refreshminiticks;
            }
            if (MF.canProduce(1)) {
                total += refreshminiticks;
            }
            if (MF.canProduce(2)) {
                total += refreshminiticks;
            }
            if (MF.canProduce(3)) {
                total += refreshminiticks;
            }
            if (MF.canProduce(4)) {
                total += refreshminiticks;
            }
            if (MF.canProduce(5)) {
                total += refreshminiticks;
            }
            hsUpdates.append(MF.addRefresh(-total, false));
        }
        return hsUpdates.toString();
    }

    public String getSmallStatus(boolean useHTML) {
        StringBuilder result = new StringBuilder();
        if (useHTML) {
            result.append(this.getNameAsColoredLink());
        } else {
            result.append(this.getName());
        }
        for (int i = 0; i < this.getUnitFactories().size(); ++i) {
            SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
            result.append(" [" + MF.getSize() + "," + MF.getFounder() + "," + MF.getTypeString() + "]");
        }
        result.append(":");
        for (House h : this.getInfluence().getHouses()) {
            result.append(h.getName() + "(" + this.getInfluence().getInfluence(h.getId()) + "cp)");
            result.append(", ");
        }
        if (useHTML) {
            result.replace(result.length() - 2, result.length(), "<br>");
        }
        return result.toString();
    }

    public SHouse checkOwner() {
        if (this.getInfluence() == null) {
            CampaignData.mwlog.errLog("getINF == null Planet: " + this.getName());
            return null;
        }
        SHouse h = null;
        Integer houseID = this.getInfluence().getOwner();
        if (houseID == null) {
            return null;
        }
        h = (SHouse)CampaignMain.cm.getData().getHouse(houseID);
        if (this.getInfluence().getInfluence(houseID) < this.getMinPlanetOwnerShip()) {
            return null;
        }
        return h;
    }

    public SHouse getOwner() {
        if (this.owner == null) {
            this.checkOwner();
        }
        return this.owner;
    }

    public void setOwner(SHouse oldOwner, SHouse newOwner, boolean sendHouseUpdates) {
        if (this.owner != null) {
            this.owner.removePlanet(this);
        }
        if (newOwner != null) {
            this.owner = newOwner;
            this.owner.addPlanet(this);
        }
        if (sendHouseUpdates) {
            this.sendHouseStatusUpdate(oldOwner, newOwner);
        }
    }

    public int doGainInfluence(SHouse winner, SHouse loser, int amount, boolean adminExchange) {
        if (!winner.isConquerable() && !adminExchange) {
            return 0;
        }
        int infgain = this.getInfluence().moveInfluence(winner, loser, amount, this.getConquestPoints());
        if (infgain > 0) {
            this.updated();
            SHouse oldOwner = this.owner;
            SHouse newOwner = this.checkOwner();
            this.setOwner(oldOwner, newOwner, true);
        }
        return infgain;
    }

    private void sendHouseStatusUpdate(SHouse oldOwner, SHouse newOwner) {
        if (oldOwner != null && oldOwner.equals(newOwner)) {
            return;
        }
        if (oldOwner == null && newOwner == null) {
            return;
        }
        StringBuilder oldOwnerHSUpdates = new StringBuilder();
        StringBuilder newOwnerHSUpdates = new StringBuilder();
        for (UnitFactory currUF : this.getUnitFactories()) {
            oldOwnerHSUpdates.append("RF|" + currUF.getWeightclass() + "$" + currUF.getType() + "$" + this.getName() + "$" + currUF.getName() + "|");
            newOwnerHSUpdates.append("AF|" + currUF.getWeightclass());
            newOwnerHSUpdates.append("$");
            newOwnerHSUpdates.append(currUF.getType());
            newOwnerHSUpdates.append("$");
            newOwnerHSUpdates.append(currUF.getFounder());
            newOwnerHSUpdates.append("$");
            newOwnerHSUpdates.append(this.getName());
            newOwnerHSUpdates.append("$");
            newOwnerHSUpdates.append(currUF.getName());
            newOwnerHSUpdates.append("$");
            newOwnerHSUpdates.append(currUF.getTicksUntilRefresh());
            newOwnerHSUpdates.append("$");
            newOwnerHSUpdates.append(currUF.getAccessLevel());
            newOwnerHSUpdates.append("|");
        }
        if (oldOwner != null && oldOwnerHSUpdates.length() > 0) {
            CampaignMain.cm.doSendToAllOnlinePlayers(oldOwner, "HS|" + oldOwnerHSUpdates.toString(), false);
        }
        if (newOwner != null && newOwnerHSUpdates.length() > 0) {
            CampaignMain.cm.doSendToAllOnlinePlayers(newOwner, "HS|" + newOwnerHSUpdates.toString(), false);
        }
    }

    public String getShortDescription(boolean withTerrain) {
        StringBuilder result = new StringBuilder(this.getName());
        if (withTerrain) {
            Continent p = this.getEnvironments().getBiggestEnvironment();
            Terrain pe = p.getEnvironment();
            if (pe != null && pe.getEnviroments().size() > 0) {
                result.append(" " + pe.getEnviroments().get(0).toImageDescription());
            }
            if (this.getUnitFactories().size() > 0) {
                for (int i = 0; i < this.getUnitFactories().size(); ++i) {
                    SUnitFactory MF = (SUnitFactory)this.getUnitFactories().get(i);
                    result.append(MF.getIcons());
                }
            }
            if (pe != null && this.getEnvironments().getTotalEnivronmentPropabilities() > 0) {
                result.append(" (" + Math.round((double)p.getSize() * 100.0 / (double)this.getEnvironments().getTotalEnivronmentPropabilities()) + "% correct)");
            } else {
                result.append(" (100% correct)");
            }
        }
        return result.toString();
    }

    public String getNameAsColoredLink() {
        String colorString = "";
        colorString = this.owner == null ? CampaignMain.cm.getConfig("DisputedPlanetColor") : this.owner.getHouseColor();
        String toReturn = "<font color=\"" + colorString + "\">" + this.getNameAsLink() + "</font>";
        return toReturn;
    }

    @Override
    public int getMinPlanetOwnerShip() {
        int ownership = super.getMinPlanetOwnerShip();
        if (ownership < 0) {
            ownership = CampaignMain.cm.getIntegerConfig("MinPlanetOwnerShip");
        }
        return ownership;
    }

    public boolean isNullOwner() {
        return this.getInfluence().getInfluence(-1) == this.getConquestPoints();
    }
}

