/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import common.Player;
import common.SubFaction;
import common.Unit;
import common.campaign.pilot.Pilot;
import common.util.TokenReader;
import common.util.UnitComponents;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.Protomech;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPersonalPilotQueues;
import server.campaign.SUnit;
import server.campaign.SmallPlayer;
import server.campaign.market2.IBuyer;
import server.campaign.market2.ISeller;
import server.campaign.mercenaries.ContractInfo;
import server.campaign.mercenaries.MercHouse;
import server.campaign.pilot.SPilot;
import server.campaign.util.ExclusionList;
import server.campaign.util.OpponentListHelper;
import server.util.MWPasswdRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SPlayer
extends Player
implements Comparable<Object>,
IBuyer,
ISeller {
    public static final int STATUS_LOGGEDOUT = 1;
    public static final int STATUS_RESERVE = 2;
    public static final int STATUS_ACTIVE = 3;
    public static final int STATUS_FIGHTING = 4;
    private String name = "";
    private String fluffText = "";
    private String myLogo = "";
    private String lastISP = "";
    private int money = 0;
    private int experience = 0;
    private int influence = 50;
    private int currentReward = 0;
    private int xpToReward = 0;
    private int groupAllowance = 0;
    private int technicians = 0;
    private int baysOwned = 0;
    private int currentTechPayment = -1;
    private double rating = 1600.0;
    private long lastOnline = 0L;
    private Vector<SUnit> units = new Vector(1, 1);
    private Vector<SArmy> armies = new Vector(1, 1);
    private Vector<Integer> totalTechs = new Vector(4, 1);
    private Vector<Integer> availableTechs = new Vector(4, 1);
    private SPersonalPilotQueues personalPilotQueue = new SPersonalPilotQueues();
    private ExclusionList exclusionList = new ExclusionList();
    private int scrapsThisTick = 0;
    private int donationsThisTick = 0;
    private double weightedArmyNumber = -1.0;
    private long lastTimeCommandSent = 0L;
    private long lastAttackFromReserve = 0L;
    private long activeSince = 0L;
    private long attackRestrictionUntil = 0L;
    private String sellingto = "";
    private String lastSentStatus = "";
    private String clientVersion = "";
    private SHouse myHouse;
    private MWPasswdRecord password = null;
    private UnitComponents unitParts = new UnitComponents();
    private int DBId = 0;
    private int forumID = 0;
    private boolean userValidated = false;
    boolean isLoading = false;
    private String subFaction = "";
    private long lastPromoted = 0L;

    public SPlayer() {
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            for (int x = 0; x < 4; ++x) {
                this.getAvailableTechs().add(0);
                this.getTotalTechs().add(0);
            }
        }
        this.myHouse = CampaignMain.cm.getHouseFromPartialString(CampaignMain.cm.getConfig("NewbieHouseName"));
    }

    public void setSave() {
        if (!this.isLoading) {
            CampaignMain.cm.forceSavePlayer(this);
        }
    }

    public boolean equals(Object o) {
        SPlayer p = null;
        try {
            p = (SPlayer)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (p == null) {
            return false;
        }
        return p.getName().equals(this.name);
    }

    public double getRatingRounded() {
        BigDecimal bd = new BigDecimal(this.rating);
        bd = bd.setScale(2, 4);
        return bd.doubleValue();
    }

    public boolean mayUse(int weightClass) {
        if (weightClass == 1 && Integer.parseInt(this.getMyHouse().getConfig("MinEXPforMedium")) > this.experience) {
            return false;
        }
        if (weightClass == 2 && Integer.parseInt(this.getMyHouse().getConfig("MinEXPforHeavy")) > this.experience) {
            return false;
        }
        return weightClass != 3 || Integer.parseInt(this.getMyHouse().getConfig("MinEXPforAssault")) <= this.experience;
    }

    public void addUnit(SUnit m, boolean isNew) {
        this.addUnit(m, isNew, true);
    }

    @Override
    public String addUnit(SUnit m, boolean isNew, boolean sendUpdates) {
        if (isNew) {
            long immunityTime = Long.parseLong(this.getMyHouse().getConfig("ImmunityTime")) * 1000L;
            m.setPassesMaintainanceUntil(System.currentTimeMillis() + immunityTime * 2L);
        }
        m.setScrappableFor(-1);
        if (this.getFreeBays() < (CampaignMain.cm.isUsingIncreasedTechs() ? SUnit.getHangarSpaceRequired(m, this.getMyHouse().houseSupportsUnit(m.getUnitFilename()), this.getMyHouse()) : SUnit.getHangarSpaceRequired(m, this.getMyHouse()))) {
            m.setUnmaintainedStatus();
        } else {
            m.setStatus(1);
        }
        SUnit.checkAmmoForUnit(m, this.myHouse);
        m.setPosId(this.getFreeID());
        this.units.add(m);
        if (sendUpdates) {
            CampaignMain.cm.toUser("PL|HD|" + m.toString(true), this.name, false);
            CampaignMain.cm.toUser("PL|SUS|" + m.getId() + "#" + m.getStatus(), this.name, false);
            CampaignMain.cm.toUser("PL|SB|" + this.getTotalMekBays(), this.name, false);
            CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.name, false);
        }
        if (CampaignMain.cm.isUsingMySQL()) {
            m.toDB();
            CampaignMain.cm.MySQL.linkUnitToPlayer(m.getDBId(), this.getDBId());
        }
        this.setSave();
        return "";
    }

    @Override
    public SUnit getUnit(int id) {
        for (SUnit currU : this.units) {
            if (currU.getId() != id) continue;
            return currU;
        }
        return null;
    }

    @Override
    public String removeUnit(SUnit unitToRemove, boolean sendHouseStatusUpdate) {
        this.removeUnit(unitToRemove.getId(), true);
        return "";
    }

    public void removeUnit(int unitid, boolean sendArmyUpdate) {
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.unlinkUnit(CampaignMain.cm.MySQL.getUnitDBIdFromMWId(unitid));
        }
        SUnit Mech2 = null;
        for (int i = 0; i < this.units.size(); ++i) {
            Mech2 = this.units.elementAt(i);
            if (Mech2.getId() != unitid) continue;
            this.units.removeElementAt(i);
        }
        for (SArmy currA : this.getArmies()) {
            if (currA.getUnitPosition(unitid) <= -1) continue;
            currA.removeUnit(unitid);
            if (!sendArmyUpdate) continue;
            CampaignMain.cm.toUser("PL|SAD|" + currA.toString(true, "%"), this.name, false);
            CampaignMain.cm.getOpsManager().checkOperations(currA, true);
        }
        CampaignMain.cm.toUser("PL|RU|" + unitid, this.name, false);
        CampaignMain.cm.toUser("PL|SB|" + this.getTotalMekBays(), this.name, false);
        CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.name, false);
        this.setSave();
    }

    public int getFreeBays() {
        int free = this.getTotalMekBays();
        int totalProtos = 0;
        boolean advanceRep = CampaignMain.cm.isUsingAdvanceRepair();
        for (SUnit currU : this.units) {
            if (currU.getStatus() != 1 && currU.getStatus() != 3) continue;
            free = CampaignMain.cm.isUsingIncreasedTechs() ? (free -= SUnit.getHangarSpaceRequired(currU, this.getMyHouse().houseSupportsUnit(currU.getUnitFilename()), this.getMyHouse())) : (free -= SUnit.getHangarSpaceRequired(currU, this.getMyHouse()));
            if (currU.getEntity() instanceof Protomech && !advanceRep) {
                if (currU.getPilot().getSkills().has(2)) continue;
                ++totalProtos;
                continue;
            }
            if (!(currU.getEntity() instanceof Protomech)) continue;
            ++totalProtos;
        }
        if (totalProtos > 0) {
            double ppoints = (double)totalProtos / 5.0;
            int techRatio = Integer.parseInt(CampaignMain.cm.getConfig("TechsToProtoPointRatio"));
            int ptechs = (int)(ppoints * (double)techRatio);
            if (ptechs < 1) {
                ptechs = 1;
            }
            free -= ptechs;
        }
        return free;
    }

    public int getTotalMekBays() {
        int minBays;
        int numBays = 0;
        boolean usesXP = Boolean.parseBoolean(this.getMyHouse().getConfig("UseExperience"));
        boolean usesTechs = Boolean.parseBoolean(this.getMyHouse().getConfig("UseTechnicians"));
        boolean usesAdvanceRepairs = CampaignMain.cm.isUsingAdvanceRepair();
        if (usesAdvanceRepairs) {
            usesTechs = false;
        }
        int BASE_BAYS = this.myHouse.getBaysProvided();
        if (!this.myHouse.isMercHouse() && (numBays += BASE_BAYS) < (minBays = Integer.parseInt(this.getMyHouse().getConfig("MinimumHouseBays")))) {
            numBays = minBays;
        }
        if (usesXP) {
            int maxBaysFromXP;
            int experienceForBay = Integer.parseInt(this.getMyHouse().getConfig("ExperienceForBay"));
            int expBays = this.experience / experienceForBay;
            if (expBays > (maxBaysFromXP = Integer.parseInt(this.getMyHouse().getConfig("MaxBaysFromEXP")))) {
                expBays = maxBaysFromXP;
            }
            numBays += expBays;
        }
        if (usesTechs) {
            numBays += this.getTechnicians();
        }
        if (usesAdvanceRepairs) {
            numBays += this.baysOwned;
        }
        return numBays;
    }

    private void doPayTechniciansMath() {
        int techs = this.getTechnicians();
        if (techs <= 0) {
            this.setCurrentTechPayment(0);
            return;
        }
        float amountToPay = 0.0f;
        float additive = Float.parseFloat(this.getMyHouse().getConfig("AdditivePerTech"));
        float ceiling = Float.parseFloat(this.getMyHouse().getConfig("AdditiveCostCeiling"));
        int techCeiling = (int)(ceiling / additive);
        if (techs > techCeiling) {
            int techsPastCeiling = techs - techCeiling;
            amountToPay += ceiling * (float)techsPastCeiling;
        }
        int techsUsingAdditive = 0;
        techsUsingAdditive = techs > techCeiling ? techCeiling : techs;
        int totalAdditions = 0;
        for (int i = 1; i <= techsUsingAdditive; ++i) {
            totalAdditions += i;
        }
        int toSet = Math.round(amountToPay += (float)totalAdditions * additive);
        if (toSet < 0) {
            toSet = 0;
        }
        this.setCurrentTechPayment(toSet);
    }

    public int doFireUnpaidTechnicians(float amountOfShortFall) {
        int currentTechs;
        this.setCurrentTechPayment(-1);
        float additive = Float.parseFloat(this.getMyHouse().getConfig("AdditivePerTech"));
        float ceiling = Float.parseFloat(this.getMyHouse().getConfig("AdditiveCostCeiling"));
        int techCeiling = (int)(ceiling / additive);
        for (currentTechs = this.getTechnicians(); amountOfShortFall > 0.0f && currentTechs > techCeiling; --currentTechs, amountOfShortFall -= ceiling) {
        }
        while (amountOfShortFall > 0.0f) {
            float costOfCurrentTech = (float)currentTechs * additive;
            amountOfShortFall -= costOfCurrentTech;
            if (--currentTechs != 0) continue;
            amountOfShortFall = 0.0f;
        }
        int numberOfTechsFired = this.getTechnicians() - currentTechs;
        this.addTechnicians(-numberOfTechsFired);
        return numberOfTechsFired;
    }

    public int getTechHiringFee() {
        int techCost = Integer.parseInt(CampaignMain.cm.getConfig("BaseTechCost"));
        boolean decreaseWithXP = Boolean.parseBoolean(this.getMyHouse().getConfig("DecreasingTechCost"));
        if (decreaseWithXP) {
            int xpToDecrease = Integer.parseInt(this.getMyHouse().getConfig("XPForDecrease"));
            int minTechCost = Integer.parseInt(this.getMyHouse().getConfig("MinimumTechCost"));
            int numDecreases = (int)Math.floor(this.experience / xpToDecrease);
            if ((techCost -= numDecreases) < minTechCost) {
                techCost = minTechCost;
            }
            if (techCost < 0) {
                techCost = 0;
            }
        }
        return techCost;
    }

    public int setRandomUnmaintained() {
        int numUnmaintained = 0;
        Vector<SUnit> okUnitsData = new Vector<SUnit>(1, 1);
        for (SUnit currU : this.units) {
            if (currU.getStatus() != 1) continue;
            okUnitsData.add(currU);
        }
        while (this.getFreeBays() < 0) {
            if (okUnitsData.size() == 0) {
                return numUnmaintained;
            }
            int rnd = CampaignMain.cm.getRandomNumber(okUnitsData.size());
            SUnit unit = (SUnit)okUnitsData.elementAt(rnd);
            unit.setUnmaintainedStatus();
            ++numUnmaintained;
            CampaignMain.cm.toUser("PL|UU|" + unit.getId() + "|" + unit.toString(true), this.name, false);
            okUnitsData.remove(rnd);
        }
        this.setSave();
        return numUnmaintained;
    }

    public void doMaintainance() {
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            return;
        }
        int increase = Integer.parseInt(this.getMyHouse().getConfig("MaintainanceIncrease"));
        int decrease = Integer.parseInt(this.getMyHouse().getConfig("MaintainanceDecrease"));
        ArrayList<SUnit> unitsToDestroy = new ArrayList<SUnit>();
        for (SUnit currUnit : this.units) {
            if (currUnit.getStatus() == 1) {
                currUnit.addToMaintainanceLevel(increase);
                continue;
            }
            if (currUnit.getStatus() != 2) continue;
            int rnd = CampaignMain.cm.getRandomNumber(100) + 1;
            long currTime = System.currentTimeMillis();
            if (CampaignMain.cm.getIThread().isImmune(this) || currUnit.getPassesMaintainanceUntil() > currTime) {
                currUnit.addToMaintainanceLevel(-decrease);
                continue;
            }
            if (rnd <= currUnit.getMaintainanceLevel()) {
                currUnit.addToMaintainanceLevel(-decrease);
                continue;
            }
            if (this.myHouse.isNewbieHouse()) {
                CampaignMain.cm.toUser("Your " + currUnit.getModelName() + " is badly maintained and failed a survival roll. In a normal faction, " + "failing these rolls <b>destroys</b> the unit. In the training faction you simply get this warning. Take heed.", this.name, true);
                return;
            }
            int mechscrapprice = Math.round((float)this.myHouse.getPriceForUnit(currUnit.getWeightclass(), currUnit.getType()) * Float.parseFloat(this.getMyHouse().getConfig("ScrapCostMultiplier")));
            if (this.getMoney() < mechscrapprice) {
                mechscrapprice = this.getMoney();
            }
            if (mechscrapprice > 0) {
                this.addMoney(-mechscrapprice);
            }
            int flutolose = this.getInfluence();
            this.addInfluence(-flutolose);
            String toSend = "Lack of maintainance has forced your techs to scrap " + currUnit.getPilot().getName() + "'s " + currUnit.getModelName() + " for parts. HQ is displeased (";
            if (mechscrapprice > 0) {
                toSend = toSend + CampaignMain.cm.moneyOrFluMessage(true, false, -mechscrapprice, true) + ", ";
            }
            toSend = toSend + CampaignMain.cm.moneyOrFluMessage(false, false, -flutolose, true) + ").";
            CampaignMain.cm.toUser(toSend, this.name, true);
            this.myHouse.addDispossessedPilot(currUnit, false);
            unitsToDestroy.add(currUnit);
        }
        for (SUnit destroyedU : unitsToDestroy) {
            this.removeUnit(destroyedU.getId(), false);
            if (!CampaignMain.cm.isUsingMySQL()) continue;
            CampaignMain.cm.MySQL.deleteUnit(destroyedU.getDBId());
        }
    }

    public boolean hasUnmaintainedUnit() {
        for (SUnit currU : this.units) {
            if (currU.getStatus() != 2) continue;
            return true;
        }
        return false;
    }

    public void setActive(boolean newStatus) {
        String lowerName = this.name.toLowerCase();
        if (!newStatus) {
            this.activeSince = 0L;
            this.setLastOnline(System.currentTimeMillis());
            OpponentListHelper olh = new OpponentListHelper(this, 1);
            olh.sendInfoToOpponents("left the front lines and may no longer be attacked");
            CampaignMain.cm.getOpsManager().removePlayerFromAllPossibleDefenderLists(this.name, true);
            CampaignMain.cm.getOpsManager().removePlayerFromAllAttackerLists(this, null, true);
            this.myHouse.getActivePlayers().remove(lowerName);
            this.myHouse.getReservePlayers().put(lowerName, this);
        } else {
            this.activeSince = System.currentTimeMillis();
            CampaignMain.cm.getIThread().removeImmunity(this);
            OpponentListHelper olh = new OpponentListHelper(this, 0);
            olh.sendInfoToOpponents("is headed to the front lines. You may attack it with ");
            this.myHouse.getReservePlayers().remove(lowerName);
            this.myHouse.getActivePlayers().put(lowerName, this);
        }
    }

    public void setFighting(boolean newStatus) {
        this.setFighting(newStatus, false);
    }

    public void setFighting(boolean newStatus, boolean toReserve) {
        String lowerName = this.name.toLowerCase();
        if (newStatus) {
            this.myHouse.getActivePlayers().remove(lowerName);
            this.myHouse.getFightingPlayers().put(lowerName, this);
            CampaignMain.cm.toUser("CS|4", this.name, false);
            OpponentListHelper olh = new OpponentListHelper(this, 1);
            olh.sendInfoToOpponents(" entered combat and may no longer be attacked");
        } else if (toReserve) {
            this.activeSince = 0L;
            this.myHouse.getFightingPlayers().remove(lowerName);
            this.myHouse.getReservePlayers().put(lowerName, this);
        } else {
            this.myHouse.getFightingPlayers().remove(lowerName);
            this.myHouse.getActivePlayers().put(lowerName, this);
            if (!CampaignMain.cm.getIThread().isImmune(this)) {
                OpponentListHelper olh = new OpponentListHelper(this, 0);
                olh.sendInfoToOpponents(" halted combat operations and returned to its post. You may attack it with ");
            }
        }
    }

    public void setFightingNoOppList() {
        CampaignMain.cm.getIThread().removeImmunity(this);
        this.activeSince = System.currentTimeMillis();
        String lowerName = this.name.toLowerCase();
        this.myHouse.getReservePlayers().remove(lowerName);
        this.myHouse.getActivePlayers().remove(lowerName);
        this.myHouse.getFightingPlayers().put(lowerName, this);
        CampaignMain.cm.toUser("CS|4", this.name, false);
    }

    protected String addInfluenceAtSlice() {
        CampaignData.mwlog.debugLog("Starting addInfluenceAtSlice for " + this.getName());
        int fluCeiling = Integer.parseInt(this.getMyHouse().getConfig("InfluenceCeiling"));
        CampaignData.mwlog.debugLog("getting max flu");
        if (this.influence >= fluCeiling) {
            CampaignData.mwlog.debugLog("returning");
            return "";
        }
        CampaignData.mwlog.debugLog("checking for merc house");
        if (this.getHouseFightingFor().isMercHouse()) {
            return "";
        }
        CampaignData.mwlog.debugLog("not in merc house");
        double weightedNumArmies = this.getWeightedArmyNumber();
        boolean activeLongEnough = System.currentTimeMillis() - this.activeSince > (long)Integer.parseInt(this.getMyHouse().getConfig("InfluenceTimeMin"));
        CampaignData.mwlog.debugLog("check active status, army number/weight, activelong enough");
        if (this.getDutyStatus() == 3 && weightedNumArmies > 0.0 && activeLongEnough) {
            CampaignData.mwlog.debugLog(this.getName() + " is active!");
            double totalInfluenceGrant = 0.0;
            double baseFlu = Double.parseDouble(this.getMyHouse().getConfig("BaseInfluence"));
            totalInfluenceGrant = baseFlu * weightedNumArmies;
            if ((double)this.influence > (double)fluCeiling * 0.5 && (double)this.influence < (double)fluCeiling * 0.75) {
                totalInfluenceGrant *= 0.8;
            } else if ((double)this.influence >= (double)fluCeiling * 0.75) {
                totalInfluenceGrant *= 0.6;
            }
            int intFluToAdd = (int)totalInfluenceGrant;
            int newFlu = this.influence + intFluToAdd;
            if (newFlu > fluCeiling) {
                intFluToAdd -= newFlu - fluCeiling;
            }
            CampaignData.mwlog.debugLog("Adding Flue");
            this.addInfluence(intFluToAdd);
            try {
                CampaignData.mwlog.debugLog("staring up flu message");
                String fileName = "";
                CampaignData.mwlog.debugLog("getting house");
                SHouse faction = this.getHouseFightingFor();
                CampaignData.mwlog.debugLog("getting flu message file");
                fileName = faction == null ? "./data/influencemessages/CommonInfluenceMessages.txt" : "./data/influencemessages/" + faction.getHouseFluFile() + "InfluenceMessages.txt";
                File messageFile = new File(fileName);
                if (!messageFile.exists() && !(messageFile = new File(fileName = "./data/influencemessages/CommonInfluenceMessages.txt")).exists()) {
                    CampaignData.mwlog.errLog("A problem occured with your CommonInfluenceMessages File!");
                    return "";
                }
                FileInputStream fis = new FileInputStream(messageFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                CampaignData.mwlog.debugLog("getting random flu message");
                int messages = Integer.parseInt(dis.readLine());
                Random rand = new Random();
                int messageLine = rand.nextInt(messages);
                String fluMessage = "";
                while (dis.ready()) {
                    fluMessage = dis.readLine();
                    if (messageLine <= 0) break;
                    --messageLine;
                }
                dis.close();
                fis.close();
                int unitId = rand.nextInt(this.units.size());
                SUnit unitForMessages = this.units.elementAt(unitId);
                CampaignData.mwlog.debugLog("Adding Subs for unitid: " + unitId);
                String fluMessageWithPilotName = fluMessage.replaceAll("PILOT", unitForMessages.getPilot().getName());
                String fluMessageWithModelName = fluMessageWithPilotName.replaceAll("UNIT", unitForMessages.getModelName());
                String fluMessageWithPlayerName = fluMessageWithModelName.replaceAll("PLAYER", this.name);
                fluMessageWithPlayerName = fluMessageWithPlayerName + " (" + CampaignMain.cm.moneyOrFluMessage(false, false, intFluToAdd, true) + ")";
                CampaignData.mwlog.debugLog("returning [" + fluMessageWithPlayerName + "] for " + this.getName());
                return fluMessageWithPlayerName;
            }
            catch (Exception e) {
                CampaignData.mwlog.errLog("A problem occured with your CommonInfluenceMessages File!");
                return "";
            }
        }
        return "";
    }

    public double getWeightedArmyNumber() {
        if (this.weightedArmyNumber <= 0.0) {
            Vector<SArmy> orderedArmies = new Vector<SArmy>(1, 1);
            CampaignData.mwlog.debugLog("Start getWeightedArmyNumber for " + this.getName());
            int MinCount = this.getMyHouse().getIntegerConfig("MinCountForTick");
            int MaxCount = this.getMyHouse().getIntegerConfig("MaxCountForTick");
            int MaxFlatDiff = 1;
            int legalOps = 0;
            double MaxPercentDiff = 0.0;
            for (SArmy currentArmy : this.getArmies()) {
                int forceBV = currentArmy.getOperationsBV(null);
                if (forceBV <= MinCount || forceBV >= MaxCount || currentArmy.isDisabled()) continue;
                boolean fLegalOp = false;
                for (String Opname : currentArmy.getLegalOperations().keySet()) {
                    if (CampaignMain.cm.getOpsManager().getOperation(Opname).getBooleanValue("DoesNotCountForPP")) continue;
                    fLegalOp = true;
                    MaxFlatDiff += Math.max(0, CampaignMain.cm.getOpsManager().getOperation(Opname).getIntValue("MaxBVDifference"));
                    MaxPercentDiff += (double)Math.max(0, CampaignMain.cm.getOpsManager().getOperation(Opname).getIntValue("MaxBVPercent"));
                    ++legalOps;
                }
                if (!fLegalOp) continue;
                if (orderedArmies.size() == 0) {
                    orderedArmies.add(currentArmy);
                    continue;
                }
                Enumeration f = orderedArmies.elements();
                int forceNumber = 0;
                boolean forceSorted = false;
                while (f.hasMoreElements() && !forceSorted) {
                    if (currentArmy.getOperationsBV(null) < ((SArmy)f.nextElement()).getOperationsBV(null)) {
                        orderedArmies.add(forceNumber, currentArmy);
                        forceSorted = true;
                        continue;
                    }
                    ++forceNumber;
                }
                if (forceSorted) continue;
                orderedArmies.add(currentArmy);
            }
            if (legalOps != 0) {
                MaxFlatDiff /= legalOps;
                MaxPercentDiff /= (double)legalOps;
            }
            this.weightedArmyNumber = orderedArmies.size();
            double weightMod = Math.max(0.0, this.getMyHouse().getDoubleConfig("BaseCountForProduction"));
            this.weightedArmyNumber *= weightMod;
            if (this.weightedArmyNumber > 0.0) {
                int overlap;
                Enumeration e = orderedArmies.elements();
                SArmy currentArmy = (SArmy)e.nextElement();
                int currentBV = currentArmy.getOperationsBV(null);
                double currentMaxDiff = 0.0;
                double caPercentDiff = (double)currentBV * MaxPercentDiff;
                currentMaxDiff = (double)MaxFlatDiff >= caPercentDiff ? (double)MaxFlatDiff : caPercentDiff;
                if ((double)(currentBV - MinCount) < currentMaxDiff) {
                    this.weightedArmyNumber -= this.getMyHouse().getDoubleConfig("FloorPenalty");
                    int overlap2 = currentBV - MinCount;
                    this.weightedArmyNumber -= (currentMaxDiff - (double)overlap2) / currentMaxDiff;
                }
                SArmy nextArmy = null;
                int nextBV = 0;
                while (e.hasMoreElements()) {
                    nextArmy = (SArmy)e.nextElement();
                    nextBV = nextArmy.getOperationsBV(null);
                    if (MaxPercentDiff <= 0.0) {
                        currentMaxDiff = MaxFlatDiff;
                    } else {
                        caPercentDiff = currentBV > nextBV ? (double)currentBV * MaxPercentDiff : (double)nextBV * MaxPercentDiff;
                        currentMaxDiff = (double)MaxFlatDiff >= caPercentDiff ? (double)MaxFlatDiff : caPercentDiff;
                    }
                    if ((double)(nextBV - currentBV) < currentMaxDiff) {
                        this.weightedArmyNumber -= this.getMyHouse().getDoubleConfig("OverlapPenalty");
                        overlap = nextBV - currentBV;
                        this.weightedArmyNumber -= (currentMaxDiff - (double)overlap) / currentMaxDiff;
                    }
                    currentArmy = nextArmy;
                    currentBV = nextBV;
                }
                caPercentDiff = (double)currentBV * MaxPercentDiff;
                currentMaxDiff = (double)MaxFlatDiff >= caPercentDiff ? (double)MaxFlatDiff : caPercentDiff;
                if ((double)(MaxCount - currentBV) < currentMaxDiff) {
                    this.weightedArmyNumber -= this.getMyHouse().getDoubleConfig("CeilingPenalty");
                    overlap = MaxCount - currentBV;
                    this.weightedArmyNumber -= (currentMaxDiff - (double)overlap) / currentMaxDiff;
                }
                for (SArmy currA : orderedArmies) {
                    if (currA.getLegalOperations().size() > 0) continue;
                    this.weightedArmyNumber -= weightMod;
                }
                if (this.weightedArmyNumber < 0.0) {
                    this.weightedArmyNumber = weightMod;
                }
            }
        }
        CampaignData.mwlog.debugLog("End getWeightedArmyNumber for " + this.getName());
        return this.weightedArmyNumber;
    }

    public void resetWeightedArmyNumber() {
        this.weightedArmyNumber = -1.0;
    }

    public void reset(String confirm) {
        if (!confirm.equals("CONFIRM")) {
            return;
        }
        this.armies.clear();
        this.units.clear();
        this.money = 0;
        this.exclusionList.getAdminExcludes().clear();
        this.exclusionList.getPlayerExcludes().clear();
        this.experience = 0;
        this.baysOwned = 0;
        this.availableTechs.clear();
        this.totalTechs.clear();
        this.technicians = 0;
        this.fluffText = " ";
        this.currentReward = 0;
        this.groupAllowance = 0;
        this.influence = 0;
        this.myHouse = CampaignMain.cm.getHouseFromPartialString(this.getMyHouse().getConfig("NewbieHouseName"), null);
        this.myLogo = " ";
        this.personalPilotQueue.flushQueue();
        this.rating = 1600.0;
        this.xpToReward = 0;
        this.sellingto = " ";
        this.weightedArmyNumber = 0.0;
        this.setSave();
    }

    @Override
    public void addMoney(int i) {
        int moneyToSet = this.money + i;
        int maxNewbieCbills = Integer.parseInt(this.getMyHouse().getConfig("MaxSOLCBills"));
        if (this.myHouse.isNewbieHouse() && moneyToSet > maxNewbieCbills) {
            moneyToSet = maxNewbieCbills;
        }
        if (moneyToSet < 0) {
            moneyToSet = 0;
        }
        this.money = moneyToSet;
        CampaignMain.cm.toUser("PL|SM|" + this.money, this.name, false);
        this.setSave();
    }

    @Override
    public int getMoney() {
        return this.money;
    }

    public void setPassword(MWPasswdRecord pass) {
        if (pass == null) {
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                CampaignData.mwlog.errLog(ex);
            }
        }
        this.password = pass;
        this.setSave();
    }

    public MWPasswdRecord getPassword() {
        return this.password;
    }

    @Override
    public boolean isHuman() {
        return true;
    }

    public SHouse getMyHouse() {
        return this.myHouse;
    }

    public SHouse getHouseFightingFor() {
        return this.getMyHouse().getHouseFightingFor(this);
    }

    public void setMyHouse(SHouse h) {
        this.myHouse = h;
        this.setSave();
    }

    public int getDutyStatus() {
        String lowerName = this.name.toLowerCase();
        if (this.myHouse.getFightingPlayers().containsKey(lowerName)) {
            return 4;
        }
        if (this.myHouse.getActivePlayers().containsKey(lowerName)) {
            return 3;
        }
        if (this.myHouse.getReservePlayers().containsKey(lowerName)) {
            return 2;
        }
        return 1;
    }

    public int getNumberOfVotesAllowed() {
        int voteTotal = Integer.parseInt(this.getMyHouse().getConfig("StartingVotes"));
        int xpForVote = Integer.parseInt(this.getMyHouse().getConfig("XPForAdditionalVote"));
        int maxVotes = Integer.parseInt(this.getMyHouse().getConfig("MaximumVotes"));
        if ((voteTotal += (int)Math.floor(this.experience / xpForVote)) > maxVotes) {
            voteTotal = maxVotes;
        }
        return voteTotal;
    }

    public void stripOfAllUnits(boolean sendStatus) {
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.clearArmies(this.getDBId());
            for (SUnit currU : this.units) {
                SPilot p = (SPilot)currU.getPilot();
                CampaignMain.cm.MySQL.deletePilot(p.getPilotId());
                CampaignMain.cm.MySQL.deleteUnit(currU.getDBId());
            }
        }
        this.units = new Vector(1, 1);
        this.armies = new Vector(1, 1);
        if (sendStatus) {
            CampaignMain.cm.toUser("PS|" + this.toString(true), this.name, false);
        }
        this.setSave();
    }

    public void addExperience(int i, boolean modAdded) {
        this.experience += i;
        if (this.experience < 0) {
            this.experience = 0;
        }
        if (this.myHouse.isNewbieHouse() && this.experience > Integer.parseInt(this.getMyHouse().getConfig("MaxSOLExp"))) {
            this.experience = Integer.parseInt(this.getMyHouse().getConfig("MaxSOLExp"));
        }
        CampaignMain.cm.toUser("PL|SE|" + this.experience, this.name, false);
        CampaignMain.cm.doSendToAllOnlinePlayers("PI|EX|" + this.name + "|" + this.experience, false);
        SmallPlayer smallp = this.myHouse.getSmallPlayers().get(this.name.toLowerCase());
        if (smallp != null) {
            smallp.setExperience(this.experience);
        }
        CampaignMain.cm.toUser("PL|SB|" + this.getTotalMekBays(), this.name, false);
        CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.name, false);
        if (!modAdded && i > 0) {
            int currentXP = this.xpToReward + i;
            int rollOver = Integer.parseInt(this.getMyHouse().getConfig("XPRollOverCap"));
            if (currentXP >= rollOver) {
                int rpToAdd = 0;
                while (currentXP >= rollOver) {
                    currentXP -= rollOver;
                    ++rpToAdd;
                }
                this.addReward(rpToAdd);
                this.setXPToReward(currentXP);
                String toSend = "You earned " + rpToAdd + " experience reward ";
                toSend = rpToAdd > 1 ? toSend + " points " : toSend + " point ";
                toSend = toSend + "[<a href=\"MWUSERP\">Use RP</a>]";
                CampaignMain.cm.toUser(toSend, this.name, true);
            } else {
                this.setXPToReward(currentXP);
            }
        }
        this.setSave();
    }

    public int getExperience() {
        return this.experience;
    }

    private int getHangarBV() {
        int bv = 0;
        for (SUnit currU : this.units) {
            bv += currU.getBV();
        }
        return bv;
    }

    private int getFreeID() {
        int id = 0;
        boolean found = false;
        while (!found) {
            found = true;
            for (int i = 0; i < this.units.size(); ++i) {
                if (this.units.get(i).getPosId() != id) continue;
                found = false;
                ++id;
            }
        }
        return id;
    }

    public int getFreeArmyId() {
        int i = 0;
        boolean free = false;
        while (!free) {
            free = true;
            for (int j = 0; j < this.getArmies().size(); ++j) {
                if (this.getArmies().elementAt(j).getID() != i) continue;
                free = false;
                ++i;
            }
        }
        return i;
    }

    public boolean mayAcquireWelfareUnits() {
        return this.getHangarBV() < Integer.parseInt(this.getMyHouse().getConfig("WelfareTotalUnitBVCeiling")) && this.getMoney() < Integer.parseInt(this.getMyHouse().getConfig("WelfareCeiling"));
    }

    public void addInfluence(int i) {
        this.setInfluence(this.getInfluence() + i);
    }

    @Override
    public int getCurrentTechPayment() {
        if (this.currentTechPayment < 0) {
            this.doPayTechniciansMath();
        }
        return this.currentTechPayment;
    }

    @Override
    public void setCurrentTechPayment(int i) {
        this.currentTechPayment = i;
        this.setSave();
    }

    @Override
    public int getTechnicians() {
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            return this.getBaysOwned();
        }
        return this.technicians;
    }

    public Vector<Integer> getTotalTechs() {
        return this.totalTechs;
    }

    public Vector<Integer> getAvailableTechs() {
        return this.availableTechs;
    }

    public String totalTechsToString() {
        StringBuilder result = new StringBuilder();
        this.getTotalTechs().setSize(4);
        for (Integer tech : this.getTotalTechs()) {
            result.append(tech + "%");
        }
        return result.toString();
    }

    public String availableTechsToString() {
        StringBuilder result = new StringBuilder();
        this.getAvailableTechs().setSize(4);
        for (Integer tech : this.getAvailableTechs()) {
            result.append(tech + "%");
        }
        return result.toString();
    }

    public void addAvailableTechs(int type, int number) {
        if (type > 3) {
            return;
        }
        int techs = this.getAvailableTechs().elementAt(type);
        this.getAvailableTechs().set(type, techs += number);
        CampaignMain.cm.toUser("PL|UAT|" + this.availableTechsToString(), this.name, false);
    }

    public void setAvailableTechs(int type, int number) {
        if (type > 3) {
            return;
        }
        this.getAvailableTechs().set(type, number);
        CampaignMain.cm.toUser("PL|UAT|" + this.availableTechsToString(), this.name, false);
    }

    public void addTotalTechs(int type, int number) {
        if (type > 3) {
            return;
        }
        int techs = this.getTotalTechs().elementAt(type);
        this.getTotalTechs().set(type, techs += number);
        CampaignMain.cm.toUser("PL|UTT|" + this.totalTechsToString(), this.name, false);
    }

    public void setTotalTechs(int type, int number) {
        if (type > 3) {
            return;
        }
        this.getTotalTechs().set(type, number);
        CampaignMain.cm.toUser("PL|UTT|" + this.totalTechsToString(), this.name, false);
    }

    public void updateAvailableTechs(String data) {
        try {
            StringTokenizer techs = new StringTokenizer(data, "%");
            int techType = 0;
            while (techs.hasMoreTokens()) {
                this.setAvailableTechs(techType, Integer.parseInt(techs.nextToken()));
                ++techType;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateTotalTechs(String data) {
        try {
            StringTokenizer techs = new StringTokenizer(data, "%");
            int techType = 0;
            while (techs.hasMoreTokens()) {
                this.setTotalTechs(techType, TokenReader.readInt(techs));
                ++techType;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBaysOwned() {
        return this.baysOwned;
    }

    public void setBaysOwned(int bays) {
        int maxBays = 0;
        maxBays = this.getMyHouse() != null ? Integer.parseInt(this.getMyHouse().getConfig("MaxBaysToBuy")) : CampaignMain.cm.getIntegerConfig("MaxBaysToBuy");
        this.baysOwned = maxBays != -1 ? Math.min(maxBays, bays) : bays;
    }

    public void addBays(int bays) {
        this.setBaysOwned(this.baysOwned + bays);
    }

    public String getLastISP() {
        return this.lastISP;
    }

    public void setLastISP(String isp) {
        this.lastISP = isp;
    }

    @Override
    public void setTechnicians(int t) {
        int maxTechs = 0;
        if (t < 0) {
            t = 0;
        }
        maxTechs = this.getMyHouse() != null ? Integer.parseInt(this.getMyHouse().getConfig("MaxTechsToHire")) : CampaignMain.cm.getIntegerConfig("MaxTechsToHire");
        this.technicians = maxTechs != -1 ? Math.min(maxTechs, t) : t;
        this.setCurrentTechPayment(-1);
        CampaignMain.cm.toUser("PL|ST|" + t, this.name, false);
        CampaignMain.cm.toUser("PL|SB|" + this.getTotalMekBays(), this.name, false);
        CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.name, false);
        this.setSave();
    }

    @Override
    public void addTechnicians(int t) {
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            this.addBays(t);
        } else {
            this.setTechnicians(this.getTechnicians() + t);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getColoredName() {
        return "<font color=\"" + this.getHouseFightingFor().getHouseColor() + "\">" + this.name + "</font>";
    }

    public void setName(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.name = s;
        this.setSave();
    }

    public SArmy getArmy(int id) {
        for (SArmy currA : this.armies) {
            if (currA.getID() != id) continue;
            return currA;
        }
        return null;
    }

    public Vector<SArmy> getArmies() {
        return this.armies;
    }

    public void removeArmy(int armyID) {
        Iterator<SArmy> i = this.armies.iterator();
        while (i.hasNext()) {
            SArmy currA = i.next();
            if (currA.getID() != armyID) continue;
            i.remove();
            break;
        }
        if (CampaignMain.cm.isUsingMySQL()) {
            CampaignMain.cm.MySQL.deleteArmy(this.getDBId(), armyID);
        }
        CampaignMain.cm.toUser("PL|RA|" + armyID, this.name, false);
    }

    public void setArmies(Vector<SArmy> v) {
        this.armies = v;
        this.setSave();
    }

    public Vector<SUnit> getUnits() {
        return this.units;
    }

    @Override
    public int compareTo(Object o) {
        SPlayer p = (SPlayer)o;
        if (this.getRating() > p.getRating()) {
            return 1;
        }
        if (this.getRating() < p.getRating()) {
            return -1;
        }
        return p.getName().compareTo(this.name);
    }

    public int getScrapsThisTick() {
        return this.scrapsThisTick;
    }

    public void addScrapThisTick() {
        ++this.scrapsThisTick;
    }

    public void setScrapsThisTick(int scraps) {
        this.scrapsThisTick = scraps;
    }

    public int getDonationsThisTick() {
        return this.donationsThisTick;
    }

    public void addDonationThisTick() {
        ++this.donationsThisTick;
    }

    public void setDonatonsThisTick(int donations) {
        this.donationsThisTick = donations;
    }

    public Date getLastOnlineDate() {
        return new Date(this.lastOnline);
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setLastOnline(long l) {
        this.lastOnline = l;
        SmallPlayer smallp = null;
        if (this.myHouse.getSmallPlayers().containsKey(this.name.toLowerCase())) {
            smallp = this.myHouse.getSmallPlayers().get(this.name.toLowerCase());
        } else {
            smallp = new SmallPlayer(this.getExperience(), this.lastOnline, this.getRating(), this.getName(), this.getFluffText(), this.getMyHouse());
            this.myHouse.getSmallPlayers().put(this.name.toLowerCase(), smallp);
        }
        smallp.setLastOnline(this.lastOnline);
    }

    public long getAttackRestrictionUntil() {
        return this.attackRestrictionUntil;
    }

    public void setAttackRestrictionUntil(long l) {
        this.attackRestrictionUntil = l;
    }

    public double getRating() {
        return this.rating;
    }

    public void setRating(double d) {
        this.rating = d;
        SmallPlayer smallp = this.myHouse.getSmallPlayers().get(this.name.toLowerCase());
        smallp.setRating(this.rating);
        if (!Boolean.parseBoolean(this.getMyHouse().getConfig("HideELO"))) {
            Double rounded = this.getRatingRounded();
            CampaignMain.cm.toUser("PL|SR|" + rounded, this.name, false);
            CampaignMain.cm.doSendToAllOnlinePlayers("PI|RA|" + this.name + "|" + rounded, false);
        }
        this.setSave();
    }

    public String getFluffText() {
        if (this.fluffText.length() > 0 && !this.fluffText.equals(" ") && !this.fluffText.equals("0")) {
            return this.fluffText;
        }
        return "";
    }

    public void setFluffText(String s) {
        this.fluffText = s;
        SmallPlayer smallp = this.myHouse.getSmallPlayers().get(this.name.toLowerCase());
        smallp.setFluffText(this.fluffText);
        this.setSave();
    }

    public String getLastSentStatus() {
        return this.lastSentStatus;
    }

    public void setLastSentStatus(String s) {
        this.lastSentStatus = s;
    }

    public long getActiveSince() {
        return this.activeSince;
    }

    public int getAmountOfTimesUnitExistsInArmies(int unitID) {
        int result = 0;
        Vector<SArmy> v = this.getArmies();
        for (int i = 0; i < v.size(); ++i) {
            SArmy a = v.elementAt(i);
            if (a.getUnit(unitID) == null) continue;
            ++result;
        }
        return result;
    }

    public void checkAndUpdateArmies(SUnit unit) {
        for (SArmy army : this.armies) {
            if (!army.isUnitInArmy(unit)) continue;
            army.setBV(0);
            CampaignMain.cm.toUser("PL|SABV|" + army.getID() + "#" + army.getBV(), this.name, false);
        }
    }

    public int getInfluence() {
        return this.influence;
    }

    public void setInfluence(int i) {
        this.influence = i;
        if (this.influence > Integer.parseInt(this.getMyHouse().getConfig("InfluenceCeiling"))) {
            this.influence = Integer.parseInt(this.getMyHouse().getConfig("InfluenceCeiling"));
        }
        if (this.influence < 0) {
            this.influence = 0;
        }
        CampaignMain.cm.toUser("PL|SI|" + this.influence, this.name, false);
        this.setSave();
    }

    public int getGroupAllowance() {
        return this.groupAllowance;
    }

    public void setGroupAllowance(int i) {
        this.groupAllowance = i;
    }

    public int getReward() {
        return this.currentReward;
    }

    public void setReward(int i) {
        this.currentReward = i;
        if (this.currentReward > Integer.parseInt(this.getMyHouse().getConfig("XPRewardCap"))) {
            this.currentReward = Integer.parseInt(this.getMyHouse().getConfig("XPRewardCap"));
        }
        if (this.currentReward < 0) {
            this.currentReward = 0;
        }
        CampaignMain.cm.toUser("PL|SRP|" + this.currentReward, this.name, false);
        this.setSave();
    }

    public void addReward(int toAdd) {
        this.setReward(this.getReward() + toAdd);
    }

    public void setXPToReward(int xp) {
        this.xpToReward = xp;
        this.setSave();
    }

    public int getXPToReward() {
        return this.xpToReward;
    }

    public void setMyLogo(String s) {
        this.myLogo = s;
    }

    public String getMyLogo() {
        return this.myLogo;
    }

    public void setPlayerSellingto(String selling) {
        this.sellingto = selling;
    }

    public String getPlayerSellingto() {
        return this.sellingto;
    }

    public void setPlayerClientVersion(String version) {
        this.clientVersion = version;
    }

    public String getPlayerClientVersion() {
        return this.clientVersion;
    }

    public SPersonalPilotQueues getPersonalPilotQueue() {
        return this.personalPilotQueue;
    }

    public ExclusionList getExclusionList() {
        return this.exclusionList;
    }

    public void setLastTimeCommandSent(long l) {
        this.lastTimeCommandSent = l;
    }

    public long getLastTimeCommandSent() {
        return this.lastTimeCommandSent;
    }

    public void setLastAttackFromReserve(long time) {
        this.lastAttackFromReserve = time;
    }

    public long getLastAttackFromReserve() {
        return this.lastAttackFromReserve;
    }

    public boolean hasRepairingUnits() {
        return this.hasRepairingUnits(true);
    }

    public boolean hasRepairingUnits(boolean inArmy) {
        if (!CampaignMain.cm.isUsingAdvanceRepair()) {
            return false;
        }
        if (inArmy) {
            for (SArmy army : this.armies) {
                for (Unit currU : army.getUnits()) {
                    SUnit unit = this.getUnit(currU.getId());
                    if (!UnitUtils.isRepairing(unit.getEntity())) continue;
                    return true;
                }
            }
        } else {
            for (SUnit currU : this.getUnits()) {
                if (!UnitUtils.isRepairing(currU.getEntity())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUnitInLockedArmy(int unitID) {
        if (this.getUnit(unitID) == null) {
            return false;
        }
        for (SArmy army : this.getArmies()) {
            if (!army.isLocked() || army.getUnit(unitID) == null) continue;
            return true;
        }
        return false;
    }

    public void healAllPilots() {
        try {
            if (!Boolean.parseBoolean(this.getMyHouse().getConfig("AllowPilotDamageToTransfer"))) {
                return;
            }
            Long timeGone = System.currentTimeMillis() - this.lastOnline;
            int tickTime = CampaignMain.cm.getIntegerConfig("TickTime");
            if (timeGone > (long)tickTime) {
                this.healAllPilots((int)(timeGone / (long)tickTime));
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public void healAllPilots(int numberOfHeals) {
        if (!Boolean.parseBoolean(this.getMyHouse().getConfig("AllowPilotDamageToTransfer"))) {
            return;
        }
        int health = Integer.parseInt(this.getMyHouse().getConfig("PilotAmountHealedPerTick")) * numberOfHeals;
        int medtechHeal = Integer.parseInt(this.getMyHouse().getConfig("MedTechAmountHealedPerTick")) * numberOfHeals;
        if (Boolean.parseBoolean(this.getMyHouse().getConfig("AllowPersonalPilotQueues"))) {
            for (int type = 0; type < 2; ++type) {
                for (int weight = 0; weight <= 3; ++weight) {
                    LinkedList<Pilot> list = this.personalPilotQueue.getPilotQueue(type, weight);
                    for (Pilot pilot : list) {
                        if (pilot.getHits() <= 0) continue;
                        int hits = pilot.getHits();
                        hits -= health;
                        if (pilot.getSkills().has(19)) {
                            hits -= medtechHeal;
                        }
                        pilot.setHits(Math.max(0, hits));
                    }
                }
            }
        }
        for (SUnit unit : this.units) {
            Pilot pilot = unit.getPilot();
            if (pilot.getHits() <= 0) continue;
            int hits = pilot.getHits();
            hits -= health;
            if (pilot.getSkills().has(19)) {
                hits -= medtechHeal;
            }
            pilot.setHits(Math.max(0, hits));
        }
    }

    public void healPilots() {
        if (!Boolean.parseBoolean(this.getMyHouse().getConfig("AllowPilotDamageToTransfer"))) {
            return;
        }
        int health = Integer.parseInt(this.getMyHouse().getConfig("PilotAmountHealedPerTick"));
        int medtechHeal = Integer.parseInt(this.getMyHouse().getConfig("MedTechAmountHealedPerTick"));
        if (Boolean.parseBoolean(this.getMyHouse().getConfig("AllowPersonalPilotQueues"))) {
            for (int type = 0; type < 2; ++type) {
                for (int weight = 0; weight <= 3; ++weight) {
                    LinkedList<Pilot> list = this.personalPilotQueue.getPilotQueue(type, weight);
                    for (Pilot pilot : list) {
                        if (pilot.getHits() <= 0) continue;
                        int hits = pilot.getHits();
                        hits -= health;
                        if (pilot.getSkills().has(19)) {
                            hits -= medtechHeal;
                        }
                        pilot.setHits(Math.max(0, hits));
                    }
                }
            }
        } else {
            for (SUnit unit : this.units) {
                Pilot pilot = unit.getPilot();
                if (pilot.getHits() <= 0) continue;
                int hits = pilot.getHits();
                hits -= health;
                if (pilot.getSkills().has(19)) {
                    hits -= medtechHeal;
                }
                pilot.setHits(Math.max(0, hits));
            }
        }
    }

    public String getReadableStatus(boolean adminStatus) {
        DecimalFormat myFormatter = new DecimalFormat("####.##");
        StringBuilder s = new StringBuilder("<br><b>Status for: " + this.getColoredName() + " (" + this.myHouse.getColoredName());
        if (this.getSubFactionName().trim().length() > 0) {
            s.append("::");
            s.append(this.getSubFactionName());
        }
        s.append(")</b><br>");
        if (adminStatus) {
            s.append("Activity Status: ");
            if (this.getDutyStatus() == 4) {
                s.append("fighting<br>");
            } else if (this.getDutyStatus() == 3) {
                s.append("active<br>");
            } else {
                s.append("inactive<br>");
            }
            if (this.getGroupAllowance() > 0) {
                s.append("IP Group Allowance: " + this.getGroupAllowance() + "<br>");
            }
        }
        s.append("  " + CampaignMain.cm.moneyOrFluMessage(true, false, this.getMoney()) + " //  " + CampaignMain.cm.moneyOrFluMessage(false, false, this.influence) + " // " + this.experience + " Experience<br>");
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            s.append("Technicians (Green/Reg/Vet/Elite): " + this.getTotalTechs().elementAt(0) + "/" + this.getTotalTechs().elementAt(1) + "/" + this.getTotalTechs().elementAt(2) + "/" + this.getTotalTechs().elementAt(3) + "<br>");
            s.append("Idle Techs (Green/Reg/Vet/Elite):  " + this.getAvailableTechs().elementAt(0) + "/" + this.getAvailableTechs().elementAt(1) + "/" + this.getAvailableTechs().elementAt(2) + "/" + this.getAvailableTechs().elementAt(3) + "<br>");
            s.append("Bays: " + this.getFreeBays() + "/" + this.getTotalMekBays() + "<br>");
            s.append("Leased Bays: " + this.getBaysOwned() + " (Cost: " + CampaignMain.cm.moneyOrFluMessage(true, false, this.getCurrentTechPayment()) + "/Game)<br>");
        } else {
            s.append("Technicians (Idle/Total): " + this.getFreeBays() + "/" + this.getTotalMekBays() + "<br>");
            s.append("Paid Technicians: " + this.getTechnicians() + " (Cost: " + CampaignMain.cm.moneyOrFluMessage(true, false, this.getCurrentTechPayment()) + "/Game)<br>");
        }
        if (Boolean.parseBoolean(this.getMyHouse().getConfig("VotingEnabled"))) {
            int votesCast = CampaignMain.cm.getVoteManager().getAllVotesBy(this).size();
            int votesAllowed = this.getNumberOfVotesAllowed();
            if (votesAllowed == votesCast) {
                s.append("Votes: All votes cast (" + votesCast + "/" + votesAllowed + ").<br>");
            } else {
                s.append("Votes: " + votesCast + " votes cast. " + votesAllowed + " votes allowed. (" + votesCast + "/" + votesAllowed + ").<br>");
            }
        }
        if (!Boolean.parseBoolean(this.getMyHouse().getConfig("HideELO")) && !adminStatus) {
            s.append("Rating: " + myFormatter.format(this.getRating()) + "<br>");
        }
        if (Boolean.parseBoolean(this.getMyHouse().getConfig("ShowReward"))) {
            s.append("Current Reward Points: " + this.getReward() + " (Maximum  of " + Integer.parseInt(this.getMyHouse().getConfig("XPRewardCap")) + ")<br>");
        }
        if (this.myHouse.isMercHouse()) {
            s.append("<br>" + this.getReadableMercStatus());
        }
        s.append("<br>");
        if (Integer.parseInt(this.getMyHouse().getConfig("NoPlayListSize")) > 0 || this.exclusionList.getAdminExcludes().size() > 0) {
            s.append("<b>No-Play List:</b> ");
            Enumeration<String> en = this.exclusionList.getPlayerExcludes().elements();
            if (en.hasMoreElements()) {
                s.append(en.nextElement());
            } else {
                s.append("empty");
            }
            while (en.hasMoreElements()) {
                s.append(", " + en.nextElement());
            }
            s.append("<br>");
            s.append("<b>No-Play (Admin):</b> ");
            en = this.exclusionList.getAdminExcludes().elements();
            if (en.hasMoreElements()) {
                s.append(en.nextElement());
            } else {
                s.append("empty");
            }
            while (en.hasMoreElements()) {
                s.append(", " + en.nextElement());
            }
            s.append("<br><br>");
        }
        s.append("<b>Current Armies:<br></b>");
        if (this.armies.size() == 0) {
            s.append("(No armies constructed)<br>");
        } else {
            for (SArmy currA : this.armies) {
                if (adminStatus) {
                    s.append(currA.getDescription(true, true, false) + "<br>");
                    continue;
                }
                s.append(currA.getDescription(true, true, true) + "<br>");
            }
        }
        s.append("<br><b>Contents of Hangar:</b><br>");
        for (SUnit currU : this.units) {
            if (currU.getStatus() == 3) continue;
            if (adminStatus) {
                s.append(currU.getDescription(false) + "<br>");
                continue;
            }
            s.append(currU.getDescription(true) + "<br>");
        }
        StringBuilder saleUnits = new StringBuilder();
        for (SUnit currU : this.units) {
            if (currU.getStatus() != 3) continue;
            if (adminStatus) {
                saleUnits.append(currU.getDescription(false) + "<br>");
                continue;
            }
            saleUnits.append(currU.getDescription(true) + "<br>");
        }
        if (saleUnits.length() > 0) {
            s.append("<br><b>Units on Market:</b><br>");
            s.append((CharSequence)saleUnits);
        }
        s.append("<br>");
        return s.toString();
    }

    public String getReadableMercStatus() {
        String s = "";
        if (this.myHouse.isMercHouse()) {
            s = "Mercenary information for " + this.getName() + ": <br>";
            s = s + "Currently fighting for: " + ((MercHouse)this.myHouse).getHouseFightingFor(this).getName() + "<br>";
            ContractInfo contract = ((MercHouse)this.myHouse).getContractInfo(this);
            s = contract != null ? s + contract.getInfo(this) : s + "Contract Status: Currently avaliable for hire <br>";
            s = s + "<br>";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean toClient) {
        StringBuilder result = new StringBuilder();
        result.append("CP~");
        result.append(this.name);
        result.append("~");
        result.append(this.money);
        result.append("~");
        result.append(this.experience);
        result.append("~");
        result.append(this.units.size() + "~");
        if (this.units.size() > 0) {
            Vector<SUnit> vector = this.units;
            synchronized (vector) {
                for (SUnit currU : this.units) {
                    currU.getPilot().setCurrentFaction(this.myHouse.getName());
                    result.append(currU.toString(toClient));
                    result.append("~");
                }
            }
        }
        result.append(this.armies.size());
        result.append("~");
        for (int i = 0; i < this.armies.size(); ++i) {
            result.append(this.armies.elementAt(i).toString(toClient, "%"));
            result.append("~");
        }
        if (!toClient) {
            if (this.getMyHouse() != null) {
                result.append(this.getMyHouse().getName());
            } else {
                result.append(CampaignMain.cm.getConfig("NewbieHouseName"));
            }
            result.append("~");
            result.append(this.lastOnline);
            result.append("~");
        }
        result.append(this.getTotalMekBays());
        result.append("~");
        result.append(this.getFreeBays());
        result.append("~");
        if (toClient) {
            if (Boolean.parseBoolean(this.getMyHouse().getConfig("HideELO"))) {
                result.append("0");
            } else {
                result.append(this.getRatingRounded());
            }
        } else {
            result.append(this.rating);
        }
        result.append("~");
        result.append(this.influence);
        result.append("~");
        if (!toClient) {
            result.append(this.fluffText);
            result.append(" ~");
            result.append(0);
            result.append("~");
        }
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            result.append(this.getBaysOwned());
        } else {
            result.append(this.technicians);
        }
        result.append("~");
        result.append(this.currentReward);
        result.append("~");
        if (!toClient) {
            if (CampaignMain.cm.isUsingMySQL()) {
                result.append(this.getDBId());
            } else {
                result.append("0");
            }
            result.append("~");
            result.append(0);
            result.append("~");
        }
        result.append(this.myHouse.getName());
        result.append(" ~");
        if (toClient) {
            result.append(this.getHouseFightingFor().getName());
            result.append(" ~");
            if (this.getMyLogo().length() == 0) {
                result.append(this.myHouse.getLogo());
            } else {
                result.append(this.getMyLogo());
            }
            result.append(" ~");
        } else {
            result.append(this.xpToReward);
            result.append("~");
            result.append("0");
            result.append("~");
            result.append(this.getPersonalPilotQueue().toString(toClient));
            result.append("~");
            result.append(this.getExclusionList().adminExcludeToString("$"));
            result.append("~");
            result.append(this.getExclusionList().playerExcludeToString("$"));
            result.append("~");
            if (CampaignMain.cm.isUsingAdvanceRepair()) {
                result.append(this.totalTechsToString());
                result.append("~");
                result.append(this.availableTechsToString());
                result.append("~");
                result.append(this.baysOwned);
                result.append("~");
            } else {
                result.append(" ");
                result.append("~");
                result.append(" ");
                result.append("~");
                result.append(this.technicians);
                result.append("~");
            }
            if (this.getMyLogo().trim().length() == 0) {
                result.append(this.myHouse.getLogo());
            } else {
                result.append(this.getMyLogo());
            }
            result.append(" ~");
            result.append(this.getLastAttackFromReserve());
            result.append("~");
            result.append(this.getGroupAllowance());
            result.append("~");
            if (this.lastISP.length() < 1) {
                result.append(" ");
            } else {
                result.append(this.lastISP);
            }
            result.append("~");
        }
        result.append(this.isInvisible());
        result.append("~");
        if (!toClient) {
            result.append(this.groupAllowance);
            result.append("~");
            if (this.password != null) {
                result.append(this.password.getAccess());
                result.append("~");
                result.append(this.password.getPasswd());
                result.append("~");
                result.append(this.password.getTime());
                result.append("~");
            } else {
                result.append("0~ ~0~");
            }
        }
        result.append(this.unitParts.toString("|"));
        result.append("~");
        result.append(this.getAutoReorder());
        result.append("~");
        if (!toClient) {
            result.append(this.getTeamNumber());
            result.append("~");
            if (this.getSubFactionName().trim().length() < 1) {
                result.append(" ");
            } else {
                result.append(this.getSubFactionName());
            }
            result.append("~");
            result.append(this.getLastPromoted());
            result.append("~");
        }
        return result.toString();
    }

    public synchronized void toDB() {
        if (this.isLoading) {
            return;
        }
        Statement ps = null;
        StringBuffer sql = new StringBuffer();
        try {
            if (this.getDBId() == 0) {
                sql.setLength(0);
                sql.append("INSERT into players set ");
                sql.append("playerName = ?, ");
                sql.append("playerMoney = ?, ");
                sql.append("playerExperience = ?, ");
                sql.append("playerHouseName = ?, ");
                sql.append("playerLastOnline = ?, ");
                sql.append("playerTotalBays = ?, ");
                sql.append("playerFreeBays = ?, ");
                sql.append("playerRating = ?, ");
                sql.append("playerInfluence = ?, ");
                sql.append("playerFluff = ?, ");
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    sql.append("playerBaysOwned = ?, playerTechnicians = NULL, ");
                } else {
                    sql.append("playerBaysOwned = NULL, playerTechnicians = ?, ");
                }
                sql.append("playerRP = ?, ");
                sql.append("playerXPToReward = ?, ");
                sql.append("playerTotalTechsString = ?, ");
                sql.append("playerAvailableTechsString = ?, ");
                sql.append("playerLogo = ?, ");
                sql.append("playerLastAFR = ?, ");
                sql.append("playerGroupAllowance = ?, ");
                sql.append("playerLastISP = ?, ");
                sql.append("playerIsInvisible = ?, ");
                sql.append("playerUnitParts = ?, ");
                sql.append("playerAccess = ?, ");
                sql.append("playerAutoReorder = ?, ");
                sql.append("playerTeamNumber = ?, ");
                sql.append("playerSubFactionName = ?, ");
                sql.append("playerForumID = ?, ");
                sql.append("playerLastPromoted = ?, ");
                sql.append("playerValidated = ?, ");
                sql.append("playerString = ?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString(), 1);
                ps.setString(1, this.getName());
                ps.setInt(2, this.getMoney());
                ps.setInt(3, this.getExperience());
                ps.setString(4, this.getMyHouse().getName());
                ps.setLong(5, this.getLastOnline());
                ps.setInt(6, this.getTotalMekBays());
                ps.setInt(7, this.getFreeBays());
                ps.setDouble(8, this.getRating());
                ps.setInt(9, this.getInfluence());
                ps.setString(10, this.getFluffText());
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    ps.setInt(11, this.getBaysOwned());
                } else {
                    ps.setInt(11, this.getTechnicians());
                }
                ps.setInt(12, this.getReward());
                ps.setInt(13, this.getXPToReward());
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    ps.setString(14, this.totalTechsToString());
                    ps.setString(15, this.availableTechsToString());
                } else {
                    ps.setString(14, "");
                    ps.setString(15, "");
                }
                if (this.getMyLogo().length() > 0) {
                    ps.setString(16, this.getMyLogo());
                } else {
                    ps.setString(16, "");
                }
                ps.setDouble(17, this.getLastAttackFromReserve());
                ps.setInt(18, this.getGroupAllowance());
                ps.setString(19, this.getLastISP());
                ps.setBoolean(20, this.isInvisible());
                ps.setString(21, this.getUnitParts().toString());
                if (this.getPassword() != null) {
                    ps.setInt(22, this.getPassword().getAccess());
                } else {
                    ps.setInt(22, 1);
                }
                ps.setBoolean(23, this.getAutoReorder());
                ps.setInt(24, this.getTeamNumber());
                ps.setString(25, this.getSubFactionName().trim().length() < 1 ? " " : this.getSubFactionName());
                ps.setInt(26, this.getForumID());
                ps.setLong(27, this.getLastPromoted());
                ps.setBoolean(28, this.isValidated());
                ps.setString(29, this.toString(false));
                ps.executeUpdate();
                ResultSet rs = ps.getGeneratedKeys();
                rs.next();
                this.setDBId(rs.getInt(1));
                rs.close();
            } else {
                sql.setLength(0);
                sql.append("UPDATE players set ");
                sql.append("playerName = ?, ");
                sql.append("playerMoney = ?, ");
                sql.append("playerExperience = ?, ");
                sql.append("playerHouseName = ?, ");
                sql.append("playerLastOnline = ?, ");
                sql.append("playerTotalBays = ?, ");
                sql.append("playerFreeBays = ?, ");
                sql.append("playerRating = ?, ");
                sql.append("playerInfluence = ?, ");
                sql.append("playerFluff = ?, ");
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    sql.append("playerBaysOwned = ?, playerTechnicians = NULL, ");
                } else {
                    sql.append("playerTechnicians = ?, playerBaysOwned = NULL, ");
                }
                sql.append("playerRP = ?, ");
                sql.append("playerXPToReward = ?, ");
                sql.append("playerTotalTechsString = ?, ");
                sql.append("playerAvailableTechsString = ?, ");
                sql.append("playerLogo = ?, ");
                sql.append("playerLastAFR = ?, ");
                sql.append("playerGroupAllowance = ?, ");
                sql.append("playerLastISP = ?, ");
                sql.append("playerIsInvisible = ?, ");
                sql.append("playerAccess = ?, ");
                sql.append("playerUnitParts = ?, ");
                sql.append("playerAutoReorder = ?, ");
                sql.append("playerPassword= ?, ");
                sql.append("playerPassTime= ?, ");
                sql.append("playerTeamNumber= ?, ");
                sql.append("playerSubFactionName = ?, ");
                sql.append("playerForumID = ?, ");
                sql.append("playerLastPromoted = ?, ");
                sql.append("playerValidated = ?, ");
                sql.append("playerString = ? ");
                sql.append("WHERE playerID = ?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString());
                ps.setString(1, this.getName());
                ps.setInt(2, this.getMoney());
                ps.setInt(3, this.getExperience());
                ps.setString(4, this.getMyHouse().getName());
                ps.setLong(5, this.getLastOnline());
                ps.setInt(6, this.getTotalMekBays());
                ps.setInt(7, this.getFreeBays());
                ps.setDouble(8, this.getRating());
                ps.setInt(9, this.getInfluence());
                ps.setString(10, this.getFluffText());
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    ps.setInt(11, this.getBaysOwned());
                } else {
                    ps.setInt(11, this.getTechnicians());
                }
                ps.setInt(12, this.getReward());
                ps.setInt(13, this.getXPToReward());
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    ps.setString(14, this.totalTechsToString());
                    ps.setString(15, this.availableTechsToString());
                } else {
                    ps.setString(14, "");
                    ps.setString(15, "");
                }
                if (this.getMyLogo().length() > 0) {
                    ps.setString(16, this.getMyLogo());
                } else {
                    ps.setString(16, "");
                }
                ps.setDouble(17, this.getLastAttackFromReserve());
                ps.setInt(18, this.getGroupAllowance());
                ps.setString(19, this.getLastISP());
                ps.setBoolean(20, this.isInvisible());
                if (this.getPassword() != null) {
                    ps.setInt(21, this.getPassword().getAccess());
                } else {
                    ps.setInt(21, 1);
                }
                ps.setString(22, this.getUnitParts().toString());
                ps.setBoolean(23, this.getAutoReorder());
                if (this.getPassword() != null) {
                    ps.setString(24, this.password.getPasswd());
                } else {
                    ps.setString(24, "");
                }
                if (this.getPassword() != null) {
                    ps.setLong(25, this.password.getTime());
                } else {
                    ps.setLong(25, 0L);
                }
                ps.setInt(26, this.getTeamNumber());
                ps.setString(27, this.getSubFactionName().trim().length() < 1 ? " " : this.getSubFactionName());
                ps.setInt(28, this.getForumID());
                ps.setLong(29, this.getLastPromoted());
                ps.setBoolean(30, this.isValidated());
                ps.setString(31, this.toString(false));
                ps.setInt(32, this.getDBId());
                ps.executeUpdate();
            }
            ps.close();
            this.getExclusionList().toDB(this.getDBId());
            if (this.getUnits().size() > 0) {
                for (SUnit currU : this.getUnits()) {
                    SPilot sPilot = (SPilot)currU.getPilot();
                    sPilot.setCurrentFaction(this.getMyHouse().getName());
                    sPilot.toDB(currU.getType(), currU.getWeightclass());
                    currU.toDB();
                }
            }
            ps.close();
            ps = CampaignMain.cm.MySQL.getPreparedStatement("DELETE from playerarmies WHERE playerID = " + this.getDBId());
            ps.executeUpdate();
            for (int weightClass = 0; weightClass < 3; ++weightClass) {
                for (SPilot sPilot : this.getPersonalPilotQueue().getPilotQueue(0, weightClass)) {
                    sPilot.toDB(0, weightClass);
                }
                for (SPilot sPilot : this.getPersonalPilotQueue().getPilotQueue(3, weightClass)) {
                    sPilot.toDB(3, weightClass);
                }
            }
            ps.close();
            CampaignData.mwlog.dbLog("Player " + this.getName() + " saved");
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL error in SPlayer.toDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromString(String s) {
        if (s == null) {
            throw new NullPointerException("SPlayer fromString(s) is null");
        }
        this.isLoading = true;
        try {
            int i;
            this.armies.clear();
            s = s.substring(3);
            StringTokenizer ST = new StringTokenizer(s, "~");
            this.setName(TokenReader.readString(ST));
            this.exclusionList.setOwnerName(this.name);
            if (CampaignMain.cm.isUsingMySQL()) {
                int dbId = CampaignMain.cm.MySQL.getPlayerIDByName(this.name);
                this.setDBId(dbId);
            }
            this.money = TokenReader.readInt(ST);
            this.experience = TokenReader.readInt(ST);
            int numofarmies = 0;
            int numofUnits = TokenReader.readInt(ST);
            this.units = new Vector(1, 1);
            for (i = 0; i < numofUnits; ++i) {
                SUnit m = new SUnit();
                m.fromString((String)ST.nextElement());
                this.units.add(m);
                CampaignMain.cm.toUser("PL|HD|" + m.toString(true), this.name, false);
            }
            numofarmies = Integer.parseInt((String)ST.nextElement());
            for (i = 0; i < numofarmies; ++i) {
                SArmy a = new SArmy(this.name);
                a.fromString((String)ST.nextElement(), "%", this);
                if (this.armies.size() < a.getID()) {
                    this.armies.add(a);
                } else {
                    this.armies.add(a.getID(), a);
                }
                CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), this.name, false);
            }
            this.setMyHouse(CampaignMain.cm.getHouseFromPartialString(TokenReader.readString(ST), null));
            this.lastOnline = TokenReader.readLong(ST);
            TokenReader.readString(ST);
            TokenReader.readString(ST);
            this.rating = TokenReader.readDouble(ST);
            this.influence = TokenReader.readInt(ST);
            this.fluffText = TokenReader.readString(ST).trim();
            int numberOfOptions = TokenReader.readInt(ST);
            for (int i2 = 0; i2 < numberOfOptions; ++i2) {
                TokenReader.readString(ST);
                TokenReader.readString(ST);
            }
            if (CampaignMain.cm.isUsingAdvanceRepair()) {
                int greenTechs = TokenReader.readInt(ST);
                int regTechs = greenTechs / 5;
                this.updateAvailableTechs((greenTechs -= regTechs) + "%" + regTechs + "%0%0%");
                this.getTotalTechs().addAll(this.getAvailableTechs());
                this.setBaysOwned(greenTechs + regTechs);
            } else {
                int te = TokenReader.readInt(ST);
                int mt = CampaignMain.cm.getIntegerConfig("MaxTechsToHire");
                this.technicians = mt != -1 ? Math.min(te, mt) : te;
            }
            this.currentReward = TokenReader.readInt(ST);
            if (CampaignMain.cm.isUsingMySQL()) {
                this.setDBId(TokenReader.readInt(ST));
            } else {
                TokenReader.readString(ST);
            }
            TokenReader.readString(ST);
            this.myHouse = CampaignMain.cm.getHouseFromPartialString(TokenReader.readString(ST));
            if (this.myHouse == null) {
                this.myHouse = CampaignMain.cm.getHouseFromPartialString(CampaignMain.cm.getConfig("NewbieHouseName"));
            }
            this.setXPToReward(TokenReader.readInt(ST));
            TokenReader.readString(ST);
            this.getPersonalPilotQueue().fromString(TokenReader.readString(ST), "$");
            this.getExclusionList().adminExcludeFromString(TokenReader.readString(ST), "$");
            this.getExclusionList().playerExcludeFromString(TokenReader.readString(ST), "$");
            try {
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    this.updateTotalTechs(TokenReader.readString(ST));
                    this.updateAvailableTechs(TokenReader.readString(ST));
                    this.setBaysOwned(TokenReader.readInt(ST));
                } else {
                    TokenReader.readString(ST);
                    TokenReader.readString(ST);
                    if (this.technicians <= 0) {
                        this.technicians = TokenReader.readInt(ST);
                    } else {
                        TokenReader.readString(ST);
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.myLogo = TokenReader.readString(ST);
            try {
                this.setLastAttackFromReserve(TokenReader.readLong(ST));
                this.setGroupAllowance(TokenReader.readInt(ST));
                this.setLastISP(TokenReader.readString(ST));
                this.setInvisible(TokenReader.readBoolean(ST));
                this.setGroupAllowance(TokenReader.readInt(ST));
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                int access = TokenReader.readInt(ST);
                String passwd = TokenReader.readString(ST);
                long time = TokenReader.readLong(ST);
                if (passwd.trim().length() > 2) {
                    this.setPassword(new MWPasswdRecord(this.name, access, passwd, time, ""));
                }
            }
            catch (Exception ex) {
                this.isLoading = false;
                this.isLoading = false;
                return;
            }
            if (CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
                this.unitParts.fromString(TokenReader.readString(ST), "|");
            } else {
                TokenReader.readString(ST);
            }
            this.setAutoReorder(TokenReader.readBoolean(ST));
            this.setTeamNumber(TokenReader.readInt(ST));
            this.subFaction = TokenReader.readString(ST);
            this.lastPromoted = TokenReader.readLong(ST);
            if (this.password != null && this.password.getPasswd().trim().length() <= 2) {
                this.password.setAccess(1);
            }
            if (CampaignMain.cm.isUsingCyclops()) {
                CampaignMain.cm.getMWCC().playerWrite(this);
                CampaignMain.cm.getMWCC().unitWriteFromList(this.getUnits(), this.name, this.myHouse.getName());
                CampaignMain.cm.getMWCC().pilotWriteFromList(this.getPersonalPilotQueue(), this.name);
            }
            CampaignMain.cm.toUser("PL|SB|" + this.getTotalMekBays(), this.name, false);
            CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.name, false);
            if (CampaignMain.cm.isUsingAdvanceRepair()) {
                if (!this.hasRepairingUnits()) {
                    CampaignMain.cm.toUser("PL|UTT|" + this.totalTechsToString(), this.name, false);
                    CampaignMain.cm.toUser("PL|UAT|" + this.totalTechsToString(), this.name, false);
                    this.updateAvailableTechs(this.totalTechsToString());
                } else {
                    CampaignMain.cm.toUser("PL|UTT|" + this.totalTechsToString(), this.name, false);
                    CampaignMain.cm.toUser("PL|UAT|" + this.availableTechsToString(), this.name, false);
                }
            }
            this.healAllPilots();
            for (SUnit currU : this.units) {
                this.fixPilot(currU);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
        finally {
            this.isLoading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fromDB(int playerID) {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        try {
            ResultSet rs = null;
            ResultSet rs1 = null;
            Statement stmt = CampaignMain.cm.MySQL.getStatement();
            Statement stmt1 = CampaignMain.cm.MySQL.getStatement();
            rs = stmt.executeQuery("SELECT * from players WHERE playerID = " + playerID);
            if (rs.next()) {
                String pString = rs.getString("playerString");
                if (pString != null && pString.trim().length() > 0) {
                    this.fromString(rs.getString("playerString"));
                    this.forumID = rs.getInt("playerForumID");
                    rs.close();
                    stmt.close();
                    stmt1.close();
                    CampaignData.mwlog.dbLog("Player " + this.getName() + " loaded");
                    return;
                }
                this.armies.clear();
                this.setName(rs.getString("playerName"));
                CampaignData.mwlog.dbLog("Loading player " + this.name);
                this.exclusionList.setOwnerName(this.name);
                this.setDBId(playerID);
                this.money = rs.getInt("playerMoney");
                this.experience = rs.getInt("playerExperience");
                this.units = new Vector(1, 1);
                this.forumID = rs.getInt("playerForumID");
                rs1 = stmt1.executeQuery("SELECT ID from units WHERE uplayerID = " + playerID);
                while (rs1.next()) {
                    SUnit m = new SUnit();
                    m.fromDB(rs1.getInt("ID"));
                    this.units.add(m);
                    CampaignMain.cm.toUser("PL|HD|" + m.toString(true), this.name, false);
                }
                rs1.close();
                rs1 = stmt1.executeQuery("SELECT * from playerarmies WHERE playerID = " + playerID);
                while (rs1.next()) {
                    SArmy a = new SArmy(this.name);
                    a.fromString(rs1.getString("armyString"), "%", this);
                    if (this.armies.size() < a.getID()) {
                        this.armies.add(a);
                    } else {
                        this.armies.add(a.getID(), a);
                    }
                    CampaignMain.cm.toUser("PL|SAD|" + a.toString(true, "%"), this.name, false);
                }
                this.setMyHouse(CampaignMain.cm.getHouseFromPartialString(rs.getString("playerHouseName"), null));
                this.lastOnline = rs.getLong("playerLastOnline");
                this.rating = rs.getDouble("playerRating");
                this.influence = rs.getInt("playerInfluence");
                this.fluffText = rs.getString("playerFluff").trim();
                this.setTeamNumber(rs.getInt("playerTeamNumber"));
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    this.addBays(rs.getInt("playerBaysOwned"));
                } else {
                    this.technicians = rs.getInt("playerTechnicians");
                }
                this.currentReward = rs.getInt("playerRP");
                this.myHouse = CampaignMain.cm.getHouseFromPartialString(rs.getString("playerHouseName"), this.getName());
                this.setXPToReward(rs.getInt("playerXPToReward"));
                this.getPersonalPilotQueue().fromDB(this.getDBId());
                this.getExclusionList().fromDB(this.getDBId());
                try {
                    if (CampaignMain.cm.isUsingAdvanceRepair()) {
                        this.updateTotalTechs(rs.getString("playerTotalTechsString"));
                        this.updateAvailableTechs(rs.getString("playerAvailableTechsString"));
                    } else if (this.technicians <= 0) {
                        this.technicians = rs.getInt("playerTechnicians");
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.myLogo = rs.getString("playerLogo");
                try {
                    this.setLastAttackFromReserve(rs.getLong("playerLastAFR"));
                    this.setGroupAllowance(rs.getInt("playerGroupAllowance"));
                    this.setLastISP(rs.getString("playerLastISP"));
                    this.setInvisible(rs.getBoolean("playerIsInvisible"));
                    this.setGroupAllowance(rs.getInt("playerGroupAllowance"));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    int access = rs.getInt("playerAccess");
                    String passwd = rs.getString("playerPassword");
                    long time = System.currentTimeMillis();
                    if (access >= 2) {
                        this.password = new MWPasswdRecord(this.name, access, passwd, time, "");
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
                    this.unitParts.fromString(rs.getString("playerUnitParts"), "|");
                }
                this.subFaction = rs.getString("playerSubfactionName");
                this.setAutoReorder(rs.getBoolean("playerAutoReorder"));
                this.setLastPromoted(rs.getLong("playerLastPromoted"));
                this.setUserValidated(rs.getBoolean("playerValidated"));
                if (this.password != null && this.password.getPasswd().trim().length() <= 2) {
                    this.password.setAccess(1);
                }
                if (CampaignMain.cm.isUsingCyclops()) {
                    CampaignMain.cm.getMWCC().playerWrite(this);
                    CampaignMain.cm.getMWCC().unitWriteFromList(this.getUnits(), this.name, this.myHouse.getName());
                    CampaignMain.cm.getMWCC().pilotWriteFromList(this.getPersonalPilotQueue(), this.name);
                }
                CampaignMain.cm.toUser("PL|SB|" + this.getTotalMekBays(), this.name, false);
                CampaignMain.cm.toUser("PL|SF|" + this.getFreeBays(), this.name, false);
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    if (!this.hasRepairingUnits()) {
                        CampaignMain.cm.toUser("PL|UTT|" + this.totalTechsToString(), this.name, false);
                        CampaignMain.cm.toUser("PL|UAT|" + this.totalTechsToString(), this.name, false);
                        this.updateAvailableTechs(this.totalTechsToString());
                    } else {
                        CampaignMain.cm.toUser("PL|UTT|" + this.totalTechsToString(), this.name, false);
                        CampaignMain.cm.toUser("PL|UAT|" + this.availableTechsToString(), this.name, false);
                    }
                }
                this.healAllPilots();
                for (SUnit currU : this.units) {
                    this.fixPilot(currU);
                }
            }
            rs.close();
            if (rs1 != null) {
                rs1.close();
            }
            stmt.close();
            stmt1.close();
            CampaignData.mwlog.dbLog("Player " + this.getName() + " loaded");
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in SPlayer.fromDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
        finally {
            this.isLoading = false;
        }
    }

    private void fixPilot(SUnit unit) {
        if (!unit.hasVacantPilot()) {
            return;
        }
        if (Boolean.parseBoolean(this.getMyHouse().getConfig("AllowPersonalPilotQueues")) && unit.isSinglePilotUnit()) {
            return;
        }
        SPilot pilot = this.getMyHouse().getNewPilot(unit.getType());
        unit.setPilot(pilot);
        CampaignMain.cm.toUser("PL|UU|" + unit.getId() + " |" + unit.toString(true), this.name, false);
        for (SArmy currA : this.armies) {
            if (currA.getUnit(unit.getId()) == null) continue;
            currA.setBV(0);
            CampaignMain.cm.toUser("PL|SAD|" + currA.toString(true, "%"), this.name, false);
            CampaignMain.cm.getOpsManager().checkOperations(currA, true);
        }
    }

    public UnitComponents getUnitParts() {
        return this.unitParts;
    }

    public int getPartsAmount(String part) {
        int amount = 0;
        amount += this.getHouseFightingFor().getPartsAmount(part);
        return amount += this.getUnitParts().getPartsCritCount(part);
    }

    public void updatePartsCache(String part, int amount) {
        if (amount < 0) {
            int playerAmount = this.getUnitParts().getPartsCritCount(part);
            if (playerAmount >= Math.abs(amount)) {
                this.getUnitParts().remove(part, amount);
            } else {
                this.getHouseFightingFor().updatePartsCache(part, amount += playerAmount);
                this.getUnitParts().remove(part, playerAmount);
                amount = -playerAmount;
            }
        } else {
            this.getUnitParts().add(part, amount);
        }
        CampaignMain.cm.toUser("PL|UPPC|" + part + "#" + amount, this.getName(), false);
    }

    public SArmy getLockedArmy() {
        for (SArmy army : this.getArmies()) {
            if (!army.isLocked()) continue;
            return army;
        }
        return null;
    }

    public int getDBId() {
        return this.DBId;
    }

    public void setDBId(int id) {
        this.DBId = id;
        this.personalPilotQueue.setOwnerID(id);
    }

    public void setForumID(int id) {
        this.forumID = id;
    }

    public int getForumID() {
        return this.forumID;
    }

    @Override
    public void setTeamNumber(int team) {
        super.setTeamNumber(team);
        this.setSave();
    }

    public void setSubFaction(String subFaction) {
        this.subFaction = subFaction;
        if (this.getSubFactionAccess() != 0) {
            this.setLastPromoted(System.currentTimeMillis());
        }
        this.setSave();
    }

    public SubFaction getSubFaction() {
        SubFaction sub = this.getMyHouse().getSubFactionList().get(this.subFaction);
        if (sub == null) {
            return new SubFaction();
        }
        return sub;
    }

    public int getSubFactionAccess() {
        SubFaction sub = this.getMyHouse().getSubFactionList().get(this.subFaction);
        if (sub == null) {
            return 0;
        }
        return Integer.parseInt(sub.getConfig("AccessLevel"));
    }

    public String getSubFactionName() {
        return this.subFaction;
    }

    public boolean playerIsLoading() {
        return this.isLoading;
    }

    public boolean canBePromoted() {
        if (this.getMyHouse().getSubFactionList().size() < 1) {
            return false;
        }
        int days = this.getMyHouse().getIntegerConfig("daysbetweenpromotions");
        long day = 86400000L;
        try {
            long daysSinceLastPromoted = (System.currentTimeMillis() - this.getLastPromoted()) / day;
            if (daysSinceLastPromoted < (long)days) {
                return false;
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return false;
        }
        return true;
    }

    public void checkForPromotion() {
        if (!this.canBePromoted()) {
            return;
        }
        int currentAccessLevel = this.getSubFactionAccess();
        for (SubFaction subFaction : this.getMyHouse().getSubFactionList().values()) {
            if (currentAccessLevel >= Integer.parseInt(subFaction.getConfig("AccessLevel")) || !(this.getRating() >= (double)Integer.parseInt(subFaction.getConfig("MinELO"))) || this.getExperience() < Integer.parseInt(subFaction.getConfig("MinExp"))) continue;
            CampaignMain.cm.toUser("You are eligible for a promotion to subFaction " + subFaction.getConfig("Name") + ". <a href=\"MEKWARS/c RequestSubFactionPromotion#" + subFaction.getConfig("Name") + "\">Click here to request promotion.</a>", this.getName());
        }
    }

    public void checkForDemotion() {
        SubFaction subfaction = this.getSubFaction();
        int access = this.getSubFactionAccess();
        int elo = Integer.parseInt(subfaction.getConfig("MinELO"));
        int exp = Integer.parseInt(subfaction.getConfig("MinExp"));
        if (access < 1) {
            return;
        }
        if ((double)elo > this.getRating() || exp > this.getExperience()) {
            StringBuilder message = new StringBuilder(this.name);
            message.append(" no longer meets the eligbility requirements for subfaction ");
            message.append(this.getSubFactionName());
            message.append(". He is eligible for the following:<br>");
            for (SubFaction subFaction : this.getMyHouse().getSubFactionList().values()) {
                if (access <= Integer.parseInt(subFaction.getConfig("AccessLevel")) || !(this.getRating() >= (double)Integer.parseInt(subFaction.getConfig("MinELO"))) || this.getExperience() < Integer.parseInt(subFaction.getConfig("MinExp"))) continue;
                if (CampaignMain.cm.getBooleanConfig("autoPromoteSubFaction")) {
                    String subFactionName = subFaction.getConfig("Name");
                    this.setSubFaction(subFactionName);
                    CampaignMain.cm.toUser("PL|SSN|" + subFactionName, this.getName(), false);
                    CampaignMain.cm.doSendToAllOnlinePlayers("PI|FT|" + this.getName() + "|" + this.getFluffText(), false);
                    CampaignMain.cm.toUser("HS|CA|0", this.getName(), false);
                    CampaignMain.cm.toUser(this.getMyHouse().getCompleteStatus(), this.getName(), false);
                    for (SArmy army : this.getArmies()) {
                        CampaignMain.cm.getOpsManager().checkOperations(army, true);
                    }
                    CampaignMain.cm.toUser("AM:You have been demoted to SubFaction " + subFactionName + ".", this.getName());
                    CampaignMain.cm.doSendHouseMail(this.getMyHouse(), "NOTE", this.getName() + " has been demoted to subfaction " + subFactionName + " by the Faction Leadership!");
                    return;
                }
                message.append(subFaction.getConfig("Name"));
                message.append(". <a href=\"MEKWARS/c demoteplayer#");
                message.append(this.getName());
                message.append("#");
                message.append(subFaction.getConfig("Name"));
                message.append("\">Click here to demote.</a><br>");
            }
            if (CampaignMain.cm.getBooleanConfig("autoPromoteSubFaction")) {
                return;
            }
            message.append("None");
            message.append(". <a href=\"MEKWARS/c demoteplayer#");
            message.append(this.getName());
            message.append("#");
            message.append("None");
            message.append("\">Click here to demote.</a><br>");
            this.getMyHouse().sendMessageToHouseLeaders(message.toString());
        }
    }

    public long getLastPromoted() {
        return this.lastPromoted;
    }

    public void setLastPromoted(long promotedTime) {
        this.lastPromoted = promotedTime;
    }

    public void lockArmy(int armyId) {
        for (SArmy army : this.getArmies()) {
            if (army.getID() == armyId) {
                army.setLocked(true);
                CampaignMain.cm.toUser("PL|SAL|" + armyId + "#" + true, this.getName(), false);
                continue;
            }
            if (!army.isLocked()) continue;
            army.setLocked(false);
            CampaignMain.cm.toUser("PL|SAL|" + army.getID() + "#" + false, this.getName(), false);
        }
    }

    public void setUserValidated(boolean validated) {
        this.userValidated = validated;
    }

    public boolean isValidated() {
        return this.userValidated;
    }
}

