/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import common.MegaMekPilotOption;
import common.Unit;
import common.campaign.pilot.skills.PilotSkill;
import common.util.TokenReader;
import common.util.UnitUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EntityListFile;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Tank;
import megamek.common.WeaponType;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.pilot.SPilot;
import server.campaign.pilot.skills.PainResistanceSkill;
import server.campaign.pilot.skills.SPilotSkill;
import server.campaign.pilot.skills.WeaponSpecialistSkill;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SUnit
extends Unit {
    private Integer BV = 0;
    private Integer scrappableFor = new Integer(-1);
    private long passesMaintainanceUntil = 0L;
    private boolean pilotIsRepairing = false;
    private Entity unitEntity = null;
    private int lastCombatPilot = -1;

    public SUnit() {
    }

    public SUnit(String p, String Filename, int weightclass) {
        int gunnery = 4;
        int piloting = 5;
        SHouse house = CampaignMain.cm.getHouseFromPartialString(p, null);
        this.setUnitFilename(Filename);
        this.init();
        if (house != null) {
            this.setPilot(house.getNewPilot(this.getType()));
        } else {
            this.setPilot(new SPilot(SPilot.getRandomPilotName(CampaignMain.cm.getR()), gunnery, piloting));
        }
        this.setWeightclass(weightclass);
        this.setProducer(p);
        this.setId(CampaignMain.cm.getAndUpdateCurrentUnitID());
    }

    public SUnit(int replaceId, String p, String Filename) {
        this.setUnitFilename(Filename);
        Entity ent = SUnit.loadMech(this.getUnitFilename());
        this.setEntity(ent);
        this.init();
        this.setPilot(new SPilot("Vacant", 99, 99));
        this.setId(replaceId);
        this.setProducer(p);
        this.unitEntity = ent;
    }

    public static void checkAmmoForUnit(SUnit u, SHouse h) {
        Entity en = u.getEntity();
        boolean wasChanged = false;
        for (Mounted mAmmo : en.getAmmo()) {
            AmmoType at = (AmmoType)mAmmo.getType();
            String munition = Long.toString(at.getMunitionType());
            if (at.getAmmoType() == 28 || at.getAmmoType() == 19 || at.getAmmoType() == 11 || at.getAmmoType() == 31 || (long)at.getAmmoType() == 0L || !CampaignMain.cm.getData().getServerBannedAmmo().containsKey(munition) && !h.getBannedAmmo().containsKey(munition)) continue;
            Vector<AmmoType> types = AmmoType.getMunitionsFor(at.getAmmoType());
            Enumeration<AmmoType> allTypes = types.elements();
            boolean defaultFound = false;
            while (allTypes.hasMoreElements() && !defaultFound) {
                AmmoType currType = allTypes.nextElement();
                if (currType.getTechLevel() > en.getTechLevel() || currType.getMunitionType() != 0L || currType.getRackSize() != at.getRackSize()) continue;
                mAmmo.changeAmmoType(currType);
                mAmmo.setShotsLeft(at.getShots());
                defaultFound = true;
                wasChanged = true;
            }
        }
        if (wasChanged) {
            u.setEntity(en);
        }
    }

    public static boolean mayBeSoldOnMarket(SUnit u) {
        if (u.getType() == 4 && !CampaignMain.cm.getBooleanConfig("BAMayBeSoldOnBM")) {
            return false;
        }
        if (u.getType() == 3 && !CampaignMain.cm.getBooleanConfig("ProtosMayBeSoldOnBM")) {
            return false;
        }
        if (u.getType() == 5 && !CampaignMain.cm.getBooleanConfig("AerosMayBeSoldOnBM")) {
            return false;
        }
        if (u.getType() == 2 && !CampaignMain.cm.getBooleanConfig("InfantryMayBeSoldOnBM")) {
            return false;
        }
        if (u.getType() == 1 && !CampaignMain.cm.getBooleanConfig("VehsMayBeSoldOnBM")) {
            return false;
        }
        return u.getType() != 0 && u.getType() != 6 || CampaignMain.cm.getBooleanConfig("MeksMayBeSoldOnBM");
    }

    public static int getHangarSpaceRequired(int typeid, int weightclass, int baymod, String model, SHouse faction) {
        if (typeid == 3) {
            return 0;
        }
        if (typeid == 2 && CampaignMain.cm.getBooleanConfig("FootInfTakeNoBays")) {
            boolean isFoot = model.startsWith("Foot");
            boolean isAMFoot = model.startsWith("Anti-Mech Foot");
            if (isFoot || isAMFoot) {
                return 0;
            }
        }
        int result = 1;
        String techAmount = "TechsFor" + Unit.getWeightClassDesc(weightclass) + Unit.getTypeClassDesc(typeid);
        result = faction != null ? faction.getIntegerConfig(techAmount) : CampaignMain.cm.getIntegerConfig(techAmount);
        if (!CampaignMain.cm.isUsingAdvanceRepair()) {
            result += baymod;
        }
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public static int getHangarSpaceRequired(int typeid, int weightclass, int baymod, String model, boolean unitSupported, SHouse faction) {
        if (unitSupported) {
            return SUnit.getHangarSpaceRequired(typeid, weightclass, baymod, model, faction);
        }
        return (int)((float)SUnit.getHangarSpaceRequired(typeid, weightclass, baymod, model, faction) * CampaignMain.cm.getFloatConfig("NonFactionUnitsIncreasedTechs"));
    }

    public static int getHangarSpaceRequired(SUnit u, SHouse faction) {
        return SUnit.getHangarSpaceRequired(u.getType(), u.getWeightclass(), u.getPilot().getBayModifier(), u.getModelName(), faction);
    }

    public static int getHangarSpaceRequired(SUnit u, boolean unitSupported, SHouse faction) {
        if (unitSupported) {
            return SUnit.getHangarSpaceRequired(u.getType(), u.getWeightclass(), u.getPilot().getBayModifier(), u.getModelName(), faction);
        }
        return SUnit.getHangarSpaceRequired(u.getType(), u.getWeightclass(), u.getPilot().getBayModifier(), u.getModelName(), unitSupported, faction);
    }

    public static int getMapSizeModification(SUnit u) {
        if (u.getType() == 1) {
            return CampaignMain.cm.getIntegerConfig("VehicleMapSizeFactor");
        }
        if (u.getType() == 2) {
            return CampaignMain.cm.getIntegerConfig("InfantryMapSizeFactor");
        }
        if (u.getType() == 0) {
            return CampaignMain.cm.getIntegerConfig("MekMapSizeFactor");
        }
        if (u.getType() == 4) {
            return CampaignMain.cm.getIntegerConfig("BattleArmorMapSizeFactor");
        }
        if (u.getType() == 5) {
            return CampaignMain.cm.getIntegerConfig("AeroMapSizeFactor");
        }
        if (u.getType() == 3) {
            return CampaignMain.cm.getIntegerConfig("ProtoMekMapSizeFactor");
        }
        return 0;
    }

    public static double getArmorCost(Entity unit) {
        double cost = 0.0;
        if (CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
            return 0.0;
        }
        String armorCost = "CostPoint" + UnitUtils.getArmorShortName(unit);
        cost = CampaignMain.cm.getDoubleConfig(armorCost);
        return cost;
    }

    public static double getStructureCost(Entity unit) {
        double cost = 0.0;
        if (CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
            return 0.0;
        }
        String armorCost = "CostPoint" + UnitUtils.getInternalShortName(unit) + "IS";
        cost = CampaignMain.cm.getDoubleConfig(armorCost);
        return cost;
    }

    public static double getCritCost(Entity unit, CriticalSlot crit) {
        WeaponType weapon;
        Mounted mounted;
        double cost = 0.0;
        if (CampaignMain.cm.getBooleanConfig("UsePartsRepair")) {
            return 0.0;
        }
        if (crit == null) {
            return 0.0;
        }
        if (crit.isBreached() && !crit.isDamaged()) {
            return 0.0;
        }
        cost = UnitUtils.isEngineCrit(crit) ? CampaignMain.cm.getDoubleConfig("EngineCritRepairCost") : (crit.getType() == 0 ? (crit.isMissing() ? CampaignMain.cm.getDoubleConfig("SystemCritReplaceCost") : CampaignMain.cm.getDoubleConfig("SystemCritRepairCost")) : ((mounted = unit.getEquipment(crit.getIndex())).getType() instanceof WeaponType ? ((weapon = (WeaponType)mounted.getType()).hasFlag(131072L) ? (crit.isMissing() ? CampaignMain.cm.getDoubleConfig("EnergyWeaponCritReplaceCost") : CampaignMain.cm.getDoubleConfig("EnergyWeaponCritRepairCost")) : (weapon.hasFlag(65536L) ? (crit.isMissing() ? CampaignMain.cm.getDoubleConfig("BallisticCritReplaceCost") : CampaignMain.cm.getDoubleConfig("BallisticCritRepairCost")) : (weapon.hasFlag(262144L) ? (crit.isMissing() ? CampaignMain.cm.getDoubleConfig("MissileCritReplaceCost") : CampaignMain.cm.getDoubleConfig("MissileCritRepairCost")) : (crit.isMissing() ? CampaignMain.cm.getDoubleConfig("EquipmentCritReplaceCost") : CampaignMain.cm.getDoubleConfig("EquipmentCritRepairCost"))))) : (crit.isMissing() ? CampaignMain.cm.getDoubleConfig("EquipmentCritReplaceCost") : CampaignMain.cm.getDoubleConfig("EquipmentCritRepairCost"))));
        cost = Math.max(cost, 1.0);
        return cost;
    }

    public String toString(boolean toPlayer) {
        if (toPlayer) {
            this.setBV(0);
            this.getBV();
        }
        StringBuilder result = new StringBuilder();
        result.append("CM$");
        result.append(this.getUnitFilename());
        result.append("$");
        result.append(this.getPosId());
        result.append("$");
        result.append(this.getStatus());
        result.append("$");
        result.append(this.getProducer());
        result.append("$");
        result.append(((SPilot)this.getPilot()).toFileFormat("#", toPlayer));
        result.append("$");
        if (toPlayer) {
            LinkedList<MegaMekPilotOption> mmoptions = this.getPilot().getMegamekOptions();
            result.append(mmoptions.size());
            result.append("$");
            for (MegaMekPilotOption mmo : mmoptions) {
                result.append(mmo.getMmname());
                result.append("$");
                result.append(mmo.isValue());
                result.append("$");
            }
            result.append(this.getType());
            result.append("$");
            result.append(this.getBV());
            result.append("$");
        }
        result.append(this.getWeightclass());
        result.append("$");
        result.append(this.getId());
        result.append("$");
        if (this.getModelName().equals("OMG-UR-FD")) {
            return result.toString();
        }
        if (this.getEntity() instanceof Mech) {
            this.unitEntity = this.getEntity();
            result.append(((Mech)this.unitEntity).isAutoEject());
            result.append("$");
        }
        ArrayList<Mounted> en_Ammo = this.unitEntity.getAmmo();
        result.append(en_Ammo.size());
        result.append("$");
        for (Mounted mAmmo : en_Ammo) {
            boolean hotloaded = mAmmo.isHotLoaded();
            if (!CampaignMain.cm.getMegaMekClient().game.getOptions().booleanOption("tacops_hotload")) {
                hotloaded = false;
            }
            AmmoType at = (AmmoType)mAmmo.getType();
            result.append(at.getAmmoType());
            result.append("$");
            result.append(at.getInternalName());
            result.append("$");
            result.append(mAmmo.getShotsLeft());
            result.append("$");
            result.append(hotloaded);
            result.append("$");
        }
        if (this.unitEntity instanceof Mech || this.unitEntity instanceof Tank) {
            int mgCount = CampaignMain.cm.getMachineGunCount(this.unitEntity.getWeaponList());
            result.append(mgCount);
            result.append("$");
            if (mgCount > 0) {
                int endLocation = 7;
                if (this.unitEntity instanceof Tank) {
                    endLocation = 5;
                }
                for (int location = 0; location <= endLocation; ++location) {
                    for (int slot = 0; slot < this.unitEntity.getNumberOfCriticals(location); ++slot) {
                        WeaponType wt;
                        Mounted m;
                        CriticalSlot crit = this.unitEntity.getCritical(location, slot);
                        if (crit == null || crit.getType() != 1 || (m = this.unitEntity.getEquipment(crit.getIndex())) == null || !(m.getType() instanceof WeaponType) || !(wt = (WeaponType)m.getType()).hasFlag(512L)) continue;
                        result.append(location);
                        result.append("$");
                        result.append(slot);
                        result.append("$");
                        result.append(m.isRapidfire());
                        result.append("$");
                    }
                }
            }
        } else {
            result.append("0$");
        }
        result.append("0$0$");
        if (CampaignMain.cm.getData().getBannedTargetingSystems().containsKey(this.getEntity().getTargSysType())) {
            result.append(0);
            this.getEntity().setTargSysType(0);
        } else {
            result.append(this.getEntity().getTargSysType());
        }
        result.append("$");
        result.append(this.getScrappableFor());
        result.append("$");
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            result.append(UnitUtils.unitBattleDamage(this.getEntity(), false));
        } else {
            result.append("%%-%%-%%-");
        }
        result.append("$");
        if (toPlayer) {
            result.append(this.getPilotIsReparing());
            result.append("$");
        }
        if (!toPlayer) {
            result.append(this.getLastCombatPilot());
            result.append("$");
        }
        result.append(this.getCurrentRepairCost());
        result.append("$");
        result.append(this.getLifeTimeRepairCost());
        result.append("$");
        if (CampaignMain.cm.isUsingMySQL() && !toPlayer) {
            result.append(this.getDBId());
            result.append("$");
        }
        return result.toString();
    }

    public synchronized void toDB() {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        Entity ent = this.getEntity();
        ResultSet rs = null;
        try {
            if (this.getDBId() == 0) {
                sql.setLength(0);
                sql.append("INSERT into units set MWID=?, uFileName=?, uPosID=?, uStatus=?, uProducer=?, uWeightClass=?, uAutoEject=?, uHasSpotlight=?, uIsUsingSpotlight=?, uTargetSystem=?, uScrappableFor=?, uBattleDamage=?, uLastCombatPilot=?, uCurrentRepairCost=?, uLifetimeRepairCost=?, uType=?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString(), 1);
                ps.setInt(1, this.getId());
                ps.setString(2, this.getUnitFilename());
                ps.setInt(3, this.getPosId());
                ps.setInt(4, this.getStatus());
                ps.setString(5, this.getProducer() == null ? " " : this.getProducer());
                ps.setInt(6, this.getWeightclass());
                if (ent instanceof Mech) {
                    ps.setBoolean(7, ((Mech)ent).isAutoEject());
                } else {
                    ps.setBoolean(7, false);
                }
                ps.setBoolean(8, false);
                ps.setBoolean(9, false);
                if (CampaignMain.cm.getData().getBannedTargetingSystems().containsKey(this.getEntity().getTargSysType())) {
                    ps.setInt(10, 0);
                    this.getEntity().setTargSysType(0);
                } else {
                    ps.setInt(10, ent.getTargSysType());
                }
                ps.setInt(11, this.getScrappableFor());
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    ps.setString(12, UnitUtils.unitBattleDamage(this.getEntity(), false));
                } else {
                    ps.setString(12, "%%-%%-%%-");
                }
                ps.setInt(13, this.getLastCombatPilot());
                ps.setInt(14, this.getCurrentRepairCost());
                ps.setInt(15, this.getLifeTimeRepairCost());
                ps.setInt(16, this.getType());
                ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                rs.next();
                this.setDBId(rs.getInt(1));
                rs.close();
            } else {
                sql.setLength(0);
                sql.append("UPDATE units set uFileName=?, uPosID=?, uStatus=?, uProducer=?, uWeightClass=?, uAutoEject=?, uHasSpotlight=?, uIsUsingSpotlight=?, uTargetSystem=?, uScrappableFor=?, uBattleDamage=?, uLastCombatPilot=?, uCurrentRepairCost=?, uLifetimeRepairCost=?, uType = ?, MWID=? WHERE ID = ?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString());
                ps.setString(1, this.getUnitFilename());
                ps.setInt(2, this.getPosId());
                ps.setInt(3, this.getStatus());
                ps.setString(4, this.getProducer() == null ? " " : this.getProducer());
                ps.setInt(5, this.getWeightclass());
                if (ent instanceof Mech) {
                    ps.setBoolean(6, ((Mech)ent).isAutoEject());
                } else {
                    ps.setBoolean(6, false);
                }
                ps.setBoolean(7, ent.hasSpotlight());
                ps.setBoolean(8, ent.isUsingSpotlight());
                if (CampaignMain.cm.getData().getBannedTargetingSystems().containsKey(this.getEntity().getTargSysType())) {
                    ps.setInt(9, 0);
                    this.getEntity().setTargSysType(0);
                } else {
                    ps.setInt(9, ent.getTargSysType());
                }
                ps.setInt(10, this.getScrappableFor());
                if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    ps.setString(11, UnitUtils.unitBattleDamage(this.getEntity(), false));
                } else {
                    ps.setString(11, "%%-%%-%%-");
                }
                ps.setInt(12, this.getLastCombatPilot());
                ps.setInt(13, this.getCurrentRepairCost());
                ps.setInt(14, this.getLifeTimeRepairCost());
                ps.setInt(15, this.getType());
                ps.setInt(16, this.getId());
                ps.setInt(17, this.getDBId());
                ps.executeUpdate();
            }
            ps.executeUpdate("DELETE from unit_mgs WHERE unitID = " + this.getDBId());
            ps.executeUpdate("DELETE from unit_ammo WHERE unitID = " + this.getDBId());
            ps.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Exception in SUnit.toDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            try {
                if (ps != null) {
                    ps.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
    }

    public String fromString(String s) {
        try {
            s = s.substring(3);
            StringTokenizer ST = new StringTokenizer(s, "$");
            this.setUnitFilename(TokenReader.readString(ST));
            this.setPosId(TokenReader.readInt(ST));
            int newstate = TokenReader.readInt(ST);
            this.setProducer(TokenReader.readString(ST));
            SPilot p = new SPilot();
            p.fromFileFormat(TokenReader.readString(ST), "#");
            this.setWeightclass(TokenReader.readInt(ST));
            this.setId(TokenReader.readInt(ST));
            if (CampaignMain.cm.getCurrentUnitID() <= this.getId()) {
                CampaignMain.cm.setCurrentUnitID(this.getId() + 1);
            }
            if (this.getId() == 0) {
                this.setId(CampaignMain.cm.getAndUpdateCurrentUnitID());
            }
            if (newstate == 3 && CampaignMain.cm.getMarket().getListingForUnit(this.getId()) == null) {
                this.setStatus(1);
            } else if (CampaignMain.cm.isUsingAdvanceRepair()) {
                this.setStatus(1);
            } else {
                this.setStatus(newstate);
            }
            this.unitEntity = SUnit.loadMech(this.getUnitFilename());
            this.setEntity(this.unitEntity);
            this.init();
            this.setPilot(p);
            if (this.getModelName().equals("OMG-UR-FD")) {
                return s;
            }
            if (this.unitEntity instanceof Mech) {
                ((Mech)this.unitEntity).setAutoEject(TokenReader.readBoolean(ST));
            }
            String defaultField = "";
            if (ST.hasMoreElements()) {
                Entity en = this.getEntity();
                int maxCrits = TokenReader.readInt(ST);
                defaultField = TokenReader.readString(ST);
                ArrayList<Mounted> e = en.getAmmo();
                for (int count = 0; count < maxCrits; ++count) {
                    int weaponType = Integer.parseInt(defaultField);
                    String ammoName = TokenReader.readString(ST);
                    int shots = TokenReader.readInt(ST);
                    boolean hotloaded = false;
                    try {
                        defaultField = TokenReader.readString(ST);
                        hotloaded = Boolean.parseBoolean(defaultField);
                        defaultField = TokenReader.readString(ST);
                    }
                    catch (Exception ex) {
                        hotloaded = false;
                    }
                    if (!CampaignMain.cm.getMegaMekClient().game.getOptions().booleanOption("tacops_hotload")) {
                        hotloaded = false;
                    }
                    Mounted mWeapon = e.get(count);
                    AmmoType at = this.getEntityAmmo(weaponType, ammoName);
                    if (at == null) continue;
                    String munition = Long.toString(at.getMunitionType());
                    if (CampaignMain.cm.getData().getServerBannedAmmo().get(munition) != null) continue;
                    mWeapon.changeAmmoType(at);
                    mWeapon.setShotsLeft(shots);
                    mWeapon.setHotLoad(hotloaded);
                }
                this.setEntity(en);
            }
            int maxMachineGuns = Integer.parseInt(defaultField);
            Entity en = this.getEntity();
            for (int count = 0; count < maxMachineGuns; ++count) {
                int location = TokenReader.readInt(ST);
                int slot = TokenReader.readInt(ST);
                boolean selection = TokenReader.readBoolean(ST);
                try {
                    CriticalSlot cs = en.getCritical(location, slot);
                    Mounted m = en.getEquipment(cs.getIndex());
                    m.setRapidfire(selection);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            this.setEntity(en);
            TokenReader.readString(ST);
            TokenReader.readString(ST);
            if (CampaignMain.cm.getMegaMekClient().game.getOptions().booleanOption("allow_level_3_targsys")) {
                int targetingType = TokenReader.readInt(ST);
                if (CampaignMain.cm.getData().getBannedTargetingSystems().containsKey(targetingType) || this.getEntity().hasC3() || this.getEntity().hasC3i() || UnitUtils.hasTargettingComputer(this.getEntity())) {
                    this.unitEntity.setTargSysType(0);
                } else {
                    this.unitEntity.setTargSysType(targetingType);
                }
            } else {
                ST.nextElement();
            }
            this.setScrappableFor(TokenReader.readInt(ST));
            if (CampaignMain.cm.isUsingAdvanceRepair() && (this.unitEntity instanceof Mech || this.unitEntity instanceof Tank)) {
                UnitUtils.applyBattleDamage(this.unitEntity, TokenReader.readString(ST), CampaignMain.cm.getRTT() != null && CampaignMain.cm.getRTT().unitRepairTimes(this.getId()) != null);
            } else {
                TokenReader.readString(ST);
            }
            this.setLastCombatPilot(TokenReader.readInt(ST));
            this.setRepairCosts(TokenReader.readInt(ST), TokenReader.readInt(ST));
            if (CampaignMain.cm.isUsingMySQL() && ST.hasMoreTokens()) {
                this.setDBId(TokenReader.readInt(ST));
            }
            return s;
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            CampaignData.mwlog.errLog("Unable to Load SUnit: " + s);
            return s;
        }
    }

    public synchronized void fromDB(int unitID) {
        ResultSet rs = null;
        ResultSet ammoRS = null;
        ResultSet mgRS = null;
        Statement ammoStmt = null;
        Statement mgStmt = null;
        Statement stmt = null;
        try {
            ammoStmt = CampaignMain.cm.MySQL.getStatement();
            mgStmt = CampaignMain.cm.MySQL.getStatement();
            stmt = CampaignMain.cm.MySQL.getStatement();
            ammoRS = ammoStmt.executeQuery("SELECT * from unit_ammo WHERE unitID = " + unitID + " ORDER BY ammoLocation");
            mgRS = mgStmt.executeQuery("SELECT * from unit_mgs WHERE unitID = " + unitID + " ORDER BY mgLocation");
            rs = stmt.executeQuery("SELECT * from units WHERE ID = " + unitID);
            if (rs.next()) {
                this.setUnitFilename(rs.getString("uFileName"));
                this.setPosId(rs.getInt("uPosID"));
                int newstate = rs.getInt("uStatus");
                this.setProducer(rs.getString("uProducer"));
                this.setWeightclass(rs.getInt("uWeightClass"));
                this.setId(rs.getInt("MWID"));
                this.setDBId(unitID);
                if (CampaignMain.cm.getCurrentUnitID() <= this.getId()) {
                    CampaignMain.cm.setCurrentUnitID(this.getId() + 1);
                }
                if (this.getId() == 0) {
                    this.setId(CampaignMain.cm.getAndUpdateCurrentUnitID());
                }
                if (newstate == 3 && CampaignMain.cm.getMarket().getListingForUnit(this.getId()) == null) {
                    this.setStatus(1);
                } else if (CampaignMain.cm.isUsingAdvanceRepair()) {
                    this.setStatus(1);
                } else {
                    this.setStatus(newstate);
                }
                this.setScrappableFor(rs.getInt("uScrappableFor"));
                this.setRepairCosts(rs.getInt("uCurrentRepairCost"), rs.getInt("uLifetimeRepairCost"));
                Entity unitEntity = SUnit.loadMech(this.getUnitFilename());
                if (unitEntity instanceof Mech) {
                    ((Mech)unitEntity).setAutoEject(rs.getBoolean("uAutoEject"));
                }
                unitEntity.setSpotlight(rs.getBoolean("uHasSpotlight"));
                unitEntity.setSpotlightState(rs.getBoolean("uIsUsingSpotlight"));
                if (CampaignMain.cm.isUsingAdvanceRepair() && (unitEntity instanceof Mech || unitEntity instanceof Tank)) {
                    UnitUtils.applyBattleDamage(unitEntity, rs.getString("uBattleDamage"), CampaignMain.cm.getRTT() != null & CampaignMain.cm.getRTT().unitRepairTimes(this.getId()) != null);
                }
                if (CampaignMain.cm.getMegaMekClient().game.getOptions().booleanOption("allow_level_3_targsys")) {
                    int targetingType = rs.getInt("uTargetSystem");
                    if (CampaignMain.cm.getData().getBannedTargetingSystems().containsKey(targetingType) || unitEntity.hasC3() || unitEntity.hasC3i() || UnitUtils.hasTargettingComputer(unitEntity)) {
                        unitEntity.setTargSysType(0);
                    } else {
                        unitEntity.setTargSysType(targetingType);
                    }
                }
                this.setEntity(unitEntity);
                SPilot p = CampaignMain.cm.MySQL.loadUnitPilot(unitID);
                this.init();
                this.setPilot(p);
                this.setLastCombatPilot(p.getPilotId());
                unitEntity = this.getEntity();
                while (ammoRS.next()) {
                    int weaponType = ammoRS.getInt("ammoType");
                    String ammoName = ammoRS.getString("ammoInternalName");
                    int shots = ammoRS.getInt("ammoShotsLeft");
                    int AmmoLoc = ammoRS.getInt("ammoLocation");
                    boolean hotloaded = Boolean.parseBoolean(ammoRS.getString("ammoHotLoaded"));
                    if (!CampaignMain.cm.getMegaMekClient().game.getOptions().booleanOption("tacops_hotload")) {
                        hotloaded = false;
                    }
                    AmmoType at = this.getEntityAmmo(weaponType, ammoName);
                    String munition = Long.toString(at.getMunitionType());
                    if (CampaignMain.cm.getData().getServerBannedAmmo().get(munition) != null) continue;
                    try {
                        unitEntity.getAmmo().get(AmmoLoc).changeAmmoType(at);
                        unitEntity.getAmmo().get(AmmoLoc).setShotsLeft(shots);
                        unitEntity.getAmmo().get(AmmoLoc).setHotLoad(hotloaded);
                    }
                    catch (Exception ex) {
                        CampaignData.mwlog.dbLog("Exception: " + ex.toString());
                        CampaignData.mwlog.dbLog(ex.getStackTrace().toString());
                    }
                }
                this.setEntity(unitEntity);
                Entity en = this.getEntity();
                while (mgRS.next()) {
                    int location = mgRS.getInt("mgLocation");
                    int slot = mgRS.getInt("mgSlot");
                    boolean selection = mgRS.getBoolean("mgRapidFire");
                    try {
                        CriticalSlot cs = en.getCritical(location, slot);
                        Mounted m = en.getEquipment(cs.getIndex());
                        m.setRapidfire(selection);
                    }
                    catch (Exception ex) {}
                }
                this.setEntity(unitEntity);
            }
            rs.close();
            mgRS.close();
            ammoRS.close();
            stmt.close();
            mgStmt.close();
            ammoStmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL Error in SUnit.fromDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
            try {
                if (rs != null) {
                    rs.close();
                }
                if (mgRS != null) {
                    mgRS.close();
                }
                if (ammoRS != null) {
                    ammoRS.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (mgStmt != null) {
                    mgStmt.close();
                }
                if (ammoStmt != null) {
                    ammoStmt.close();
                }
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
    }

    public String getDescription(boolean showLink) {
        String status = "";
        status = CampaignMain.cm.isUsingAdvanceRepair() ? (UnitUtils.hasCriticalDamage(this.getEntity()) ? "Is Critically Damaged" : (UnitUtils.hasArmorDamage(this.getEntity()) ? "Has Minor Armor Damage" : (UnitUtils.isRepairing(this.getEntity()) ? "Is Currently Under Going Repairs" : "Is Fully Functional"))) : (this.getStatus() == 2 ? "Unmaintained (" + this.getMaintainanceLevel() + "%)" : "Maintained (" + this.getMaintainanceLevel() + "%)");
        String idToShow = "";
        idToShow = showLink ? "<a href=\"MEKWARS/c sth#u#" + this.getId() + "\">#" + this.getId() + "</a>" : "#" + this.getId();
        String dialogBox = "<a href=\"MEKINFO" + this.getEntity().getChassis() + " " + this.getEntity().getModel() + "#" + this.getBV() + "#" + this.getPilot().getGunnery() + "#" + this.getPilot().getPiloting() + "\">" + this.getModelName() + "</a>";
        if (this.getType() == 0 || this.getType() == 1) {
            return idToShow + " " + dialogBox + " (" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ") [" + this.getPilot().getExperience() + " EXP " + this.getPilot().getSkillString(false) + "] Kills: " + this.getPilot().getKills() + " " + this.getProducer() + ". BV: " + this.getBV() + " " + status;
        }
        if ((this.getType() == 2 || this.getType() == 4) && ((Infantry)this.getEntity()).isAntiMek()) {
            return idToShow + " " + dialogBox + " (" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ") [" + this.getPilot().getExperience() + " EXP " + this.getPilot().getSkillString(false) + "] Kills: " + this.getPilot().getKills() + " " + this.getProducer() + ". BV: " + this.getBV() + " " + status;
        }
        return idToShow + " " + dialogBox + " (" + this.getPilot().getGunnery() + ") [" + this.getPilot().getExperience() + " EXP " + this.getPilot().getSkillString(false) + "] Kills: " + this.getPilot().getKills() + " " + this.getProducer() + ". BV: " + this.getBV() + " " + status;
    }

    public String getSmallDescription() {
        String result = this.getType() == 0 || this.getType() == 1 || this.getType() == 5 ? this.getModelName() + " [" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() : (this.getType() == 2 || this.getType() == 4 ? (((Infantry)this.getEntity()).isAntiMek() ? this.getModelName() + " [" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() : this.getModelName() + " [" + this.getPilot().getGunnery()) : this.getModelName() + " [" + this.getPilot().getGunnery());
        if (!this.getPilot().getSkillString(true).equals(" ")) {
            result = result + this.getPilot().getSkillString(true);
        }
        result = result + "]";
        return result;
    }

    public String getModelName() {
        if (this.checkModelName() == null) {
            this.unitEntity = SUnit.loadMech(this.getUnitFilename());
            this.init();
        }
        return this.checkModelName();
    }

    public String getVerboseModelName() {
        if (this.getType() == 0 || this.getType() == 1 || this.getType() == 5) {
            return this.getModelName() + " (" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ")";
        }
        if ((this.getType() == 2 || this.getType() == 4) && ((Infantry)this.getEntity()).isAntiMek()) {
            return this.getModelName() + " (" + this.getPilot().getGunnery() + "/" + this.getPilot().getPiloting() + ")";
        }
        return this.getModelName() + " (" + this.getPilot().getGunnery() + ")";
    }

    public int calcBV() {
        try {
            if (this.hasVacantPilot()) {
                this.getEntity().getCrew().setGunnery(4);
                this.getEntity().getCrew().setPiloting(5);
            } else {
                this.getEntity().setCrew(UnitUtils.createEntityPilot(this));
            }
            int calcedBV = this.getEntity().calculateBattleValue(false, false);
            int FastHoverBVMod = CampaignMain.cm.getIntegerConfig("FastHoverBVMod");
            if (FastHoverBVMod > 0 && this.getType() == 1 && this.getEntity().getMovementMode() == 5 && this.getEntity().getWalkMP() >= 8) {
                calcedBV += FastHoverBVMod;
            }
            if (CampaignMain.cm.getBooleanConfig("ElitePilotsBVMod")) {
                if (this.getPilot().getGunnery() < 3) {
                    calcedBV = (int)Math.round((double)calcedBV * 1.05);
                } else if (this.getPilot().getPiloting() < 3) {
                    calcedBV = (int)Math.round((double)calcedBV * 1.05);
                }
            }
            calcedBV += this.getPilotSkillBV();
            if (this.hasVacantPilot()) {
                this.getEntity().getCrew().setGunnery(99);
                this.getEntity().getCrew().setPiloting(99);
            }
            return calcedBV;
        }
        catch (Exception ex) {
            return Integer.MAX_VALUE;
        }
    }

    public boolean equals(Object o) {
        SUnit m = null;
        try {
            m = (SUnit)o;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (m == null) {
            return false;
        }
        return m.getId() == this.getId() && m.getUnitFilename().equals(this.getUnitFilename()) && m.getPilot().getGunnery() == this.getPilot().getGunnery() && m.getPilot().getPiloting() == this.getPilot().getPiloting();
    }

    public void setPilot(SPilot p) {
        this.setBV(0);
        if (p == null) {
            return;
        }
        Pilot mPilot = new Pilot(p.getName(), p.getGunnery(), p.getPiloting());
        Entity entity = this.getEntity();
        if (this.getEntity() instanceof BattleArmor && !((BattleArmor)this.getEntity()).isAntiMek() && !this.hasVacantPilot()) {
            mPilot.setPiloting(5);
        }
        entity.setCrew(mPilot);
        this.setEntity(entity);
        if (p.getSkills().has(12)) {
            Iterator<PilotSkill> ski = p.getSkills().getSkillIterator();
            while (ski.hasNext()) {
                SPilotSkill skill = (SPilotSkill)ski.next();
                if (!skill.getName().equals("Weapon Specialist") || !p.getWeapon().equals("Default")) continue;
                p.getSkills().remove(skill);
                ((WeaponSpecialistSkill)skill).assignWeapon(this.getEntity(), p);
                skill.addToPilot(p);
                skill.modifyPilot(p);
                break;
            }
        }
        p.setUnitType(this.getType());
        super.setPilot(p);
        if (CampaignMain.cm.isUsingMySQL()) {
            this.toDB();
        }
    }

    public void init() {
        this.setType(Unit.getEntityType(this.getEntity()));
        if (this.getType() == 3 || this.getType() == 4 || this.getType() == 2 || this.getType() == 1 || this.getEntity().isOmni()) {
            this.setModelname(new String(this.unitEntity.getChassis() + " " + this.unitEntity.getModel()).trim());
        } else if (this.unitEntity.getModel().trim().length() > 0) {
            this.setModelname(this.unitEntity.getModel().trim());
        } else {
            this.setModelname(this.unitEntity.getChassis().trim());
        }
        this.getC3Type(this.unitEntity);
        if (this.getModelName().equals("OMG-UR-FD")) {
            this.setProducer("Error loading unit. Tried to build from " + this.getUnitFilename());
            this.setWeightclass(0);
        }
    }

    public void setUnmaintainedStatus() {
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            this.setStatus(1);
            return;
        }
        int baseUnmaintained = CampaignMain.cm.getIntegerConfig("BaseUnmaintainedLevel");
        int unmaintPenalty = CampaignMain.cm.getIntegerConfig("UnmaintainedPenalty");
        this.setStatus(2);
        if (this.getMaintainanceLevel() >= baseUnmaintained + unmaintPenalty) {
            this.setMaintainanceLevel(baseUnmaintained);
        } else {
            this.addToMaintainanceLevel(-unmaintPenalty);
        }
    }

    public int getBV() {
        int toReturn = 0;
        if (this.BV <= 0) {
            toReturn = this.calcBV();
            this.BV = toReturn;
        } else {
            toReturn = this.BV;
        }
        return toReturn < 0 ? 0 : toReturn;
    }

    public void setBV(Integer i) {
        if (i < 0) {
            this.BV = 0;
        }
        this.BV = i;
    }

    public Entity getEntity() {
        if (this.unitEntity != null) {
            return this.unitEntity;
        }
        this.unitEntity = SUnit.loadMech(this.getUnitFilename());
        return this.unitEntity;
    }

    public void setEntity(Entity unitEntity) {
        this.unitEntity = unitEntity;
    }

    public static Entity loadMech(String Filename) {
        if (Filename == null) {
            return null;
        }
        Entity ent = null;
        if (new File("./data/mechfiles").exists()) {
            try {
                MechSummary ms = MechSummaryCache.getInstance().getMech(Filename.trim());
                if (ms == null) {
                    MechSummary[] units;
                    for (MechSummary unit : units = MechSummaryCache.getInstance().getAllMechs()) {
                        if (!unit.getEntryName().equalsIgnoreCase(Filename) && !unit.getModel().trim().equalsIgnoreCase(Filename.trim()) && !unit.getChassis().trim().equalsIgnoreCase(Filename.trim())) continue;
                        ms = unit;
                        break;
                    }
                }
                if (ms != null) {
                    ent = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
                }
            }
            catch (Exception exep) {
                ent = null;
            }
        }
        if (ent != null) {
            return ent;
        }
        try {
            ent = new MechFileParser(new File("./data/unitfiles/Meks.zip"), Filename).getEntity();
        }
        catch (Exception ex) {
            try {
                ent = new MechFileParser(new File("./data/unitfiles/Vehicles.zip"), Filename).getEntity();
            }
            catch (Exception exe) {
                try {
                    ent = new MechFileParser(new File("./data/unitfiles/Infantry.zip"), Filename).getEntity();
                }
                catch (Exception exei) {
                    CampaignData.mwlog.errLog("Error loading: " + Filename);
                    try {
                        ent = UnitUtils.createOMG();
                    }
                    catch (Exception exep) {
                        CampaignData.mwlog.errLog("Unable to find default unit file. Server Exiting");
                        CampaignData.mwlog.errLog(exep);
                        System.exit(1);
                    }
                }
            }
        }
        return ent;
    }

    public void setPassesMaintainanceUntil(long l) {
        this.passesMaintainanceUntil = l;
    }

    public long getPassesMaintainanceUntil() {
        return this.passesMaintainanceUntil;
    }

    public int getScrappableFor() {
        return this.scrappableFor;
    }

    public void setScrappableFor(int i) {
        this.scrappableFor = i;
    }

    public int getExperience() {
        return this.getPilot().getExperience();
    }

    public void setExperience(Integer experience) {
        this.getPilot().setExperience(experience);
    }

    public boolean isOmni() {
        boolean isOmni = this.getEntity().isOmni();
        String targetChassis = this.getEntity().getChassis();
        if (this.getType() == 1 && !isOmni) {
            try {
                FileInputStream fis = new FileInputStream("./data/buildtables/omnivehiclelist.txt");
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                while (dis.ready()) {
                    String chassie = dis.readLine();
                    if (!targetChassis.equalsIgnoreCase(chassie)) continue;
                    dis.close();
                    fis.close();
                    return true;
                }
                dis.close();
                fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isOmni;
    }

    public boolean hasTAG() {
        return this.getEntity().hasTAG();
    }

    public boolean hasHoming() {
        for (Mounted ammo : this.getEntity().getAmmo()) {
            if (((AmmoType)ammo.getType()).getMunitionType() != 0x2000000000L) continue;
            return true;
        }
        return false;
    }

    public boolean hasSemiGuided() {
        for (Mounted ammo : this.getEntity().getAmmo()) {
            if (((AmmoType)ammo.getType()).getMunitionType() != 524288L) continue;
            return true;
        }
        return false;
    }

    public int getPilotSkillBV() {
        int skillBV = 0;
        Iterator<PilotSkill> pilotSkills = this.getPilot().getSkills().getSkillIterator();
        while (pilotSkills.hasNext()) {
            SPilotSkill skill = (SPilotSkill)pilotSkills.next();
            if (skill instanceof WeaponSpecialistSkill || skill instanceof PainResistanceSkill) {
                skillBV += skill.getBVMod(this.getEntity(), (SPilot)this.getPilot());
                continue;
            }
            skillBV += skill.getBVMod(this.getEntity());
        }
        return skillBV;
    }

    public void setPilotIsRepairing(boolean repair) {
        this.pilotIsRepairing = repair;
    }

    public boolean getPilotIsReparing() {
        return this.pilotIsRepairing;
    }

    public int getLastCombatPilot() {
        return this.lastCombatPilot;
    }

    public void setLastCombatPilot(int pilot) {
        this.lastCombatPilot = pilot;
    }

    @Override
    public void setWeightclass(int i) {
        if (i > 3 || i < 0) {
            i = SUnit.getEntityWeight(this.getEntity());
        }
        super.setWeightclass(i);
    }

    public static Vector<SUnit> createMULUnits(String filename) {
        return SUnit.createMULUnits(filename, "autoassigned unit");
    }

    public static Vector<SUnit> createMULUnits(String filename, String fluff) {
        Vector<SUnit> mulUnits = new Vector<SUnit>(1, 1);
        Vector<Entity> loadedUnits = null;
        File entityFile = new File("data/armies/" + filename);
        try {
            loadedUnits = EntityListFile.loadFrom(entityFile);
            loadedUnits.trimToSize();
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Unable to load file " + entityFile.getName());
            CampaignData.mwlog.errLog(ex);
            return mulUnits;
        }
        for (Entity en : loadedUnits) {
            SUnit cm = new SUnit();
            cm.setEntity(en);
            cm.setUnitFilename(UnitUtils.getEntityFileName(en));
            cm.setId(CampaignMain.cm.getAndUpdateCurrentUnitID());
            cm.init();
            cm.setProducer(fluff);
            SPilot pilot = null;
            pilot = new SPilot(en.getCrew().getName(), en.getCrew().getGunnery(), en.getCrew().getPiloting());
            if (pilot.getName().equalsIgnoreCase("Unnamed") || pilot.getName().equalsIgnoreCase("vacant")) {
                pilot.setName(SPilot.getRandomPilotName(CampaignMain.cm.getR()));
            }
            pilot.setCurrentFaction("Common");
            StringTokenizer skillList = new StringTokenizer(en.getCrew().getAdvantageList(","), ",");
            while (skillList.hasMoreTokens()) {
                String skill = skillList.nextToken();
                if (skill.toLowerCase().startsWith("weapon_specialist")) {
                    pilot.addMegamekOption(new MegaMekPilotOption("weapon_specialist", true));
                    pilot.getSkills().add(CampaignMain.cm.getPilotSkill(12));
                    pilot.setWeapon(skill.substring("weapon_specialist".length()).trim());
                    continue;
                }
                if (skill.toLowerCase().startsWith("edge ")) {
                    pilot.addMegamekOption(new MegaMekPilotOption("edge", true));
                    pilot.getSkills().add(CampaignMain.cm.getPilotSkill(20));
                    try {
                        pilot.getSkills().getPilotSkill(20).setLevel(Integer.parseInt(skill.substring("edge ".length()).trim()));
                    }
                    catch (Exception ex) {
                        pilot.getSkills().getPilotSkill(20).setLevel(1);
                    }
                    continue;
                }
                if (skill.toLowerCase().equals("edge_when_headhit")) {
                    pilot.setHeadHit(true);
                    continue;
                }
                if (skill.toLowerCase().equals("edge_when_tac")) {
                    pilot.setTac(true);
                    continue;
                }
                if (skill.toLowerCase().equals("edge_when_ko")) {
                    pilot.setKO(true);
                    continue;
                }
                if (skill.toLowerCase().equals("edge_when_explosion")) {
                    pilot.setExplosion(true);
                    continue;
                }
                pilot.getSkills().add(CampaignMain.cm.getPilotSkill(PilotSkill.getMMSkillID(skill)));
                pilot.addMegamekOption(new MegaMekPilotOption(skill, true));
            }
            cm.setPilot(pilot);
            cm.setWeightclass(99);
            mulUnits.add(cm);
        }
        return mulUnits;
    }
}

