/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import common.Unit;
import common.UnitFactory;
import common.util.TokenReader;
import java.io.File;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.BuildTable;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SUnit;
import server.campaign.pilot.SPilot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SUnitFactory
extends UnitFactory
implements Serializable {
    private static final long serialVersionUID = 1735176578439214960L;
    private SPlanet planet;

    public SUnitFactory() {
    }

    public SUnitFactory(String Name2, SPlanet P, String Size, String Faction, int ticksuntilrefresh, int refreshSpeed, int type, String buildTableFolder, int accessLevel) {
        this.setName(Name2);
        this.setPlanet(P);
        this.setSize(Size);
        this.setFounder(Faction);
        this.setTicksUntilRefresh(ticksuntilrefresh);
        this.setRefreshSpeed(refreshSpeed);
        this.setType(type);
        this.setBuildTableFolder(buildTableFolder);
        this.setAccessLevel(accessLevel);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("MF*");
        result.append(this.getName());
        result.append("*");
        result.append(this.getSize());
        result.append("*");
        result.append(this.getFounder());
        result.append("*");
        result.append(this.getTicksUntilRefresh());
        result.append("*");
        result.append(this.getRefreshSpeed());
        result.append("*");
        String buildtablefolder = this.getBuildTableFolder().replaceAll("standard\\" + File.separatorChar, "");
        if (buildtablefolder.trim().length() < 1 || buildtablefolder.equals("standard")) {
            result.append("0");
        } else {
            result.append(buildtablefolder);
        }
        result.append("*");
        result.append(this.getType());
        result.append("*");
        result.append(this.isLocked());
        result.append("*");
        result.append(this.getAccessLevel());
        result.append("*");
        return result.toString();
    }

    public void toDB() {
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        SPlanet planet = this.getPlanet();
        PreparedStatement ps = null;
        int fid = 0;
        try {
            stmt = CampaignMain.cm.MySQL.getStatement();
            sql.setLength(0);
            sql.append("SELECT FactoryID from factories WHERE FactoryID = '");
            sql.append(this.getID());
            sql.append("'");
            rs = stmt.executeQuery(sql.toString());
            if (!rs.next()) {
                sql.setLength(0);
                sql.append("INSERT into factories set ");
                sql.append("FactoryName = ?, ");
                sql.append("FactorySize = ?, ");
                sql.append("FactoryFounder = ?, ");
                sql.append("FactoryTicks = ?, ");
                sql.append("FactoryRefreshSpeed = ?, ");
                sql.append("FactoryType = ?, ");
                sql.append("FactoryPlanet = ?, ");
                sql.append("FactoryisLocked = ?, ");
                sql.append("FactoryBuildTableFolder = ?, ");
                sql.append("FactoryAccessLevel = ?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString(), 1);
                ps.setString(1, this.getName());
                ps.setString(2, this.getSize());
                ps.setString(3, this.getFounder());
                ps.setInt(4, this.getTicksUntilRefresh());
                ps.setInt(5, this.getRefreshSpeed());
                ps.setInt(6, this.getType());
                ps.setString(7, planet.getName());
                ps.setString(8, Boolean.toString(this.isLocked()));
                ps.setString(9, this.getBuildTableFolder());
                ps.setInt(10, this.getAccessLevel());
                ps.executeUpdate();
                rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    fid = rs.getInt(1);
                    this.setID(fid);
                }
            } else {
                fid = rs.getInt("FactoryID");
                sql.setLength(0);
                sql.append("UPDATE factories set ");
                sql.append("FactoryName = ?, ");
                sql.append("FactorySize = ?, ");
                sql.append("FactoryPlanet = ?, ");
                sql.append("FactoryFounder = ?, ");
                sql.append("FactoryTicks = ?, ");
                sql.append("FactoryRefreshSpeed = ?, ");
                sql.append("FactoryType = ?, ");
                sql.append("FactoryisLocked = ?, ");
                sql.append("FactoryBuildTableFolder = ?, ");
                sql.append("FactoryAccessLevel = ? ");
                sql.append("WHERE FactoryID = ?");
                ps = CampaignMain.cm.MySQL.getPreparedStatement(sql.toString());
                ps.setString(1, this.getName());
                ps.setString(2, this.getSize());
                ps.setString(3, planet.getName());
                ps.setString(4, this.getFounder());
                ps.setInt(5, this.getTicksUntilRefresh());
                ps.setInt(6, this.getRefreshSpeed());
                ps.setInt(7, this.getType());
                ps.setString(8, Boolean.toString(this.isLocked()));
                ps.setString(9, this.getBuildTableFolder());
                ps.setInt(10, this.getAccessLevel());
                ps.setInt(11, this.getID());
                ps.executeUpdate();
            }
            rs.close();
            ps.close();
            stmt.close();
        }
        catch (SQLException e) {
            CampaignData.mwlog.dbLog("SQL ERROR in SUnitFactory.toDB: " + e.getMessage());
            CampaignData.mwlog.dbLog(e);
        }
    }

    public void fromString(String s, SPlanet p, Random r) {
        s = s.substring(3);
        StringTokenizer ST = new StringTokenizer(s, "*");
        this.setName(TokenReader.readString(ST));
        this.setSize(TokenReader.readString(ST));
        this.setFounder(TokenReader.readString(ST));
        this.setTicksUntilRefresh(TokenReader.readInt(ST));
        this.setRefreshSpeed(TokenReader.readInt(ST));
        this.setBuildTableFolder(TokenReader.readString(ST));
        this.setType(TokenReader.readInt(ST));
        this.setLock(TokenReader.readBoolean(ST));
        this.setAccessLevel(TokenReader.readInt(ST));
        this.setPlanet(p);
    }

    public String getIcons() {
        String sizeid = "";
        String result = "";
        int size = this.getWeightclass();
        if (size == 0) {
            sizeid = sizeid + "l";
        } else if (size == 1) {
            sizeid = sizeid + "m";
        } else if (size == 2) {
            sizeid = sizeid + "h";
        } else if (size == 3) {
            sizeid = sizeid + "a";
        }
        if (this.canProduce(0)) {
            sizeid = sizeid + "m";
        } else if (this.canProduce(1)) {
            sizeid = sizeid + "v";
        } else if (this.canProduce(2)) {
            sizeid = sizeid + "li";
        } else if (this.canProduce(4)) {
            sizeid = sizeid + "b";
        } else if (this.canProduce(3)) {
            sizeid = sizeid + "p";
        } else if (this.canProduce(5)) {
            sizeid = sizeid + "ae";
        }
        result = result + "<img src=\"data/images/" + sizeid + ".gif\">";
        return result;
    }

    public Vector<SUnit> getMechProduced(int type_id, SPilot pilot) {
        String Filename = "";
        String producer = "Built by ";
        Vector<SUnit> units = new Vector<SUnit>(1, 1);
        producer = this.getPlanet().getOwner() != null ? producer + this.getPlanet().getOwner().getName() : producer + this.getFounder();
        if (this.getPlanet().getName() != null) {
            producer = producer + " on " + this.getPlanet().getName();
        }
        String unitSize = this.getSize();
        if (CampaignMain.cm.getBooleanConfig("UseOnlyOneVehicleSize") && type_id == 1) {
            unitSize = Unit.getWeightClassDesc(CampaignMain.cm.getRandomNumber(4));
        }
        Filename = BuildTable.getUnitFilename(this.getFounder(), unitSize, type_id, this.getBuildTableFolder());
        String buildtableName = this.getFounder() + "_" + this.getSize();
        if (type_id != 0) {
            buildtableName = buildtableName + Unit.getTypeClassDesc(type_id);
        }
        CampaignData.mwlog.infoLog("New unit for " + this.getPlanet().getOwner().getName() + " on " + this.getPlanet().getName() + ": " + Filename + "(Table: " + buildtableName + ")");
        if (Filename.toLowerCase().trim().endsWith(".mul")) {
            units.addAll(SUnit.createMULUnits(Filename, producer));
        } else {
            SUnit cm = new SUnit(producer, Filename, this.getWeightclass());
            cm.setPilot(pilot);
            units.add(cm);
        }
        return units;
    }

    public String addRefresh(int i, boolean sendHSUpdate) {
        SHouse owner;
        int startRefresh = this.getTicksUntilRefresh();
        this.setTicksUntilRefresh(this.getTicksUntilRefresh() + i);
        if (this.getTicksUntilRefresh() < 0) {
            this.setTicksUntilRefresh(0);
        }
        if (this.getTicksUntilRefresh() == startRefresh) {
            return "";
        }
        String hsUpdate = "CF|" + this.getWeightclass() + "$" + this.getType() + "$" + this.getPlanet().getName() + "$" + this.getName() + "$" + this.getTicksUntilRefresh() + "$" + this.getAccessLevel() + "|";
        if (sendHSUpdate && (owner = this.getPlanet().getOwner()) != null) {
            CampaignMain.cm.doSendToAllOnlinePlayers(owner, "HS|" + hsUpdate, false);
        }
        return hsUpdate;
    }

    public SPlanet getPlanet() {
        return this.planet;
    }

    public void setPlanet(SPlanet planet) {
        this.planet = planet;
    }

    public int getPriceForUnit(int weightclass, int typeid) {
        SHouse originalHouse = (SHouse)CampaignMain.cm.getData().getHouseByName(this.getFounder());
        return originalHouse.getPriceForUnit(weightclass, typeid);
    }

    public int getInfluenceForUnit(int weightclass, int typeid) {
        SHouse originalHouse = (SHouse)CampaignMain.cm.getData().getHouseByName(this.getFounder());
        return originalHouse.getInfluenceForUnit(weightclass, typeid);
    }

    public int getPPCost(int weightclass, int typeid) {
        SHouse originalHouse = (SHouse)CampaignMain.cm.getData().getHouseByName(this.getFounder());
        return originalHouse.getPPCost(weightclass, typeid);
    }

    public String getTechProduced(int type_id) {
        String Filename = "";
        String producer = "Built by ";
        producer = this.getPlanet().getOwner() != null ? producer + this.getPlanet().getOwner().getName() : producer + this.getFounder();
        if (this.getPlanet().getName() != null) {
            producer = producer + " on " + this.getPlanet().getName();
        }
        String unitSize = this.getSize();
        if (CampaignMain.cm.getBooleanConfig("UseOnlyOneVehicleSize") && type_id == 1) {
            unitSize = Unit.getWeightClassDesc(CampaignMain.cm.getRandomNumber(4));
        }
        Filename = BuildTable.getUnitFilename(this.getFounder(), unitSize, type_id, this.getBuildTableFolder());
        return Filename;
    }
}

