/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import java.io.FileWriter;
import java.io.IOException;
import server.campaign.CampaignMain;
import server.campaign.util.Statistics;

public class TickThread
extends Thread {
    CampaignMain myCampaign;
    private long until;
    private int Duration = 900000;
    private int tickid = 0;

    public TickThread(CampaignMain main, int Duration2) {
        super("Tick Thread");
        this.Duration = Duration2;
        this.myCampaign = main;
    }

    public int getTickID() {
        return this.tickid;
    }

    public void extendedWait(int time) {
        this.until = System.currentTimeMillis() + (long)time;
        try {
            this.wait(time);
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
        }
    }

    public long getRemainingSleepTime() {
        return Math.max(0L, this.until - System.currentTimeMillis());
    }

    public synchronized void run() {
        try {
            while (true) {
                this.extendedWait(this.Duration);
                ++this.tickid;
                CampaignData.mwlog.tickLog("Tick (" + this.tickid + ") Started");
                try {
                    this.myCampaign.tick(true, this.tickid);
                }
                catch (Exception ex) {
                    CampaignData.mwlog.errLog(ex);
                    this.myCampaign.doSendToAllOnlinePlayers("Tick skipped. Errors occured", true);
                }
                try {
                    this.myCampaign.toFile();
                }
                catch (Exception ex) {
                    this.myCampaign.doSendToAllOnlinePlayers("Warning! AutoSave failed!", true);
                }
                if (this.tickid % 8 == 0) {
                    this.myCampaign.addToNewsFeed(Statistics.getReadableHouseRanking(false));
                    try {
                        FileWriter out = new FileWriter(this.myCampaign.getConfig("HouseRankPath"), true);
                        out.write(Statistics.getReadableHouseRanking(false));
                        out.write("\n");
                        out.close();
                    }
                    catch (IOException e) {
                        CampaignData.mwlog.errLog(e);
                    }
                }
                CampaignData.mwlog.tickLog("Tick (" + this.tickid + ") Finished");
                this.myCampaign.doSendToAllOnlinePlayers("CC|NT|" + this.Duration + "|" + true, false);
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog(ex);
            return;
        }
    }
}

