/*
 * Decompiled with CFR 0.152.
 */
package server.campaign;

import common.CampaignData;
import common.Unit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import megamek.common.Entity;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import server.campaign.SUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitCosts {
    Vector<Vector<Double>> minCostUnitList = new Vector(4, 1);
    Vector<Vector<Double>> maxCostUnitList = new Vector(4, 1);

    public UnitCosts() {
        for (int weight = 0; weight <= 3; ++weight) {
            Vector<Double> maxVector = new Vector<Double>(4, 1);
            Vector<Double> minVector = new Vector<Double>(4, 1);
            for (int type = 0; type < 6; ++type) {
                maxVector.add(0.0);
                minVector.add(0.0);
            }
            this.maxCostUnitList.add(maxVector);
            this.minCostUnitList.add(minVector);
        }
    }

    public void addMaxCost(int weight, int type, double amount) {
        Vector<Double> maxCost = this.getMaxCost(weight);
        maxCost.removeElementAt(type);
        maxCost.add(type, amount);
        this.setMaxCost(weight, maxCost);
    }

    public void addMinCost(int weight, int type, double amount) {
        Vector<Double> minCost = this.getMinCost(weight);
        minCost.removeElementAt(type);
        minCost.add(type, amount);
        this.setMinCost(weight, minCost);
    }

    public Vector<Double> getMaxCost(int weight) {
        return this.maxCostUnitList.get(weight);
    }

    public Vector<Double> getMinCost(int weight) {
        return this.minCostUnitList.get(weight);
    }

    public Double getMaxCostValue(int weight, int type) {
        Vector<Double> maxCostVector = this.maxCostUnitList.get(weight);
        return maxCostVector.get(type);
    }

    public Double getMinCostValue(int weight, int type) {
        Vector<Double> minCostVector = this.minCostUnitList.get(weight);
        return minCostVector.get(type);
    }

    public void setMaxCost(int weight, Vector<Double> cost) {
        this.maxCostUnitList.removeElementAt(weight);
        this.maxCostUnitList.add(weight, cost);
    }

    public void setMinCost(int weight, Vector<Double> cost) {
        this.minCostUnitList.removeElementAt(weight);
        this.minCostUnitList.add(weight, cost);
    }

    public void loadUnitCosts() {
        double minCost;
        double maxCost;
        double cost;
        SUnit unit;
        ZipEntry entry;
        ZipInputStream zipFile;
        FileInputStream in;
        String entityName = "";
        if (new File("./data/mechfiles").exists()) {
            try {
                MechSummary[] units;
                for (MechSummary unit2 : units = MechSummaryCache.getInstance().getAllMechs()) {
                    Entity ent = new MechFileParser(unit2.getSourceFile(), unit2.getEntryName()).getEntity();
                    double cost2 = unit2.getCost();
                    double maxCost2 = this.getMaxCostValue(Unit.getEntityWeight(ent), Unit.getEntityType(ent));
                    double minCost2 = this.getMinCostValue(Unit.getEntityWeight(ent), Unit.getEntityType(ent));
                    this.addMaxCost(Unit.getEntityWeight(ent), Unit.getEntityType(ent), Math.max(cost2, maxCost2));
                    this.addMinCost(Unit.getEntityWeight(ent), Unit.getEntityType(ent), Math.min(cost2, minCost2));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return;
        }
        try {
            in = new FileInputStream("./data/unitfiles/Meks.zip");
            zipFile = new ZipInputStream(in);
            while (zipFile.available() == 1) {
                entry = zipFile.getNextEntry();
                entityName = entry.getName();
                if (entityName.startsWith("Error")) continue;
                unit = new SUnit("null", entityName, 0);
                cost = unit.getEntity().getCost();
                if (cost > (maxCost = this.getMaxCostValue(unit.getWeightclass(), unit.getType()).doubleValue())) {
                    this.addMaxCost(unit.getWeightclass(), unit.getType(), cost);
                    continue;
                }
                minCost = this.getMinCostValue(unit.getWeightclass(), unit.getType());
                if (minCost != 0.0 && !(cost < minCost)) continue;
                this.addMinCost(unit.getWeightclass(), unit.getType(), cost);
            }
            zipFile.close();
            in.close();
        }
        catch (FileNotFoundException fnf) {
            CampaignData.mwlog.errLog("Unable to load Meks.zip for UnitCosts.loadUnitCosts");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error with Meks.zip file " + entityName);
            CampaignData.mwlog.errLog(ex);
        }
        try {
            in = new FileInputStream("./data/unitfiles/Vehicles.zip");
            zipFile = new ZipInputStream(in);
            while (zipFile.available() == 1) {
                entry = zipFile.getNextEntry();
                entityName = entry.getName();
                unit = new SUnit("null", entityName, 0);
                cost = unit.getEntity().getCost();
                if (cost > (maxCost = this.getMaxCostValue(unit.getWeightclass(), unit.getType()).doubleValue())) {
                    this.addMaxCost(unit.getWeightclass(), unit.getType(), cost);
                    continue;
                }
                minCost = this.getMinCostValue(unit.getWeightclass(), unit.getType());
                if (minCost != 0.0 && !(cost < minCost)) continue;
                this.addMinCost(unit.getWeightclass(), unit.getType(), cost);
            }
            zipFile.close();
            in.close();
        }
        catch (FileNotFoundException fnf) {
            CampaignData.mwlog.errLog("Unable to load Vehicles.zip for UnitCosts.loadUnitCosts");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error with Vehicles.zip file " + entityName);
            CampaignData.mwlog.errLog(ex);
        }
        try {
            in = new FileInputStream("./data/unitfiles/Infantry.zip");
            zipFile = new ZipInputStream(in);
            while (zipFile.available() == 1) {
                entry = zipFile.getNextEntry();
                entityName = entry.getName();
                unit = new SUnit("null", entityName, 0);
                cost = unit.getEntity().getCost();
                if (cost > (maxCost = this.getMaxCostValue(unit.getWeightclass(), unit.getType()).doubleValue())) {
                    this.addMaxCost(unit.getWeightclass(), unit.getType(), cost);
                    continue;
                }
                minCost = this.getMinCostValue(unit.getWeightclass(), unit.getType());
                if (minCost != 0.0 && !(cost < minCost)) continue;
                this.addMinCost(unit.getWeightclass(), unit.getType(), cost);
            }
            zipFile.close();
            in.close();
        }
        catch (FileNotFoundException fnf) {
            CampaignData.mwlog.errLog("Unable to load Infantry.zip for UnitCosts.loadUnitCosts");
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error with Infantry.zip file " + entityName);
            CampaignData.mwlog.errLog(ex);
        }
    }

    public String displayUnitCostsLists() {
        StringBuilder result = new StringBuilder("<b>Max Costs</b><br>");
        for (int weight = 0; weight <= 3; ++weight) {
            for (int type = 0; type < 6; ++type) {
                result.append(Unit.getWeightClassDesc(weight) + " " + Unit.getTypeClassDesc(type) + " MaxCost: " + this.getMaxCostValue(weight, type) + " MinCost: " + this.getMinCostValue(weight, type) + ".<br>");
            }
        }
        return result.toString();
    }
}

