/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.Unit;
import java.util.ArrayList;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;
import server.campaign.operations.ShortOperation;

public class AcceptAttackFromReserveCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer dp = CampaignMain.cm.getPlayer(Username);
        if (dp == null) {
            CampaignMain.cm.toUser("AM:Null player in AcceptAttackFromReserve. Report this immediately!", Username, true);
            return;
        }
        OperationManager manager = CampaignMain.cm.getOpsManager();
        int armyID = -1;
        int attackingArmyID = -1;
        SPlayer ap = null;
        String opName = "";
        SPlanet target = null;
        try {
            ap = CampaignMain.cm.getPlayer(command.nextToken());
            attackingArmyID = Integer.parseInt(command.nextToken());
            armyID = Integer.parseInt(command.nextToken());
            opName = command.nextToken();
            target = CampaignMain.cm.getPlanetFromPartialString(command.nextToken(), null);
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Should be /c acceptattackfromreserve#attacker name#attack army#your army#opname#world", Username, true);
            return;
        }
        SArmy aa = null;
        SArmy da = null;
        aa = ap.getArmy(attackingArmyID);
        if (aa == null) {
            CampaignMain.cm.toUser("AM:Defend failed. Attacker does not have an army with ID #" + armyID + ".", Username, true);
            return;
        }
        da = dp.getArmy(armyID);
        if (da == null) {
            CampaignMain.cm.toUser("AM:Defend failed. Army #" + armyID + " does not exist.", Username, true);
            return;
        }
        if (da.isDisabled()) {
            CampaignMain.cm.toUser("AM:Defend failed. Army #" + armyID + " is disabled and cannot be used to defend.", Username, true);
            return;
        }
        Long launchTime = ap.getLastAttackFromReserve();
        if (launchTime + Long.parseLong(CampaignMain.cm.getConfig("AttackFromReserveResponseTime")) * 60000L < System.currentTimeMillis()) {
            CampaignMain.cm.toUser("AM:Sorry - this offer has expired.", Username, true);
            return;
        }
        if (dp.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You are already fighting!", Username, true);
            return;
        }
        Operation o = manager.getOperation(opName);
        ArrayList<SArmy> fullMatches = new ArrayList<SArmy>();
        ArrayList<Integer> defensiveFailures = manager.getShortValidator().validateShortDefender(dp, da, o, target);
        if (defensiveFailures.size() != 0) {
            CampaignMain.cm.toUser("AM:Army #" + da.getID() + "could not defend " + manager.getShortValidator().failuresToString(defensiveFailures), Username, true);
            return;
        }
        fullMatches.add(da);
        for (Unit currU : da.getUnits()) {
            if (!currU.hasVacantPilot()) continue;
            CampaignMain.cm.toUser("AM:You may not defend using an army with pilotless units.", Username, true);
            return;
        }
        int opID = manager.getFreeShortID();
        ShortOperation so = new ShortOperation(o.getName(), target, ap, aa, fullMatches, opID, -1, true);
        manager.addShortOperation(so, ap, o);
        ap.setActive(true);
        dp.setActive(true);
        CampaignMain.cm.getOpsManager().removePlayerFromAllAttackerLists(dp, so, true);
        CampaignMain.cm.getOpsManager().removePlayerFromAllDefenderLists(dp, so, true);
        so.addDefender(dp, da, "");
        int money = o.getIntValue("DefenderCostMoney");
        int flu = o.getIntValue("DefenderCostInfluence");
        int rp = o.getIntValue("DefenderCostReward");
        String toSend = "AM:You are now defending Attack #" + opID;
        boolean hasCost = false;
        if (money > 0) {
            dp.addMoney(-money);
            toSend = toSend + "(" + CampaignMain.cm.moneyOrFluMessage(true, true, money);
            hasCost = true;
        }
        if (flu > 0) {
            dp.addInfluence(-flu);
            toSend = hasCost ? toSend + ", " : toSend + "(";
            toSend = toSend + CampaignMain.cm.moneyOrFluMessage(false, true, flu);
            hasCost = true;
        }
        if (rp > 0) {
            dp.addReward(-rp);
            toSend = hasCost ? toSend + ", " : toSend + "(";
            toSend = toSend + "-" + rp + " RP";
            hasCost = true;
        }
        toSend = hasCost ? toSend + ")." : toSend + ".";
        CampaignData.mwlog.gameLog("AcceptAttackFromReserve: " + so.getShortID() + "/" + dp.getName() + " w. Army #" + da.getID());
        CampaignMain.cm.toUser(toSend, Username, true);
    }
}

