/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import common.Unit;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import java.util.Vector;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.SUnit;
import server.campaign.commands.CheckAttackThread;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivateCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    @Override
    public int getExecutionLevel() {
        return this.accessLevel;
    }

    @Override
    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    @Override
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (new Boolean(CampaignMain.cm.getConfig("CampaignLock")).booleanValue()) {
            CampaignMain.cm.toUser("AM:The campaign is currently locked. Player activation is disabled until the campaign is unlocked. NOTE: Running games will resolve normally.", Username, true);
            return;
        }
        if (command.hasMoreTokens()) {
            p.setPlayerClientVersion(command.nextToken());
        }
        try {
            if (!"0.2.40.0".substring(0, "0.2.40.0".lastIndexOf(".")).equals(p.getPlayerClientVersion().substring(0, p.getPlayerClientVersion().lastIndexOf(".")))) {
                CampaignMain.cm.doSendModMail("NOTE", Username + " failed to activate. Was using version " + p.getPlayerClientVersion() + " Server Version: " + "0.2.40.0");
                CampaignMain.cm.toUser("AM:You may not go active with an incompatible client version! Please switch to version 0.2.40.0!", Username, true);
                return;
            }
        }
        catch (Exception ex) {
            CampaignData.mwlog.errLog("Error activating player. User reported client verson: " + p.getPlayerClientVersion() + " --- Stack Trace Follows.");
            CampaignMain.cm.toUser("AM:Your clients version was not reported to the server. <a href=\"MEKWARS/c setclientversion#" + Username + "#" + "0.2.40.0" + "\">Click here to update the server.</a> then try to activate again.", Username);
            return;
        }
        int currentStatus = p.getDutyStatus();
        if (currentStatus == 4) {
            CampaignMain.cm.toUser("AM:You are already fighting!", Username, true);
            return;
        }
        if (currentStatus == 3) {
            CampaignMain.cm.toUser("AM:You are already on active duty!", Username, true);
            return;
        }
        if (currentStatus == 1) {
            CampaignMain.cm.toUser("AM:You are logged out and may not activate.", Username, true);
            return;
        }
        boolean MULOnlyOps = CampaignMain.cm.getOpsManager().hasMULOnlyOps();
        if (p.getArmies().size() == 0 && !MULOnlyOps) {
            CampaignMain.cm.toUser("AM:You must have armies constructed in order to activate.", Username, true);
            return;
        }
        int enabledArmies = 0;
        for (SArmy a : p.getArmies()) {
            if (a.isDisabled()) continue;
            ++enabledArmies;
            break;
        }
        if (enabledArmies == 0 && !MULOnlyOps) {
            CampaignMain.cm.toUser("AM:You must have at least 1 enabled army to activate.", Username, true);
            return;
        }
        for (SArmy currA : p.getArmies()) {
            if (currA.getAmountOfUnits() == 0 && !MULOnlyOps) {
                CampaignMain.cm.toUser("AM:You may not activate with empty armies.", Username, true);
                return;
            }
            for (Unit currU : currA.getUnits()) {
                if (!currU.hasVacantPilot()) continue;
                CampaignMain.cm.toUser("AM:You may not activate with pilotless units!", Username, true);
                return;
            }
        }
        if (!CampaignMain.cm.getBooleanConfig("allowGoingActiveWithoutUnitCommanders") && this.hasCommanderlessUnits(p.getArmies())) {
            CampaignMain.cm.toUser("AM:You may not activate with armies lacking unit commanders!", Username, true);
            return;
        }
        if (CampaignMain.cm.isUsingAdvanceRepair()) {
            if (this.armiesContainEnginedUnit(p.getArmies())) {
                CampaignMain.cm.toUser("AM:You may not activate with a cored or engine-disabled unit in an army.", Username, true);
                return;
            }
            if (this.armiesContainLeggedUnit(p.getArmies())) {
                CampaignMain.cm.toUser("AM:You may not activate with a legless unit in an army.", Username, true);
                return;
            }
            if (p.hasRepairingUnits()) {
                CampaignMain.cm.toUser("AM:You may not activate while units in your armies are undergoing repairs.", Username, true);
                return;
            }
            if (CampaignMain.cm.getBooleanConfig("UseSimpleRepair") && this.armiesDamagedUnits(p.getArmies())) {
                CampaignMain.cm.toUser("AM:You may not activate while units in your armies have damage.", Username, true);
                return;
            }
            if (!CampaignMain.cm.getBooleanConfig("AllowUnitsToActivateWithPartialBins") && this.armiesPartialAmmoBinUnits(p.getArmies())) {
                CampaignMain.cm.toUser("AM:You may not activate while units in your armies have parital ammo bins.", Username, true);
                return;
            }
        }
        for (SArmy currA : p.getArmies()) {
            for (Unit currUnit : currA.getUnits()) {
                if (currUnit.getStatus() != 2) continue;
                CampaignMain.cm.toUser("AM:You may not send armies containing unmaintained units to the front lines!", Username, true);
                return;
            }
        }
        if (p.getFreeBays() < 0) {
            if (CampaignMain.cm.isUsingAdvanceRepair()) {
                CampaignMain.cm.toUser("AM:You may not activate with negative bays!", Username, true);
            } else {
                CampaignMain.cm.toUser("AM:You may not activate with negative techs!", Username, true);
            }
            return;
        }
        int armyID = this.hasIllegalOpArmies(p, p.getArmies());
        if (armyID > -1) {
            CampaignMain.cm.toUser("AM:Army #" + armyID + " is currently unable to launch or defend any ops!  You may not go active.", Username, true);
            return;
        }
        for (SArmy army : p.getArmies()) {
            CampaignMain.cm.getOpsManager().checkOperations(army, false);
        }
        p.getWeightedArmyNumber();
        p.setActive(true);
        CampaignMain.cm.toUser("AM:[!] You're on your way to the front lines.", Username, true);
        CampaignMain.cm.sendPlayerStatusUpdate(p, new Boolean(CampaignMain.cm.getConfig("HideActiveStatus")) == false);
        int threadLenth = CampaignMain.cm.getIntegerConfig("MinActiveTime") * 1000;
        CheckAttackThread caThread = new CheckAttackThread(p, threadLenth);
        caThread.start();
    }

    private boolean armiesContainEnginedUnit(Vector<SArmy> armies) {
        for (SArmy army : armies) {
            for (SUnit sUnit : army.getUnits()) {
                if (!UnitUtils.isCored(sUnit.getEntity())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean armiesContainLeggedUnit(Vector<SArmy> armies) {
        for (SArmy army : armies) {
            for (SUnit sUnit : army.getUnits()) {
                if (sUnit.getType() == 0) {
                    if (sUnit.getEntity().getInternal(7) <= 0) {
                        return true;
                    }
                    if (sUnit.getEntity().getInternal(6) > 0) continue;
                    return true;
                }
                if (sUnit.getType() != 6) continue;
                if (sUnit.getEntity().getInternal(7) <= 0) {
                    return true;
                }
                if (sUnit.getEntity().getInternal(6) <= 0) {
                    return true;
                }
                if (sUnit.getEntity().getInternal(5) <= 0) {
                    return true;
                }
                if (sUnit.getEntity().getInternal(4) > 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean armiesDamagedUnits(Vector<SArmy> armies) {
        for (SArmy army : armies) {
            for (SUnit sUnit : army.getUnits()) {
                if (UnitUtils.hasArmorDamage(sUnit.getEntity())) {
                    return true;
                }
                if (!UnitUtils.hasCriticalDamage(sUnit.getEntity())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean armiesPartialAmmoBinUnits(Vector<SArmy> armies) {
        for (SArmy army : armies) {
            for (SUnit sUnit : army.getUnits()) {
                if (UnitUtils.hasAllAmmo(sUnit.getEntity())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasCommanderlessUnits(Vector<SArmy> armies) {
        for (SArmy army : armies) {
            if (army.getCommanders().size() <= 0) continue;
            return false;
        }
        return true;
    }

    private int hasIllegalOpArmies(SPlayer player, Vector<SArmy> armies) {
        for (SArmy army : armies) {
            boolean canAttack = false;
            boolean canDefend = false;
            if (army.getLegalOperations().size() > 0) {
                canAttack = true;
            }
            OperationManager manager = CampaignMain.cm.getOpsManager();
            for (Operation op : manager.getOperations().values()) {
                if (manager.validateShortDefense(player, army, op, null) != null) continue;
                canDefend = true;
                break;
            }
            if (canAttack || canDefend || army.isDisabled()) continue;
            return army.getID();
        }
        return -1;
    }
}

