/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;

public class AttackCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(StringTokenizer command, String Username) {
        String s;
        boolean minActiveMet;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        OperationManager manager = CampaignMain.cm.getOpsManager();
        SPlayer ap = CampaignMain.cm.getPlayer(Username);
        if (ap == null) {
            CampaignMain.cm.toUser("AM:Null player. Contact an administrator to report this, immediately!", Username, true);
            return;
        }
        if (ap.getDutyStatus() < 3) {
            CampaignMain.cm.toUser("AM:You aren't on the front lines! (You are currently in Reserve. Activate in order to attack.)", Username, true);
            return;
        }
        if (ap.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You are already fighting!", Username, true);
            return;
        }
        int altID = CampaignMain.cm.getOpsManager().playerIsAnAttacker(ap);
        if (altID >= 0) {
            CampaignMain.cm.toUser("AM:You're only allowed to attack once, and are already in Attack #" + altID + ".", Username, true);
            return;
        }
        altID = CampaignMain.cm.getOpsManager().playerIsADefender(ap);
        if (altID >= 0) {
            CampaignMain.cm.toUser("AM:You're already defending against Attack #" + altID + ".", Username, true);
            return;
        }
        boolean bl = minActiveMet = System.currentTimeMillis() - ap.getActiveSince() >= Long.parseLong(CampaignMain.cm.getConfig("MinActiveTime")) * 1000L;
        if (!minActiveMet) {
            CampaignMain.cm.toUser("AM:You're still on your way to the frontline. You cannot attack until you arrive.", Username, true);
            return;
        }
        String opName = "";
        try {
            opName = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:No operation name given. Try again.", Username, true);
            return;
        }
        Operation o = manager.getOperation(opName);
        if (o == null) {
            CampaignMain.cm.toUser("AM:Operation Type: " + opName + " does not exist.", Username, true);
            return;
        }
        int armyID = -1;
        try {
            armyID = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Non-number given for Army ID. Try again.", Username, true);
            return;
        }
        SArmy aa = ap.getArmy(armyID);
        boolean MULArmy = o.getBooleanValue("MULArmiesOnly");
        if (aa == null) {
            if (!MULArmy) {
                CampaignMain.cm.toUser("AM:An error occured while creating your Army (The Army was null. This usually means the army doesn't exist. Example: you tried to use Army 1, but you only have Armies 0 and 2.)", Username, true);
                return;
            }
            aa = new SArmy(-1, Username);
        } else {
            if (aa.getBV() == 0 && !MULArmy) {
                CampaignMain.cm.toUser("AM:Army #" + armyID + " has a BV of 0 and may not be used to attack.", Username, true);
                return;
            }
            if (aa.isDisabled()) {
                CampaignMain.cm.toUser("AM: Army #" + armyID + " is disabled and may not be used to attack.", Username, true);
                return;
            }
        }
        String planetName = "";
        try {
            planetName = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:No planet name given. Try again.", Username, true);
            return;
        }
        SPlanet target = CampaignMain.cm.getPlanetFromPartialString(planetName, Username);
        if (target == null) {
            return;
        }
        int longID = -1;
        if (o.getTypeIndicator() == Operation.TYPE_SHORTANDLONG) {
            if (!manager.hasSpecificLongOnPlanet(ap.getHouseFightingFor(), target, o)) {
                CampaignMain.cm.toUser("AM:Your faction has no " + opName + " in progress on " + target.getName() + ".", Username, true);
                return;
            }
            longID = manager.getLongID(ap.getHouseFightingFor(), target);
        }
        if ((s = manager.validateShortAttack(ap, aa, o, target, longID, false)) != null && !s.trim().equals("")) {
            CampaignMain.cm.toUser("AM:Attack failed " + s, Username, true);
            return;
        }
        if (o.getBooleanValue("TeamOperation") && o.getIntValue("NumberOfTeams") > 1) {
            int teamNumber = 1;
            if (o.getBooleanValue("TeamsMustBeSameFaction")) {
                SHouse attackingFaction = ap.getHouseFightingFor();
                teamNumber = 1;
                boolean sendCommand = false;
                for (String player : attackingFaction.getActivePlayers().keySet()) {
                    if (player.equalsIgnoreCase(ap.getName())) continue;
                    StringBuilder toSend = new StringBuilder(ap.getName() + " is performing a " + o.getName() + " on " + target.getName() + " you may join with the following armies:");
                    sendCommand = false;
                    SPlayer joiningPlayer = attackingFaction.getActivePlayers().get(player);
                    for (SArmy army : joiningPlayer.getArmies()) {
                        String failures = manager.validateShortAttack(joiningPlayer, army, o, target, longID, true);
                        if (failures != null && s != null && !s.trim().equals("")) continue;
                        sendCommand = true;
                        toSend.append("<a href=\"MEKWARS/c joinattack#" + ap.getName() + "#" + army.getID() + "\">Army #" + army.getID() + "</a> (Units: " + army.getUnits().size() + " / BV: " + army.getBV() + ")");
                    }
                    if (!sendCommand) continue;
                    CampaignMain.cm.toUser(toSend.toString(), player);
                }
            }
            CampaignMain.cm.toUser("PL|STN|" + teamNumber, Username, false);
            CampaignMain.cm.toUser("AM:You have been assigned to team #" + teamNumber, Username);
            ap.setTeamNumber(teamNumber);
        }
    }
}

