/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.Unit;
import java.util.ArrayList;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlanet;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;

public class AttackFromReserveCommand
implements Command {
    int accessLevel = 2;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        OperationManager manager = CampaignMain.cm.getOpsManager();
        SPlayer ap = CampaignMain.cm.getPlayer(Username);
        if (ap == null) {
            CampaignMain.cm.toUser("AM:Null player. Contact an administrator to report this, immediately!", Username, true);
            return;
        }
        if (!CampaignMain.cm.getBooleanConfig("AllowAttackFromReserve")) {
            CampaignMain.cm.toUser("AM:Sorry but attack from reserve is not allowed in this campaign!", Username, true);
            return;
        }
        if (new Boolean(CampaignMain.cm.getConfig("CampaignLock")).booleanValue()) {
            CampaignMain.cm.toUser("AM:The campaign is currently locked. Attacks are disabled until the campaign is unlocked.", Username, true);
            return;
        }
        if (ap.getLastAttackFromReserve() + Long.parseLong(CampaignMain.cm.getConfig("AttackFromReserveSleepTime")) * 60000L > System.currentTimeMillis()) {
            CampaignMain.cm.toUser("AM:Sorry but you may only attack from reserve once every " + CampaignMain.cm.getConfig("AttackFromReserveSleepTime") + " mins.", Username, true);
            return;
        }
        if (ap.getDutyStatus() == 3) {
            CampaignMain.cm.toUser("AM:You are currently active. You must deactivate in order to attack from reserve.)", Username, true);
            return;
        }
        if (ap.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You are already fighting!", Username, true);
            return;
        }
        int altID = CampaignMain.cm.getOpsManager().playerIsAnAttacker(ap);
        if (altID >= 0) {
            CampaignMain.cm.toUser("AM:You're only allowed to attack once, and are already in Attack #" + altID + ".", Username, true);
            return;
        }
        altID = CampaignMain.cm.getOpsManager().playerIsADefender(ap);
        if (altID >= 0) {
            CampaignMain.cm.toUser("AM:You're already defending against Attack #" + altID + ".", Username, true);
            return;
        }
        String opName = command.nextToken();
        Operation o = manager.getOperation(opName);
        if (o == null) {
            CampaignMain.cm.toUser("AM:Operation Type: " + opName + " does not exist.", Username, true);
            return;
        }
        int armyID = -1;
        try {
            armyID = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Non-number given for Army ID. Try again.", Username, true);
            return;
        }
        SArmy aa = ap.getArmy(armyID);
        boolean mulArmy = o.getBooleanValue("MULArmiesOnly");
        if (aa == null) {
            if (mulArmy) {
                aa = new SArmy(-1, Username);
            } else {
                CampaignMain.cm.toUser("AM:You do not have an army with ID #" + armyID + ".", Username, true);
                return;
            }
        }
        if (aa.getBV() == 0 && !mulArmy) {
            CampaignMain.cm.toUser("AM:Army #" + armyID + " has a BV of 0 and may not be used to attack.", Username, true);
            return;
        }
        if (aa.isDisabled()) {
            CampaignMain.cm.toUser("AM:Army #" + armyID + " is disabled and may not be used to attack.", Username, true);
            return;
        }
        for (Unit currU : aa.getUnits()) {
            if (!currU.hasVacantPilot()) continue;
            CampaignMain.cm.toUser("AM:You may not attack using an army with pilotless units.", Username, true);
            return;
        }
        String planetName = command.nextToken();
        SPlanet target = CampaignMain.cm.getPlanetFromPartialString(planetName, Username);
        if (target == null) {
            return;
        }
        ArrayList<Integer> failureReasons = new ArrayList<Integer>();
        CampaignMain.cm.getOpsManager().getShortValidator().checkAttackerRange(failureReasons, ap, o, target);
        CampaignMain.cm.getOpsManager().getShortValidator().checkAttackerMilestones(failureReasons, ap, o);
        CampaignMain.cm.getOpsManager().getShortValidator().checkAttackerCosts(failureReasons, ap, o);
        CampaignMain.cm.getOpsManager().getShortValidator().checkAttackerConstruction(failureReasons, aa, o);
        if (failureReasons.size() > 0) {
            CampaignMain.cm.toUser(CampaignMain.cm.getOpsManager().getShortValidator().failuresToString(failureReasons), Username);
            return;
        }
        String toFind = command.nextToken();
        SPlayer dp = CampaignMain.cm.getPlayer(toFind);
        if (dp == null) {
            CampaignMain.cm.toUser("AM:Could not find a player named " + toFind + ". Try again?", Username, true);
            return;
        }
        if (ap.equals(dp)) {
            CampaignMain.cm.toUser("AM:You cannot attack yourself. Nice try though.", Username, true);
            return;
        }
        if (ap.getExclusionList().checkExclude(dp.getName()) == 2 || dp.getExclusionList().checkExclude(ap.getName()) == 2) {
            CampaignMain.cm.toUser("AM:A moderator-added no play stops you from playing with " + dp.getName() + ".", Username, true);
            return;
        }
        if (target.getInfluence().getInfluence(dp.getHouseFightingFor().getId()) < 1) {
            CampaignMain.cm.toUser(dp.getName() + " cannot defend " + target.getName(), Username, true);
            return;
        }
        ArrayList<SArmy> defendingArmies = new ArrayList<SArmy>();
        for (SArmy currArmy : dp.getArmies()) {
            ArrayList<Integer> defenderFails = manager.getShortValidator().validateShortDefender(dp, currArmy, o, target);
            if (defenderFails.size() != 0 || !aa.matches(currArmy, o)) continue;
            defendingArmies.add(currArmy);
        }
        if (defendingArmies.size() == 0) {
            CampaignMain.cm.toUser("AM:" + dp.getName() + " cannot defend your attack with his current force(s).", Username, true);
            return;
        }
        ap.setLastAttackFromReserve(System.currentTimeMillis());
        CampaignMain.cm.toUser("AM:Your attack proposal was sent to " + dp.getName(), Username, true);
        StringBuilder toSend = new StringBuilder("AM:" + ap.getName() + " proposes you a game of " + o.getName() + " on planet " + target.getNameAsColoredLink() + " with " + aa.getAmountOfUnits() + " units totalling " + aa.getBV() + " BV. You may accept with:  <br>");
        for (SArmy currArmy : defendingArmies) {
            int aID = currArmy.getID();
            int aBV = currArmy.getOperationsBV(null);
            int aUnits = currArmy.getAmountOfUnits();
            toSend.append("<a href=\"MEKWARS/c acceptattackfromreserve#" + ap.getName() + "#" + aa.getID() + "#" + aID + "#" + opName + "#" + target.getName() + "\">Army #" + aID + " </a> (Units: " + aUnits + " / BV: " + aBV + ")<br>");
        }
        toSend.delete(toSend.lastIndexOf("<br>"), toSend.length());
        toSend.append("<br>Or <a href=\"MEKWARS/c declineattackfromreserve#" + ap.getName() + "\">decline</a>.");
        toSend.append("<br>You have " + CampaignMain.cm.getConfig("AttackFromReserveResponseTime") + " mins to accept, or the attack will be automatically declined.");
        CampaignMain.cm.toUser(toSend.toString(), dp.getName(), true);
    }
}

