/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.market2.MarketListing;

public class BidCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        if (p == null) {
            CampaignMain.cm.toUser("AM:Null SPlayer while bidding. Report immediately!", Username, true);
            return;
        }
        int auctionID = -1;
        int bidAmount = -1;
        try {
            auctionID = Integer.parseInt(command.nextToken());
            bidAmount = Integer.parseInt(command.nextToken());
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c bid#AuctionID#Amount", Username, true);
            return;
        }
        if (!p.getMyHouse().mayBuyFromBM()) {
            CampaignMain.cm.toUser("AM:You are not allowed to buy units from the market. Your faction forbids it!", Username, true);
            return;
        }
        int minBMEXP = CampaignMain.cm.getIntegerConfig("MinEXPforBMBuying");
        if (p.getExperience() < minBMEXP) {
            CampaignMain.cm.toUser("AM:You are not allowed to buy units from the Market. Required Experience: " + minBMEXP + ".", Username, true);
            return;
        }
        MarketListing auction = CampaignMain.cm.getMarket().getListingByID(auctionID);
        if (auction == null) {
            CampaignMain.cm.toUser("AM:There is no auction with ID#" + auctionID + ".", Username, true);
            return;
        }
        int minBid = auction.getMinBid();
        if (bidAmount < minBid) {
            CampaignMain.cm.toUser("AM:Minimum bid for the " + auction.getListedModelName() + " is " + CampaignMain.cm.moneyOrFluMessage(true, false, minBid) + ". Nice try.", Username, true);
            return;
        }
        int bidFluCost = CampaignMain.cm.getIntegerConfig("BMBidFlu");
        if (p.getInfluence() < bidFluCost) {
            CampaignMain.cm.toUser("AM:You need " + CampaignMain.cm.moneyOrFluMessage(false, true, bidFluCost) + " to place a bid.", Username, true);
            return;
        }
        auction.placeBid(Username, bidAmount);
        p.addInfluence(-bidFluCost);
        CampaignMain.cm.toUser("AM:You bid " + CampaignMain.cm.moneyOrFluMessage(true, false, bidAmount) + " for the " + auction.getListedModelName() + " (-" + CampaignMain.cm.moneyOrFluMessage(false, true, bidFluCost) + ").", Username, true);
        CampaignMain.cm.toUser("BM|CU|" + auction.toString(auctionID, p), Username, false);
    }
}

