/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import megamek.common.Entity;
import server.campaign.CampaignMain;
import server.campaign.SUnit;
import server.campaign.commands.Command;

public class BuildTableListCommand
implements Command {
    int accessLevel = 2;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        String filePath = "./data/buildtables";
        if (command.hasMoreTokens()) {
            filePath = command.nextToken();
        }
        try {
            File file = new File(filePath);
            String results = "Files in " + filePath + "<br>";
            if (file.isDirectory()) {
                String[] fileList = file.list();
                for (int i = 0; i < fileList.length; ++i) {
                    results = results + "<a href=\"MEKWARS/c buildtablelist#" + filePath + "/" + fileList[i] + "\">" + fileList[i] + "</a><br>";
                }
            }
            if (file.isFile()) {
                FileInputStream fis = new FileInputStream(file);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                while (dis.ready()) {
                    String fileWithOutChance;
                    String line = dis.readLine();
                    if (line.length() <= 1) continue;
                    if (line.indexOf(".") != -1) {
                        String fileWithOutChance2 = line.substring(line.indexOf(" ")).trim();
                        Entity ent = SUnit.loadMech(fileWithOutChance2);
                        if (ent.getModel().equals("OMG-UR-FD")) {
                            CampaignData.mwlog.errLog(fileWithOutChance2 + " errored in Build Table: " + filePath);
                            results = results + fileWithOutChance2.trim() + "<br>";
                            continue;
                        }
                        results = results + "<a href=\"MEKINFO" + ent.getChassis() + " " + ent.getModel() + "#" + ent.calculateBattleValue() + "#4#5\">" + line.trim() + "</a><br>";
                        continue;
                    }
                    if (file.getName().indexOf("_") < 0) continue;
                    String typeWeight = file.getName().substring(file.getName().indexOf("_"));
                    line = line + typeWeight.trim();
                    try {
                        fileWithOutChance = line.substring(line.indexOf(" "));
                    }
                    catch (Exception ex) {
                        fileWithOutChance = line;
                    }
                    String tempFilePath = filePath.substring(0, filePath.lastIndexOf("/"));
                    results = results + "<a href=\"MEKWARS/c buildtablelist#" + tempFilePath + "/" + fileWithOutChance.trim() + "\">" + line + "</a><br>";
                }
            }
            CampaignMain.cm.toUser("SM|" + results, Username, false);
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:Unknown path try again!", Username, true);
            CampaignData.mwlog.errLog("Error with build table list");
            CampaignData.mwlog.errLog(ex);
            return;
        }
    }
}

