/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class BuyBaysCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!CampaignMain.cm.isUsingAdvanceRepair()) {
            return;
        }
        int numtobuy = 1;
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SHouse house = p.getMyHouse();
        int bayCost = 0;
        int maxBays = Integer.parseInt(house.getConfig("MaxBaysToBuy"));
        try {
            numtobuy = Integer.parseInt(command.nextToken());
        }
        catch (NumberFormatException ex) {
            CampaignMain.cm.toUser("AM:Lease Bays command failed. Check your input. It should be something like this: /c buybays#3", Username, true);
            return;
        }
        bayCost = Integer.parseInt(house.getConfig("CostToBuyNewBay"));
        if (bayCost == -1) {
            CampaignMain.cm.toUser("AM:Sorry but their are no bays available for leasing at this moment in time.", Username, true);
            return;
        }
        if (maxBays != -1 && p.getBaysOwned() + numtobuy > maxBays) {
            CampaignMain.cm.toUser("AM:Sorry but the max number of bays you can lease is " + maxBays + ".", Username, true);
            return;
        }
        if ((bayCost *= numtobuy) > p.getMoney()) {
            CampaignMain.cm.toUser("AM:Leasing " + numtobuy + " bays will cost you " + CampaignMain.cm.moneyOrFluMessage(true, false, bayCost) + " for a security deposit. You only have " + CampaignMain.cm.moneyOrFluMessage(true, false, p.getMoney()) + ".", Username, true);
            return;
        }
        p.addBays(numtobuy);
        p.addMoney(-bayCost);
        if (numtobuy == 1) {
            CampaignMain.cm.toUser("AM:You've leased a bay! After paying the security deposit of " + CampaignMain.cm.moneyOrFluMessage(true, false, bayCost), Username, true);
        } else {
            CampaignMain.cm.toUser("AM:You've leased " + numtobuy + " bays! After paying the security deposit of " + CampaignMain.cm.moneyOrFluMessage(true, false, bayCost), Username, true);
        }
        CampaignMain.cm.toUser("PL|SF|" + p.getFreeBays(), Username, false);
        CampaignMain.cm.toUser("PL|SB|" + p.getTotalMekBays(), Username, false);
        CampaignMain.cm.toUser("PL|ST|" + p.getBaysOwned(), Username, false);
    }
}

