/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.BMEquipment;
import common.util.UnitUtils;
import java.util.StringTokenizer;
import megamek.common.EquipmentType;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class BuyPartsCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (!CampaignMain.cm.isUsingAdvanceRepair()) {
            return;
        }
        int numtobuy = 1;
        String partName = "";
        SPlayer player = CampaignMain.cm.getPlayer(Username);
        try {
            partName = command.nextToken();
            numtobuy = Integer.parseInt(command.nextToken());
        }
        catch (Exception ex) {
            CampaignMain.cm.toUser("AM:Invalid Syntax: /BuyParts Name#Amount", Username);
            return;
        }
        boolean allowTechCrossOver = CampaignMain.cm.getBooleanConfig("AllowCrossOverTech");
        BMEquipment bme = CampaignMain.cm.getPartsMarket().getEquipmentList().get(partName);
        if (bme == null || !allowTechCrossOver && !UnitUtils.isSameTech(bme.getTechLevel(), player.getMyHouse().getTechLevel())) {
            CampaignMain.cm.toUser("AM:" + partName + " not found on the black market", Username);
            return;
        }
        if (numtobuy < 1) {
            CampaignMain.cm.toUser("AM:You cannot buy negative parts!", Username);
            return;
        }
        int cost = (int)Math.ceil((double)numtobuy * bme.getCost());
        if (numtobuy > bme.getAmount()) {
            CampaignMain.cm.toUser("AM:There are only " + bme.getAmount() + " crits left select a smaller amount", Username);
            return;
        }
        if (cost > player.getMoney()) {
            CampaignMain.cm.toUser("AM:It will cost you " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + " you only have " + CampaignMain.cm.moneyOrFluMessage(true, true, player.getMoney()) + ".", Username);
            return;
        }
        EquipmentType eq = EquipmentType.get(bme.getEquipmentInternalName());
        bme.setAmount(bme.getAmount() - numtobuy);
        player.addMoney(-cost);
        if (eq == null) {
            CampaignMain.cm.toUser("AM:You have bought " + numtobuy + " " + bme.getEquipmentInternalName() + " crits for " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + ".", Username);
            player.updatePartsCache(bme.getEquipmentInternalName(), numtobuy);
        } else {
            CampaignMain.cm.toUser("AM:You have bought " + numtobuy + " " + eq.getName() + " crits for " + CampaignMain.cm.moneyOrFluMessage(true, true, cost) + ".", Username);
            player.updatePartsCache(eq.getInternalName(), numtobuy);
        }
        CampaignMain.cm.getPartsMarket().updatePartsBlackMarketAllPlayers();
    }
}

