/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.pilot.SPilot;

public class BuyPilotsFromHouseCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        SHouse h = p.getMyHouse();
        if (!new Boolean(h.getConfig("AllowPersonalPilotQueues")).booleanValue()) {
            return;
        }
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        if (command.hasMoreElements()) {
            int unitType = Integer.parseInt(command.nextToken());
            int weightClass = Integer.parseInt(command.nextToken());
            int numberOfPilots = 1;
            if (command.hasMoreTokens()) {
                numberOfPilots = Integer.parseInt(command.nextToken());
            }
            if (p.getPersonalPilotQueue().getPilotQueue(unitType, weightClass).size() > 0 && !h.getBooleanConfig("AllowPlayerToBuyPilotsFromHouseWhenPoolIsFull")) {
                CampaignMain.cm.toUser("AM:You faction will not let you plunder their pilot reserves while you have perfectly able pilots in your barracks!", Username, true);
                return;
            }
            if (p.getPersonalPilotQueue().getPilotQueue(unitType, weightClass).size() + numberOfPilots > Integer.parseInt(h.getConfig("MaxAllowedPilotsInQueueToBuyFromHouse"))) {
                CampaignMain.cm.toUser("AM:Your Faction will only allow you to buy pilots from their reserve when you have " + h.getIntegerConfig("MaxAllowedPilotsInQueueToBuyFromHouse") + ", or less, pilots in your barracks.", Username, true);
                return;
            }
            int money = 0;
            money = unitType == 0 ? h.getIntegerConfig("CostToBuyNewPilot") : h.getIntegerConfig("CostToBuyNewProtoPilot");
            if (p.getMoney() < money * numberOfPilots) {
                CampaignMain.cm.toUser("AM:You do not have enough money to procure a new pilot from your faction.(" + CampaignMain.cm.moneyOrFluMessage(true, true, money) + ") needed.", Username, true);
                return;
            }
            for (int pilotCount = 0; pilotCount < numberOfPilots; ++pilotCount) {
                p.addMoney(-money);
                SPilot pilot = h.getNewPilot(unitType);
                p.getPersonalPilotQueue().addPilot(pilot, unitType, weightClass);
                String toUser = "";
                String skills = pilot.getSkillString(true, h.getPilotQueues().getBasePilotSkill(unitType)).trim();
                if (unitType == 0) {
                    toUser = "AM:You have purchased " + pilot.getName() + " (" + pilot.getGunnery() + "/" + pilot.getPiloting();
                    toUser = skills == null || skills.equals("") ? toUser + ") from your faction for " + CampaignMain.cm.moneyOrFluMessage(true, true, money) + "." : toUser + " " + skills + ") from your faction for " + CampaignMain.cm.moneyOrFluMessage(true, true, money) + ".";
                } else {
                    toUser = "AM:You have purchased " + pilot.getName() + " (" + pilot.getGunnery();
                    toUser = skills == null || skills.equals("") ? toUser + ") from your faction for " + CampaignMain.cm.moneyOrFluMessage(true, true, money) + "." : toUser + " " + skills + ") from your faction for " + CampaignMain.cm.moneyOrFluMessage(true, true, money) + ".";
                }
                CampaignMain.cm.toUser(toUser, Username, true);
                CampaignMain.cm.toUser("PL|AP2PPQ|" + unitType + "|" + weightClass + "|" + pilot.toFileFormat("#", true), Username, false);
            }
        }
    }
}

