/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.commands.Command;
import server.campaign.mercenaries.ContractInfo;

public class CancelOfferCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        boolean contractRemoved = false;
        String receivingPlayerName = "";
        for (int i = 0; i < CampaignMain.cm.getUnresolvedContracts().size(); ++i) {
            ContractInfo info = CampaignMain.cm.getUnresolvedContracts().get(i);
            if (!info.getOfferingPlayerName().equalsIgnoreCase(Username)) continue;
            receivingPlayerName = info.getPlayerName();
            CampaignMain.cm.getUnresolvedContracts().remove(i);
            contractRemoved = true;
            CampaignMain.cm.getUnresolvedContracts().trimToSize();
            break;
        }
        if (contractRemoved) {
            CampaignMain.cm.toUser("AM:You have cancelled your offer to " + receivingPlayerName, Username, true);
            CampaignMain.cm.toUser(Username + " has rescinded his contract offer", receivingPlayerName, true);
        } else if (!contractRemoved) {
            CampaignMain.cm.toUser("AM:There was no outstanding contract to cancel!", Username, true);
        }
    }
}

