/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class CheckArmyLinkCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = null;
        int armyid = -1;
        SArmy army = null;
        try {
            p = CampaignMain.cm.getPlayer(command.nextToken());
            armyid = Integer.parseInt(command.nextToken());
            army = p.getArmy(armyid);
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c checkarmylink#name#armyid", Username, true);
            return;
        }
        if (p.getDutyStatus() != 4 && CampaignMain.cm.getServer().getUserLevel(Username) < 200) {
            CampaignMain.cm.toUser("AM:You may only check links in fighting players' amries.", Username, true);
            return;
        }
        StringBuilder toSend = new StringBuilder("Link info for " + p.getName() + "'s Army #" + armyid + ":");
        if (army.getC3Network().size() < 1) {
            toSend.append(" No Linked C3.");
            CampaignMain.cm.toUser(toSend.toString(), Username, true);
        } else {
            Enumeration<Integer> c3Units = army.getC3Network().keys();
            while (c3Units.hasMoreElements()) {
                Integer c3U = c3Units.nextElement();
                Integer c3M = army.getC3Network().get(c3U);
                toSend.append("<br>Unit " + c3U + " is linked to unit " + c3M + ".");
            }
            CampaignMain.cm.toUser(toSend.toString(), Username, true);
        }
    }
}

