/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.Enumeration;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SHouse;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;
import server.campaign.operations.OperationManager;

public class CheckAttackCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        boolean minActiveMet;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        boolean canProbeFromReserve = CampaignMain.cm.getBooleanConfig("ProbeInReserve");
        if (!canProbeFromReserve && p.getDutyStatus() < 3) {
            CampaignMain.cm.toUser("AM:You are not on the frontline. You can't probe enemy forces from reserve!", Username, true);
            return;
        }
        if (p.getDutyStatus() == 4) {
            CampaignMain.cm.toUser("AM:You should focus on playing your game!", Username, true);
            return;
        }
        boolean bl = minActiveMet = System.currentTimeMillis() - p.getActiveSince() >= Long.parseLong(CampaignMain.cm.getConfig("MinActiveTime")) * 1000L;
        if (!canProbeFromReserve && !minActiveMet) {
            CampaignMain.cm.toUser("AM:You're still on your way to the frontline. Contact an intelligence officer once you arrive at your post.", Username, true);
            return;
        }
        if (p.getMyHouse().isMercHouse() && p.getHouseFightingFor() == p.getMyHouse()) {
            CampaignMain.cm.toUser("AM:You are not under contract!", Username, true);
            return;
        }
        boolean usingOpRules = CampaignMain.cm.getBooleanConfig("UseOperationsRule");
        String Desc = "<br>";
        if (command.hasMoreElements()) {
            Desc = "<br><table><tr><td>Army ";
            int armyID = -1;
            try {
                armyID = Integer.parseInt(command.nextToken());
            }
            catch (Exception e) {
                CampaignMain.cm.toUser("AM:Improper format. Try: /c checkattack or /c checkattack#armyid", Username, true);
                return;
            }
            SArmy arm = p.getArmy(armyID);
            if (arm == null) {
                CampaignMain.cm.toUser("AM:Army #" + armyID + " doesn't exist.", Username, true);
                return;
            }
            if (arm.isDisabled()) {
                CampaignMain.cm.toUser("AM: Army #" + armyID + " is disabled.", Username, true);
                return;
            }
            Desc = Desc + arm.getID() + " (" + arm.getBV() + " BV) ";
            Desc = Desc + " may attack: </td><td>&nbsp;</td><td>&nbsp;</td></tr>";
            Enumeration<SArmy> targets = arm.getOpponents().elements();
            while (targets.hasMoreElements()) {
                SArmy currTarget = targets.nextElement();
                SPlayer currTargetP = CampaignMain.cm.getPlayer(currTarget.getPlayerName());
                String coloredHouseName = currTargetP.getMyHouse().getHouseFightingFor(currTargetP).getColoredName();
                String defendableOps = this.listDefendableOperations(arm, currTargetP, currTarget, p.getHouseFightingFor());
                if (defendableOps.equals("[]")) continue;
                Desc = Desc + "<tr><td>&nbsp;</td><td>";
                Desc = CampaignMain.cm.getBooleanConfig("ShowInfInCheckAttack") ? Desc + coloredHouseName + "(" + currTarget.getAmountOfUnits() + ")" : Desc + coloredHouseName + "(" + currTarget.getAmountOfUnitsWithoutInfantry() + ")";
                if (usingOpRules && arm.getAmountOfUnits() > currTarget.getAmountOfUnits()) {
                    Desc = Desc + "(BV Against: " + arm.getOperationsBV(currTarget) + ")";
                }
                Desc = Desc + "</td><td>" + defendableOps;
                Desc = Desc + "</td></tr>";
            }
            Desc = Desc + "</table>";
        } else {
            Desc = "Intelligence reports the following attack options:<br>";
            Enumeration<SArmy> e = p.getArmies().elements();
            while (e.hasMoreElements()) {
                SArmy arm = e.nextElement();
                Desc = Desc + "<table><tr><td>";
                if (arm == null || arm.isDisabled()) continue;
                Desc = Desc + "Army " + arm.getID();
                if (usingOpRules) {
                    Desc = Desc + " (" + arm.getBV() + " BV)";
                }
                Desc = Desc + ": </td>";
                Enumeration<SArmy> targets = arm.getOpponents().elements();
                while (targets.hasMoreElements()) {
                    String defendableOps;
                    SArmy currTarget = targets.nextElement();
                    SPlayer currTargetP = CampaignMain.cm.getPlayer(currTarget.getPlayerName());
                    if (currTargetP == null || (defendableOps = this.listDefendableOperations(arm, currTargetP, currTarget, p.getHouseFightingFor())).equals("[]")) continue;
                    String coloredHouseName = currTargetP.getMyHouse().getHouseFightingFor(currTargetP).getColoredName();
                    Desc = Desc + "<td>";
                    Desc = CampaignMain.cm.getBooleanConfig("ShowInfInCheckAttack") ? Desc + coloredHouseName + "(" + currTarget.getAmountOfUnits() + ")" : Desc + coloredHouseName + "(" + currTarget.getAmountOfUnitsWithoutInfantry() + ")";
                    if (usingOpRules && arm.getAmountOfUnits() > currTarget.getAmountOfUnits()) {
                        Desc = Desc + "(BV Against: " + arm.getOperationsBV(currTarget) + ")";
                    }
                    Desc = Desc + "</td><td>" + defendableOps;
                    Desc = Desc + "</td></tr>";
                    if (!targets.hasMoreElements()) continue;
                    Desc = Desc + "<tr><td>&nbsp;</td>";
                }
                Desc = Desc + "</table>";
            }
        }
        CampaignMain.cm.toUser(Desc + "<br>", Username, true);
    }

    private String listDefendableOperations(SArmy aa, SPlayer dp, SArmy da, SHouse ah) {
        StringBuffer report = new StringBuffer(" [");
        OperationManager manager = CampaignMain.cm.getOpsManager();
        for (String attack : aa.getLegalOperations().keySet()) {
            Operation o = manager.getOperation(attack);
            if (!aa.matches(da, o) || dp.getHouseFightingFor().equals(ah) && !o.getBooleanValue("AllowInFaction") || manager.validateShortDefense(dp, da, o, null) != null) continue;
            report.append(attack);
            report.append(", ");
        }
        report.trimToSize();
        if (report.length() <= 2) {
            return "[]";
        }
        report.delete(report.length() - 2, report.length());
        report.append("]");
        return report.toString();
    }
}

