/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import common.CampaignData;
import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SPlayer;
import server.campaign.commands.Command;
import server.campaign.operations.Operation;
import server.campaign.operations.ShortOperation;

public class CommenceOperationCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        String confirm;
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        int opID = -1;
        try {
            opID = Integer.parseInt(command.nextToken());
            confirm = command.nextToken();
        }
        catch (Exception e) {
            CampaignMain.cm.toUser("AM:Improper format. Try: /c commenceOperation#Op number#CONFIRM", Username, true);
            return;
        }
        SPlayer ap = CampaignMain.cm.getPlayer(Username);
        if (ap == null) {
            CampaignMain.cm.toUser("AM:Null player. Report this immediately!", Username, true);
            return;
        }
        if (!confirm.equals("CONFIRM")) {
            CampaignMain.cm.toUser("AM:This command must be confirmed!", Username, true);
            return;
        }
        ShortOperation so = CampaignMain.cm.getOpsManager().getRunningOps().get(opID);
        if (so == null) {
            CampaignMain.cm.toUser("AM:Operation #" + opID + " does not exist.", Username, true);
            return;
        }
        Operation o = CampaignMain.cm.getOpsManager().getOperation(so.getName());
        if (!o.getBooleanValue("FreeForAllOperation")) {
            CampaignMain.cm.toUser("AM:This command can only be used on Free For All Operations!", Username);
            return;
        }
        if (!so.getAttackers().containsKey(ap.getName().toLowerCase())) {
            CampaignMain.cm.toUser("AM:Only the attacker may commence this operation! ", Username, true);
            return;
        }
        if (so.getStatus() != ShortOperation.STATUS_WAITING) {
            if (so.getStatus() == ShortOperation.STATUS_FINISHED) {
                CampaignMain.cm.toUser("AM:Operation #" + opID + " is finished.", Username, true);
                return;
            }
            CampaignMain.cm.toUser("AM:Operation #" + opID + " has already commenced.", Username, true);
            return;
        }
        int minPlayers = 3;
        try {
            minPlayers = o.getIntValue("MinNumberOfPlayers");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (so.getDefenders().size() + so.getAttackers().size() < minPlayers) {
            CampaignMain.cm.toUser("AM:Operation #" + opID + " does not have enough players to commence!<br>At least " + minPlayers + " players are needed.", Username, true);
            return;
        }
        so.changeStatus(ShortOperation.STATUS_INPROGRESS);
        CampaignData.mwlog.gameLog("Operation Commenced: " + so.getShortID() + "/" + ap.getName());
        CampaignMain.cm.toUser("AM:Operation Commenced!", Username, true);
    }
}

