/*
 * Decompiled with CFR 0.152.
 */
package server.campaign.commands;

import java.util.StringTokenizer;
import server.campaign.CampaignMain;
import server.campaign.SArmy;
import server.campaign.SPlayer;
import server.campaign.commands.Command;

public class CreateArmyCommand
implements Command {
    int accessLevel = 0;
    String syntax = "";

    public int getExecutionLevel() {
        return this.accessLevel;
    }

    public void setExecutionLevel(int i) {
        this.accessLevel = i;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void process(StringTokenizer command, String Username) {
        int userLevel;
        if (this.accessLevel != 0 && (userLevel = CampaignMain.cm.getServer().getUserLevel(Username)) < this.getExecutionLevel()) {
            CampaignMain.cm.toUser("AM:Insufficient access level for command. Level: " + userLevel + ". Required: " + this.accessLevel + ".", Username, true);
            return;
        }
        SPlayer p = CampaignMain.cm.getPlayer(Username);
        int maxlances = CampaignMain.cm.getIntegerConfig("MaxLancesPerPlayer");
        if (p.getDutyStatus() == 3) {
            CampaignMain.cm.toUser("AM:You may not create new armies while on active duty.", Username, true);
            return;
        }
        if (p.getArmies().size() >= maxlances) {
            CampaignMain.cm.toUser("AM:You have reached the max number of allowable armies (" + maxlances + ").", Username, true);
            return;
        }
        p.getArmies().trimToSize();
        int i = 0;
        boolean free = false;
        while (!free) {
            free = true;
            for (int j = 0; j < p.getArmies().size(); ++j) {
                if (p.getArmies().elementAt(j).getID() != i) continue;
                free = false;
                ++i;
            }
        }
        SArmy newArmy = new SArmy(i, p.getName());
        if (command.hasMoreElements()) {
            String name = (String)command.nextElement();
            boolean illegalName = false;
            if (name.length() > 50) {
                name = name.substring(0, 50);
            }
            if (name.indexOf("%") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (% forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("~") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (~ forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("$") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name ($ forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("|") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (| forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("!") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (! forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("*") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (* forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("#") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (# forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf(">") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (> forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("<") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (< forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("@") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (@ forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("&") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (& forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("^") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (^ forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("+") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (+ forbidden).", Username, true);
                illegalName = true;
            } else if (name.indexOf("=") != -1) {
                CampaignMain.cm.toUser("AM:Illegal army name (= forbidden).", Username, true);
                illegalName = true;
            }
            if (!illegalName) {
                newArmy.setName(name);
            }
        }
        newArmy.setUpperLimiter(CampaignMain.cm.getIntegerConfig("DefaultUpperLimit"));
        newArmy.setLowerLimiter(CampaignMain.cm.getIntegerConfig("DefaultLowerLimit"));
        if (p.getArmies().size() < newArmy.getID()) {
            p.getArmies().add(newArmy);
        } else {
            p.getArmies().add(newArmy.getID(), newArmy);
        }
        CampaignMain.cm.toUser("PL|SAD|" + p.getArmy(i).toString(true, "%"), Username, false);
        CampaignMain.cm.toUser("AM:Created a new Army (#" + p.getArmy(i).getID() + ").", Username, true);
    }
}

